/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionTriggerEnterBlock;
import net.minecraft.advancements.critereon.CriterionTriggerImpossible;
import net.minecraft.advancements.critereon.CriterionTriggerInventoryChanged;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.FurnaceRecipe;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeBlasting;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;

public abstract class RecipeProvider {
    protected final HolderLookup.a a;
    private final HolderGetter<Item> c;
    protected final RecipeOutput b;
    private static final Map<BlockFamily.b, a> d = ImmutableMap.builder().put((Object)BlockFamily.b.a, (generator, output, input) -> generator.e(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.b, (generator, output, input) -> generator.b(RecipeCategory.a, output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.d, (generator, output, input) -> generator.f(RecipeCategory.a, output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.e, (generator, output, input) -> generator.a(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.f, (generator, output, input) -> generator.f(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.g, (generator, output, input) -> generator.f(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.h, (generator, output, input) -> generator.g(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.i, (generator, output, input) -> generator.g(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.k, (generator, output, input) -> generator.h(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.l, (generator, output, input) -> generator.a(RecipeCategory.a, output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.m, (generator, output, input) -> generator.b(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.n, (generator, output, input) -> generator.c(RecipeCategory.c, output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.o, (generator, output, input) -> generator.e(RecipeCategory.a, output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.p, (generator, output, input) -> generator.c(output, RecipeItemStack.a(input))).put((Object)BlockFamily.b.q, (generator, output, input) -> generator.d(RecipeCategory.b, output, RecipeItemStack.a(input))).build();

    protected RecipeProvider(HolderLookup.a registries, RecipeOutput exporter) {
        this.a = registries;
        this.c = registries.d(Registries.K);
        this.b = exporter;
    }

    protected abstract void a();

    protected void a(FeatureFlagSet enabledFeatures) {
        BlockFamilies.a().filter(BlockFamily::d).forEach(family -> this.a((BlockFamily)family, enabledFeatures));
    }

    protected void a(IMaterial output, IMaterial input, @Nullable String group) {
        this.a(output, input, group, 1);
    }

    protected void a(IMaterial output, IMaterial input, @Nullable String group, int outputCount) {
        this.b(RecipeCategory.i, output, outputCount).b(input).b(group).b(RecipeProvider.b(input), this.a(input)).a(this.b, RecipeProvider.p(output, input));
    }

    protected void a(List<IMaterial> inputs, RecipeCategory category, IMaterial output, float experience, int cookingTime, String group) {
        this.a(RecipeSerializer.o, FurnaceRecipe::new, inputs, category, output, experience, cookingTime, group, "_from_smelting");
    }

    protected void b(List<IMaterial> inputs, RecipeCategory category, IMaterial output, float experience, int cookingTime, String group) {
        this.a(RecipeSerializer.p, RecipeBlasting::new, inputs, category, output, experience, cookingTime, group, "_from_blasting");
    }

    private <T extends RecipeCooking> void a(RecipeSerializer<T> serializer, RecipeCooking.a<T> recipeFactory, List<IMaterial> inputs, RecipeCategory category, IMaterial output, float experience, int cookingTime, String group, String suffix) {
        for (IMaterial itemLike : inputs) {
            SimpleCookingRecipeBuilder.a(RecipeItemStack.a(itemLike), category, output, experience, cookingTime, serializer, recipeFactory).b(group).b(RecipeProvider.b(itemLike), this.a(itemLike)).a(this.b, RecipeProvider.c(output) + suffix + "_" + RecipeProvider.c(itemLike));
        }
    }

    protected void a(Item input, RecipeCategory category, Item result) {
        SmithingTransformRecipeBuilder.a(RecipeItemStack.a((IMaterial)Items.ym), RecipeItemStack.a((IMaterial)input), this.b(TagsItem.bi), category, result).a("has_netherite_ingot", this.a(TagsItem.bi)).a(this.b, RecipeProvider.c(result) + "_smithing");
    }

    protected void a(Item input, ResourceKey<IRecipe<?>> resourceKey) {
        SmithingTrimRecipeBuilder.a(RecipeItemStack.a((IMaterial)input), this.b(TagsItem.bE), this.b(TagsItem.bF), RecipeCategory.i).a("has_smithing_trim_template", this.a(input)).a(this.b, resourceKey);
    }

    protected void a(RecipeCategory category, IMaterial output, IMaterial input) {
        this.a(category, output, 1).a(Character.valueOf('#'), input).b("##").b("##").b(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    protected void a(RecipeCategory category, IMaterial output, IMaterial input, String criterionName) {
        this.b(category, output).a(input, 9).b(criterionName, this.a(input)).a(this.b);
    }

    protected void b(RecipeCategory category, IMaterial output, IMaterial input) {
        this.a(category, output, input, RecipeProvider.b(input));
    }

    protected void a(IMaterial output, TagKey<Item> logTag, int count) {
        this.b(RecipeCategory.a, output, count).a(logTag).b("planks").b("has_log", this.a(logTag)).a(this.b);
    }

    protected void b(IMaterial output, TagKey<Item> logTag, int count) {
        this.b(RecipeCategory.a, output, count).a(logTag).b("planks").b("has_logs", this.a(logTag)).a(this.b);
    }

    protected void a(IMaterial output, IMaterial input) {
        this.a(RecipeCategory.a, output, 3).a(Character.valueOf('#'), input).b("##").b("##").c("bark").b("has_log", this.a(input)).a(this.b);
    }

    protected void b(IMaterial output, IMaterial input) {
        this.a(RecipeCategory.d, output).a(Character.valueOf('#'), input).b("# #").b("###").c("boat").b("in_water", RecipeProvider.a(Blocks.J)).a(this.b);
    }

    protected void c(IMaterial output, IMaterial input) {
        this.b(RecipeCategory.d, output).b(Blocks.cD).b(input).b("chest_boat").b("has_boat", this.a(TagsItem.aT)).a(this.b);
    }

    private RecipeBuilder e(IMaterial output, RecipeItemStack input) {
        return this.b(RecipeCategory.c, output).a(input);
    }

    protected RecipeBuilder a(IMaterial output, RecipeItemStack input) {
        return this.a(RecipeCategory.c, output, 3).a(Character.valueOf('#'), input).b("##").b("##").b("##");
    }

    private RecipeBuilder f(IMaterial output, RecipeItemStack input) {
        int i2 = output == Blocks.fC ? 6 : 3;
        Item item = output == Blocks.fC ? Items.vn : Items.pM;
        return this.a(RecipeCategory.b, output, i2).a(Character.valueOf('W'), input).a(Character.valueOf('#'), item).b("W#W").b("W#W");
    }

    private RecipeBuilder g(IMaterial output, RecipeItemStack input) {
        return this.a(RecipeCategory.c, output).a(Character.valueOf('#'), Items.pM).a(Character.valueOf('W'), input).b("#W#").b("#W#");
    }

    protected void d(IMaterial output, IMaterial input) {
        this.c(RecipeCategory.c, output, RecipeItemStack.a(input)).a(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    private RecipeBuilder c(RecipeCategory category, IMaterial output, RecipeItemStack input) {
        return this.a(category, output).a(Character.valueOf('#'), input).b("##");
    }

    protected void c(RecipeCategory category, IMaterial output, IMaterial input) {
        this.a(category, output, RecipeItemStack.a(input)).a(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    protected RecipeBuilder a(RecipeCategory category, IMaterial output, RecipeItemStack input) {
        return this.a(category, output, 6).a(Character.valueOf('#'), input).b("###");
    }

    protected RecipeBuilder b(IMaterial output, RecipeItemStack input) {
        return this.a(RecipeCategory.a, output, 4).a(Character.valueOf('#'), input).b("#  ").b("## ").b("###");
    }

    protected RecipeBuilder c(IMaterial output, RecipeItemStack input) {
        return this.a(RecipeCategory.c, output, 2).a(Character.valueOf('#'), input).b("###").b("###");
    }

    private RecipeBuilder h(IMaterial output, RecipeItemStack input) {
        return this.a(RecipeCategory.b, output, 3).c("sign").a(Character.valueOf('#'), input).a(Character.valueOf('X'), Items.pM).b("###").b("###").b(" X ");
    }

    protected void e(IMaterial output, IMaterial input) {
        this.a(RecipeCategory.b, output, 6).c("hanging_sign").a(Character.valueOf('#'), input).a(Character.valueOf('X'), Items.gf).b("X X").b("###").b("###").b("has_stripped_logs", this.a(input)).a(this.b);
    }

    protected void a(List<Item> dyes, List<Item> dyeables, String group) {
        this.a(dyes, dyeables, null, group, RecipeCategory.a);
    }

    protected void a(List<Item> dyes, List<Item> dyeables, @Nullable Item undyed, String group, RecipeCategory category) {
        for (int i2 = 0; i2 < dyes.size(); ++i2) {
            Item item2 = dyes.get(i2);
            Item item22 = dyeables.get(i2);
            Stream<Item> stream = dyeables.stream().filter(item -> !item.equals(item22));
            if (undyed != null) {
                stream = Stream.concat(stream, Stream.of(undyed));
            }
            this.b(category, (IMaterial)item22).b(item2).a(RecipeItemStack.a(stream)).b(group).b("has_needed_dye", this.a(item2)).a(this.b, "dye_" + RecipeProvider.c(item22));
        }
    }

    protected void f(IMaterial output, IMaterial input) {
        this.a(RecipeCategory.b, output, 3).a(Character.valueOf('#'), input).b("##").c("carpet").b(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    protected void g(IMaterial output, IMaterial inputWool) {
        this.a(RecipeCategory.b, output).a(Character.valueOf('#'), inputWool).a(Character.valueOf('X'), TagsItem.b).b("###").b("XXX").c("bed").b(RecipeProvider.b(inputWool), this.a(inputWool)).a(this.b);
    }

    protected void h(IMaterial output, IMaterial inputWool) {
        this.a(RecipeCategory.b, output).a(Character.valueOf('#'), inputWool).a(Character.valueOf('|'), Items.pM).b("###").b("###").b(" | ").c("banner").b(RecipeProvider.b(inputWool), this.a(inputWool)).a(this.b);
    }

    protected void i(IMaterial output, IMaterial input) {
        this.a(RecipeCategory.a, output, 8).a(Character.valueOf('#'), Blocks.aX).a(Character.valueOf('X'), input).b("###").b("#X#").b("###").c("stained_glass").b("has_glass", this.a(Blocks.aX)).a(this.b);
    }

    protected void j(IMaterial output, IMaterial input) {
        this.a(RecipeCategory.b, output, 16).a(Character.valueOf('#'), input).b("###").b("###").c("stained_glass_pane").b("has_glass", this.a(input)).a(this.b);
    }

    protected void k(IMaterial output, IMaterial inputDye) {
        this.a(RecipeCategory.b, output, 8).a(Character.valueOf('#'), Blocks.fm).a(Character.valueOf('$'), inputDye).b("###").b("#$#").b("###").c("stained_glass_pane").b("has_glass_pane", this.a(Blocks.fm)).b(RecipeProvider.b(inputDye), this.a(inputDye)).a(this.b, RecipeProvider.p(output, Blocks.fm));
    }

    protected void l(IMaterial output, IMaterial input) {
        this.a(RecipeCategory.a, output, 8).a(Character.valueOf('#'), Blocks.iR).a(Character.valueOf('X'), input).b("###").b("#X#").b("###").c("stained_terracotta").b("has_terracotta", this.a(Blocks.iR)).a(this.b);
    }

    protected void m(IMaterial output, IMaterial input) {
        this.b(RecipeCategory.a, output, 8).b(input).a(Blocks.L, 4).a(Blocks.O, 4).b("concrete_powder").b("has_sand", this.a(Blocks.L)).b("has_gravel", this.a(Blocks.O)).a(this.b);
    }

    protected void n(IMaterial output, IMaterial input) {
        this.b(RecipeCategory.b, output).b(Blocks.qg).b(input).b("dyed_candle").b(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    protected void d(RecipeCategory category, IMaterial output, IMaterial input) {
        this.d(category, output, RecipeItemStack.a(input)).a(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    private RecipeBuilder d(RecipeCategory category, IMaterial output, RecipeItemStack input) {
        return this.a(category, output, 6).a(Character.valueOf('#'), input).b("###").b("###");
    }

    protected void e(RecipeCategory category, IMaterial output, IMaterial input) {
        this.e(category, output, RecipeItemStack.a(input)).a(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    private RecipeBuilder e(RecipeCategory category, IMaterial output, RecipeItemStack input) {
        return this.a(category, output, 4).a(Character.valueOf('S'), input).b("SS").b("SS");
    }

    protected void f(RecipeCategory category, IMaterial output, IMaterial input) {
        this.f(category, output, RecipeItemStack.a(input)).b(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    private ShapedRecipeBuilder f(RecipeCategory category, IMaterial output, RecipeItemStack input) {
        return this.a(category, output, 4).a(Character.valueOf('#'), input).b("##").b("##");
    }

    protected void g(RecipeCategory category, IMaterial output, IMaterial input) {
        this.b(category, output, RecipeItemStack.a(input)).b(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    protected void h(RecipeCategory category, IMaterial output, IMaterial input) {
        this.a(category, output).a(Character.valueOf('#'), input).b("#").b("#").b(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    protected ShapedRecipeBuilder b(RecipeCategory category, IMaterial output, RecipeItemStack input) {
        return this.a(category, output).a(Character.valueOf('#'), input).b("#").b("#");
    }

    protected void i(RecipeCategory category, IMaterial output, IMaterial input) {
        this.a(category, output, input, 1);
    }

    protected void a(RecipeCategory category, IMaterial output, IMaterial input, int count) {
        SingleItemRecipeBuilder.a(RecipeItemStack.a(input), category, output, count).b(RecipeProvider.b(input), this.a(input)).a(this.b, RecipeProvider.p(output, input) + "_stonecutting");
    }

    private void q(IMaterial output, IMaterial input) {
        SimpleCookingRecipeBuilder.c(RecipeItemStack.a(input), RecipeCategory.a, output, 0.1f, 200).b(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    protected void a(RecipeCategory reverseCategory, IMaterial baseItem, RecipeCategory compactingCategory, IMaterial compactItem) {
        this.a(reverseCategory, baseItem, compactingCategory, compactItem, RecipeProvider.d(compactItem), null, RecipeProvider.d(baseItem), null);
    }

    protected void a(RecipeCategory reverseCategory, IMaterial baseItem, RecipeCategory compactingCategory, IMaterial compactItem, String compactingId, String compactingGroup) {
        this.a(reverseCategory, baseItem, compactingCategory, compactItem, compactingId, compactingGroup, RecipeProvider.d(baseItem), null);
    }

    protected void b(RecipeCategory reverseCategory, IMaterial baseItem, RecipeCategory compactingCategory, IMaterial compactItem, String reverseId, String reverseGroup) {
        this.a(reverseCategory, baseItem, compactingCategory, compactItem, RecipeProvider.d(compactItem), null, reverseId, reverseGroup);
    }

    private void a(RecipeCategory reverseCategory, IMaterial baseItem, RecipeCategory compactingCategory, IMaterial compactItem, String compactingId, @Nullable String compactingGroup, String reverseId, @Nullable String reverseGroup) {
        this.b(reverseCategory, baseItem, 9).b(compactItem).b(reverseGroup).b(RecipeProvider.b(compactItem), this.a(compactItem)).a(this.b, ResourceKey.a(Registries.bk, MinecraftKey.a(reverseId)));
        this.a(compactingCategory, compactItem).a(Character.valueOf('#'), baseItem).b("###").b("###").b("###").c(compactingGroup).b(RecipeProvider.b(baseItem), this.a(baseItem)).a(this.b, ResourceKey.a(Registries.bk, MinecraftKey.a(compactingId)));
    }

    protected void o(IMaterial template, IMaterial resource) {
        this.a(RecipeCategory.i, template, 2).a(Character.valueOf('#'), Items.oV).a(Character.valueOf('C'), resource).a(Character.valueOf('S'), template).b("#S#").b("#C#").b("###").b(RecipeProvider.b(template), this.a(template)).a(this.b);
    }

    protected void d(IMaterial template, RecipeItemStack resource) {
        this.a(RecipeCategory.i, template, 2).a(Character.valueOf('#'), Items.oV).a(Character.valueOf('C'), resource).a(Character.valueOf('S'), template).b("#S#").b("#C#").b("###").b(RecipeProvider.b(template), this.a(template)).a(this.b);
    }

    protected <T extends RecipeCooking> void a(String cooker, RecipeSerializer<T> serializer, RecipeCooking.a<T> recipeFactory, int cookingTime) {
        this.a(cooker, serializer, recipeFactory, cookingTime, Items.sO, Items.sP, 0.35f);
        this.a(cooker, serializer, recipeFactory, cookingTime, Items.sQ, Items.sR, 0.35f);
        this.a(cooker, serializer, recipeFactory, cookingTime, Items.rN, Items.rR, 0.35f);
        this.a(cooker, serializer, recipeFactory, cookingTime, Items.dR, Items.sL, 0.1f);
        this.a(cooker, serializer, recipeFactory, cookingTime, Items.rO, Items.rS, 0.35f);
        this.a(cooker, serializer, recipeFactory, cookingTime, Items.vD, Items.vE, 0.35f);
        this.a(cooker, serializer, recipeFactory, cookingTime, Items.qt, Items.qu, 0.35f);
        this.a(cooker, serializer, recipeFactory, cookingTime, Items.uW, Items.uX, 0.35f);
        this.a(cooker, serializer, recipeFactory, cookingTime, Items.vq, Items.vr, 0.35f);
    }

    private <T extends RecipeCooking> void a(String cooker, RecipeSerializer<T> serializer, RecipeCooking.a<T> recipeFactory, int cookingTime, IMaterial input, IMaterial output, float experience) {
        SimpleCookingRecipeBuilder.a(RecipeItemStack.a(input), RecipeCategory.g, output, experience, cookingTime, serializer, recipeFactory).b(RecipeProvider.b(input), this.a(input)).a(this.b, RecipeProvider.c(output) + "_from_" + cooker);
    }

    protected void b(FeatureFlagSet enabledFeatures) {
        HoneycombItem.a.get().forEach((unwaxed, waxed) -> {
            if (!waxed.i().a(enabledFeatures)) {
                return;
            }
            this.b(RecipeCategory.a, (IMaterial)waxed).b((IMaterial)unwaxed).b(Items.xq).b(RecipeProvider.c(waxed)).b(RecipeProvider.b(unwaxed), this.a((IMaterial)unwaxed)).a(this.b, RecipeProvider.p(waxed, Items.xq));
        });
    }

    protected void a(Block output, Block input) {
        this.a(RecipeCategory.a, (IMaterial)output, 4).a(Character.valueOf('M'), input).b(" M ").b("M M").b(" M ").b(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    protected void b(Block output, Block input) {
        this.a(RecipeCategory.c, (IMaterial)output, 4).a(Character.valueOf('C'), input).a(Character.valueOf('R'), Items.lV).a(Character.valueOf('B'), Items.sU).b(" C ").b("CBC").b(" R ").b(RecipeProvider.b(input), this.a(input)).a(this.b);
    }

    protected void a(Item input, SuspiciousEffectHolder stewIngredient) {
        ItemStack itemStack = new ItemStack(Items.wM.f(), 1, DataComponentPatch.a().a(DataComponents.R, stewIngredient.b()).a());
        this.a(RecipeCategory.g, itemStack).b(Items.oP).b(Items.dH).b(Items.dI).b(input).b("suspicious_stew").b(RecipeProvider.b(input), this.a(input)).a(this.b, RecipeProvider.c(itemStack.h()) + "_from_" + RecipeProvider.c(input));
    }

    protected void a(BlockFamily family, FeatureFlagSet enabledFeatures) {
        family.b().forEach((variant, block) -> {
            if (!block.i().a(enabledFeatures)) {
                return;
            }
            a familyRecipeProvider = d.get(variant);
            Block itemLike = this.a(family, (BlockFamily.b)((Object)variant));
            if (familyRecipeProvider != null) {
                RecipeBuilder recipeBuilder = familyRecipeProvider.create(this, (IMaterial)block, itemLike);
                family.e().ifPresent(group -> recipeBuilder.a(group + (String)(variant == BlockFamily.b.d ? "" : "_" + variant.a())));
                recipeBuilder.a(family.f().orElseGet(() -> RecipeProvider.b(itemLike)), this.a(itemLike));
                recipeBuilder.a(this.b);
            }
            if (variant == BlockFamily.b.c) {
                this.q((IMaterial)block, itemLike);
            }
        });
    }

    private Block a(BlockFamily family, BlockFamily.b variant) {
        if (variant == BlockFamily.b.b) {
            if (!family.b().containsKey((Object)BlockFamily.b.l)) {
                throw new IllegalStateException("Slab is not defined for the family.");
            }
            return family.a(BlockFamily.b.l);
        }
        return family.a();
    }

    private static Criterion<CriterionTriggerEnterBlock.a> a(Block block) {
        return CriterionTriggers.e.a(new CriterionTriggerEnterBlock.a(Optional.empty(), Optional.of(block.p()), Optional.empty()));
    }

    private Criterion<CriterionTriggerInventoryChanged.a> a(CriterionConditionValue.IntegerRange count, IMaterial item) {
        return RecipeProvider.a(CriterionConditionItem.a.a().a(this.c, item).a(count));
    }

    protected Criterion<CriterionTriggerInventoryChanged.a> a(IMaterial item) {
        return RecipeProvider.a(CriterionConditionItem.a.a().a(this.c, item));
    }

    protected Criterion<CriterionTriggerInventoryChanged.a> a(TagKey<Item> tag) {
        return RecipeProvider.a(CriterionConditionItem.a.a().a(this.c, tag));
    }

    private static Criterion<CriterionTriggerInventoryChanged.a> a(CriterionConditionItem.a ... predicates) {
        return RecipeProvider.a((CriterionConditionItem[])Arrays.stream(predicates).map(CriterionConditionItem.a::b).toArray(CriterionConditionItem[]::new));
    }

    private static Criterion<CriterionTriggerInventoryChanged.a> a(CriterionConditionItem ... predicates) {
        return CriterionTriggers.f.a(new CriterionTriggerInventoryChanged.a(Optional.empty(), CriterionTriggerInventoryChanged.a.a.b, List.of(predicates)));
    }

    protected static String b(IMaterial item) {
        return "has_" + RecipeProvider.c(item);
    }

    protected static String c(IMaterial item) {
        return BuiltInRegistries.g.b(item.j()).a();
    }

    protected static String d(IMaterial item) {
        return RecipeProvider.c(item);
    }

    protected static String p(IMaterial to, IMaterial from) {
        return RecipeProvider.c(to) + "_from_" + RecipeProvider.c(from);
    }

    protected static String e(IMaterial item) {
        return RecipeProvider.c(item) + "_from_smelting";
    }

    protected static String f(IMaterial item) {
        return RecipeProvider.c(item) + "_from_blasting";
    }

    protected RecipeItemStack b(TagKey<Item> tag) {
        return RecipeItemStack.a(this.c.b(tag));
    }

    protected ShapedRecipeBuilder a(RecipeCategory category, IMaterial output) {
        return ShapedRecipeBuilder.a(this.c, category, output);
    }

    protected ShapedRecipeBuilder a(RecipeCategory category, IMaterial output, int count) {
        return ShapedRecipeBuilder.a(this.c, category, output, count);
    }

    protected ShapelessRecipeBuilder a(RecipeCategory category, ItemStack output) {
        return ShapelessRecipeBuilder.a(this.c, category, output);
    }

    protected ShapelessRecipeBuilder b(RecipeCategory category, IMaterial output) {
        return ShapelessRecipeBuilder.a(this.c, category, output);
    }

    protected ShapelessRecipeBuilder b(RecipeCategory category, IMaterial output, int count) {
        return ShapelessRecipeBuilder.a(this.c, category, output, count);
    }

    @FunctionalInterface
    static interface a {
        public RecipeBuilder create(RecipeProvider var1, IMaterial var2, IMaterial var3);
    }

    protected static abstract class b
    implements DebugReportProvider {
        private final PackOutput d;
        private final CompletableFuture<HolderLookup.a> e;

        protected b(PackOutput output, CompletableFuture<HolderLookup.a> registriesFuture) {
            this.d = output;
            this.e = registriesFuture;
        }

        @Override
        @Override
        public final CompletableFuture<?> a(final CachedOutput writer) {
            return this.e.thenCompose(registries -> {
                PackOutput.a pathProvider = this.d.a(Registries.bk);
                PackOutput.a pathProvider2 = this.d.a(Registries.bj);
                final HashSet set = Sets.newHashSet();
                final ArrayList list = new ArrayList();
                RecipeOutput recipeOutput = new RecipeOutput(){
                    final /* synthetic */ HolderLookup.a d;
                    final /* synthetic */ PackOutput.a e;
                    final /* synthetic */ PackOutput.a f;
                    {
                        this.d = provider;
                        this.e = pathProvider;
                        this.f = pathProvider2;
                    }

                    @Override
                    @Override
                    public void a(ResourceKey<IRecipe<?>> key, IRecipe<?> recipe, @Nullable AdvancementHolder advancement) {
                        if (!set.add(key)) {
                            throw new IllegalStateException("Duplicate recipe " + String.valueOf(key.a()));
                        }
                        this.a(key, recipe);
                        if (advancement != null) {
                            this.a(advancement);
                        }
                    }

                    @Override
                    @Override
                    public Advancement.SerializedAdvancement a() {
                        return Advancement.SerializedAdvancement.b().a(RecipeBuilder.a);
                    }

                    @Override
                    @Override
                    public void b() {
                        AdvancementHolder advancementHolder = Advancement.SerializedAdvancement.b().a("impossible", CriterionTriggers.b.a(new CriterionTriggerImpossible.a())).b(RecipeBuilder.a);
                        this.a(advancementHolder);
                    }

                    private void a(ResourceKey<IRecipe<?>> key, IRecipe<?> recipe) {
                        list.add(DebugReportProvider.a(writer, this.d, IRecipe.a, recipe, this.e.a(key.a())));
                    }

                    private void a(AdvancementHolder advancementEntry) {
                        list.add(DebugReportProvider.a(writer, this.d, Advancement.a, advancementEntry.b(), this.f.a(advancementEntry.a())));
                    }
                };
                this.a((HolderLookup.a)registries, recipeOutput).a();
                return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
            });
        }

        protected abstract RecipeProvider a(HolderLookup.a var1, RecipeOutput var2);
    }
}

