/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.IMaterial;

public class ShapedRecipeBuilder
implements RecipeBuilder {
    private final HolderGetter<Item> b;
    private final RecipeCategory c;
    private final Item d;
    private final int e;
    private final List<String> f = Lists.newArrayList();
    private final Map<Character, RecipeItemStack> g = Maps.newLinkedHashMap();
    private final Map<String, Criterion<?>> h = new LinkedHashMap();
    @Nullable
    private String i;
    private boolean j = true;

    private ShapedRecipeBuilder(HolderGetter<Item> registryLookup, RecipeCategory category, IMaterial output, int count) {
        this.b = registryLookup;
        this.c = category;
        this.d = output.j();
        this.e = count;
    }

    public static ShapedRecipeBuilder a(HolderGetter<Item> registryLookup, RecipeCategory category, IMaterial output) {
        return ShapedRecipeBuilder.a(registryLookup, category, output, 1);
    }

    public static ShapedRecipeBuilder a(HolderGetter<Item> registryLookup, RecipeCategory category, IMaterial output, int count) {
        return new ShapedRecipeBuilder(registryLookup, category, output, count);
    }

    public ShapedRecipeBuilder a(Character c2, TagKey<Item> tag) {
        return this.a(c2, RecipeItemStack.a(this.b.b(tag)));
    }

    public ShapedRecipeBuilder a(Character c2, IMaterial item) {
        return this.a(c2, RecipeItemStack.a(item));
    }

    public ShapedRecipeBuilder a(Character c2, RecipeItemStack ingredient) {
        if (this.g.containsKey(c2)) {
            throw new IllegalArgumentException("Symbol '" + c2 + "' is already defined!");
        }
        if (c2.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.g.put(c2, ingredient);
        return this;
    }

    public ShapedRecipeBuilder b(String patternStr) {
        if (!this.f.isEmpty() && patternStr.length() != this.f.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.f.add(patternStr);
        return this;
    }

    @Override
    public ShapedRecipeBuilder b(String string, Criterion<?> criterion) {
        this.h.put(string, criterion);
        return this;
    }

    @Override
    public ShapedRecipeBuilder c(@Nullable String string) {
        this.i = string;
        return this;
    }

    public ShapedRecipeBuilder a(boolean showNotification) {
        this.j = showNotification;
        return this;
    }

    @Override
    @Override
    public Item a() {
        return this.d;
    }

    @Override
    @Override
    public void a(RecipeOutput exporter, ResourceKey<IRecipe<?>> recipeKey) {
        ShapedRecipePattern shapedRecipePattern = this.a(recipeKey);
        Advancement.SerializedAdvancement builder = exporter.a().a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(recipeKey)).a(AdvancementRewards.a.c(recipeKey)).a(AdvancementRequirements.a.b);
        this.h.forEach(builder::a);
        ShapedRecipes shapedRecipe = new ShapedRecipes(Objects.requireNonNullElse(this.i, ""), RecipeBuilder.a(this.c), shapedRecipePattern, new ItemStack(this.d, this.e), this.j);
        exporter.a(recipeKey, shapedRecipe, builder.b(recipeKey.a().f("recipes/" + this.c.a() + "/")));
    }

    private ShapedRecipePattern a(ResourceKey<IRecipe<?>> recipeKey) {
        if (this.h.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeKey.a()));
        }
        return ShapedRecipePattern.a(this.g, this.f);
    }

    @Override
    public /* synthetic */ RecipeBuilder a(@Nullable String group) {
        return this.c(group);
    }

    public /* synthetic */ RecipeBuilder a(String name, Criterion criterion) {
        return this.b(name, criterion);
    }
}

