/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.ShapelessRecipes;
import net.minecraft.world.level.IMaterial;

public class ShapelessRecipeBuilder
implements RecipeBuilder {
    private final HolderGetter<Item> b;
    private final RecipeCategory c;
    private final ItemStack d;
    private final List<RecipeItemStack> e = new ArrayList<RecipeItemStack>();
    private final Map<String, Criterion<?>> f = new LinkedHashMap();
    @Nullable
    private String g;

    private ShapelessRecipeBuilder(HolderGetter<Item> registryLookup, RecipeCategory category, ItemStack output) {
        this.b = registryLookup;
        this.c = category;
        this.d = output;
    }

    public static ShapelessRecipeBuilder a(HolderGetter<Item> registryLookup, RecipeCategory category, ItemStack output) {
        return new ShapelessRecipeBuilder(registryLookup, category, output);
    }

    public static ShapelessRecipeBuilder a(HolderGetter<Item> registryLookup, RecipeCategory category, IMaterial output) {
        return ShapelessRecipeBuilder.a(registryLookup, category, output, 1);
    }

    public static ShapelessRecipeBuilder a(HolderGetter<Item> registryLookup, RecipeCategory category, IMaterial output, int count) {
        return new ShapelessRecipeBuilder(registryLookup, category, output.j().n().c(count));
    }

    public ShapelessRecipeBuilder a(TagKey<Item> tag) {
        return this.a(RecipeItemStack.a(this.b.b(tag)));
    }

    public ShapelessRecipeBuilder b(IMaterial item) {
        return this.a(item, 1);
    }

    public ShapelessRecipeBuilder a(IMaterial item, int amount) {
        for (int i2 = 0; i2 < amount; ++i2) {
            this.a(RecipeItemStack.a(item));
        }
        return this;
    }

    public ShapelessRecipeBuilder a(RecipeItemStack ingredient) {
        return this.a(ingredient, 1);
    }

    public ShapelessRecipeBuilder a(RecipeItemStack ingredient, int amount) {
        for (int i2 = 0; i2 < amount; ++i2) {
            this.e.add(ingredient);
        }
        return this;
    }

    @Override
    public ShapelessRecipeBuilder b(String string, Criterion<?> criterion) {
        this.f.put(string, criterion);
        return this;
    }

    @Override
    public ShapelessRecipeBuilder b(@Nullable String string) {
        this.g = string;
        return this;
    }

    @Override
    @Override
    public Item a() {
        return this.d.h();
    }

    @Override
    @Override
    public void a(RecipeOutput exporter, ResourceKey<IRecipe<?>> recipeKey) {
        this.a(recipeKey);
        Advancement.SerializedAdvancement builder = exporter.a().a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(recipeKey)).a(AdvancementRewards.a.c(recipeKey)).a(AdvancementRequirements.a.b);
        this.f.forEach(builder::a);
        ShapelessRecipes shapelessRecipe = new ShapelessRecipes(Objects.requireNonNullElse(this.g, ""), RecipeBuilder.a(this.c), this.d, this.e);
        exporter.a(recipeKey, shapelessRecipe, builder.b(recipeKey.a().f("recipes/" + this.c.a() + "/")));
    }

    private void a(ResourceKey<IRecipe<?>> recipeKey) {
        if (this.f.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeKey.a()));
        }
    }

    @Override
    public /* synthetic */ RecipeBuilder a(@Nullable String group) {
        return this.b(group);
    }

    public /* synthetic */ RecipeBuilder a(String name, Criterion criterion) {
        return this.b(name, criterion);
    }
}

