/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.structures;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.util.FastBufferedInputStream;
import org.slf4j.Logger;

public class DebugReportNBT
implements DebugReportProvider {
    private static final Logger d = LogUtils.getLogger();
    private final Iterable<Path> e;
    private final PackOutput f;

    public DebugReportNBT(PackOutput output, Collection<Path> paths) {
        this.e = paths;
        this.f = output;
    }

    @Override
    @Override
    public CompletableFuture<?> a(CachedOutput writer) {
        Path path = this.f.a();
        ArrayList<CompletionStage> list = new ArrayList<CompletionStage>();
        for (Path path2 : this.e) {
            list.add(CompletableFuture.supplyAsync(() -> {
                CompletableFuture<Void> completableFuture;
                block8: {
                    Stream<Path> stream = Files.walk(path2, new FileVisitOption[0]);
                    try {
                        completableFuture = CompletableFuture.allOf((CompletableFuture[])stream.filter(path -> path.toString().endsWith(".nbt")).map(path -> CompletableFuture.runAsync(() -> DebugReportNBT.a(writer, path, DebugReportNBT.a(path2, path), path), SystemUtils.h())).toArray(CompletableFuture[]::new));
                        if (stream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            d.error("Failed to read structure input directory", (Throwable)iOException);
                            return CompletableFuture.completedFuture(null);
                        }
                    }
                    stream.close();
                }
                return completableFuture;
            }, SystemUtils.g().a("NbtToSnbt")).thenCompose(future -> future));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    @Override
    @Override
    public final String a() {
        return "NBT -> SNBT";
    }

    private static String a(Path inputPath, Path filePath) {
        String string = inputPath.relativize(filePath).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".nbt".length());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Path a(CachedOutput writer, Path inputPath, String filename, Path outputPath) {
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);){
            Path path;
            try (FastBufferedInputStream inputStream2 = new FastBufferedInputStream(inputStream);){
                Path path2 = outputPath.resolve(filename + ".snbt");
                DebugReportNBT.a(writer, path2, GameProfileSerializer.a(NBTCompressedStreamTools.a(inputStream2, NBTReadLimiter.a())));
                d.info("Converted {} from NBT to SNBT", (Object)filename);
                path = path2;
            }
            return path;
        }
        catch (IOException iOException) {
            d.error("Couldn't convert {} from NBT to SNBT at {}", new Object[]{filename, inputPath, iOException});
            return null;
        }
    }

    public static void a(CachedOutput writer, Path path, String content) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
        hashingOutputStream.write(content.getBytes(StandardCharsets.UTF_8));
        hashingOutputStream.write(10);
        writer.writeIfNeeded(path, byteArrayOutputStream.toByteArray(), hashingOutputStream.hash());
    }
}

