/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class ItemTagsProvider
extends IntrinsicHolderTagsProvider<Item> {
    private final CompletableFuture<TagsProvider.c<Block>> d;
    private final Map<TagKey<Block>, TagKey<Item>> g = new HashMap<TagKey<Block>, TagKey<Item>>();

    public ItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.a> registriesFuture, CompletableFuture<TagsProvider.c<Block>> blockTagLookupFuture) {
        super(output, Registries.K, registriesFuture, (T item) -> item.f().h());
        this.d = blockTagLookupFuture;
    }

    public ItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.a> registriesFuture, CompletableFuture<TagsProvider.c<Item>> parentTagLookupFuture, CompletableFuture<TagsProvider.c<Block>> blockTagLookupFuture) {
        super(output, Registries.K, registriesFuture, parentTagLookupFuture, item -> item.f().h());
        this.d = blockTagLookupFuture;
    }

    protected void a(TagKey<Block> blockTag, TagKey<Item> itemTag) {
        this.g.put(blockTag, itemTag);
    }

    @Override
    @Override
    protected CompletableFuture<HolderLookup.a> b() {
        return super.b().thenCombine(this.d, (registries, blockTags) -> {
            this.g.forEach((blockTag, itemTag) -> {
                TagBuilder tagBuilder = this.c(itemTag);
                Optional optional = (Optional)blockTags.apply(blockTag);
                ((TagBuilder)optional.orElseThrow(() -> new IllegalStateException("Missing block tag " + String.valueOf(itemTag.b())))).b().forEach(tagBuilder::a);
            });
            return registries;
        });
    }
}

