/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessSequence;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockButtonAbstract;
import net.minecraft.world.level.block.BlockLever;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class GameTestHarnessHelper {
    private final GameTestHarnessInfo a;
    private boolean b;

    public GameTestHarnessHelper(GameTestHarnessInfo test) {
        this.a = test;
    }

    public WorldServer a() {
        return this.a.g();
    }

    public IBlockData a(BlockPosition pos) {
        return this.a().a_(this.j(pos));
    }

    public <T extends TileEntity> T b(BlockPosition pos) {
        TileEntity blockEntity = this.a().c_(this.j(pos));
        if (blockEntity == null) {
            throw new GameTestHarnessAssertionPosition("Missing block entity", this.j(pos), pos, this.a.p());
        }
        return (T)blockEntity;
    }

    public void b() {
        this.a(Entity.class);
    }

    public void a(Class entityClass) {
        AxisAlignedBB aABB = this.j();
        List<Entity> list = this.a().a(entityClass, aABB.g(1.0), (? super T entity) -> !(entity instanceof EntityHuman));
        list.forEach(entity -> entity.c(this.a()));
    }

    public EntityItem a(Item item, Vec3D pos) {
        WorldServer serverLevel = this.a();
        Vec3D vec3 = this.a(pos);
        EntityItem itemEntity = new EntityItem(serverLevel, vec3.d, vec3.e, vec3.f, new ItemStack(item, 1));
        itemEntity.n(0.0, 0.0, 0.0);
        serverLevel.b(itemEntity);
        return itemEntity;
    }

    public EntityItem a(Item item, float x2, float y2, float z2) {
        return this.a(item, new Vec3D(x2, y2, z2));
    }

    public EntityItem a(Item item, BlockPosition pos) {
        return this.a(item, (float)pos.u(), (float)pos.v(), (float)pos.w());
    }

    public <E extends Entity> E a(EntityTypes<E> type, BlockPosition pos) {
        return this.a(type, Vec3D.c(pos));
    }

    public <E extends Entity> E a(EntityTypes<E> type, Vec3D pos) {
        WorldServer serverLevel = this.a();
        E entity = type.a(serverLevel, EntitySpawnReason.d);
        if (entity == null) {
            throw new NullPointerException("Failed to create entity " + String.valueOf(type.r().h().a()));
        }
        if (entity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)entity;
            mob.ai();
        }
        Vec3D vec3 = this.a(pos);
        ((Entity)entity).b(vec3.d, vec3.e, vec3.f, ((Entity)entity).dM(), ((Entity)entity).dO());
        serverLevel.b((Entity)entity);
        return entity;
    }

    public void a(Entity entity, DamageSource damageSource, float amount) {
        entity.a(this.a(), damageSource, amount);
    }

    public void a(Entity entity) {
        entity.c(this.a());
    }

    public <E extends Entity> E a(EntityTypes<E> type) {
        return this.a(type, 0, 0, 0, 2.147483647E9);
    }

    public <E extends Entity> E a(EntityTypes<E> type, int x2, int y2, int z2, double margin) {
        List<E> list = this.b(type, x2, y2, z2, margin);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertion("Expected " + type.j() + " to exist around " + x2 + "," + y2 + "," + z2);
        }
        if (list.size() > 1) {
            throw new GameTestHarnessAssertion("Expected only one " + type.j() + " to exist around " + x2 + "," + y2 + "," + z2 + ", but found " + list.size());
        }
        Vec3D vec3 = this.a(new Vec3D(x2, y2, z2));
        list.sort((a2, b2) -> {
            double d2 = a2.du().f(vec3);
            double e2 = b2.du().f(vec3);
            return Double.compare(d2, e2);
        });
        return (E)((Entity)list.get(0));
    }

    public <E extends Entity> List<E> b(EntityTypes<E> type, int x2, int y2, int z2, double margin) {
        return this.a(type, Vec3D.c(new BlockPosition(x2, y2, z2)), margin);
    }

    public <E extends Entity> List<E> a(EntityTypes<E> type, Vec3D pos, double margin) {
        WorldServer serverLevel = this.a();
        Vec3D vec3 = this.a(pos);
        AxisAlignedBB aABB = this.a.e();
        AxisAlignedBB aABB2 = new AxisAlignedBB(vec3.b(-margin, -margin, -margin), vec3.b(margin, margin, margin));
        return serverLevel.a(type, aABB, (? super T entity) -> entity.cR().c(aABB2) && entity.bL());
    }

    public <E extends Entity> E a(EntityTypes<E> type, int x2, int y2, int z2) {
        return this.a(type, new BlockPosition(x2, y2, z2));
    }

    public <E extends Entity> E a(EntityTypes<E> type, float x2, float y2, float z2) {
        return this.a(type, new Vec3D(x2, y2, z2));
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, BlockPosition pos) {
        EntityInsentient mob = (EntityInsentient)this.a(type, pos);
        mob.gh();
        return (E)mob;
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, int x2, int y2, int z2) {
        return this.b(type, new BlockPosition(x2, y2, z2));
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, Vec3D pos) {
        EntityInsentient mob = (EntityInsentient)this.a(type, pos);
        mob.gh();
        return (E)mob;
    }

    public <E extends EntityInsentient> E b(EntityTypes<E> type, float x2, float y2, float z2) {
        return this.b(type, new Vec3D(x2, y2, z2));
    }

    public void a(EntityInsentient entity, float x2, float y2, float z2) {
        Vec3D vec3 = this.a(new Vec3D(x2, y2, z2));
        entity.b(vec3.d, vec3.e, vec3.f, entity.dM(), entity.dO());
    }

    public GameTestHarnessSequence a(EntityInsentient entity, BlockPosition pos, float speed) {
        return this.g().a(2, () -> {
            PathEntity path = entity.L().a(this.j(pos), 0);
            entity.L().a(path, (double)speed);
        });
    }

    public void a(int x2, int y2, int z2) {
        this.c(new BlockPosition(x2, y2, z2));
    }

    public void c(BlockPosition pos) {
        this.b(pos, (IBlockData state) -> state.a(TagsBlock.f), () -> "Expected button");
        BlockPosition blockPos = this.j(pos);
        IBlockData blockState = this.a().a_(blockPos);
        BlockButtonAbstract buttonBlock = (BlockButtonAbstract)blockState.b();
        buttonBlock.a(blockState, (World)this.a(), blockPos, (EntityHuman)null);
    }

    public void d(BlockPosition pos) {
        this.a(pos, this.a(EnumGamemode.b));
    }

    public void a(BlockPosition pos, EntityHuman player) {
        BlockPosition blockPos = this.j(pos);
        this.a(pos, player, new MovingObjectPositionBlock(Vec3D.b(blockPos), EnumDirection.c, blockPos, true));
    }

    public void a(BlockPosition pos, EntityHuman player, MovingObjectPositionBlock result) {
        EnumHand interactionHand;
        BlockPosition blockPos = this.j(pos);
        IBlockData blockState = this.a().a_(blockPos);
        EnumInteractionResult interactionResult = blockState.a(player.b(interactionHand = EnumHand.a), this.a(), player, interactionHand, result);
        if (interactionResult.a()) {
            return;
        }
        if (interactionResult instanceof EnumInteractionResult.f && blockState.a((World)this.a(), player, result).a()) {
            return;
        }
        ItemActionContext useOnContext = new ItemActionContext(player, interactionHand, result);
        player.b(interactionHand).a(useOnContext);
    }

    public EntityLiving a(EntityLiving entity) {
        entity.j(0);
        entity.x(0.25f);
        return entity;
    }

    public EntityLiving b(EntityLiving entity) {
        entity.x(0.25f);
        return entity;
    }

    public EntityHuman a(final EnumGamemode gameMode) {
        return new EntityHuman(this, this.a(), BlockPosition.c, 0.0f, new GameProfile(UUID.randomUUID(), "test-mock-player")){

            @Override
            @Override
            public boolean aa_() {
                return gameMode == EnumGamemode.d;
            }

            @Override
            @Override
            public boolean b() {
                return gameMode.g();
            }

            @Override
            @Override
            public boolean c() {
                return true;
            }
        };
    }

    @Deprecated(forRemoval=true)
    public EntityPlayer c() {
        CommonListenerCookie commonListenerCookie = CommonListenerCookie.a(new GameProfile(UUID.randomUUID(), "test-mock-player"), false);
        EntityPlayer serverPlayer = new EntityPlayer(this, this.a().p(), this.a(), commonListenerCookie.a(), commonListenerCookie.c()){

            @Override
            @Override
            public boolean aa_() {
                return false;
            }

            @Override
            @Override
            public boolean b() {
                return true;
            }
        };
        NetworkManager connection = new NetworkManager(EnumProtocolDirection.a);
        EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{connection});
        this.a().p().ag().a(connection, serverPlayer, commonListenerCookie);
        return serverPlayer;
    }

    public void b(int x2, int y2, int z2) {
        this.e(new BlockPosition(x2, y2, z2));
    }

    public void e(BlockPosition pos) {
        this.a(Blocks.dI, pos);
        BlockPosition blockPos = this.j(pos);
        IBlockData blockState = this.a().a_(blockPos);
        BlockLever leverBlock = (BlockLever)blockState.b();
        leverBlock.b(blockState, (World)this.a(), blockPos, null);
    }

    public void a(BlockPosition pos, long delay) {
        this.a(pos, Blocks.hq);
        this.b(delay, () -> this.a(pos, Blocks.a));
    }

    public void f(BlockPosition pos) {
        this.a().a(this.j(pos), false, null);
    }

    public void a(int x2, int y2, int z2, Block block) {
        this.a(new BlockPosition(x2, y2, z2), block);
    }

    public void a(int x2, int y2, int z2, IBlockData state) {
        this.a(new BlockPosition(x2, y2, z2), state);
    }

    public void a(BlockPosition pos, Block block) {
        this.a(pos, block.m());
    }

    public void a(BlockPosition pos, IBlockData state) {
        this.a().a(this.j(pos), state, 3);
    }

    public void d() {
        this.a(13000);
    }

    public void a(int timeOfDay) {
        this.a().b((long)timeOfDay);
    }

    public void a(Block block, int x2, int y2, int z2) {
        this.a(block, new BlockPosition(x2, y2, z2));
    }

    public void a(Block block, BlockPosition pos) {
        IBlockData blockState = this.a(pos);
        this.a((Object)pos, (Object)block1 -> blockState.a(block), "Expected " + block.f().getString() + ", got " + blockState.b().f().getString());
    }

    public void b(Block block, int x2, int y2, int z2) {
        this.b(block, new BlockPosition(x2, y2, z2));
    }

    public void b(Block block, BlockPosition pos) {
        this.a((Object)pos, (Object)block1 -> !this.a(pos).a(block), "Did not expect " + block.f().getString());
    }

    public void c(Block block, int x2, int y2, int z2) {
        this.c(block, new BlockPosition(x2, y2, z2));
    }

    public void c(Block block, BlockPosition pos) {
        this.b(() -> this.a(block, pos));
    }

    public void a(BlockPosition pos, Predicate<Block> predicate, String errorMessage) {
        this.a(pos, predicate, () -> errorMessage);
    }

    public void a(BlockPosition pos, Predicate<Block> predicate, Supplier<String> errorMessageSupplier) {
        this.b(pos, (IBlockData state) -> predicate.test(state.b()), errorMessageSupplier);
    }

    public <T extends Comparable<T>> void a(BlockPosition pos, IBlockState<T> property, T value) {
        IBlockData blockState = this.a(pos);
        boolean bl = blockState.b(property);
        if (!bl || !blockState.c(property).equals(value)) {
            String string = bl ? "was " + String.valueOf(blockState.c(property)) : "property " + property.f() + " is missing";
            String string2 = String.format(Locale.ROOT, "Expected property %s to be %s, %s", property.f(), value, string);
            throw new GameTestHarnessAssertionPosition(string2, this.j(pos), pos, this.a.p());
        }
    }

    public <T extends Comparable<T>> void a(BlockPosition pos, IBlockState<T> property, Predicate<T> predicate, String errorMessage) {
        this.b(pos, (IBlockData state) -> {
            if (!state.b(property)) {
                return false;
            }
            Object comparable = state.c(property);
            return predicate.test(comparable);
        }, () -> errorMessage);
    }

    public void b(BlockPosition pos, Predicate<IBlockData> predicate, Supplier<String> errorMessageSupplier) {
        IBlockData blockState = this.a(pos);
        if (!predicate.test(blockState)) {
            throw new GameTestHarnessAssertionPosition(errorMessageSupplier.get(), this.j(pos), pos, this.a.p());
        }
    }

    public <T extends TileEntity> void c(BlockPosition pos, Predicate<T> predicate, Supplier<String> errorMessageSupplier) {
        T blockEntity = this.b(pos);
        if (!predicate.test(blockEntity)) {
            throw new GameTestHarnessAssertionPosition(errorMessageSupplier.get(), this.j(pos), pos, this.a.p());
        }
    }

    public void a(BlockPosition pos, EnumDirection direction, IntPredicate powerPredicate, Supplier<String> errorMessage) {
        BlockPosition blockPos = this.j(pos);
        WorldServer serverLevel = this.a();
        IBlockData blockState = serverLevel.a_(blockPos);
        int i2 = blockState.a((IBlockAccess)serverLevel, blockPos, direction);
        if (!powerPredicate.test(i2)) {
            throw new GameTestHarnessAssertionPosition(errorMessage.get(), blockPos, pos, this.a.p());
        }
    }

    public void b(EntityTypes<?> type) {
        List<Entity> list = this.a().a(type, this.j(), Entity::bL);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertion("Expected " + type.j() + " to exist");
        }
    }

    public void c(EntityTypes<?> type, int x2, int y2, int z2) {
        this.c(type, new BlockPosition(x2, y2, z2));
    }

    public void c(EntityTypes<?> type, BlockPosition pos) {
        BlockPosition blockPos = this.j(pos);
        List<Entity> list = this.a().a(type, new AxisAlignedBB(blockPos), Entity::bL);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + type.j(), blockPos, pos, this.a.p());
        }
    }

    public void a(EntityTypes<?> type, AxisAlignedBB box) {
        AxisAlignedBB aABB = this.a(box);
        List<Entity> list = this.a().a(type, aABB, Entity::bL);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + type.j(), BlockPosition.a(aABB.f()), BlockPosition.a(box.f()), this.a.p());
        }
    }

    public void a(EntityTypes<?> type, int amount) {
        List<Entity> list = this.a().a(type, this.j(), Entity::bL);
        if (list.size() != amount) {
            throw new GameTestHarnessAssertion("Expected " + amount + " of type " + type.j() + " to exist, found " + list.size());
        }
    }

    public void a(EntityTypes<?> type, BlockPosition pos, int amount, double radius) {
        BlockPosition blockPos = this.j(pos);
        List<?> list = this.b(type, pos, radius);
        if (list.size() != amount) {
            throw new GameTestHarnessAssertionPosition("Expected " + amount + " entities of type " + type.j() + ", actual number of entities found=" + list.size(), blockPos, pos, this.a.p());
        }
    }

    public void a(EntityTypes<?> type, BlockPosition pos, double radius) {
        List<?> list = this.b(type, pos, radius);
        if (list.isEmpty()) {
            BlockPosition blockPos = this.j(pos);
            throw new GameTestHarnessAssertionPosition("Expected " + type.j(), blockPos, pos, this.a.p());
        }
    }

    public <T extends Entity> List<T> b(EntityTypes<T> type, BlockPosition pos, double radius) {
        BlockPosition blockPos = this.j(pos);
        return this.a().a(type, new AxisAlignedBB(blockPos).g(radius), Entity::bL);
    }

    public <T extends Entity> List<T> c(EntityTypes<T> type) {
        return this.a().a(type, this.j(), Entity::bL);
    }

    public void a(Entity entity, int x2, int y2, int z2) {
        this.a(entity, new BlockPosition(x2, y2, z2));
    }

    public void a(Entity entity, BlockPosition pos) {
        BlockPosition blockPos = this.j(pos);
        List<Entity> list = this.a().a(entity.aq(), new AxisAlignedBB(blockPos), Entity::bL);
        list.stream().filter(e2 -> e2 == entity).findFirst().orElseThrow(() -> new GameTestHarnessAssertionPosition("Expected " + entity.aq().j(), blockPos, pos, this.a.p()));
    }

    public void a(Item item, BlockPosition pos, double radius, int amount) {
        BlockPosition blockPos = this.j(pos);
        List<EntityItem> list = this.a().a(EntityTypes.ar, new AxisAlignedBB(blockPos).g(radius), Entity::bL);
        int i2 = 0;
        for (EntityItem itemEntity : list) {
            ItemStack itemStack = itemEntity.l();
            if (!itemStack.a(item)) continue;
            i2 += itemStack.L();
        }
        if (i2 != amount) {
            throw new GameTestHarnessAssertionPosition("Expected " + amount + " " + item.m().getString() + " items to exist (found " + i2 + ")", blockPos, pos, this.a.p());
        }
    }

    public void a(Item item, BlockPosition pos, double radius) {
        BlockPosition blockPos = this.j(pos);
        List<EntityItem> list = this.a().a(EntityTypes.ar, new AxisAlignedBB(blockPos).g(radius), Entity::bL);
        for (Entity entity : list) {
            EntityItem itemEntity = (EntityItem)entity;
            if (!itemEntity.l().h().equals(item)) continue;
            return;
        }
        throw new GameTestHarnessAssertionPosition("Expected " + item.m().getString() + " item", blockPos, pos, this.a.p());
    }

    public void b(Item item, BlockPosition pos, double radius) {
        BlockPosition blockPos = this.j(pos);
        List<EntityItem> list = this.a().a(EntityTypes.ar, new AxisAlignedBB(blockPos).g(radius), Entity::bL);
        for (Entity entity : list) {
            EntityItem itemEntity = (EntityItem)entity;
            if (!itemEntity.l().h().equals(item)) continue;
            throw new GameTestHarnessAssertionPosition("Did not expect " + item.m().getString() + " item", blockPos, pos, this.a.p());
        }
    }

    public void a(Item item) {
        List<EntityItem> list = this.a().a(EntityTypes.ar, this.j(), Entity::bL);
        for (Entity entity : list) {
            EntityItem itemEntity = (EntityItem)entity;
            if (!itemEntity.l().h().equals(item)) continue;
            return;
        }
        throw new GameTestHarnessAssertion("Expected " + item.m().getString() + " item");
    }

    public void b(Item item) {
        List<EntityItem> list = this.a().a(EntityTypes.ar, this.j(), Entity::bL);
        for (Entity entity : list) {
            EntityItem itemEntity = (EntityItem)entity;
            if (!itemEntity.l().h().equals(item)) continue;
            throw new GameTestHarnessAssertion("Did not expect " + item.m().getString() + " item");
        }
    }

    public void d(EntityTypes<?> type) {
        List<Entity> list = this.a().a(type, this.j(), Entity::bL);
        if (!list.isEmpty()) {
            throw new GameTestHarnessAssertion("Did not expect " + type.j() + " to exist");
        }
    }

    public void d(EntityTypes<?> type, int x2, int y2, int z2) {
        this.d(type, new BlockPosition(x2, y2, z2));
    }

    public void d(EntityTypes<?> type, BlockPosition pos) {
        BlockPosition blockPos = this.j(pos);
        List<Entity> list = this.a().a(type, new AxisAlignedBB(blockPos), Entity::bL);
        if (!list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Did not expect " + type.j(), blockPos, pos, this.a.p());
        }
    }

    public void b(EntityTypes<?> type, AxisAlignedBB box) {
        AxisAlignedBB aABB = this.a(box);
        List<Entity> list = this.a().a(type, aABB, Entity::bL);
        if (!list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Did not expect " + type.j(), BlockPosition.a(aABB.f()), BlockPosition.a(box.f()), this.a.p());
        }
    }

    public void a(EntityTypes<?> type, double x2, double y2, double z2) {
        Vec3D vec3 = new Vec3D(x2, y2, z2);
        Vec3D vec32 = this.a(vec3);
        Predicate<Entity> predicate = entity -> entity.cR().a(vec32, vec32);
        List<Entity> list = this.a().a(type, this.j(), predicate);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertion("Expected " + type.j() + " to touch " + String.valueOf(vec32) + " (relative " + String.valueOf(vec3) + ")");
        }
    }

    public void b(EntityTypes<?> type, double x2, double y2, double z2) {
        Vec3D vec3 = new Vec3D(x2, y2, z2);
        Vec3D vec32 = this.a(vec3);
        Predicate<Entity> predicate = entity -> !entity.cR().a(vec32, vec32);
        List<Entity> list = this.a().a(type, this.j(), predicate);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertion("Did not expect " + type.j() + " to touch " + String.valueOf(vec32) + " (relative " + String.valueOf(vec3) + ")");
        }
    }

    public <E extends Entity, T> void a(BlockPosition pos, EntityTypes<E> type, Predicate<E> predicate) {
        BlockPosition blockPos = this.j(pos);
        List<Entity> list = this.a().a(type, new AxisAlignedBB(blockPos), Entity::bL);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + type.j(), blockPos, pos, this.a.p());
        }
        for (Entity entity : list) {
            if (predicate.test(entity)) continue;
            throw new GameTestHarnessAssertion("Test failed for entity " + String.valueOf(entity));
        }
    }

    public <E extends Entity, T> void a(BlockPosition pos, EntityTypes<E> type, Function<? super E, T> entityDataGetter, @Nullable T data) {
        BlockPosition blockPos = this.j(pos);
        List<Entity> list = this.a().a(type, new AxisAlignedBB(blockPos), Entity::bL);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + type.j(), blockPos, pos, this.a.p());
        }
        for (Entity entity : list) {
            T object = entityDataGetter.apply(entity);
            if (Objects.equals(object, data)) continue;
            throw new GameTestHarnessAssertion("Expected entity data to be: " + String.valueOf(data) + ", but was: " + String.valueOf(object));
        }
    }

    public <E extends EntityLiving> void a(BlockPosition pos, EntityTypes<E> entityType, Item item) {
        BlockPosition blockPos = this.j(pos);
        List<EntityLiving> list = this.a().a(entityType, new AxisAlignedBB(blockPos), Entity::bL);
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected entity of type: " + String.valueOf(entityType), blockPos, pos, this.i());
        }
        for (EntityLiving livingEntity : list) {
            if (!livingEntity.b(item)) continue;
            return;
        }
        throw new GameTestHarnessAssertionPosition("Entity should be holding: " + String.valueOf(item), blockPos, pos, this.i());
    }

    public <E extends Entity> void b(BlockPosition pos, EntityTypes<E> entityType, Item item) {
        BlockPosition blockPos = this.j(pos);
        List<Entity> list = this.a().a(entityType, new AxisAlignedBB(blockPos), (? super T entity) -> ((Entity)entity).bL());
        if (list.isEmpty()) {
            throw new GameTestHarnessAssertionPosition("Expected " + entityType.j() + " to exist", blockPos, pos, this.i());
        }
        for (Entity entity2 : list) {
            if (!((InventoryCarrier)((Object)entity2)).t().a_(stack -> stack.a(item))) continue;
            return;
        }
        throw new GameTestHarnessAssertionPosition("Entity inventory should contain: " + String.valueOf(item), blockPos, pos, this.i());
    }

    public void g(BlockPosition pos) {
        BlockPosition blockPos = this.j(pos);
        TileEntity blockEntity = this.a().c_(blockPos);
        if (blockEntity instanceof TileEntityContainer && !((TileEntityContainer)blockEntity).c()) {
            throw new GameTestHarnessAssertion("Container should be empty");
        }
    }

    public void a(BlockPosition pos, Item item) {
        BlockPosition blockPos = this.j(pos);
        TileEntity blockEntity = this.a().c_(blockPos);
        if (!(blockEntity instanceof TileEntityContainer)) {
            MinecraftKey resourceLocation = blockEntity != null ? BuiltInRegistries.j.b(blockEntity.q()) : null;
            throw new GameTestHarnessAssertion("Expected a container at " + String.valueOf(pos) + ", found " + String.valueOf(resourceLocation));
        }
        if (((TileEntityContainer)blockEntity).a_(item) != 1) {
            throw new GameTestHarnessAssertion("Container should contain: " + String.valueOf(item));
        }
    }

    public void a(StructureBoundingBox checkedBlockBox, BlockPosition correctStatePos) {
        BlockPosition.a(checkedBlockBox).forEach(checkedPos -> {
            BlockPosition blockPos2 = correctStatePos.b(checkedPos.u() - checkedBlockBox.h(), checkedPos.v() - checkedBlockBox.i(), checkedPos.w() - checkedBlockBox.j());
            this.a((BlockPosition)checkedPos, blockPos2);
        });
    }

    public void a(BlockPosition checkedPos, BlockPosition correctStatePos) {
        IBlockData blockState2;
        IBlockData blockState = this.a(checkedPos);
        if (blockState != (blockState2 = this.a(correctStatePos))) {
            this.a("Incorrect state. Expected " + String.valueOf(blockState2) + ", got " + String.valueOf(blockState), checkedPos);
        }
    }

    public void a(long delay, BlockPosition pos, Item item) {
        this.a(delay, () -> this.a(pos, item));
    }

    public void a(long delay, BlockPosition pos) {
        this.a(delay, () -> this.g(pos));
    }

    public <E extends Entity, T> void b(BlockPosition pos, EntityTypes<E> type, Function<E, T> entityDataGetter, T data) {
        this.b(() -> this.a(pos, type, entityDataGetter, data));
    }

    public void a(Entity entity, AxisAlignedBB box, String message) {
        if (!box.d(this.b(entity.du()))) {
            this.a(message);
        }
    }

    public <E extends Entity> void a(E entity, Predicate<E> predicate, String testName) {
        if (!predicate.test(entity)) {
            throw new GameTestHarnessAssertion("Entity " + String.valueOf(entity) + " failed " + testName + " test");
        }
    }

    public <E extends Entity, T> void a(E entity, Function<E, T> propertyGetter, String propertyName, T expectedValue) {
        T object = propertyGetter.apply(entity);
        if (!object.equals(expectedValue)) {
            throw new GameTestHarnessAssertion("Entity " + String.valueOf(entity) + " value " + propertyName + "=" + String.valueOf(object) + " is not equal to expected " + String.valueOf(expectedValue));
        }
    }

    public void a(EntityLiving entity, Holder<MobEffectList> effect, int amplifier) {
        MobEffect mobEffectInstance = entity.c(effect);
        if (mobEffectInstance == null || mobEffectInstance.e() != amplifier) {
            int i2 = amplifier + 1;
            throw new GameTestHarnessAssertion("Entity " + String.valueOf(entity) + " failed has " + effect.a().d() + " x " + i2 + " test");
        }
    }

    public void e(EntityTypes<?> type, int x2, int y2, int z2) {
        this.e(type, new BlockPosition(x2, y2, z2));
    }

    public void e(EntityTypes<?> type, BlockPosition pos) {
        this.b(() -> this.c(type, pos));
    }

    public void f(EntityTypes<?> type, int x2, int y2, int z2) {
        this.f(type, new BlockPosition(x2, y2, z2));
    }

    public void f(EntityTypes<?> type, BlockPosition pos) {
        this.b(() -> this.d(type, pos));
    }

    public void e() {
        this.a.m();
    }

    private void k() {
        if (this.b) {
            throw new IllegalStateException("This test already has final clause");
        }
        this.b = true;
    }

    public void a(Runnable runnable) {
        this.k();
        this.a.q().a(0L, runnable).a();
    }

    public void b(Runnable runnable) {
        this.k();
        this.a.q().a(runnable).a();
    }

    public void a(int duration, Runnable runnable) {
        this.k();
        this.a.q().a((long)duration, runnable).a();
    }

    public void a(long tick, Runnable runnable) {
        this.a.a(tick, runnable);
    }

    public void b(long ticks, Runnable runnable) {
        this.a(this.a.p() + ticks, runnable);
    }

    public void h(BlockPosition pos) {
        BlockPosition blockPos = this.j(pos);
        WorldServer serverLevel = this.a();
        serverLevel.a_(blockPos).b(serverLevel, blockPos, serverLevel.A);
    }

    public void i(BlockPosition pos) {
        BlockPosition blockPos = this.j(pos);
        WorldServer serverLevel = this.a();
        serverLevel.a(blockPos);
    }

    public void f() {
        AxisAlignedBB aABB = this.l();
        int i2 = (int)Math.floor(aABB.d);
        int j2 = (int)Math.floor(aABB.f);
        int k2 = (int)Math.floor(aABB.e);
        for (int l2 = (int)Math.floor(aABB.a); l2 < i2; ++l2) {
            for (int m2 = (int)Math.floor(aABB.c); m2 < j2; ++m2) {
                this.i(new BlockPosition(l2, k2, m2));
            }
        }
    }

    public int a(HeightMap.Type heightmap, int x2, int z2) {
        BlockPosition blockPos = this.j(new BlockPosition(x2, 0, z2));
        return this.k(this.a().a(heightmap, blockPos)).v();
    }

    public void a(String message, BlockPosition pos) {
        throw new GameTestHarnessAssertionPosition(message, this.j(pos), pos, this.i());
    }

    public void a(String message, Entity entity) {
        throw new GameTestHarnessAssertionPosition(message, entity.dw(), this.k(entity.dw()), this.i());
    }

    public void a(String message) {
        throw new GameTestHarnessAssertion(message);
    }

    public void c(Runnable task) {
        this.a.q().a(task).a(() -> new GameTestHarnessAssertion("Fail conditions met"));
    }

    public void d(Runnable task) {
        LongStream.range(this.a.p(), this.a.w()).forEach(tick -> this.a.a(tick, task::run));
    }

    public GameTestHarnessSequence g() {
        return this.a.q();
    }

    public BlockPosition j(BlockPosition pos) {
        BlockPosition blockPos = this.a.d();
        BlockPosition blockPos2 = blockPos.a(pos);
        return DefinedStructure.a(blockPos2, EnumBlockMirror.a, this.a.u(), blockPos);
    }

    public BlockPosition k(BlockPosition pos) {
        BlockPosition blockPos = this.a.d();
        EnumBlockRotation rotation = this.a.u().a(EnumBlockRotation.c);
        BlockPosition blockPos2 = DefinedStructure.a(pos, EnumBlockMirror.a, rotation, blockPos);
        return blockPos2.b(blockPos);
    }

    public AxisAlignedBB a(AxisAlignedBB box) {
        Vec3D vec3 = this.a(box.h());
        Vec3D vec32 = this.a(box.i());
        return new AxisAlignedBB(vec3, vec32);
    }

    public AxisAlignedBB b(AxisAlignedBB box) {
        Vec3D vec3 = this.b(box.h());
        Vec3D vec32 = this.b(box.i());
        return new AxisAlignedBB(vec3, vec32);
    }

    public Vec3D a(Vec3D pos) {
        Vec3D vec3 = Vec3D.a(this.a.d());
        return DefinedStructure.a(vec3.e(pos), EnumBlockMirror.a, this.a.u(), this.a.d());
    }

    public Vec3D b(Vec3D pos) {
        Vec3D vec3 = Vec3D.a(this.a.d());
        return DefinedStructure.a(pos.d(vec3), EnumBlockMirror.a, this.a.u(), this.a.d());
    }

    public EnumBlockRotation h() {
        return this.a.u();
    }

    public void a(boolean condition, String message) {
        if (!condition) {
            throw new GameTestHarnessAssertion(message);
        }
    }

    public <N> void a(N value, N expected, String name) {
        if (!value.equals(expected)) {
            throw new GameTestHarnessAssertion("Expected " + name + " to be " + String.valueOf(expected) + ", but was " + String.valueOf(value));
        }
    }

    public void b(boolean condition, String message) {
        if (condition) {
            throw new GameTestHarnessAssertion(message);
        }
    }

    public long i() {
        return this.a.p();
    }

    public AxisAlignedBB j() {
        return this.a.e();
    }

    private AxisAlignedBB l() {
        AxisAlignedBB aABB = this.a.e();
        EnumBlockRotation rotation = this.a.u();
        switch (rotation) {
            case d: 
            case b: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, aABB.d(), aABB.c(), aABB.b());
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, aABB.b(), aABB.c(), aABB.d());
    }

    public void a(Consumer<BlockPosition> posConsumer) {
        AxisAlignedBB aABB = this.l().a(1.0, 1.0, 1.0);
        BlockPosition.MutableBlockPosition.b(aABB).forEach(posConsumer);
    }

    public void e(Runnable runnable) {
        LongStream.range(this.a.p(), this.a.w()).forEach(tick -> this.a.a(tick, runnable::run));
    }

    public void a(EntityHuman player, ItemStack stack, BlockPosition pos, EnumDirection direction) {
        BlockPosition blockPos = this.j(pos.a(direction));
        MovingObjectPositionBlock blockHitResult = new MovingObjectPositionBlock(Vec3D.b(blockPos), direction, blockPos, false);
        ItemActionContext useOnContext = new ItemActionContext(player, EnumHand.a, blockHitResult);
        stack.a(useOnContext);
    }

    public void a(ResourceKey<BiomeBase> biome) {
        AxisAlignedBB aABB = this.j();
        BlockPosition blockPos = BlockPosition.a(aABB.a, aABB.b, aABB.c);
        BlockPosition blockPos2 = BlockPosition.a(aABB.d, aABB.e, aABB.f);
        Either<Integer, CommandSyntaxException> either = FillBiomeCommand.a(this.a(), blockPos, blockPos2, this.a().K_().e(Registries.aI).b(biome));
        if (either.right().isPresent()) {
            this.a("Failed to set biome for test");
        }
    }
}

