/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessHelper;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessSequence;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTimeout;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.AxisAlignedBB;

public class GameTestHarnessInfo {
    private final GameTestHarnessTestFunction a;
    @Nullable
    private BlockPosition b;
    @Nullable
    private BlockPosition c;
    private final WorldServer d;
    private final Collection<GameTestHarnessListener> e = Lists.newArrayList();
    private final int f;
    private final Collection<GameTestHarnessSequence> g = Lists.newCopyOnWriteArrayList();
    private final Object2LongMap<Runnable> h = new Object2LongOpenHashMap();
    private long i;
    private int j = 20;
    private boolean k;
    private boolean l;
    private long m;
    private boolean n;
    private final RetryOptions o;
    private final Stopwatch p = Stopwatch.createUnstarted();
    private boolean q;
    private final EnumBlockRotation r;
    @Nullable
    private Throwable s;
    @Nullable
    private TileEntityStructure t;

    public GameTestHarnessInfo(GameTestHarnessTestFunction testFunction, EnumBlockRotation rotation, WorldServer world, RetryOptions testAttemptConfig) {
        this.a = testFunction;
        this.d = world;
        this.o = testAttemptConfig;
        this.f = testFunction.f();
        this.r = testFunction.e().a(rotation);
    }

    void a(BlockPosition pos) {
        this.b = pos;
    }

    public GameTestHarnessInfo a(int additionalExpectedStopTime) {
        this.i = this.d.ac() + this.a.g() + (long)additionalExpectedStopTime;
        this.p.start();
        return this;
    }

    public GameTestHarnessInfo a() {
        if (this.k) {
            return this;
        }
        this.j = 0;
        this.k = true;
        TileEntityStructure structureBlockEntity = this.f();
        structureBlockEntity.c(this.d);
        StructureBoundingBox boundingBox = GameTestHarnessStructures.b(structureBlockEntity);
        this.d.n().a(boundingBox);
        this.d.a(boundingBox);
        return this;
    }

    private boolean E() {
        if (this.k) {
            return true;
        }
        if (this.j > 0) {
            --this.j;
            return false;
        }
        this.a().a(0);
        return true;
    }

    public void a(GameTestHarnessRunner context) {
        if (this.k()) {
            return;
        }
        if (this.t == null) {
            this.a(new IllegalStateException("Running test without structure block entity"));
        }
        if (!this.l && !GameTestHarnessStructures.b(this.t).b().allMatch(chunkPos -> this.d.f(chunkPos.l()))) {
            return;
        }
        this.l = true;
        if (!this.E()) {
            return;
        }
        this.F();
        if (this.k()) {
            if (this.s != null) {
                this.e.forEach(listener -> listener.b(this, context));
            } else {
                this.e.forEach(listener -> listener.a(this, context));
            }
        }
    }

    private void F() {
        this.m = this.d.ac() - this.i;
        if (this.m < 0L) {
            return;
        }
        if (!this.n) {
            this.G();
        }
        ObjectIterator objectIterator = this.h.object2LongEntrySet().iterator();
        while (objectIterator.hasNext()) {
            Object2LongMap.Entry entry = (Object2LongMap.Entry)objectIterator.next();
            if (entry.getLongValue() > this.m) continue;
            try {
                ((Runnable)entry.getKey()).run();
            }
            catch (Exception exception) {
                this.a(exception);
            }
            objectIterator.remove();
        }
        if (this.m > (long)this.f) {
            if (this.g.isEmpty()) {
                this.a(new GameTestHarnessTimeout("Didn't succeed or fail within " + this.a.f() + " ticks"));
            } else {
                this.g.forEach(runner -> runner.b(this.m));
                if (this.s == null) {
                    this.a(new GameTestHarnessTimeout("No sequences finished"));
                }
            }
        } else {
            this.g.forEach(runner -> runner.a(this.m));
        }
    }

    private void G() {
        if (this.n) {
            return;
        }
        this.n = true;
        try {
            this.a.a(new GameTestHarnessHelper(this));
        }
        catch (Exception exception) {
            this.a(exception);
        }
    }

    public void a(long tick, Runnable runnable) {
        this.h.put((Object)runnable, tick);
    }

    public String b() {
        return this.a.c();
    }

    @Nullable
    public BlockPosition c() {
        return this.b;
    }

    public BlockPosition d() {
        return GameTestHarnessStructures.c(this.t);
    }

    public AxisAlignedBB e() {
        TileEntityStructure structureBlockEntity = this.f();
        return GameTestHarnessStructures.a(structureBlockEntity);
    }

    public TileEntityStructure f() {
        if (this.t == null) {
            if (this.b == null) {
                throw new IllegalStateException("Could not find a structureBlockEntity for this GameTestInfo");
            }
            this.t = (TileEntityStructure)this.d.c_(this.b);
            if (this.t == null) {
                throw new IllegalStateException("Could not find a structureBlockEntity at the given coordinate " + String.valueOf(this.b));
            }
        }
        return this.t;
    }

    public WorldServer g() {
        return this.d;
    }

    public boolean h() {
        return this.q && this.s == null;
    }

    public boolean i() {
        return this.s != null;
    }

    public boolean j() {
        return this.n;
    }

    public boolean k() {
        return this.q;
    }

    public long l() {
        return this.p.elapsed(TimeUnit.MILLISECONDS);
    }

    private void H() {
        if (!this.q) {
            this.q = true;
            if (this.p.isRunning()) {
                this.p.stop();
            }
        }
    }

    public void m() {
        if (this.s == null) {
            this.H();
            AxisAlignedBB aABB = this.e();
            List<Entity> list = this.g().a(Entity.class, aABB.g(1.0), entity -> !(entity instanceof EntityHuman));
            list.forEach(entity -> entity.a(Entity.RemovalReason.b));
        }
    }

    public void a(Throwable throwable) {
        this.s = throwable;
        this.H();
    }

    @Nullable
    public Throwable n() {
        return this.s;
    }

    @Override
    public String toString() {
        return this.b();
    }

    public void a(GameTestHarnessListener listener) {
        this.e.add(listener);
    }

    public GameTestHarnessInfo o() {
        BlockPosition blockPos = this.D();
        this.t = GameTestHarnessStructures.b(this, blockPos, this.u(), this.d);
        this.b = this.t.aB_();
        GameTestHarnessStructures.a(this.b, new BlockPosition(1, 0, -1), this.u(), this.d);
        GameTestHarnessStructures.a(this.e(), this.d, !this.a.l());
        this.e.forEach(listener -> listener.a(this));
        return this;
    }

    long p() {
        return this.m;
    }

    GameTestHarnessSequence q() {
        GameTestHarnessSequence gameTestSequence = new GameTestHarnessSequence(this);
        this.g.add(gameTestSequence);
        return gameTestSequence;
    }

    public boolean r() {
        return this.a.h();
    }

    public boolean s() {
        return !this.a.h();
    }

    public String t() {
        return this.a.d();
    }

    public EnumBlockRotation u() {
        return this.r;
    }

    public GameTestHarnessTestFunction v() {
        return this.a;
    }

    public int w() {
        return this.f;
    }

    public boolean x() {
        return this.a.a();
    }

    public int y() {
        return this.a.j();
    }

    public int z() {
        return this.a.k();
    }

    public RetryOptions A() {
        return this.o;
    }

    public Stream<GameTestHarnessListener> B() {
        return this.e.stream();
    }

    public GameTestHarnessInfo C() {
        GameTestHarnessInfo gameTestInfo = new GameTestHarnessInfo(this.a, this.r, this.d, this.A());
        if (this.c != null) {
            gameTestInfo.b(this.c);
        }
        if (this.b != null) {
            gameTestInfo.a(this.b);
        }
        return gameTestInfo;
    }

    public BlockPosition D() {
        if (this.c == null) {
            StructureBoundingBox boundingBox = GameTestHarnessStructures.b(this.f());
            this.c = new BlockPosition(boundingBox.h(), boundingBox.i(), boundingBox.j());
        }
        return this.c;
    }

    public void b(BlockPosition boxMinPos) {
        this.c = boxMinPos;
    }
}

