/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.List;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.gametest.framework.ExhaustedAttemptsException;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ReportGameListener
implements GameTestHarnessListener {
    private int a = 0;
    private int b = 0;

    @Override
    @Override
    public void a(GameTestHarnessInfo test) {
        ReportGameListener.a(test, Blocks.eD);
        ++this.a;
    }

    private void a(GameTestHarnessInfo state, GameTestHarnessRunner context, boolean prevPassed) {
        RetryOptions retryOptions = state.A();
        Object string = String.format("[Run: %4d, Ok: %4d, Fail: %4d", this.a, this.b, this.a - this.b);
        if (!retryOptions.b()) {
            string = (String)string + String.format(", Left: %4d", retryOptions.d() - this.a);
        }
        string = (String)string + "]";
        String string2 = state.b() + " " + (prevPassed ? "passed" : "failed") + "! " + state.l() + "ms";
        String string3 = String.format("%-53s%s", string, string2);
        if (prevPassed) {
            ReportGameListener.a(state, string3);
        } else {
            ReportGameListener.a(state.g(), EnumChatFormat.m, string3);
        }
        if (retryOptions.a(this.a, this.b)) {
            context.a(state);
        }
    }

    @Override
    @Override
    public void a(GameTestHarnessInfo test, GameTestHarnessRunner context) {
        ++this.b;
        if (test.A().c()) {
            this.a(test, context, true);
            return;
        }
        if (!test.x()) {
            ReportGameListener.a(test, test.b() + " passed! (" + test.l() + "ms)");
            return;
        }
        if (this.b >= test.z()) {
            ReportGameListener.a(test, String.valueOf(test) + " passed " + this.b + " times of " + this.a + " attempts.");
        } else {
            ReportGameListener.a(test.g(), EnumChatFormat.k, "Flaky test " + String.valueOf(test) + " succeeded, attempt: " + this.a + " successes: " + this.b);
            context.a(test);
        }
    }

    @Override
    @Override
    public void b(GameTestHarnessInfo test, GameTestHarnessRunner context) {
        if (!test.x()) {
            ReportGameListener.a(test, test.n());
            if (test.A().c()) {
                this.a(test, context, false);
            }
            return;
        }
        GameTestHarnessTestFunction testFunction = test.v();
        String string = "Flaky test " + String.valueOf(test) + " failed, attempt: " + this.a + "/" + testFunction.j();
        if (testFunction.k() > 1) {
            string = string + ", successes: " + this.b + " (" + testFunction.k() + " required)";
        }
        ReportGameListener.a(test.g(), EnumChatFormat.o, string);
        if (test.y() - this.a + this.b >= test.z()) {
            context.a(test);
        } else {
            ReportGameListener.a(test, new ExhaustedAttemptsException(this.a, this.b, test));
        }
    }

    @Override
    @Override
    public void a(GameTestHarnessInfo prevState, GameTestHarnessInfo nextState, GameTestHarnessRunner context) {
        nextState.a(this);
    }

    public static void a(GameTestHarnessInfo test, String output) {
        ReportGameListener.b(test, Blocks.eA);
        ReportGameListener.b(test, output);
    }

    private static void b(GameTestHarnessInfo test, String output) {
        ReportGameListener.a(test.g(), EnumChatFormat.k, output);
        GlobalTestReporter.b(test);
    }

    protected static void a(GameTestHarnessInfo test, Throwable output) {
        ReportGameListener.b(test, test.r() ? Blocks.eJ : Blocks.ew);
        ReportGameListener.c(test, SystemUtils.c(output));
        ReportGameListener.b(test, output);
    }

    protected static void b(GameTestHarnessInfo test, Throwable output) {
        String string = output.getMessage() + (String)(output.getCause() == null ? "" : " cause: " + SystemUtils.c(output.getCause()));
        String string2 = (test.r() ? "" : "(optional) ") + test.b() + " failed! " + string;
        ReportGameListener.a(test.g(), test.r() ? EnumChatFormat.m : EnumChatFormat.o, string2);
        Throwable throwable = (Throwable)MoreObjects.firstNonNull((Object)ExceptionUtils.getRootCause((Throwable)output), (Object)output);
        if (throwable instanceof GameTestHarnessAssertionPosition) {
            GameTestHarnessAssertionPosition gameTestAssertPosException = (GameTestHarnessAssertionPosition)throwable;
            ReportGameListener.a(test.g(), gameTestAssertPosException.c(), gameTestAssertPosException.a());
        }
        GlobalTestReporter.a(test);
    }

    protected static void a(GameTestHarnessInfo test, Block block) {
        WorldServer serverLevel = test.g();
        BlockPosition blockPos = ReportGameListener.b(test);
        serverLevel.b(blockPos, Blocks.gc.m().a(test.u()));
        ReportGameListener.b(test, block);
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int j2 = -1; j2 <= 1; ++j2) {
                BlockPosition blockPos2 = blockPos.b(i2, -1, j2);
                serverLevel.b(blockPos2, Blocks.cp.m());
            }
        }
    }

    private static BlockPosition b(GameTestHarnessInfo state) {
        BlockPosition blockPos = state.c();
        BlockPosition blockPos2 = new BlockPosition(-1, -2, -1);
        return DefinedStructure.a(blockPos.a(blockPos2), EnumBlockMirror.a, state.u(), blockPos);
    }

    private static void b(GameTestHarnessInfo state, Block block) {
        BlockPosition blockPos;
        WorldServer serverLevel = state.g();
        if (serverLevel.a_(blockPos = ReportGameListener.b(state)).a(Blocks.gc)) {
            BlockPosition blockPos2 = blockPos.b(0, 1, 0);
            serverLevel.b(blockPos2, block.m());
        }
    }

    private static void c(GameTestHarnessInfo test, String output) {
        WorldServer serverLevel = test.g();
        BlockPosition blockPos = test.c();
        BlockPosition blockPos2 = new BlockPosition(-1, 0, -1);
        BlockPosition blockPos3 = DefinedStructure.a(blockPos.a(blockPos2), EnumBlockMirror.a, test.u(), blockPos);
        serverLevel.b(blockPos3, Blocks.ov.m().a(test.u()));
        IBlockData blockState = serverLevel.a_(blockPos3);
        ItemStack itemStack = ReportGameListener.a(test.b(), test.r(), output);
        BlockLectern.a(null, (World)serverLevel, blockPos3, blockState, itemStack);
    }

    private static ItemStack a(String text, boolean required, String output) {
        StringBuffer stringBuffer = new StringBuffer();
        Arrays.stream(text.split("\\.")).forEach(line -> stringBuffer.append((String)line).append('\n'));
        if (!required) {
            stringBuffer.append("(optional)\n");
        }
        stringBuffer.append("-------------------\n");
        ItemStack itemStack = new ItemStack(Items.uO);
        itemStack.b(DataComponents.S, new WritableBookContent(List.of(Filterable.a(String.valueOf(stringBuffer) + output))));
        return itemStack;
    }

    protected static void a(WorldServer world, EnumChatFormat formatting, String message) {
        world.a((? super EntityPlayer player) -> true).forEach(player -> player.a(IChatBaseComponent.b(message).a(formatting)));
    }

    private static void a(WorldServer world, BlockPosition pos, String message) {
        PacketDebug.a(world, pos, message, -2130771968, Integer.MAX_VALUE);
    }
}

