/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.TextComponentTagVisitor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import org.slf4j.Logger;

public final class GameProfileSerializer {
    private static final Comparator<NBTTagList> b = Comparator.comparingInt(nbt -> nbt.e(1)).thenComparingInt(nbt -> nbt.e(0)).thenComparingInt(nbt -> nbt.e(2));
    private static final Comparator<NBTTagList> c = Comparator.comparingDouble(nbt -> nbt.h(1)).thenComparingDouble(nbt -> nbt.h(0)).thenComparingDouble(nbt -> nbt.h(2));
    public static final String a = "data";
    private static final char d = '{';
    private static final char e = '}';
    private static final String f = ",";
    private static final char g = ':';
    private static final Splitter h = Splitter.on((String)",");
    private static final Splitter i = Splitter.on((char)':').limit(2);
    private static final Logger j = LogUtils.getLogger();
    private static final int k = 2;
    private static final int l = -1;

    private GameProfileSerializer() {
    }

    @VisibleForTesting
    public static boolean a(@Nullable NBTBase standard, @Nullable NBTBase subject, boolean ignoreListOrder) {
        if (standard == subject) {
            return true;
        }
        if (standard == null) {
            return true;
        }
        if (subject == null) {
            return false;
        }
        if (!standard.getClass().equals(subject.getClass())) {
            return false;
        }
        if (standard instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)standard;
            NBTTagCompound compoundTag2 = (NBTTagCompound)subject;
            if (compoundTag2.f() < compoundTag.f()) {
                return false;
            }
            for (String string : compoundTag.e()) {
                NBTBase tag = compoundTag.c(string);
                if (GameProfileSerializer.a(tag, compoundTag2.c(string), ignoreListOrder)) continue;
                return false;
            }
            return true;
        }
        if (standard instanceof NBTTagList) {
            NBTTagList listTag = (NBTTagList)standard;
            if (ignoreListOrder) {
                NBTTagList listTag2 = (NBTTagList)subject;
                if (listTag.isEmpty()) {
                    return listTag2.isEmpty();
                }
                if (listTag2.size() < listTag.size()) {
                    return false;
                }
                for (NBTBase tag2 : listTag) {
                    boolean bl = false;
                    for (NBTBase tag3 : listTag2) {
                        if (!GameProfileSerializer.a(tag2, tag3, ignoreListOrder)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    return false;
                }
                return true;
            }
        }
        return standard.equals(subject);
    }

    public static NBTTagIntArray a(UUID uuid) {
        return new NBTTagIntArray(UUIDUtil.a(uuid));
    }

    public static UUID a(NBTBase element) {
        if (element.c() != NBTTagIntArray.a) {
            throw new IllegalArgumentException("Expected UUID-Tag to be of type " + NBTTagIntArray.a.a() + ", but found " + element.c().a() + ".");
        }
        int[] is = ((NBTTagIntArray)element).g();
        if (is.length != 4) {
            throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + is.length + ".");
        }
        return UUIDUtil.a(is);
    }

    public static Optional<BlockPosition> a(NBTTagCompound nbt, String key) {
        int[] is = nbt.n(key);
        return is.length == 3 ? Optional.of(new BlockPosition(is[0], is[1], is[2])) : Optional.empty();
    }

    public static NBTBase a(BlockPosition pos) {
        return new NBTTagIntArray(new int[]{pos.u(), pos.v(), pos.w()});
    }

    public static IBlockData a(HolderGetter<Block> blockLookup, NBTTagCompound nbt) {
        Optional optional;
        if (!nbt.b("Name", 8)) {
            return Blocks.a.m();
        }
        MinecraftKey resourceLocation = MinecraftKey.c(nbt.l("Name"));
        Optional<Object> optional2 = optional = resourceLocation != null ? blockLookup.a(ResourceKey.a(Registries.f, resourceLocation)) : Optional.empty();
        if (optional.isEmpty()) {
            return Blocks.a.m();
        }
        Block block = (Block)((Holder)optional.get()).a();
        IBlockData blockState = block.m();
        if (nbt.b("Properties", 10)) {
            NBTTagCompound compoundTag = nbt.p("Properties");
            BlockStateList<Block, IBlockData> stateDefinition = block.l();
            for (String string : compoundTag.e()) {
                IBlockState<?> property = stateDefinition.a(string);
                if (property == null) continue;
                blockState = GameProfileSerializer.a(blockState, property, string, compoundTag, nbt);
            }
        }
        return blockState;
    }

    private static <S extends IBlockDataHolder<?, S>, T extends Comparable<T>> S a(S state, IBlockState<T> property, String key, NBTTagCompound properties, NBTTagCompound root) {
        Optional<T> optional = property.b(properties.l(key));
        if (optional.isPresent()) {
            return (S)((IBlockDataHolder)state.b(property, (Comparable)((Comparable)optional.get())));
        }
        j.warn("Unable to read property: {} with value: {} for blockstate: {}", new Object[]{key, properties.l(key), root});
        return state;
    }

    public static NBTTagCompound a(IBlockData state) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("Name", BuiltInRegistries.e.b(state.b()).toString());
        Map<IBlockState<?>, Comparable<?>> map = state.G();
        if (!map.isEmpty()) {
            NBTTagCompound compoundTag2 = new NBTTagCompound();
            for (Map.Entry<IBlockState<?>, Comparable<?>> entry : map.entrySet()) {
                IBlockState<?> property = entry.getKey();
                compoundTag2.a(property.f(), GameProfileSerializer.a(property, entry.getValue()));
            }
            compoundTag.a("Properties", compoundTag2);
        }
        return compoundTag;
    }

    public static NBTTagCompound a(Fluid state) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("Name", BuiltInRegistries.c.b(state.a()).toString());
        Map<IBlockState<?>, Comparable<?>> map = state.G();
        if (!map.isEmpty()) {
            NBTTagCompound compoundTag2 = new NBTTagCompound();
            for (Map.Entry<IBlockState<?>, Comparable<?>> entry : map.entrySet()) {
                IBlockState<?> property = entry.getKey();
                compoundTag2.a(property.f(), GameProfileSerializer.a(property, entry.getValue()));
            }
            compoundTag.a("Properties", compoundTag2);
        }
        return compoundTag;
    }

    private static <T extends Comparable<T>> String a(IBlockState<T> property, Comparable<?> value) {
        return property.b(value);
    }

    public static String b(NBTBase nbt) {
        return GameProfileSerializer.a(nbt, false);
    }

    public static String a(NBTBase nbt, boolean withArrayContents) {
        return GameProfileSerializer.a(new StringBuilder(), nbt, 0, withArrayContents).toString();
    }

    public static StringBuilder a(StringBuilder stringBuilder, NBTBase nbt, int depth, boolean withArrayContents) {
        switch (nbt.b()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                stringBuilder.append(nbt);
                break;
            }
            case 7: {
                NBTTagByteArray byteArrayTag = (NBTTagByteArray)nbt;
                byte[] bs = byteArrayTag.e();
                int i2 = bs.length;
                GameProfileSerializer.a(depth, stringBuilder).append("byte[").append(i2).append("] {\n");
                if (withArrayContents) {
                    GameProfileSerializer.a(depth + 1, stringBuilder);
                    for (int j2 = 0; j2 < bs.length; ++j2) {
                        if (j2 != 0) {
                            stringBuilder.append(',');
                        }
                        if (j2 % 16 == 0 && j2 / 16 > 0) {
                            stringBuilder.append('\n');
                            if (j2 < bs.length) {
                                GameProfileSerializer.a(depth + 1, stringBuilder);
                            }
                        } else if (j2 != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%02X", bs[j2] & 0xFF));
                    }
                } else {
                    GameProfileSerializer.a(depth + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                GameProfileSerializer.a(depth, stringBuilder).append('}');
                break;
            }
            case 9: {
                NBTTagList listTag = (NBTTagList)nbt;
                int k2 = listTag.size();
                byte l2 = listTag.f();
                String string = l2 == 0 ? "undefined" : NBTTagTypes.a(l2).b();
                GameProfileSerializer.a(depth, stringBuilder).append("list<").append(string).append(">[").append(k2).append("] [");
                if (k2 != 0) {
                    stringBuilder.append('\n');
                }
                for (int m2 = 0; m2 < k2; ++m2) {
                    if (m2 != 0) {
                        stringBuilder.append(",\n");
                    }
                    GameProfileSerializer.a(depth + 1, stringBuilder);
                    GameProfileSerializer.a(stringBuilder, listTag.k(m2), depth + 1, withArrayContents);
                }
                if (k2 != 0) {
                    stringBuilder.append('\n');
                }
                GameProfileSerializer.a(depth, stringBuilder).append(']');
                break;
            }
            case 10: {
                NBTTagCompound compoundTag = (NBTTagCompound)nbt;
                ArrayList list = Lists.newArrayList(compoundTag.e());
                Collections.sort(list);
                GameProfileSerializer.a(depth, stringBuilder).append('{');
                if (stringBuilder.length() - stringBuilder.lastIndexOf("\n") > 2 * (depth + 1)) {
                    stringBuilder.append('\n');
                    GameProfileSerializer.a(depth + 1, stringBuilder);
                }
                int r2 = list.stream().mapToInt(String::length).max().orElse(0);
                String string2 = Strings.repeat((String)" ", (int)r2);
                for (int s2 = 0; s2 < list.size(); ++s2) {
                    if (s2 != 0) {
                        stringBuilder.append(",\n");
                    }
                    String string3 = (String)list.get(s2);
                    GameProfileSerializer.a(depth + 1, stringBuilder).append('\"').append(string3).append('\"').append(string2, 0, string2.length() - string3.length()).append(": ");
                    GameProfileSerializer.a(stringBuilder, compoundTag.c(string3), depth + 1, withArrayContents);
                }
                if (!list.isEmpty()) {
                    stringBuilder.append('\n');
                }
                GameProfileSerializer.a(depth, stringBuilder).append('}');
                break;
            }
            case 11: {
                NBTTagIntArray intArrayTag = (NBTTagIntArray)nbt;
                int[] is = intArrayTag.g();
                int n2 = 0;
                for (int o2 : is) {
                    n2 = Math.max(n2, String.format(Locale.ROOT, "%X", o2).length());
                }
                int p2 = is.length;
                GameProfileSerializer.a(depth, stringBuilder).append("int[").append(p2).append("] {\n");
                if (withArrayContents) {
                    GameProfileSerializer.a(depth + 1, stringBuilder);
                    for (int q2 = 0; q2 < is.length; ++q2) {
                        if (q2 != 0) {
                            stringBuilder.append(',');
                        }
                        if (q2 % 16 == 0 && q2 / 16 > 0) {
                            stringBuilder.append('\n');
                            if (q2 < is.length) {
                                GameProfileSerializer.a(depth + 1, stringBuilder);
                            }
                        } else if (q2 != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%0" + n2 + "X", is[q2]));
                    }
                } else {
                    GameProfileSerializer.a(depth + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                GameProfileSerializer.a(depth, stringBuilder).append('}');
                break;
            }
            case 12: {
                NBTTagLongArray longArrayTag = (NBTTagLongArray)nbt;
                long[] ls = longArrayTag.g();
                long t2 = 0L;
                for (long u2 : ls) {
                    t2 = Math.max(t2, (long)String.format(Locale.ROOT, "%X", u2).length());
                }
                long v2 = ls.length;
                GameProfileSerializer.a(depth, stringBuilder).append("long[").append(v2).append("] {\n");
                if (withArrayContents) {
                    GameProfileSerializer.a(depth + 1, stringBuilder);
                    for (int w2 = 0; w2 < ls.length; ++w2) {
                        if (w2 != 0) {
                            stringBuilder.append(',');
                        }
                        if (w2 % 16 == 0 && w2 / 16 > 0) {
                            stringBuilder.append('\n');
                            if (w2 < ls.length) {
                                GameProfileSerializer.a(depth + 1, stringBuilder);
                            }
                        } else if (w2 != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%0" + t2 + "X", ls[w2]));
                    }
                } else {
                    GameProfileSerializer.a(depth + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                GameProfileSerializer.a(depth, stringBuilder).append('}');
                break;
            }
            default: {
                stringBuilder.append("<UNKNOWN :(>");
            }
        }
        return stringBuilder;
    }

    private static StringBuilder a(int depth, StringBuilder stringBuilder) {
        int i2 = stringBuilder.lastIndexOf("\n") + 1;
        int j2 = stringBuilder.length() - i2;
        for (int k2 = 0; k2 < 2 * depth - j2; ++k2) {
            stringBuilder.append(' ');
        }
        return stringBuilder;
    }

    public static IChatBaseComponent c(NBTBase element) {
        return new TextComponentTagVisitor("").a(element);
    }

    public static String a(NBTTagCompound compound) {
        return new SnbtPrinterTagVisitor().a((NBTBase)GameProfileSerializer.b(compound));
    }

    public static NBTTagCompound a(String string) throws CommandSyntaxException {
        return GameProfileSerializer.c(MojangsonParser.a(string));
    }

    @VisibleForTesting
    static NBTTagCompound b(NBTTagCompound compound) {
        boolean bl = compound.b("palettes", 9);
        NBTTagList listTag = bl ? compound.c("palettes", 9).b(0) : compound.c("palette", 10);
        NBTTagList listTag3 = listTag.stream().map(NBTTagCompound.class::cast).map(GameProfileSerializer::d).map(NBTTagString::a).collect(Collectors.toCollection(NBTTagList::new));
        compound.a("palette", listTag3);
        if (bl) {
            NBTTagList listTag4 = new NBTTagList();
            NBTTagList listTag5 = compound.c("palettes", 9);
            listTag5.stream().map(NBTTagList.class::cast).forEach(nbt -> {
                NBTTagCompound compoundTag = new NBTTagCompound();
                for (int i2 = 0; i2 < nbt.size(); ++i2) {
                    compoundTag.a(listTag3.j(i2), GameProfileSerializer.d(nbt.a(i2)));
                }
                listTag4.add(compoundTag);
            });
            compound.a("palettes", listTag4);
        }
        if (compound.b("entities", 9)) {
            NBTTagList listTag6 = compound.c("entities", 10);
            NBTTagList listTag7 = listTag6.stream().map(NBTTagCompound.class::cast).sorted(Comparator.comparing(nbt -> nbt.c("pos", 6), c)).collect(Collectors.toCollection(NBTTagList::new));
            compound.a("entities", listTag7);
        }
        NBTTagList listTag8 = compound.c("blocks", 10).stream().map(NBTTagCompound.class::cast).sorted(Comparator.comparing(nbt -> nbt.c("pos", 3), b)).peek(nbt -> nbt.a("state", listTag3.j(nbt.h("state")))).collect(Collectors.toCollection(NBTTagList::new));
        compound.a(a, listTag8);
        compound.r("blocks");
        return compound;
    }

    @VisibleForTesting
    static NBTTagCompound c(NBTTagCompound compound) {
        NBTTagList listTag = compound.c("palette", 8);
        Map map = (Map)listTag.stream().map(NBTTagString.class::cast).map(NBTTagString::u_).collect(ImmutableMap.toImmutableMap(Function.identity(), GameProfileSerializer::b));
        if (compound.b("palettes", 9)) {
            compound.a("palettes", compound.c("palettes", 10).stream().map(NBTTagCompound.class::cast).map(nbt -> map.keySet().stream().map(nbt::l).map(GameProfileSerializer::b).collect(Collectors.toCollection(NBTTagList::new))).collect(Collectors.toCollection(NBTTagList::new)));
            compound.r("palette");
        } else {
            compound.a("palette", map.values().stream().collect(Collectors.toCollection(NBTTagList::new)));
        }
        if (compound.b(a, 9)) {
            Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
            object2IntMap.defaultReturnValue(-1);
            for (int i2 = 0; i2 < listTag.size(); ++i2) {
                object2IntMap.put((Object)listTag.j(i2), i2);
            }
            NBTTagList listTag2 = compound.c(a, 10);
            for (int j2 = 0; j2 < listTag2.size(); ++j2) {
                NBTTagCompound compoundTag = listTag2.a(j2);
                String string = compoundTag.l("state");
                int k2 = object2IntMap.getInt((Object)string);
                if (k2 == -1) {
                    throw new IllegalStateException("Entry " + string + " missing from palette");
                }
                compoundTag.a("state", k2);
            }
            compound.a("blocks", listTag2);
            compound.r(a);
        }
        return compound;
    }

    @VisibleForTesting
    static String d(NBTTagCompound compound) {
        StringBuilder stringBuilder = new StringBuilder(compound.l("Name"));
        if (compound.b("Properties", 10)) {
            NBTTagCompound compoundTag = compound.p("Properties");
            String string = compoundTag.e().stream().sorted().map(key -> key + ":" + compoundTag.c((String)key).u_()).collect(Collectors.joining(f));
            stringBuilder.append('{').append(string).append('}');
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    static NBTTagCompound b(String string) {
        String string2;
        NBTTagCompound compoundTag = new NBTTagCompound();
        int i2 = string.indexOf(123);
        if (i2 >= 0) {
            string2 = string.substring(0, i2);
            NBTTagCompound compoundTag2 = new NBTTagCompound();
            if (i2 + 2 <= string.length()) {
                String string3 = string.substring(i2 + 1, string.indexOf(125, i2));
                h.split((CharSequence)string3).forEach(property -> {
                    List list = i.splitToList((CharSequence)property);
                    if (list.size() == 2) {
                        compoundTag2.a((String)list.get(0), (String)list.get(1));
                    } else {
                        j.error("Something went wrong parsing: '{}' -- incorrect gamedata!", (Object)string);
                    }
                });
                compoundTag.a("Properties", compoundTag2);
            }
        } else {
            string2 = string;
        }
        compoundTag.a("Name", string2);
        return compoundTag;
    }

    public static NBTTagCompound e(NBTTagCompound nbt) {
        int i2 = SharedConstants.b().d().c();
        return GameProfileSerializer.a(nbt, i2);
    }

    public static NBTTagCompound a(NBTTagCompound nbt, int dataVersion) {
        nbt.a("DataVersion", dataVersion);
        return nbt;
    }

    public static int b(NBTTagCompound nbt, int fallback) {
        return nbt.b("DataVersion", 99) ? nbt.h("DataVersion") : fallback;
    }
}

