/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagString
implements NBTBase {
    private static final int b = 36;
    public static final NBTTagType<NBTTagString> a = new NBTTagType.b<NBTTagString>(){

        @Override
        public NBTTagString a(DataInput dataInput, NBTReadLimiter nbtAccounter) throws IOException {
            return NBTTagString.a(1.d(dataInput, nbtAccounter));
        }

        @Override
        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter tracker) throws IOException {
            return visitor.a(1.d(input, tracker));
        }

        private static String d(DataInput input, NBTReadLimiter tracker) throws IOException {
            tracker.b(36L);
            String string = input.readUTF();
            tracker.a(2L, string.length());
            return string;
        }

        @Override
        @Override
        public void b(DataInput input, NBTReadLimiter tracker) throws IOException {
            NBTTagString.a(input);
        }

        @Override
        @Override
        public String a() {
            return "STRING";
        }

        @Override
        @Override
        public String b() {
            return "TAG_String";
        }

        @Override
        @Override
        public boolean d() {
            return true;
        }

        @Override
        public /* synthetic */ NBTBase c(DataInput input, NBTReadLimiter tracker) throws IOException {
            return this.a(input, tracker);
        }
    };
    private static final NBTTagString c = new NBTTagString("");
    private static final char w = '\"';
    private static final char x = '\'';
    private static final char y = '\\';
    private static final char z = '\u0000';
    private final String A;

    public static void a(DataInput input) throws IOException {
        input.skipBytes(input.readUnsignedShort());
    }

    private NBTTagString(String value) {
        Objects.requireNonNull(value, "Null string not allowed");
        this.A = value;
    }

    public static NBTTagString a(String value) {
        if (value.isEmpty()) {
            return c;
        }
        return new NBTTagString(value);
    }

    @Override
    @Override
    public void a(DataOutput output) throws IOException {
        output.writeUTF(this.A);
    }

    @Override
    @Override
    public int a() {
        return 36 + 2 * this.A.length();
    }

    @Override
    @Override
    public byte b() {
        return 8;
    }

    @Override
    public NBTTagType<NBTTagString> c() {
        return a;
    }

    @Override
    @Override
    public String toString() {
        return NBTBase.super.u_();
    }

    @Override
    public NBTTagString e() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof NBTTagString && Objects.equals(this.A, ((NBTTagString)object).A);
    }

    @Override
    public int hashCode() {
        return this.A.hashCode();
    }

    @Override
    @Override
    public String u_() {
        return this.A;
    }

    @Override
    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    public static String b(String value) {
        StringBuilder stringBuilder = new StringBuilder(" ");
        int c2 = 0;
        for (int i2 = 0; i2 < value.length(); ++i2) {
            int d2 = value.charAt(i2);
            if (d2 == 92) {
                stringBuilder.append('\\');
            } else if (d2 == 34 || d2 == 39) {
                if (c2 == 0) {
                    int n2 = c2 = d2 == 34 ? 39 : 34;
                }
                if (c2 == d2) {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append((char)d2);
        }
        if (c2 == 0) {
            c2 = 34;
        }
        stringBuilder.setCharAt(0, (char)c2);
        stringBuilder.append((char)c2);
        return stringBuilder.toString();
    }

    @Override
    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.A);
    }

    @Override
    public /* synthetic */ NBTBase d() {
        return this.e();
    }
}

