/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.protocol.Packet;

public class UnconfiguredPipelineHandler {
    public static <T extends PacketListener> b a(ProtocolInfo<T> newState) {
        return UnconfiguredPipelineHandler.a(new PacketDecoder<T>(newState));
    }

    private static b a(ChannelInboundHandler newDecoder) {
        return context -> {
            context.pipeline().replace(context.name(), "decoder", (ChannelHandler)newDecoder);
            context.channel().config().setAutoRead(true);
        };
    }

    public static <T extends PacketListener> d b(ProtocolInfo<T> newState) {
        return UnconfiguredPipelineHandler.a(new PacketEncoder<T>(newState));
    }

    private static d a(ChannelOutboundHandler newEncoder) {
        return context -> context.pipeline().replace(context.name(), "encoder", (ChannelHandler)newEncoder);
    }

    @FunctionalInterface
    public static interface b {
        public void run(ChannelHandlerContext var1);

        default public b andThen(b inboundConfigurationTask) {
            return context -> {
                this.run(context);
                inboundConfigurationTask.run(context);
            };
        }
    }

    @FunctionalInterface
    public static interface d {
        public void run(ChannelHandlerContext var1);

        default public d andThen(d outboundConfigurationTask) {
            return context -> {
                this.run(context);
                outboundConfigurationTask.run(context);
            };
        }
    }

    public static class c
    extends ChannelOutboundHandlerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
            if (object instanceof Packet) {
                ReferenceCountUtil.release((Object)object);
                throw new EncoderException("Pipeline has no outbound protocol configured, can't process packet " + String.valueOf(object));
            }
            if (object instanceof d) {
                d outboundConfigurationTask = (d)object;
                try {
                    outboundConfigurationTask.run(channelHandlerContext);
                }
                finally {
                    ReferenceCountUtil.release((Object)object);
                }
                channelPromise.setSuccess();
            } else {
                channelHandlerContext.write(object, channelPromise);
            }
        }
    }

    public static class a
    extends ChannelDuplexHandler {
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
            if (object instanceof ByteBuf || object instanceof Packet) {
                ReferenceCountUtil.release((Object)object);
                throw new DecoderException("Pipeline has no inbound protocol configured, can't process packet " + String.valueOf(object));
            }
            channelHandlerContext.fireChannelRead(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
            if (object instanceof b) {
                b inboundConfigurationTask = (b)object;
                try {
                    inboundConfigurationTask.run(channelHandlerContext);
                }
                finally {
                    ReferenceCountUtil.release((Object)object);
                }
                channelPromise.setSuccess();
            } else {
                channelHandlerContext.write(object, channelPromise);
            }
        }
    }
}

