/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChatHoverable {
    public static final Codec<ChatHoverable> a = Codec.withAlternative((Codec)e.a.codec(), (Codec)e.b.codec()).xmap(ChatHoverable::new, event -> event.b);
    private final e<?> b;

    public <T> ChatHoverable(EnumHoverAction<T> action, T contents) {
        this(new e<T>(action, contents));
    }

    private ChatHoverable(e<?> data) {
        this.b = data;
    }

    public EnumHoverAction<?> a() {
        return this.b.c;
    }

    @Nullable
    public <T> T a(EnumHoverAction<T> action) {
        if (this.b.c == action) {
            return action.a(this.b.d);
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return ((ChatHoverable)object).b.equals(this.b);
    }

    @Override
    public String toString() {
        return this.b.toString();
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }

    static final class e<T>
    extends Record {
        private final EnumHoverAction<T> c;
        private final T d;
        public static final MapCodec<e<?>> a = EnumHoverAction.e.dispatchMap("action", e::a, action -> action.h);
        public static final MapCodec<e<?>> b = EnumHoverAction.e.dispatchMap("action", e::a, action -> action.i);

        e(EnumHoverAction<T> action, T object) {
            this.c = action;
            this.d = object;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "action;value", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "action;value", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "action;value", "c", "d"}, this, object);
        }

        public EnumHoverAction<T> a() {
            return this.c;
        }

        public T b() {
            return this.d;
        }
    }

    public static class EnumHoverAction<T>
    implements INamable {
        public static final EnumHoverAction<IChatBaseComponent> a = new EnumHoverAction<IChatBaseComponent>("show_text", true, ComponentSerialization.a, (text, ops) -> DataResult.success((Object)text));
        public static final EnumHoverAction<c> b = new EnumHoverAction<c>("show_item", true, net.minecraft.network.chat.ChatHoverable$c.b, c::a);
        public static final EnumHoverAction<b> c = new EnumHoverAction<b>("show_entity", true, net.minecraft.network.chat.ChatHoverable$b.a, b::a);
        public static final Codec<EnumHoverAction<?>> d = INamable.b(() -> new EnumHoverAction[]{a, b, c});
        public static final Codec<EnumHoverAction<?>> e = d.validate(EnumHoverAction::a);
        private final String f;
        private final boolean g;
        final MapCodec<e<T>> h;
        final MapCodec<e<T>> i;

        public EnumHoverAction(String name, boolean parsable, Codec<T> contentCodec, final d<T> legacySerializer) {
            this.f = name;
            this.g = parsable;
            this.h = contentCodec.xmap(value -> new e<Object>(this, value), action -> action.d).fieldOf("contents");
            this.i = new Codec<e<T>>(){

                public <D> DataResult<Pair<e<T>, D>> decode(DynamicOps<D> dynamicOps, D object) {
                    return ComponentSerialization.a.decode(dynamicOps, object).flatMap(pair -> {
                        DataResult dataResult2;
                        if (dynamicOps instanceof RegistryOps) {
                            RegistryOps registryOps = (RegistryOps)dynamicOps;
                            DataResult dataResult = legacySerializer.parse((IChatBaseComponent)pair.getFirst(), registryOps);
                        } else {
                            dataResult2 = legacySerializer.parse((IChatBaseComponent)pair.getFirst(), null);
                        }
                        return dataResult2.map(value -> Pair.of(new e<Object>(this, value), (Object)pair.getSecond()));
                    });
                }

                public <D> DataResult<D> a(e<T> typedHoverEvent, DynamicOps<D> dynamicOps, D object) {
                    return DataResult.error(() -> "Can't encode in legacy format");
                }

                public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                    return this.a((e)object, dynamicOps, object2);
                }
            }.fieldOf("value");
        }

        public boolean a() {
            return this.g;
        }

        @Override
        @Override
        public String c() {
            return this.f;
        }

        T a(Object o2) {
            return (T)o2;
        }

        @Override
        public String toString() {
            return "<action " + this.f + ">";
        }

        private static DataResult<EnumHoverAction<?>> a(@Nullable EnumHoverAction<?> action) {
            if (action == null) {
                return DataResult.error(() -> "Unknown action");
            }
            if (!action.a()) {
                return DataResult.error(() -> "Action not allowed: " + String.valueOf(action));
            }
            return DataResult.success(action, (Lifecycle)Lifecycle.stable());
        }
    }

    public static interface d<T> {
        public DataResult<T> parse(IChatBaseComponent var1, @Nullable RegistryOps<?> var2);
    }

    public static class c {
        public static final Codec<c> a = ItemStack.a.xmap(c::new, c::a);
        private static final Codec<c> c = ItemStack.f.xmap(c::new, c::a);
        public static final Codec<c> b = Codec.withAlternative(a, c);
        public final Holder<Item> d;
        public final int e;
        public final DataComponentPatch f;
        @Nullable
        private ItemStack g;

        c(Holder<Item> item, int count, DataComponentPatch changes) {
            this.d = item;
            this.e = count;
            this.f = changes;
        }

        public c(ItemStack stack) {
            this(stack.i(), stack.L(), stack.e());
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            c itemStackInfo = (c)object;
            return this.e == itemStackInfo.e && this.d.equals(itemStackInfo.d) && this.f.equals(itemStackInfo.f);
        }

        @Override
        public int hashCode() {
            int i2 = this.d.hashCode();
            i2 = 31 * i2 + this.e;
            i2 = 31 * i2 + this.f.hashCode();
            return i2;
        }

        public ItemStack a() {
            if (this.g == null) {
                this.g = new ItemStack(this.d, this.e, this.f);
            }
            return this.g;
        }

        private static DataResult<c> a(IChatBaseComponent text, @Nullable RegistryOps<?> ops) {
            try {
                NBTTagCompound compoundTag = MojangsonParser.a(text.getString());
                DynamicOpsNBT dynamicOps = ops != null ? ops.a(DynamicOpsNBT.a) : DynamicOpsNBT.a;
                return ItemStack.a.parse((DynamicOps)dynamicOps, (Object)compoundTag).map(c::new);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return DataResult.error(() -> "Failed to parse item tag: " + commandSyntaxException.getMessage());
            }
        }
    }

    public static class b {
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f.q().fieldOf("type").forGetter(content -> content.b), (App)UUIDUtil.f.fieldOf("id").forGetter(content -> content.c), (App)ComponentSerialization.a.lenientOptionalFieldOf("name").forGetter(content -> content.d)).apply((Applicative)instance, b::new));
        public final EntityTypes<?> b;
        public final UUID c;
        public final Optional<IChatBaseComponent> d;
        @Nullable
        private List<IChatBaseComponent> e;

        public b(EntityTypes<?> entityType, UUID uuid, @Nullable IChatBaseComponent name) {
            this(entityType, uuid, Optional.ofNullable(name));
        }

        public b(EntityTypes<?> entityType, UUID uuid, Optional<IChatBaseComponent> name) {
            this.b = entityType;
            this.c = uuid;
            this.d = name;
        }

        public static DataResult<b> a(IChatBaseComponent text2, @Nullable RegistryOps<?> ops) {
            try {
                NBTTagCompound compoundTag = MojangsonParser.a(text2.getString());
                JsonOps dynamicOps = ops != null ? ops.a(JsonOps.INSTANCE) : JsonOps.INSTANCE;
                DataResult dataResult = ComponentSerialization.a.parse((DynamicOps)dynamicOps, (Object)JsonParser.parseString((String)compoundTag.l("name")));
                EntityTypes<?> entityType = BuiltInRegistries.f.a(MinecraftKey.a(compoundTag.l("type")));
                UUID uUID = UUID.fromString(compoundTag.l("id"));
                return dataResult.map(text -> new b(entityType, uUID, (IChatBaseComponent)text));
            }
            catch (Exception exception) {
                return DataResult.error(() -> "Failed to parse tooltip: " + exception.getMessage());
            }
        }

        public List<IChatBaseComponent> a() {
            if (this.e == null) {
                this.e = new ArrayList<IChatBaseComponent>();
                this.d.ifPresent(this.e::add);
                this.e.add(IChatBaseComponent.a("gui.entity_tooltip.type", this.b.h()));
                this.e.add(IChatBaseComponent.b(this.c.toString()));
            }
            return this.e;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            b entityTooltipInfo = (b)object;
            return this.b.equals(entityTooltipInfo.b) && this.c.equals(entityTooltipInfo.c) && this.d.equals(entityTooltipInfo.d);
        }

        @Override
        public int hashCode() {
            int i2 = this.b.hashCode();
            i2 = 31 * i2 + this.c.hashCode();
            i2 = 31 * i2 + this.d.hashCode();
            return i2;
        }
    }
}

