/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.selector.SelectorPattern;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.FormattedString;
import net.minecraft.world.level.ChunkCoordIntPair;

public interface IChatBaseComponent
extends Message,
IChatFormatted,
Iterable<IChatBaseComponent> {
    default public Stream<IChatBaseComponent> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.c().stream().flatMap(IChatBaseComponent::stream)});
    }

    @Override
    default public Iterator<IChatBaseComponent> iterator() {
        return this.stream().iterator();
    }

    public ChatModifier a();

    public ComponentContents b();

    @Override
    default public String getString() {
        return IChatFormatted.super.getString();
    }

    default public String a(int length) {
        StringBuilder stringbuilder = new StringBuilder();
        this.a((String s2) -> {
            int j2 = length - stringbuilder.length();
            if (j2 <= 0) {
                return a;
            }
            stringbuilder.append(s2.length() <= j2 ? s2 : s2.substring(0, j2));
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public List<IChatBaseComponent> c();

    @Nullable
    default public String d() {
        ComponentContents componentcontents = this.b();
        if (componentcontents instanceof LiteralContents) {
            LiteralContents literalcontents = (LiteralContents)componentcontents;
            if (this.c().isEmpty() && this.a().g()) {
                return literalcontents.b();
            }
        }
        return null;
    }

    default public IChatMutableComponent e() {
        return IChatMutableComponent.a(this.b());
    }

    default public IChatMutableComponent f() {
        return new IChatMutableComponent(this.b(), new ArrayList<IChatBaseComponent>(this.c()), this.a());
    }

    public FormattedString g();

    @Override
    default public <T> Optional<T> a(IChatFormatted.b<T> styledVisitor, ChatModifier style) {
        IChatBaseComponent ichatbasecomponent;
        Optional<T> optional1;
        ChatModifier chatmodifier1 = this.a().a(style);
        Optional<T> optional = this.b().a(styledVisitor, chatmodifier1);
        if (optional.isPresent()) {
            return optional;
        }
        Iterator<IChatBaseComponent> iterator = this.c().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!(optional1 = (ichatbasecomponent = iterator.next()).a(styledVisitor, chatmodifier1)).isPresent());
        return optional1;
    }

    @Override
    default public <T> Optional<T> a(IChatFormatted.a<T> visitor) {
        IChatBaseComponent ichatbasecomponent;
        Optional<T> optional1;
        Optional<T> optional = this.b().a(visitor);
        if (optional.isPresent()) {
            return optional;
        }
        Iterator<IChatBaseComponent> iterator = this.c().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!(optional1 = (ichatbasecomponent = iterator.next()).a(visitor)).isPresent());
        return optional1;
    }

    default public List<IChatBaseComponent> h() {
        return this.a(ChatModifier.a);
    }

    default public List<IChatBaseComponent> a(ChatModifier style) {
        ArrayList list = Lists.newArrayList();
        this.a((chatmodifier1, s2) -> {
            if (!s2.isEmpty()) {
                list.add(IChatBaseComponent.b(s2).c(chatmodifier1));
            }
            return Optional.empty();
        }, style);
        return list;
    }

    default public boolean a(IChatBaseComponent text) {
        List<IChatBaseComponent> list1;
        if (this.equals(text)) {
            return true;
        }
        List<IChatBaseComponent> list = this.h();
        return Collections.indexOfSubList(list, list1 = text.a(this.a())) != -1;
    }

    public static IChatBaseComponent a(@Nullable String string) {
        return string != null ? IChatBaseComponent.b(string) : CommonComponents.a;
    }

    public static IChatMutableComponent b(String string) {
        return IChatMutableComponent.a(LiteralContents.a(string));
    }

    public static IChatMutableComponent c(String key) {
        return IChatMutableComponent.a(new TranslatableContents(key, null, TranslatableContents.a));
    }

    public static IChatMutableComponent a(String key, Object ... args) {
        return IChatMutableComponent.a(new TranslatableContents(key, null, args));
    }

    public static IChatMutableComponent b(String key, Object ... args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            Object object = args[i2];
            if (TranslatableContents.a(object) || object instanceof IChatBaseComponent) continue;
            args[i2] = String.valueOf(object);
        }
        return IChatBaseComponent.a(key, args);
    }

    public static IChatMutableComponent a(String key, @Nullable String fallback) {
        return IChatMutableComponent.a(new TranslatableContents(key, fallback, TranslatableContents.a));
    }

    public static IChatMutableComponent a(String key, @Nullable String fallback, Object ... args) {
        return IChatMutableComponent.a(new TranslatableContents(key, fallback, args));
    }

    public static IChatMutableComponent i() {
        return IChatMutableComponent.a(LiteralContents.c);
    }

    public static IChatMutableComponent d(String string) {
        return IChatMutableComponent.a(new KeybindContents(string));
    }

    public static IChatMutableComponent a(String rawPath, boolean interpret, Optional<IChatBaseComponent> separator, DataSource dataSource) {
        return IChatMutableComponent.a(new NbtContents(rawPath, interpret, separator, dataSource));
    }

    public static IChatMutableComponent a(SelectorPattern selector, String objective) {
        return IChatMutableComponent.a(new ScoreContents(Either.left(selector), objective));
    }

    public static IChatMutableComponent b(String name, String objective) {
        return IChatMutableComponent.a(new ScoreContents(Either.right(name), objective));
    }

    public static IChatMutableComponent a(SelectorPattern selector, Optional<IChatBaseComponent> separator) {
        return IChatMutableComponent.a(new SelectorContents(selector, separator));
    }

    public static IChatBaseComponent a(Date date) {
        return IChatBaseComponent.b(date.toString());
    }

    public static IChatBaseComponent a(Message message) {
        IChatBaseComponent object;
        if (message instanceof IChatBaseComponent) {
            IChatBaseComponent ichatbasecomponent = (IChatBaseComponent)message;
            object = ichatbasecomponent;
        } else {
            object = IChatBaseComponent.b(message.getString());
        }
        return object;
    }

    public static IChatBaseComponent a(UUID uuid) {
        return IChatBaseComponent.b(uuid.toString());
    }

    public static IChatBaseComponent a(MinecraftKey id) {
        return IChatBaseComponent.b(id.toString());
    }

    public static IChatBaseComponent a(ChunkCoordIntPair pos) {
        return IChatBaseComponent.b(pos.toString());
    }

    public static IChatBaseComponent a(URI uri) {
        return IChatBaseComponent.b(uri.toString());
    }

    public static class ChatSerializer {
        private static final Gson a = new GsonBuilder().disableHtmlEscaping().create();

        private ChatSerializer() {
        }

        static IChatMutableComponent b(JsonElement json, HolderLookup.a registries) {
            return (IChatMutableComponent)ComponentSerialization.a.parse(registries.a(JsonOps.INSTANCE), (Object)json).getOrThrow(JsonParseException::new);
        }

        static JsonElement b(IChatBaseComponent text, HolderLookup.a registries) {
            return (JsonElement)ComponentSerialization.a.encodeStart(registries.a(JsonOps.INSTANCE), (Object)text).getOrThrow(JsonParseException::new);
        }

        public static String a(IChatBaseComponent text, HolderLookup.a registries) {
            return a.toJson(ChatSerializer.b(text, registries));
        }

        @Nullable
        public static IChatMutableComponent a(String json, HolderLookup.a registries) {
            JsonElement jsonelement = JsonParser.parseString((String)json);
            return jsonelement == null ? null : ChatSerializer.b(jsonelement, registries);
        }

        @Nullable
        public static IChatMutableComponent a(@Nullable JsonElement json, HolderLookup.a registries) {
            return json == null ? null : ChatSerializer.b(json, registries);
        }

        @Nullable
        public static IChatMutableComponent b(String json, HolderLookup.a registries) {
            JsonReader jsonreader = new JsonReader((Reader)new StringReader(json));
            jsonreader.setLenient(true);
            JsonElement jsonelement = JsonParser.parseReader((JsonReader)jsonreader);
            return jsonelement == null ? null : ChatSerializer.b(jsonelement, registries);
        }
    }

    public static class b
    implements JsonDeserializer<IChatMutableComponent>,
    JsonSerializer<IChatBaseComponent> {
        private final HolderLookup.a a;

        public b(HolderLookup.a registries) {
            this.a = registries;
        }

        public IChatMutableComponent a(JsonElement jsonelement, Type type, JsonDeserializationContext jsondeserializationcontext) throws JsonParseException {
            return ChatSerializer.b(jsonelement, this.a);
        }

        public JsonElement a(IChatBaseComponent ichatbasecomponent, Type type, JsonSerializationContext jsonserializationcontext) {
            return ChatSerializer.b(ichatbasecomponent, this.a);
        }
    }
}

