/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.entity.TileEntity;

public final class BlockDataSource
extends Record
implements DataSource {
    private final String d;
    @Nullable
    private final IVectorPosition e;
    public static final MapCodec<BlockDataSource> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("block").forGetter(BlockDataSource::b)).apply((Applicative)instance, BlockDataSource::new));
    public static final DataSource.a<BlockDataSource> b = new DataSource.a<BlockDataSource>(a, "block");

    public BlockDataSource(String rawPath) {
        this(rawPath, BlockDataSource.a(rawPath));
    }

    public BlockDataSource(String rawPath, @Nullable IVectorPosition coordinates) {
        this.d = rawPath;
        this.e = coordinates;
    }

    @Nullable
    private static IVectorPosition a(String string) {
        try {
            return ArgumentPosition.a().a(new StringReader(string));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    @Override
    @Override
    public Stream<NBTTagCompound> a(CommandListenerWrapper source) {
        TileEntity blockEntity;
        BlockPosition blockPos;
        WorldServer serverLevel;
        if (this.e != null && (serverLevel = source.e()).p(blockPos = this.e.c(source)) && (blockEntity = serverLevel.c_(blockPos)) != null) {
            return Stream.of(blockEntity.b(source.u()));
        }
        return Stream.empty();
    }

    @Override
    @Override
    public DataSource.a<?> a() {
        return b;
    }

    @Override
    @Override
    public String toString() {
        return "block=" + this.d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BlockDataSource)) return false;
        BlockDataSource blockDataSource = (BlockDataSource)object;
        if (!this.d.equals(blockDataSource.d)) return false;
        return true;
    }

    @Override
    @Override
    public int hashCode() {
        return this.d.hashCode();
    }

    public String b() {
        return this.d;
    }

    @Nullable
    public IVectorPosition c() {
        return this.e;
    }
}

