/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.codec;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import io.netty.buffer.ByteBuf;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.codec.StreamMemberEncoder;

public interface StreamCodec<B, V>
extends StreamDecoder<B, V>,
StreamEncoder<B, V> {
    public static <B, V> StreamCodec<B, V> a(final StreamEncoder<B, V> encoder, final StreamDecoder<B, V> decoder) {
        return new StreamCodec<B, V>(){

            @Override
            @Override
            public V decode(B buf) {
                return decoder.decode(buf);
            }

            @Override
            @Override
            public void encode(B buf, V value) {
                encoder.encode(buf, value);
            }
        };
    }

    public static <B, V> StreamCodec<B, V> a(final StreamMemberEncoder<B, V> encoder, final StreamDecoder<B, V> decoder) {
        return new StreamCodec<B, V>(){

            @Override
            @Override
            public V decode(B buf) {
                return decoder.decode(buf);
            }

            @Override
            @Override
            public void encode(B buf, V value) {
                encoder.encode(value, buf);
            }
        };
    }

    public static <B, V> StreamCodec<B, V> a(final V value) {
        return new StreamCodec<B, V>(){

            @Override
            @Override
            public V decode(B buf) {
                return value;
            }

            @Override
            @Override
            public void encode(B buf, V value2) {
                if (!value2.equals(value)) {
                    throw new IllegalStateException("Can't encode '" + String.valueOf(value2) + "', expected '" + String.valueOf(value) + "'");
                }
            }
        };
    }

    default public <O> StreamCodec<B, O> a(a<B, V, O> function) {
        return function.apply(this);
    }

    default public <O> StreamCodec<B, O> a(final Function<? super V, ? extends O> to, final Function<? super O, ? extends V> from) {
        return new StreamCodec<B, O>(){

            @Override
            @Override
            public O decode(B buf) {
                return to.apply(StreamCodec.this.decode(buf));
            }

            @Override
            @Override
            public void encode(B buf, O value) {
                StreamCodec.this.encode(buf, from.apply(value));
            }
        };
    }

    default public <O extends ByteBuf> StreamCodec<O, V> b(final Function<O, ? extends B> function) {
        return new StreamCodec<O, V>(){

            @Override
            public V a(O byteBuf) {
                Object object = function.apply(byteBuf);
                return StreamCodec.this.decode(object);
            }

            @Override
            public void a(O byteBuf, V object) {
                Object object2 = function.apply(byteBuf);
                StreamCodec.this.encode(object2, object);
            }

            @Override
            public /* synthetic */ void encode(Object buf, Object value) {
                this.a((ByteBuf)buf, value);
            }

            @Override
            public /* synthetic */ Object decode(Object buf) {
                return this.a((ByteBuf)buf);
            }
        };
    }

    default public <U> StreamCodec<B, U> b(final Function<? super U, ? extends V> type, final Function<? super V, ? extends StreamCodec<? super B, ? extends U>> codec) {
        return new StreamCodec<B, U>(){

            @Override
            @Override
            public U decode(B buf) {
                Object object = StreamCodec.this.decode(buf);
                StreamCodec streamCodec = (StreamCodec)codec.apply(object);
                return streamCodec.decode(buf);
            }

            @Override
            @Override
            public void encode(B buf, U value) {
                Object object = type.apply(value);
                StreamCodec streamCodec = (StreamCodec)codec.apply(object);
                StreamCodec.this.encode(buf, object);
                streamCodec.encode(buf, value);
            }
        };
    }

    public static <B, C, T1> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec, final Function<C, T1> from, final Function<T1, C> to) {
        return new StreamCodec<B, C>(){

            @Override
            @Override
            public C decode(B buf) {
                Object object = codec.decode(buf);
                return to.apply(object);
            }

            @Override
            @Override
            public void encode(B buf, C value) {
                codec.encode(buf, from.apply(value));
            }
        };
    }

    public static <B, C, T1, T2> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> from1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> from2, final BiFunction<T1, T2, C> to) {
        return new StreamCodec<B, C>(){

            @Override
            @Override
            public C decode(B buf) {
                Object object = codec1.decode(buf);
                Object object2 = codec2.decode(buf);
                return to.apply(object, object2);
            }

            @Override
            @Override
            public void encode(B buf, C value) {
                codec1.encode(buf, from1.apply(value));
                codec2.encode(buf, from2.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> from1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> from2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> from3, final Function3<T1, T2, T3, C> to) {
        return new StreamCodec<B, C>(){

            @Override
            @Override
            public C decode(B buf) {
                Object object = codec1.decode(buf);
                Object object2 = codec2.decode(buf);
                Object object3 = codec3.decode(buf);
                return to.apply(object, object2, object3);
            }

            @Override
            @Override
            public void encode(B buf, C value) {
                codec1.encode(buf, from1.apply(value));
                codec2.encode(buf, from2.apply(value));
                codec3.encode(buf, from3.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> from1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> from2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> from3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> from4, final Function4<T1, T2, T3, T4, C> to) {
        return new StreamCodec<B, C>(){

            @Override
            @Override
            public C decode(B buf) {
                Object object = codec1.decode(buf);
                Object object2 = codec2.decode(buf);
                Object object3 = codec3.decode(buf);
                Object object4 = codec4.decode(buf);
                return to.apply(object, object2, object3, object4);
            }

            @Override
            @Override
            public void encode(B buf, C value) {
                codec1.encode(buf, from1.apply(value));
                codec2.encode(buf, from2.apply(value));
                codec3.encode(buf, from3.apply(value));
                codec4.encode(buf, from4.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> from1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> from2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> from3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> from4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> from5, final Function5<T1, T2, T3, T4, T5, C> to) {
        return new StreamCodec<B, C>(){

            @Override
            @Override
            public C decode(B buf) {
                Object object = codec1.decode(buf);
                Object object2 = codec2.decode(buf);
                Object object3 = codec3.decode(buf);
                Object object4 = codec4.decode(buf);
                Object object5 = codec5.decode(buf);
                return to.apply(object, object2, object3, object4, object5);
            }

            @Override
            @Override
            public void encode(B buf, C value) {
                codec1.encode(buf, from1.apply(value));
                codec2.encode(buf, from2.apply(value));
                codec3.encode(buf, from3.apply(value));
                codec4.encode(buf, from4.apply(value));
                codec5.encode(buf, from5.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> from1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> from2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> from3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> from4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> from5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> from6, final Function6<T1, T2, T3, T4, T5, T6, C> to) {
        return new StreamCodec<B, C>(){

            @Override
            @Override
            public C decode(B buf) {
                Object object = codec1.decode(buf);
                Object object2 = codec2.decode(buf);
                Object object3 = codec3.decode(buf);
                Object object4 = codec4.decode(buf);
                Object object5 = codec5.decode(buf);
                Object object6 = codec6.decode(buf);
                return to.apply(object, object2, object3, object4, object5, object6);
            }

            @Override
            @Override
            public void encode(B buf, C value) {
                codec1.encode(buf, from1.apply(value));
                codec2.encode(buf, from2.apply(value));
                codec3.encode(buf, from3.apply(value));
                codec4.encode(buf, from4.apply(value));
                codec5.encode(buf, from5.apply(value));
                codec6.encode(buf, from6.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> from1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> from2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> from3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> from4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> from5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> from6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> from7, final Function7<T1, T2, T3, T4, T5, T6, T7, C> to) {
        return new StreamCodec<B, C>(){

            @Override
            @Override
            public C decode(B buf) {
                Object object = codec1.decode(buf);
                Object object2 = codec2.decode(buf);
                Object object3 = codec3.decode(buf);
                Object object4 = codec4.decode(buf);
                Object object5 = codec5.decode(buf);
                Object object6 = codec6.decode(buf);
                Object object7 = codec7.decode(buf);
                return to.apply(object, object2, object3, object4, object5, object6, object7);
            }

            @Override
            @Override
            public void encode(B buf, C value) {
                codec1.encode(buf, from1.apply(value));
                codec2.encode(buf, from2.apply(value));
                codec3.encode(buf, from3.apply(value));
                codec4.encode(buf, from4.apply(value));
                codec5.encode(buf, from5.apply(value));
                codec6.encode(buf, from6.apply(value));
                codec7.encode(buf, from7.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8> StreamCodec<B, C> a(final StreamCodec<? super B, T1> codec1, final Function<C, T1> from1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> from2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> from3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> from4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> from5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> from6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> from7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> from8, final Function8<T1, T2, T3, T4, T5, T6, T7, T8, C> to) {
        return new StreamCodec<B, C>(){

            @Override
            @Override
            public C decode(B buf) {
                Object object = codec1.decode(buf);
                Object object2 = codec2.decode(buf);
                Object object3 = codec3.decode(buf);
                Object object4 = codec4.decode(buf);
                Object object5 = codec5.decode(buf);
                Object object6 = codec6.decode(buf);
                Object object7 = codec7.decode(buf);
                Object object8 = codec8.decode(buf);
                return to.apply(object, object2, object3, object4, object5, object6, object7, object8);
            }

            @Override
            @Override
            public void encode(B buf, C value) {
                codec1.encode(buf, from1.apply(value));
                codec2.encode(buf, from2.apply(value));
                codec3.encode(buf, from3.apply(value));
                codec4.encode(buf, from4.apply(value));
                codec5.encode(buf, from5.apply(value));
                codec6.encode(buf, from6.apply(value));
                codec7.encode(buf, from7.apply(value));
                codec8.encode(buf, from8.apply(value));
            }
        };
    }

    public static <B, T> StreamCodec<B, T> a(final UnaryOperator<StreamCodec<B, T>> codecGetter) {
        return new StreamCodec<B, T>(){
            private final Supplier<StreamCodec<B, T>> b = Suppliers.memoize(() -> (StreamCodec)codecGetter.apply(this));

            @Override
            @Override
            public T decode(B buf) {
                return this.b.get().decode(buf);
            }

            @Override
            @Override
            public void encode(B buf, T value) {
                this.b.get().encode(buf, value);
            }
        };
    }

    default public <S extends B> StreamCodec<S, V> a() {
        return this;
    }

    @FunctionalInterface
    public static interface a<B, S, T> {
        public StreamCodec<B, T> apply(StreamCodec<B, S> var1);
    }
}

