/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.util.DataSanitizationUtil;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.ItemStack;

public class PacketPlayOutEntityEquipment
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutEntityEquipment> a = Packet.a(PacketPlayOutEntityEquipment::a, PacketPlayOutEntityEquipment::new);
    private static final byte b = -128;
    private final int c;
    private final List<Pair<EnumItemSlot, ItemStack>> d;
    private boolean sanitize;

    public PacketPlayOutEntityEquipment(int entityId, List<Pair<EnumItemSlot, ItemStack>> equipmentList) {
        this(entityId, equipmentList, false);
    }

    public PacketPlayOutEntityEquipment(int entityId, List<Pair<EnumItemSlot, ItemStack>> equipmentList, boolean sanitize) {
        this.sanitize = sanitize;
        this.c = entityId;
        this.d = equipmentList;
    }

    private PacketPlayOutEntityEquipment(RegistryFriendlyByteBuf buf) {
        byte i2;
        this.c = buf.l();
        this.d = Lists.newArrayList();
        do {
            i2 = buf.readByte();
            EnumItemSlot equipmentSlot = EnumItemSlot.i.get(i2 & 0x7F);
            ItemStack itemStack = (ItemStack)ItemStack.g.decode(buf);
            this.d.add((Pair<EnumItemSlot, ItemStack>)Pair.of((Object)equipmentSlot, (Object)itemStack));
        } while ((i2 & 0xFFFFFF80) != 0);
    }

    @Override
    private void a(RegistryFriendlyByteBuf buf) {
        buf.c(this.c);
        int i2 = this.d.size();
        try (DataSanitizationUtil.DataSanitizer ignored = DataSanitizationUtil.start(this.sanitize);){
            for (int j2 = 0; j2 < i2; ++j2) {
                Pair<EnumItemSlot, ItemStack> pair = this.d.get(j2);
                EnumItemSlot equipmentSlot = (EnumItemSlot)pair.getFirst();
                boolean bl = j2 != i2 - 1;
                int k2 = equipmentSlot.ordinal();
                buf.l(bl ? k2 | 0xFFFFFF80 : k2);
                ItemStack.g.encode(buf, (ItemStack)pair.getSecond());
            }
        }
    }

    @Override
    public PacketType<PacketPlayOutEntityEquipment> a() {
        return GamePacketTypes.aI;
    }

    @Override
    public void a(PacketListenerPlayOut listener) {
        listener.a(this);
    }

    public int b() {
        return this.c;
    }

    public List<Pair<EnumItemSlot, ItemStack>> e() {
        return this.d;
    }
}

