/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutSpawnEntity
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutSpawnEntity> a = Packet.a(PacketPlayOutSpawnEntity::a, PacketPlayOutSpawnEntity::new);
    private static final double b = 8000.0;
    private static final double c = 3.9;
    private final int d;
    private final UUID e;
    private final EntityTypes<?> f;
    private final double g;
    private final double h;
    private final double i;
    private final int j;
    private final int k;
    private final int l;
    private final byte m;
    private final byte n;
    private final byte o;
    private final int p;

    public PacketPlayOutSpawnEntity(Entity entity, EntityTrackerEntry entityTrackerEntry) {
        this(entity, entityTrackerEntry, 0);
    }

    public PacketPlayOutSpawnEntity(Entity entity, EntityTrackerEntry entityTrackerEntry, int entityData) {
        this(entity.ar(), entity.cG(), entity.dv().a(), entity.dv().b(), entity.dv().c(), entityTrackerEntry.d(), entityTrackerEntry.e(), entity.aq(), entityData, entityTrackerEntry.c(), entityTrackerEntry.f());
    }

    public PacketPlayOutSpawnEntity(Entity entity, int entityData, BlockPosition pos) {
        this(entity.ar(), entity.cG(), pos.u(), pos.v(), pos.w(), entity.dO(), entity.dM(), entity.aq(), entityData, entity.dz(), entity.cA());
    }

    public PacketPlayOutSpawnEntity(int entityId, UUID uuid, double x2, double y2, double z2, float pitch, float yaw, EntityTypes<?> entityType, int entityData, Vec3D velocity, double headYaw) {
        this.d = entityId;
        this.e = uuid;
        this.g = x2;
        this.h = y2;
        this.i = z2;
        this.m = MathHelper.g(pitch);
        this.n = MathHelper.g(yaw);
        this.o = MathHelper.g((float)headYaw);
        this.f = entityType;
        this.p = entityData;
        this.j = (int)(MathHelper.a(velocity.d, -3.9, 3.9) * 8000.0);
        this.k = (int)(MathHelper.a(velocity.e, -3.9, 3.9) * 8000.0);
        this.l = (int)(MathHelper.a(velocity.f, -3.9, 3.9) * 8000.0);
    }

    private PacketPlayOutSpawnEntity(RegistryFriendlyByteBuf buf) {
        this.d = buf.l();
        this.e = buf.n();
        this.f = (EntityTypes)ByteBufCodecs.a(Registries.z).decode(buf);
        this.g = buf.readDouble();
        this.h = buf.readDouble();
        this.i = buf.readDouble();
        this.m = buf.readByte();
        this.n = buf.readByte();
        this.o = buf.readByte();
        this.p = buf.l();
        this.j = buf.readShort();
        this.k = buf.readShort();
        this.l = buf.readShort();
    }

    @Override
    private void a(RegistryFriendlyByteBuf buf) {
        buf.c(this.d);
        buf.a(this.e);
        ByteBufCodecs.a(Registries.z).encode(buf, this.f);
        buf.a(this.g);
        buf.a(this.h);
        buf.a(this.i);
        buf.l(this.m);
        buf.l(this.n);
        buf.l(this.o);
        buf.c(this.p);
        buf.m(this.j);
        buf.m(this.k);
        buf.m(this.l);
    }

    @Override
    public PacketType<PacketPlayOutSpawnEntity> a() {
        return GamePacketTypes.c;
    }

    @Override
    public void a(PacketListenerPlayOut listener) {
        listener.a(this);
    }

    public int b() {
        return this.d;
    }

    public UUID e() {
        return this.e;
    }

    public EntityTypes<?> f() {
        return this.f;
    }

    public double g() {
        return this.g;
    }

    public double h() {
        return this.h;
    }

    public double i() {
        return this.i;
    }

    public double j() {
        return (double)this.j / 8000.0;
    }

    public double k() {
        return (double)this.k / 8000.0;
    }

    public double l() {
        return (double)this.l / 8000.0;
    }

    public float m() {
        return MathHelper.a(this.m);
    }

    public float n() {
        return MathHelper.a(this.n);
    }

    public float o() {
        return MathHelper.a(this.o);
    }

    public int p() {
        return this.p;
    }
}

