/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.syncher;

import com.mojang.logging.LogUtils;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.network.syncher.SyncedDataHolder;
import net.minecraft.util.ClassTreeIdRegistry;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class DataWatcher {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 254;
    static final ClassTreeIdRegistry c = new ClassTreeIdRegistry();
    private final SyncedDataHolder d;
    private final Item<?>[] e;
    private boolean f;

    DataWatcher(SyncedDataHolder trackedEntity, Item<?>[] entries) {
        this.d = trackedEntity;
        this.e = entries;
    }

    public static <T> DataWatcherObject<T> a(Class<? extends SyncedDataHolder> entityClass, DataWatcherSerializer<T> dataHandler) {
        int i2;
        if (a.isDebugEnabled()) {
            try {
                Class<?> oclass1 = Class.forName(Thread.currentThread().getStackTrace()[2].getClassName());
                if (!oclass1.equals(entityClass)) {
                    a.debug("defineId called for: {} from {}", new Object[]{entityClass, oclass1, new RuntimeException()});
                }
            }
            catch (ClassNotFoundException oclass1) {
                // empty catch block
            }
        }
        if ((i2 = c.c(entityClass)) > 254) {
            throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is 254)");
        }
        return dataHandler.a(i2);
    }

    public <T> Item<T> b(DataWatcherObject<T> key) {
        return this.e[key.a()];
    }

    public <T> T a(DataWatcherObject<T> data) {
        return this.b(data).b();
    }

    public <T> void a(DataWatcherObject<T> key, T value) {
        this.a(key, value, false);
    }

    public <T> void a(DataWatcherObject<T> key, T value, boolean force) {
        Item<T> datawatcher_item = this.b(key);
        if (force || ObjectUtils.notEqual(value, datawatcher_item.b())) {
            datawatcher_item.a(value);
            this.d.a(key);
            datawatcher_item.a(true);
            this.f = true;
        }
    }

    public <T> void markDirty(DataWatcherObject<T> datawatcherobject) {
        this.b(datawatcherobject).a(true);
        this.f = true;
    }

    public boolean a() {
        return this.f;
    }

    @Nullable
    public List<c<?>> b() {
        if (!this.f) {
            return null;
        }
        this.f = false;
        ArrayList list = new ArrayList();
        for (Item<?> datawatcher_item : this.e) {
            if (!datawatcher_item.c()) continue;
            datawatcher_item.a(false);
            list.add(datawatcher_item.e());
        }
        return list;
    }

    @Nullable
    public List<c<?>> c() {
        ArrayList list = null;
        for (Item<?> datawatcher_item : this.e) {
            if (datawatcher_item.d()) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.add(datawatcher_item.e());
        }
        return list;
    }

    public void a(List<c<?>> entries) {
        for (c<?> datawatcher_c : entries) {
            Item<?> datawatcher_item = this.e[datawatcher_c.a];
            this.a(datawatcher_item, datawatcher_c);
            this.d.a(datawatcher_item.a());
        }
        this.d.a(entries);
    }

    private <T> void a(Item<T> to, c<?> from) {
        if (!Objects.equals(from.b(), to.a.b())) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid entity data item type for field %d on entity %s: old=%s(%s), new=%s(%s)", to.a.a(), this.d, to.b, to.b.getClass(), from.c, from.c.getClass()));
        }
        to.a(from.c);
    }

    @Nullable
    public List<c<?>> packAll() {
        ArrayList list = new ArrayList();
        for (Item<?> dataItem : this.e) {
            list.add(dataItem.e());
        }
        return list;
    }

    public static class Item<T> {
        final DataWatcherObject<T> a;
        T b;
        private final T c;
        private boolean d;

        public Item(DataWatcherObject<T> data, T value) {
            this.a = data;
            this.c = value;
            this.b = value;
        }

        public DataWatcherObject<T> a() {
            return this.a;
        }

        public void a(T value) {
            this.b = value;
        }

        public T b() {
            return this.b;
        }

        public boolean c() {
            return this.d;
        }

        public void a(boolean dirty) {
            this.d = dirty;
        }

        public boolean d() {
            return this.c.equals(this.b);
        }

        public c<T> e() {
            return net.minecraft.network.syncher.DataWatcher$c.a(this.a, this.b);
        }
    }

    public record c<T>(int a, DataWatcherSerializer<T> b, T c) {
        public static <T> c<T> a(DataWatcherObject<T> data, T value) {
            DataWatcherSerializer<T> datawatcherserializer = data.b();
            return new c<T>(data.a(), datawatcherserializer, datawatcherserializer.copy(value));
        }

        public void a(RegistryFriendlyByteBuf buf) {
            int i2 = DataWatcherRegistry.b(this.b);
            if (i2 < 0) {
                throw new EncoderException("Unknown serializer type " + String.valueOf(this.b));
            }
            buf.l(this.a);
            buf.c(i2);
            this.b.codec().encode(buf, this.c);
        }

        public static c<?> a(RegistryFriendlyByteBuf buf, int id) {
            int j2 = buf.l();
            DataWatcherSerializer<?> datawatcherserializer = DataWatcherRegistry.a(j2);
            if (datawatcherserializer == null) {
                throw new DecoderException("Unknown serializer type " + j2);
            }
            return net.minecraft.network.syncher.DataWatcher$c.a(buf, id, datawatcherserializer);
        }

        private static <T> c<T> a(RegistryFriendlyByteBuf buf, int id, DataWatcherSerializer<T> handler) {
            return new c<T>(id, handler, handler.codec().decode(buf));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "id;serializer;value", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "id;serializer;value", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "id;serializer;value", "a", "b", "c"}, this, o2);
        }
    }

    public static class a {
        private final SyncedDataHolder a;
        private final Item<?>[] b;

        public a(SyncedDataHolder entity) {
            this.a = entity;
            this.b = new Item[c.b(entity.getClass())];
        }

        public <T> a a(DataWatcherObject<T> data, T value) {
            int i2 = data.a();
            if (i2 > this.b.length) {
                throw new IllegalArgumentException("Data value id is too big with " + i2 + "! (Max is " + this.b.length + ")");
            }
            if (this.b[i2] != null) {
                throw new IllegalArgumentException("Duplicate id value for " + i2 + "!");
            }
            if (DataWatcherRegistry.b(data.b()) < 0) {
                String s2 = String.valueOf(data.b());
                throw new IllegalArgumentException("Unregistered serializer " + s2 + " for " + i2 + "!");
            }
            this.b[data.a()] = new Item<T>(data, value);
            return this;
        }

        public DataWatcher a() {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                if (this.b[i2] != null) continue;
                String s2 = String.valueOf(this.a.getClass());
                throw new IllegalStateException("Entity " + s2 + " has not defined synched data value " + i2);
            }
            return new DataWatcher(this.a, this.b);
        }
    }
}

