/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

public class HolderSetCodec<E>
implements Codec<HolderSet<E>> {
    private final ResourceKey<? extends IRegistry<E>> a;
    private final Codec<Holder<E>> b;
    private final Codec<List<Holder<E>>> c;
    private final Codec<Either<TagKey<E>, List<Holder<E>>>> d;

    private static <E> Codec<List<Holder<E>>> a(Codec<Holder<E>> entryCodec, boolean alwaysSerializeAsList) {
        Codec codec = entryCodec.listOf().validate(ExtraCodecs.b(Holder::f));
        if (alwaysSerializeAsList) {
            return codec;
        }
        return Codec.either((Codec)codec, entryCodec).xmap(either -> either.map(entries -> entries, List::of), entries -> entries.size() == 1 ? Either.right((Holder)entries.get(0)) : Either.left(entries));
    }

    public static <E> Codec<HolderSet<E>> a(ResourceKey<? extends IRegistry<E>> registryRef, Codec<Holder<E>> entryCodec, boolean alwaysSerializeAsList) {
        return new HolderSetCodec<E>(registryRef, entryCodec, alwaysSerializeAsList);
    }

    private HolderSetCodec(ResourceKey<? extends IRegistry<E>> registry, Codec<Holder<E>> entryCodec, boolean alwaysSerializeAsList) {
        this.a = registry;
        this.b = entryCodec;
        this.c = HolderSetCodec.a(entryCodec, alwaysSerializeAsList);
        this.d = Codec.either(TagKey.b(registry), this.c);
    }

    public <T> DataResult<Pair<HolderSet<E>, T>> decode(DynamicOps<T> dynamicOps, T object) {
        RegistryOps registryOps;
        Optional optional;
        if (dynamicOps instanceof RegistryOps && (optional = (registryOps = (RegistryOps)dynamicOps).b(this.a)).isPresent()) {
            HolderGetter holderGetter = optional.get();
            return this.d.decode(dynamicOps, object).flatMap(pair -> {
                DataResult dataResult = ((Either)pair.getFirst()).map(tag -> HolderSetCodec.a(holderGetter, tag), entries -> DataResult.success(HolderSet.a(entries)));
                return dataResult.map(entries -> Pair.of((Object)entries, (Object)pair.getSecond()));
            });
        }
        return this.a(dynamicOps, object);
    }

    private static <E> DataResult<HolderSet<E>> a(HolderGetter<E> registry, TagKey<E> tag) {
        return registry.a(tag).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Missing tag: '" + String.valueOf(tag.b()) + "' in '" + String.valueOf(tag.a().a()) + "'"));
    }

    public <T> DataResult<T> a(HolderSet<E> holderSet, DynamicOps<T> dynamicOps, T object) {
        RegistryOps registryOps;
        Optional optional;
        if (dynamicOps instanceof RegistryOps && (optional = (registryOps = (RegistryOps)dynamicOps).a(this.a)).isPresent()) {
            if (!holderSet.a(optional.get())) {
                return DataResult.error(() -> "HolderSet " + String.valueOf(holderSet) + " is not valid in current registry set");
            }
            return this.d.encode(holderSet.d().mapRight(List::copyOf), dynamicOps, object);
        }
        return this.b(holderSet, dynamicOps, object);
    }

    private <T> DataResult<Pair<HolderSet<E>, T>> a(DynamicOps<T> ops, T input) {
        return this.b.listOf().decode(ops, input).flatMap(pair -> {
            ArrayList<Holder.a> list = new ArrayList<Holder.a>();
            for (Holder holder : (List)pair.getFirst()) {
                if (holder instanceof Holder.a) {
                    Holder.a direct = (Holder.a)holder;
                    list.add(direct);
                    continue;
                }
                return DataResult.error(() -> "Can't decode element " + String.valueOf(holder) + " without registry");
            }
            return DataResult.success((Object)new Pair(HolderSet.a(list), pair.getSecond()));
        });
    }

    private <T> DataResult<T> b(HolderSet<E> entryList, DynamicOps<T> ops, T prefix) {
        return this.c.encode(entryList.a().toList(), ops, prefix);
    }

    public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
        return this.a((HolderSet)object, dynamicOps, object2);
    }
}

