/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.lang.reflect.Type;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ChatDeserializer;
import org.apache.commons.lang3.StringUtils;

public final class MinecraftKey
implements Comparable<MinecraftKey> {
    public static final Codec<MinecraftKey> a = Codec.STRING.comapFlatMap(MinecraftKey::d, MinecraftKey::toString).stable();
    public static final StreamCodec<ByteBuf, MinecraftKey> b = ByteBufCodecs.o.a(MinecraftKey::a, MinecraftKey::toString);
    public static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.id.invalid"));
    public static final char d = ':';
    public static final String e = "minecraft";
    public static final String f = "realms";
    public static final String PAPER_NAMESPACE = "paper";
    private final String h;
    private final String i;

    private MinecraftKey(String namespace, String path) {
        assert (MinecraftKey.j(namespace));
        assert (MinecraftKey.i(path));
        String resourceLocation = namespace + ":" + path;
        if (resourceLocation.length() > Short.MAX_VALUE || ByteBufUtil.utf8MaxBytes((CharSequence)resourceLocation) > 65535) {
            throw new ResourceKeyInvalidException("Resource location too long: " + resourceLocation);
        }
        this.h = namespace;
        this.i = path;
    }

    private static MinecraftKey d(String namespace, String path) {
        return new MinecraftKey(MinecraftKey.e(namespace, path), MinecraftKey.f(namespace, path));
    }

    public static MinecraftKey a(String namespace, String path) {
        return MinecraftKey.d(namespace, path);
    }

    public static MinecraftKey a(String id) {
        return MinecraftKey.a(id, ':');
    }

    public static MinecraftKey b(String path) {
        return new MinecraftKey(e, MinecraftKey.f(e, path));
    }

    @Nullable
    public static MinecraftKey c(String id) {
        return MinecraftKey.b(id, ':');
    }

    @Nullable
    public static MinecraftKey b(String namespace, String path) {
        return MinecraftKey.j(namespace) && MinecraftKey.i(path) ? new MinecraftKey(namespace, path) : null;
    }

    public static MinecraftKey a(String id, char delimiter) {
        int i2 = id.indexOf(delimiter);
        if (i2 >= 0) {
            String string = id.substring(i2 + 1);
            if (i2 != 0) {
                String string2 = id.substring(0, i2);
                return MinecraftKey.d(string2, string);
            }
            return MinecraftKey.b(string);
        }
        return MinecraftKey.b(id);
    }

    @Nullable
    public static MinecraftKey b(String id, char delimiter) {
        int i2 = id.indexOf(delimiter);
        if (i2 >= 0) {
            String string = id.substring(i2 + 1);
            if (!MinecraftKey.i(string)) {
                return null;
            }
            if (i2 != 0) {
                String string2 = id.substring(0, i2);
                return MinecraftKey.j(string2) ? new MinecraftKey(string2, string) : null;
            }
            return new MinecraftKey(e, string);
        }
        return MinecraftKey.i(id) ? new MinecraftKey(e, id) : null;
    }

    public static DataResult<MinecraftKey> d(String id) {
        try {
            return DataResult.success((Object)MinecraftKey.a(id));
        }
        catch (ResourceKeyInvalidException var2) {
            return DataResult.error(() -> "Not a valid resource location: " + id + " " + var2.getMessage());
        }
    }

    public String a() {
        return this.i;
    }

    public String b() {
        return this.h;
    }

    public MinecraftKey e(String path) {
        return new MinecraftKey(this.h, MinecraftKey.f(this.h, path));
    }

    public MinecraftKey a(UnaryOperator<String> pathFunction) {
        return this.e((String)pathFunction.apply(this.i));
    }

    public MinecraftKey f(String prefix) {
        return this.e(prefix + this.i);
    }

    public MinecraftKey g(String suffix) {
        return this.e(this.i + suffix);
    }

    public String toString() {
        return this.h + ":" + this.i;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof MinecraftKey)) return false;
        MinecraftKey resourceLocation = (MinecraftKey)object;
        if (!this.h.equals(resourceLocation.h)) return false;
        if (!this.i.equals(resourceLocation.i)) return false;
        return true;
    }

    public int hashCode() {
        return 31 * this.h.hashCode() + this.i.hashCode();
    }

    public int a(MinecraftKey resourceLocation) {
        int i2 = this.i.compareTo(resourceLocation.i);
        if (i2 == 0) {
            i2 = this.h.compareTo(resourceLocation.h);
        }
        return i2;
    }

    public String c() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public String d() {
        return this.h + "." + this.i;
    }

    public String e() {
        return this.h.equals(e) ? this.i : this.d();
    }

    public String h(String prefix) {
        return prefix + "." + this.d();
    }

    public String c(String prefix, String suffix) {
        return prefix + "." + this.d() + "." + suffix;
    }

    private static String c(StringReader reader) {
        int i2 = reader.getCursor();
        while (reader.canRead() && MinecraftKey.a(reader.peek())) {
            reader.skip();
        }
        return reader.getString().substring(i2, reader.getCursor());
    }

    public static MinecraftKey a(StringReader reader) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        String string = MinecraftKey.c(reader);
        try {
            return MinecraftKey.a(string);
        }
        catch (ResourceKeyInvalidException var4) {
            reader.setCursor(i2);
            throw c.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static MinecraftKey b(StringReader reader) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        String string = MinecraftKey.c(reader);
        if (string.isEmpty()) {
            throw c.createWithContext((ImmutableStringReader)reader);
        }
        try {
            return MinecraftKey.a(string);
        }
        catch (ResourceKeyInvalidException var4) {
            reader.setCursor(i2);
            throw c.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static boolean a(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 == '_' || c2 == ':' || c2 == '/' || c2 == '.' || c2 == '-';
    }

    public static boolean i(String path) {
        for (int i2 = 0; i2 < path.length(); ++i2) {
            if (MinecraftKey.b(path.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean j(String namespace) {
        for (int i2 = 0; i2 < namespace.length(); ++i2) {
            if (MinecraftKey.c(namespace.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static String e(String namespace, String path) {
        if (!MinecraftKey.j(namespace)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9_.-] character in namespace of location: " + StringUtils.normalizeSpace((String)namespace) + ":" + StringUtils.normalizeSpace((String)path));
        }
        return namespace;
    }

    public static boolean b(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '/' || character == '.';
    }

    private static boolean c(char character) {
        return character == '_' || character == '-' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '.';
    }

    private static String f(String namespace, String path) {
        if (!MinecraftKey.i(path)) {
            throw new ResourceKeyInvalidException("Non [a-z0-9/._-] character in path of location: " + namespace + ":" + StringUtils.normalizeSpace((String)path));
        }
        return path;
    }

    public static class a
    implements JsonDeserializer<MinecraftKey>,
    JsonSerializer<MinecraftKey> {
        public MinecraftKey a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return MinecraftKey.a(ChatDeserializer.a(jsonElement, "location"));
        }

        public JsonElement a(MinecraftKey resourceLocation, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(resourceLocation.toString());
        }
    }
}

