/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.registry.PaperRegistryAccess;
import io.papermc.paper.registry.PaperRegistryListenerManager;
import io.papermc.paper.registry.data.util.Conversions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.tags.TagDataPack;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.slf4j.Logger;

public class RegistryDataLoader {
    private static final Logger d = LogUtils.getLogger();
    private static final Comparator<ResourceKey<?>> e = Comparator.comparing(ResourceKey::b).thenComparing(ResourceKey::a);
    private static final RegistrationInfo f = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());
    private static final Function<Optional<KnownPack>, RegistrationInfo> g = SystemUtils.b((T knownPacks) -> {
        Lifecycle lifecycle = knownPacks.map(KnownPack::a).map(vanilla -> Lifecycle.stable()).orElse(Lifecycle.experimental());
        return new RegistrationInfo((Optional<KnownPack>)knownPacks, lifecycle);
    });
    public static final List<d<?>> a = List.of(new d<DimensionManager>(Registries.aN, DimensionManager.h), new d<BiomeBase>(Registries.aI, BiomeBase.a), new d<ChatMessageType>(Registries.aJ, ChatMessageType.a), new d(Registries.aK, WorldGenCarverWrapper.a), new d(Registries.aL, WorldGenFeatureConfigured.a), new d<PlacedFeature>(Registries.aT, PlacedFeature.a), new d<Structure>(Registries.aU, Structure.a), new d<StructureSet>(Registries.aW, StructureSet.a), new d<ProcessorList>(Registries.aV, DefinedStructureStructureProcessorType.c), new d<WorldGenFeatureDefinedStructurePoolTemplate>(Registries.aX, WorldGenFeatureDefinedStructurePoolTemplate.a), new d<GeneratorSettingBase>(Registries.aR, GeneratorSettingBase.a), new d<NoiseGeneratorNormal.a>(Registries.aS, NoiseGeneratorNormal.a.a), new d<DensityFunction>(Registries.aM, DensityFunction.b), new d<WorldPreset>(Registries.bb, WorldPreset.a), new d<FlatLevelGeneratorPreset>(Registries.aQ, FlatLevelGeneratorPreset.a), new d<TrimPattern>(Registries.ba, TrimPattern.a), new d<TrimMaterial>(Registries.aZ, TrimMaterial.a), new d<TrialSpawnerConfig>(Registries.bd, TrialSpawnerConfig.b), new d<WolfVariant>(Registries.m, WolfVariant.a, true), new d<PaintingVariant>(Registries.X, PaintingVariant.a, true), new d<DamageType>(Registries.s, DamageType.a), new d<MultiNoiseBiomeSourceParameterList>(Registries.bc, MultiNoiseBiomeSourceParameterList.a), new d<EnumBannerPatternType>(Registries.d, EnumBannerPatternType.a), new d<Enchantment>(Registries.aO, Enchantment.b), new d<EnchantmentProvider>(Registries.aP, EnchantmentProvider.a), new d<JukeboxSong>(Registries.L, JukeboxSong.a), new d<Instrument>(Registries.I, Instrument.a));
    public static final List<d<?>> b = List.of(new d<WorldDimension>(Registries.bf, WorldDimension.a));
    public static final List<d<?>> c = List.of(new d<BiomeBase>(Registries.aI, BiomeBase.b), new d<ChatMessageType>(Registries.aJ, ChatMessageType.a), new d<TrimPattern>(Registries.ba, TrimPattern.a), new d<TrimMaterial>(Registries.aZ, TrimMaterial.a), new d<WolfVariant>(Registries.m, WolfVariant.a, true), new d<PaintingVariant>(Registries.X, PaintingVariant.a, true), new d<DimensionManager>(Registries.aN, DimensionManager.h), new d<DamageType>(Registries.s, DamageType.a), new d<EnumBannerPatternType>(Registries.d, EnumBannerPatternType.a), new d<Enchantment>(Registries.aO, Enchantment.b), new d<JukeboxSong>(Registries.L, JukeboxSong.a), new d<Instrument>(Registries.I, Instrument.a));

    public static IRegistryCustom.Dimension a(IResourceManager resourceManager, List<HolderLookup.b<?>> registries, List<d<?>> entries) {
        return RegistryDataLoader.a((a<?> loader, RegistryOps.c infoGetter, Conversions conversions) -> loader.loadFromResources(resourceManager, infoGetter, conversions), registries, entries);
    }

    public static IRegistryCustom.Dimension a(Map<ResourceKey<? extends IRegistry<?>>, c> data, ResourceProvider factory, List<HolderLookup.b<?>> registries, List<d<?>> entries) {
        return RegistryDataLoader.a((a<?> loader, RegistryOps.c infoGetter, Conversions conversions) -> loader.loadFromNetwork(data, factory, infoGetter, conversions), registries, entries);
    }

    private static IRegistryCustom.Dimension a(b loadable, List<HolderLookup.b<?>> registries, List<d<?>> entries) {
        HashMap map = new HashMap();
        List<a<?>> list = entries.stream().map(entry -> entry.a(Lifecycle.stable(), map)).collect(Collectors.toUnmodifiableList());
        RegistryOps.c registryInfoLookup = RegistryDataLoader.a(registries, list);
        Conversions conversions = new Conversions(registryInfoLookup);
        list.forEach(loader -> loadable.apply((a<?>)loader, registryInfoLookup, conversions));
        list.forEach(loader -> {
            IRegistryWritable registry = loader.b();
            try {
                registry.n();
            }
            catch (Exception var4x) {
                map.put(registry.g(), var4x);
            }
            if (loader.a.c && registry.d() == 0) {
                map.put(registry.g(), new IllegalStateException("Registry must be non-empty"));
            }
        });
        if (!map.isEmpty()) {
            throw RegistryDataLoader.a(map);
        }
        return new IRegistryCustom.c(list.stream().map(a::b).toList()).e();
    }

    private static RegistryOps.c a(List<HolderLookup.b<?>> registries, List<a<?>> additionalRegistries) {
        final HashMap map = new HashMap();
        registries.forEach(registry -> map.put(registry.g(), RegistryDataLoader.a(registry)));
        additionalRegistries.forEach(loader -> map.put(loader.b.g(), RegistryDataLoader.a(loader.b)));
        return new RegistryOps.c(){

            @Override
            public <T> Optional<RegistryOps.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                return Optional.ofNullable((RegistryOps.b)map.get(registryRef));
            }
        };
    }

    private static <T> RegistryOps.b<T> a(IRegistryWritable<T> registry) {
        return new RegistryOps.b<T>(registry, registry.p(), registry.h());
    }

    private static <T> RegistryOps.b<T> a(HolderLookup.b<T> registry) {
        return new RegistryOps.b<T>(registry, registry, registry.h());
    }

    private static ReportedException a(Map<ResourceKey<?>, Exception> exceptions) {
        RegistryDataLoader.b(exceptions);
        return RegistryDataLoader.c(exceptions);
    }

    private static void b(Map<ResourceKey<?>, Exception> exceptions) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Map<MinecraftKey, Map<MinecraftKey, Exception>> map = exceptions.entrySet().stream().collect(Collectors.groupingBy(entry -> ((ResourceKey)entry.getKey()).b(), Collectors.toMap(entry -> ((ResourceKey)entry.getKey()).a(), Map.Entry::getValue)));
        map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            printWriter.printf("> Errors in registry %s:%n", entry.getKey());
            ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(element -> {
                printWriter.printf(">> Errors in element %s:%n", element.getKey());
                ((Exception)element.getValue()).printStackTrace(printWriter);
            });
        });
        printWriter.flush();
        d.error("Registry loading errors:\n{}", (Object)stringWriter);
    }

    private static ReportedException c(Map<ResourceKey<?>, Exception> exceptions) {
        CrashReport crashReport = CrashReport.a(new IllegalStateException("Failed to load registries due to errors"), "Registry Loading");
        CrashReportSystemDetails crashReportCategory = crashReport.a("Loading info");
        crashReportCategory.a("Errors", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            exceptions.entrySet().stream().sorted(Map.Entry.comparingByKey(e)).forEach(entry -> stringBuilder.append("\n\t\t").append(((ResourceKey)entry.getKey()).b()).append("/").append(((ResourceKey)entry.getKey()).a()).append(": ").append(((Exception)entry.getValue()).getMessage()));
            return stringBuilder.toString();
        });
        return new ReportedException(crashReport);
    }

    private static <E> void loadElementFromResource(IRegistryWritable<E> registry, Decoder<E> decoder, RegistryOps<JsonElement> ops, ResourceKey<E> key, IResource resource, RegistrationInfo entryInfo, Conversions conversions) throws IOException {
        try (BufferedReader reader = resource.e();){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            DataResult dataResult = decoder.parse(ops, (Object)jsonElement);
            Object object = dataResult.getOrThrow();
            PaperRegistryListenerManager.INSTANCE.registerWithListeners(registry, key, object, entryInfo, conversions);
        }
    }

    static <E> void loadContentsFromManager(IResourceManager resourceManager, RegistryOps.c infoGetter, IRegistryWritable<E> registry, Decoder<E> elementDecoder, Map<ResourceKey<?>, Exception> errors, Conversions conversions) {
        String string = Registries.c(registry.g());
        FileToIdConverter fileToIdConverter = FileToIdConverter.a(string);
        RegistryOps<JsonElement> registryOps = RegistryOps.a(JsonOps.INSTANCE, infoGetter);
        for (Map.Entry<MinecraftKey, IResource> entry : fileToIdConverter.a(resourceManager).entrySet()) {
            MinecraftKey resourceLocation = entry.getKey();
            ResourceKey resourceKey = ResourceKey.a(registry.g(), fileToIdConverter.b(resourceLocation));
            IResource resource = entry.getValue();
            RegistrationInfo registrationInfo = g.apply(resource.c());
            try {
                RegistryDataLoader.loadElementFromResource(registry, elementDecoder, registryOps, resourceKey, resource, registrationInfo, conversions);
            }
            catch (Exception var15) {
                errors.put(resourceKey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse %s from pack %s", resourceLocation, resource.b()), var15));
            }
        }
        PaperRegistryListenerManager.INSTANCE.runFreezeListeners(registry.g(), conversions);
        TagDataPack.loadTagsForRegistry(resourceManager, registry, ReloadableRegistrarEvent.Cause.INITIAL);
    }

    static <E> void loadContentsFromNetwork(Map<ResourceKey<? extends IRegistry<?>>, c> data, ResourceProvider factory, RegistryOps.c infoGetter, IRegistryWritable<E> registry, Decoder<E> decoder, Map<ResourceKey<?>, Exception> loadingErrors, Conversions conversions) {
        c networkedRegistryData = data.get(registry.g());
        if (networkedRegistryData != null) {
            RegistryOps<NBTBase> registryOps = RegistryOps.a(DynamicOpsNBT.a, infoGetter);
            RegistryOps<JsonElement> registryOps2 = RegistryOps.a(JsonOps.INSTANCE, infoGetter);
            String string = Registries.c(registry.g());
            FileToIdConverter fileToIdConverter = FileToIdConverter.a(string);
            for (RegistrySynchronization.a packedRegistryEntry : networkedRegistryData.a) {
                ResourceKey resourceKey = ResourceKey.a(registry.g(), packedRegistryEntry.a());
                Optional<NBTBase> optional = packedRegistryEntry.b();
                if (optional.isPresent()) {
                    try {
                        DataResult dataResult = decoder.parse(registryOps, (Object)optional.get());
                        Object object = dataResult.getOrThrow();
                        registry.a(resourceKey, object, f);
                    }
                    catch (Exception var17) {
                        loadingErrors.put(resourceKey, new IllegalStateException(String.format(Locale.ROOT, "Failed to parse value %s from server", optional.get()), var17));
                    }
                    continue;
                }
                MinecraftKey resourceLocation = fileToIdConverter.a(packedRegistryEntry.a());
                try {
                    IResource resource = factory.getResourceOrThrow(resourceLocation);
                    RegistryDataLoader.loadElementFromResource(registry, decoder, registryOps2, resourceKey, resource, f, conversions);
                }
                catch (Exception var18) {
                    loadingErrors.put(resourceKey, new IllegalStateException("Failed to parse local data", var18));
                }
            }
            TagDataPack.a(networkedRegistryData.b, registry);
        }
    }

    @FunctionalInterface
    static interface b {
        public void apply(a<?> var1, RegistryOps.c var2, Conversions var3);
    }

    public record c(List<RegistrySynchronization.a> a, TagNetworkSerialization.a b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "elements;tags", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "elements;tags", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "elements;tags", "a", "b"}, this, o2);
        }
    }

    record a<T>(d<T> a, IRegistryWritable<T> b, Map<ResourceKey<?>, Exception> c) {
        public void loadFromResources(IResourceManager resourceManager, RegistryOps.c infoGetter, Conversions conversions) {
            RegistryDataLoader.loadContentsFromManager(resourceManager, infoGetter, this.b, this.a.b, this.c, conversions);
        }

        public void loadFromNetwork(Map<ResourceKey<? extends IRegistry<?>>, c> data, ResourceProvider factory, RegistryOps.c infoGetter, Conversions conversions) {
            RegistryDataLoader.loadContentsFromNetwork(data, factory, infoGetter, this.b, this.a.b, this.c, conversions);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "data;registry;loadingErrors", "a", "b", "c"}, this, o2);
        }
    }

    public record d<T>(ResourceKey<? extends IRegistry<T>> a, Codec<T> b, boolean c) {
        d(ResourceKey<? extends IRegistry<T>> key, Codec<T> codec) {
            this(key, codec, false);
        }

        a<T> a(Lifecycle lifecycle, Map<ResourceKey<?>, Exception> errors) {
            RegistryMaterials writableRegistry = new RegistryMaterials(this.a, lifecycle);
            PaperRegistryAccess.instance().registerRegistry(this.a, writableRegistry);
            return new a(this, writableRegistry, errors);
        }

        public void a(BiConsumer<ResourceKey<? extends IRegistry<T>>, Codec<T>> callback) {
            callback.accept(this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "key;elementCodec;requiredNonEmpty", "a", "b", "c"}, this, o2);
        }
    }
}

