/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.TagDataPack;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class CustomFunctionManager
implements IReloadListener {
    private static final Logger b = LogUtils.getLogger();
    public static final ResourceKey<IRegistry<CommandFunction<CommandListenerWrapper>>> a = ResourceKey.a(MinecraftKey.b("function"));
    private static final FileToIdConverter c = new FileToIdConverter(Registries.c(a), ".mcfunction");
    private volatile Map<MinecraftKey, CommandFunction<CommandListenerWrapper>> d = ImmutableMap.of();
    private final TagDataPack<CommandFunction<CommandListenerWrapper>> e = new TagDataPack((id, required) -> this.a(id), Registries.d(a));
    private volatile Map<MinecraftKey, List<CommandFunction<CommandListenerWrapper>>> f = Map.of();
    private final int g;
    private final CommandDispatcher<CommandListenerWrapper> h;

    public Optional<CommandFunction<CommandListenerWrapper>> a(MinecraftKey id) {
        return Optional.ofNullable(this.d.get(id));
    }

    public Map<MinecraftKey, CommandFunction<CommandListenerWrapper>> a() {
        return this.d;
    }

    public List<CommandFunction<CommandListenerWrapper>> b(MinecraftKey id) {
        return this.f.getOrDefault(id, List.of());
    }

    public Iterable<MinecraftKey> b() {
        return this.f.keySet();
    }

    public CustomFunctionManager(int level, CommandDispatcher<CommandListenerWrapper> commandDispatcher) {
        this.g = level;
        this.h = commandDispatcher;
    }

    @Override
    public CompletableFuture<Void> a(IReloadListener.a synchronizer, IResourceManager manager, Executor prepareExecutor, Executor applyExecutor) {
        CompletableFuture<Map> completableFuture = CompletableFuture.supplyAsync(() -> this.e.a(manager), prepareExecutor);
        CompletionStage completableFuture2 = CompletableFuture.supplyAsync(() -> c.a(manager), prepareExecutor).thenCompose(functions -> {
            HashMap map = Maps.newHashMap();
            CommandListenerWrapper commandSourceStack = new CommandListenerWrapper(ICommandListener.a, Vec3D.c, Vec2F.a, null, this.g, "", CommonComponents.a, null, null);
            for (Map.Entry entry : functions.entrySet()) {
                MinecraftKey resourceLocation = (MinecraftKey)entry.getKey();
                MinecraftKey resourceLocation2 = c.b(resourceLocation);
                map.put(resourceLocation2, CompletableFuture.supplyAsync(() -> {
                    List<String> list = CustomFunctionManager.a((IResource)entry.getValue());
                    return CommandFunction.a(resourceLocation2, this.h, commandSourceStack, list);
                }, prepareExecutor));
            }
            CompletableFuture[] completableFutures = map.values().toArray(new CompletableFuture[0]);
            return CompletableFuture.allOf(completableFutures).handle((unused, ex) -> map);
        });
        return ((CompletableFuture)((CompletableFuture)completableFuture.thenCombine(completableFuture2, Pair::of)).thenCompose(synchronizer::a)).thenAcceptAsync(intermediate -> {
            Map map = (Map)intermediate.getSecond();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            map.forEach((id, functionFuture) -> ((CompletableFuture)functionFuture.handle((function, ex) -> {
                if (ex != null) {
                    b.error("Failed to load function {}", id, ex);
                } else {
                    builder.put(id, function);
                }
                return null;
            })).join());
            this.d = builder.build();
            this.f = this.e.build((Map)intermediate.getFirst(), null);
        }, applyExecutor);
    }

    private static List<String> a(IResource resource) {
        try {
            List<String> var2;
            try (BufferedReader bufferedReader = resource.e();){
                var2 = bufferedReader.lines().toList();
            }
            return var2;
        }
        catch (IOException var6) {
            throw new CompletionException(var6);
        }
    }
}

