/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import ca.spottedleaf.moonrise.common.util.MoonriseCommon;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.server.ChunkSystemMinecraftServer;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.jtracy.DiscontinuousFrame;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.ServerBuildInfo;
import io.papermc.paper.adventure.ImprovedChatDecorator;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.adventure.providers.ClickCallbackProviderImpl;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.command.brigadier.PaperBrigadier;
import io.papermc.paper.command.brigadier.PaperCommands;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import io.papermc.paper.log.CustomLogManager;
import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventRunner;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.plugin.manager.PaperPluginManagerImpl;
import io.papermc.paper.threadedregions.scheduler.FoliaGlobalRegionScheduler;
import io.papermc.paper.util.LogManagerShutdownThread;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ServerStopRejectedExecutionException;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.Proxy;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.Main;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.Services;
import net.minecraft.server.SuppressedExceptionCollector;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.DemoPlayerInteractManager;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerConnection;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.tags.TagDataPack;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.ModCheck;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.TimeRange;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.GameProfilerTick;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.IAsyncTaskHandlerReentrant;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.PersistentCommandStorage;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_21_R2.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R2.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_21_R2.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R2.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends IAsyncTaskHandlerReentrant<TickTask>
implements ServerInfo,
ChunkIOErrorReporter,
ICommandListener,
ChunkSystemMinecraftServer {
    private static MinecraftServer SERVER;
    public static final Logger l;
    public static final ComponentLogger COMPONENT_LOGGER;
    public static final String b = "vanilla";
    private static final float m = 0.8f;
    private static final int n = 100;
    private static final long o;
    private static final int p = 20;
    private static final long q;
    private static final int r = 100;
    private static final long s;
    private static final long t;
    private static final int u = 12;
    private static final int v = 5;
    private static final int w = 6000;
    private static final int x = 100;
    private static final int y = 3;
    public static final int c = 29999984;
    public static final WorldSettings d;
    public static final GameProfile e;
    public Convertable.ConversionSession f;
    public final WorldNBTStorage g;
    private final List<Runnable> z = Lists.newArrayList();
    private MetricsRecorder A;
    private Consumer<MethodProfilerResults> B;
    private Consumer<Path> C;
    private boolean D;
    @Nullable
    private TimeProfiler E;
    private boolean F;
    private ServerConnection G;
    public final WorldLoadListenerFactory H;
    @Nullable
    private ServerPing I;
    @Nullable
    private ServerPing.a J;
    private final RandomSource K;
    public final DataFixer L;
    private String M;
    private int N;
    private final LayeredRegistryAccess<RegistryLayer> O;
    private Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> P;
    private PlayerList Q;
    private volatile boolean R;
    private volatile boolean isRestarting = false;
    private boolean S;
    private int T;
    private int U;
    protected final Proxy h;
    private boolean V;
    private boolean W;
    private boolean X;
    private boolean Y;
    private Component motd;
    private int aa;
    private final long[] ab;
    private long ac;
    public final TickTimes tickTimes5s = new TickTimes(100);
    public final TickTimes tickTimes10s = new TickTimes(200);
    public final TickTimes tickTimes60s = new TickTimes(1200);
    @Nullable
    private KeyPair ad;
    @Nullable
    private GameProfile ae;
    private boolean af;
    private volatile boolean ag;
    private long ah;
    protected final Services i;
    private long ai;
    public final Thread aj;
    private long ak;
    private long al;
    private long am;
    private long an;
    private boolean ao;
    private long ap;
    private boolean aq;
    private final ResourcePackRepository ar;
    private final ScoreboardServer as;
    @Nullable
    private PersistentCommandStorage at;
    private final BossBattleCustomData au;
    private final CustomFunctionData av;
    private boolean aw;
    private float ax;
    public final Executor ay;
    @Nullable
    private String az;
    public ReloadableResources aA;
    private final StructureTemplateManager aB;
    private final ServerTickRateManager aC;
    protected SaveData j;
    public PotionBrewer aD;
    private FuelValues aE;
    private int aF;
    private volatile boolean aG;
    private static final AtomicReference<RuntimeException> aH;
    private final SuppressedExceptionCollector aI;
    private final DiscontinuousFrame aJ;
    public final WorldLoader.a worldLoader;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public static int currentTick;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 20;
    @Deprecated(forRemoval=true)
    public final double[] recentTps = new double[3];
    public final PaperConfigurations paperConfigurations;
    public boolean isIteratingOverLevels = false;
    public volatile Thread shutdownThread;
    public volatile boolean abnormalExit = false;
    public static final long SERVER_INIT;
    private final Set<String> pluginsBlockingSleep = new HashSet<String>();
    private volatile Throwable chunkSystemCrash;
    private static final long CHUNK_TASK_QUEUE_BACKOFF_MIN_TIME = 25000L;
    private static final long MAX_CHUNK_EXEC_TIME = 1000L;
    private static final long TASK_EXECUTION_FAILURE_BACKOFF = 5000L;
    private long lastMidTickExecute;
    private long lastMidTickExecuteFailure;
    private boolean hasStopped = false;
    private boolean hasLoggedStop = false;
    public volatile boolean hasFullyShutdown = false;
    private final Object stopLock = new Object();
    private static final long SEC_IN_NANO = 1000000000L;
    private static final long MAX_CATCHUP_BUFFER = 60000000000L;
    private long lastTick = 0L;
    private long catchupTime = 0L;
    public final RollingAverage tps1 = new RollingAverage(60);
    public final RollingAverage tps5 = new RollingAverage(300);
    public final RollingAverage tps15 = new RollingAverage(900);
    private static final BigDecimal TPS_BASE;
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(l)).build());
    public final ChatDecorator improvedChatDecorator = new ImprovedChatDecorator(this);

    public static <S extends MinecraftServer> S a(Function<Thread, S> serverFactory) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        TickThread thread = new TickThread(() -> ((MinecraftServer)atomicreference.get()).y(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, throwable) -> l.error("Uncaught exception in server thread", throwable));
        thread.setPriority(7);
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer s0 = (MinecraftServer)serverFactory.apply(thread);
        atomicreference.set(s0);
        thread.start();
        return (S)s0;
    }

    @Override
    public final void moonrise$setChunkSystemCrash(Throwable throwable) {
        this.chunkSystemCrash = throwable;
    }

    private boolean tickMidTickTasks() {
        boolean executed = false;
        for (WorldServer world : this.L()) {
            long currTime = System.nanoTime();
            if (currTime - world.moonrise$getLastMidTickFailure() <= 5000L) continue;
            if (!world.m().d()) {
                world.moonrise$setLastMidTickFailure(currTime);
                continue;
            }
            executed = true;
        }
        return executed;
    }

    @Override
    public final void moonrise$executeMidTickTasks() {
        long overuse;
        long currTime;
        long diff;
        boolean moreTasks;
        long startTime = System.nanoTime();
        if (startTime - this.lastMidTickExecute <= 25000L || startTime - this.lastMidTickExecuteFailure <= 5000L) {
            return;
        }
        do {
            moreTasks = this.tickMidTickTasks();
            currTime = System.nanoTime();
            diff = currTime - startTime;
        } while (moreTasks && diff < 1000L);
        if (!moreTasks) {
            this.lastMidTickExecuteFailure = currTime;
        }
        if ((overuse = diff - 1000L) >= 10000000L) {
            overuse = 10000000L;
        }
        double overuseCount = (double)overuse / 1000.0;
        long extraSleep = Math.round(overuseCount * 25000.0);
        this.lastMidTickExecute = currTime + extraSleep;
    }

    public MinecraftServer(OptionSet options, WorldLoader.a worldLoader, Thread thread, Convertable.ConversionSession convertable_conversionsession, ResourcePackRepository resourcepackrepository, WorldStem worldstem, Proxy proxy, DataFixer datafixer, Services services, WorldLoadListenerFactory worldloadlistenerfactory) {
        super("Server");
        SERVER = this;
        this.A = InactiveMetricsRecorder.a;
        this.B = methodprofilerresults -> this.aU();
        this.C = path -> {};
        this.K = RandomSource.a();
        this.N = -1;
        this.P = Maps.newLinkedHashMap();
        this.R = true;
        this.U = 6000;
        this.ab = new long[100];
        this.ac = 0L;
        this.ak = SystemUtils.d();
        this.al = SystemUtils.d();
        this.an = SystemUtils.d();
        this.ao = false;
        this.as = new ScoreboardServer(this);
        this.au = new BossBattleCustomData();
        this.aI = new SuppressedExceptionCollector();
        this.O = worldstem.c();
        this.j = worldstem.d();
        this.h = proxy;
        this.ar = resourcepackrepository;
        this.aA = new ReloadableResources(worldstem.a(), worldstem.b());
        this.i = services;
        if (services.f() != null) {
            services.f().a(this);
        }
        this.aC = new ServerTickRateManager(this);
        this.H = worldloadlistenerfactory;
        this.f = convertable_conversionsession;
        this.g = convertable_conversionsession.g();
        this.L = datafixer;
        this.av = new CustomFunctionData(this, this.aA.b.a());
        HolderLookup.b holdergetter = this.O.a().e(Registries.f).a(this.j.K());
        this.aB = new StructureTemplateManager(worldstem.a(), convertable_conversionsession, datafixer, holdergetter);
        this.aj = thread;
        this.ay = SystemUtils.g();
        this.aD = PotionBrewer.a(this.j.K());
        this.aA.b.c().a(this.j.K());
        this.aE = FuelValues.a(this.O.a(), this.j.K());
        this.aJ = TracyClient.createDiscontinuousFrame((String)"Server Tick");
        this.options = options;
        this.worldLoader = worldLoader;
        LogManagerShutdownThread.unhook();
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
        this.paperConfigurations = services.paperConfigurations();
    }

    private void a(WorldPersistentData persistentStateManager) {
        persistentStateManager.a(this.aJ().b(), "scoreboard");
    }

    protected abstract boolean e() throws IOException;

    protected void loadLevel(String s2) {
        if (!JvmProfiler.f.c()) {
            // empty if block
        }
        boolean flag = false;
        ProfiledDuration profiledduration = JvmProfiler.f.e();
        this.loadWorld0(s2);
        if (profiledduration != null) {
            profiledduration.finish();
        }
        if (flag) {
            try {
                JvmProfiler.f.b();
            }
            catch (Throwable throwable) {
                l.warn("Failed to stop JFR profiling", throwable);
            }
        }
    }

    protected void t() {
    }

    private void loadWorld0(String s2) {
        Convertable.ConversionSession worldSession = this.f;
        IRegistryCustom.Dimension iregistrycustom_dimension = this.O.a();
        IRegistry<WorldDimension> dimensions = iregistrycustom_dimension.e(Registries.bf);
        for (WorldDimension worldDimension : dimensions) {
            WorldServer world;
            WorldDataServer worlddata;
            Dynamic<?> dynamic;
            String name;
            ResourceKey<WorldDimension> dimensionKey = dimensions.d(worldDimension).get();
            int dimension = 0;
            if (dimensionKey == WorldDimension.c) {
                if (!this.server.getAllowNether()) continue;
                dimension = -1;
            } else if (dimensionKey == WorldDimension.d) {
                if (!this.server.getAllowEnd()) continue;
                dimension = 1;
            } else if (dimensionKey != WorldDimension.b) {
                dimension = -999;
            }
            String worldType = dimension == -999 ? dimensionKey.a().b() + "_" + dimensionKey.a().a() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase(Locale.ROOT);
            String string = name = dimensionKey == WorldDimension.b ? s2 : s2 + "_" + worldType;
            if (dimension != 0) {
                File newWorld = Convertable.getStorageFolder(new File(name).toPath(), dimensionKey).toFile();
                File oldWorld = Convertable.getStorageFolder(new File(s2).toPath(), dimensionKey).toFile();
                File oldLevelDat = new File(new File(s2), "level.dat");
                if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                    l.info("---- Migration of old " + worldType + " folder required ----");
                    l.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                    l.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                    l.info("Attempting to move " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "...");
                    if (newWorld.exists()) {
                        l.warn("A file or folder already exists at " + String.valueOf(newWorld) + "!");
                        l.info("---- Migration of old " + worldType + " folder failed ----");
                    } else if (newWorld.getParentFile().mkdirs()) {
                        if (oldWorld.renameTo(newWorld)) {
                            l.info("Success! To restore " + worldType + " in the future, simply move " + String.valueOf(newWorld) + " to " + String.valueOf(oldWorld));
                            try {
                                Files.copy((File)oldLevelDat, (File)new File(new File(name), "level.dat"));
                                org.apache.commons.io.FileUtils.copyDirectory((File)new File(new File(s2), "data"), (File)new File(new File(name), "data"));
                            }
                            catch (IOException exception) {
                                l.warn("Unable to migrate world data.");
                            }
                            l.info("---- Migration of old " + worldType + " folder complete ----");
                        } else {
                            l.warn("Could not move folder " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "!");
                            l.info("---- Migration of old " + worldType + " folder failed ----");
                        }
                    } else {
                        l.warn("Could not create path for " + String.valueOf(newWorld) + "!");
                        l.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                }
                try {
                    worldSession = Convertable.b(this.server.getWorldContainer().toPath()).validateAndCreateAccess(name, dimensionKey);
                }
                catch (IOException | ContentValidationException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (worldSession.m()) {
                WorldInfo worldinfo;
                try {
                    dynamic = worldSession.h();
                    worldinfo = worldSession.a(dynamic);
                }
                catch (IOException | NbtException | ReportedNbtException ioexception) {
                    Convertable.b convertable_b = worldSession.e();
                    l.warn("Failed to load world data from {}", (Object)convertable_b.b(), (Object)ioexception);
                    l.info("Attempting to use fallback");
                    try {
                        dynamic = worldSession.i();
                        worldinfo = worldSession.a(dynamic);
                    }
                    catch (IOException | NbtException | ReportedNbtException ioexception1) {
                        l.error("Failed to load world data from {}", (Object)convertable_b.c(), (Object)ioexception1);
                        l.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.b(), (Object)convertable_b.c());
                        return;
                    }
                    worldSession.n();
                }
                if (worldinfo.d()) {
                    l.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.r()) {
                    l.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            ChunkGenerator gen = this.server.getGenerator(name);
            BiomeProvider biomeProvider = this.server.getBiomeProvider(name);
            WorldLoader.a worldloader_a = this.worldLoader;
            IRegistry<WorldDimension> iregistry = worldloader_a.d().e(Registries.bf);
            if (dynamic != null) {
                LevelDataAndDimensions leveldataanddimensions = Convertable.a(dynamic, worldloader_a.b(), iregistry, worldloader_a.c());
                worlddata = (WorldDataServer)leveldataanddimensions.a();
            } else {
                WorldDimensions worlddimensions;
                WorldOptions worldoptions;
                WorldSettings worldsettings;
                if (this.X()) {
                    worldsettings = d;
                    worldoptions = WorldOptions.b;
                    worlddimensions = WorldPresets.a(worldloader_a.c());
                } else {
                    DedicatedServerProperties dedicatedserverproperties = ((DedicatedServer)this).a();
                    worldsettings = new WorldSettings(dedicatedserverproperties.l, dedicatedserverproperties.k, dedicatedserverproperties.t, dedicatedserverproperties.j, false, new GameRules(worldloader_a.b().b()), worldloader_a.b());
                    worldoptions = this.options.has("bonusChest") ? dedicatedserverproperties.aa.a(true) : dedicatedserverproperties.aa;
                    worlddimensions = dedicatedserverproperties.a(worldloader_a.c());
                }
                WorldDimensions.b worlddimensions_b = worlddimensions.a(iregistry);
                Lifecycle lifecycle = worlddimensions_b.a().add(worldloader_a.c().d());
                worlddata = new WorldDataServer(worldsettings, worldoptions, worlddimensions_b.d(), lifecycle);
            }
            worlddata.checkName(name);
            if (this.options.has("forceUpgrade")) {
                Main.a(worldSession, DataConverterRegistry.a(), this.options.has("eraseCache"), () -> true, iregistrycustom_dimension, this.options.has("recreateRegionFiles"));
            }
            WorldDataServer iworlddataserver = worlddata;
            boolean flag = worlddata.A();
            WorldOptions worldoptions = worlddata.y();
            long i2 = worldoptions.c();
            long j2 = BiomeManager.a(i2);
            ImmutableList list = ImmutableList.of((Object)new MobSpawnerPhantom(), (Object)new MobSpawnerPatrol(), (Object)new MobSpawnerCat(), (Object)new VillageSiege(), (Object)new MobSpawnerTrader(iworlddataserver));
            WorldDimension worlddimension = dimensions.c(dimensionKey);
            CraftWorldInfo worldInfo = new CraftWorldInfo(iworlddataserver, worldSession, World.Environment.getEnvironment((int)dimension), worlddimension.a().a(), worlddimension.b(), this.ba());
            if (biomeProvider == null && gen != null) {
                biomeProvider = gen.getDefaultBiomeProvider((org.bukkit.generator.WorldInfo)worldInfo);
            }
            ResourceKey<net.minecraft.world.level.World> worldKey = ResourceKey.a(Registries.be, dimensionKey.a());
            if (dimensionKey == WorldDimension.b) {
                this.j = worlddata;
                this.j.a(((DedicatedServer)this).a().k);
                worldloadlistener = this.H.create(this.j.o().c(GameRules.ab));
                world = new WorldServer(this, this.ay, worldSession, iworlddataserver, worldKey, worlddimension, worldloadlistener, flag, j2, (List<MobSpawner>)list, true, null, World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
                WorldPersistentData worldpersistentdata = world.v();
                this.a(worldpersistentdata);
                this.server.scoreboardManager = new CraftScoreboardManager(this, world.g());
                this.at = new PersistentCommandStorage(worldpersistentdata);
            } else {
                worldloadlistener = this.H.create(this.j.o().c(GameRules.ab));
                ImmutableList spawners = GlobalConfiguration.get().misc.useDimensionTypeForCustomSpawners && this.ba().e(Registries.aN).d(worlddimension.a().a()).orElseThrow() == BuiltinDimensionTypes.a ? list : Collections.emptyList();
                world = new WorldServer(this, this.ay, worldSession, iworlddataserver, worldKey, worlddimension, worldloadlistener, flag, j2, (List<MobSpawner>)spawners, true, this.J().M(), World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
            }
            worlddata.a(this.getServerModName(), this.Q().a());
            this.addLevel(world);
            this.initWorld(world, worlddata, this.j, worldoptions);
            this.ag().a(world);
            if (worlddata.E() == null) continue;
            this.aM().a(worlddata.E(), this.ba());
        }
        this.t();
        for (WorldServer worldserver : this.L()) {
            this.prepareLevels(worldserver.m().a.E, worldserver);
            this.server.getPluginManager().callEvent((Event)new WorldLoadEvent((World)worldserver.getWorld()));
        }
        ScoreboardServer scoreboard = this.aJ();
        Collection toRemove = scoreboard.g().stream().filter(team -> team.b().startsWith("collideRule_")).map(ScoreboardTeam::b).collect(Collectors.toList());
        for (String teamName : toRemove) {
            scoreboard.d(scoreboard.b(teamName));
        }
        if (!GlobalConfiguration.get().collisions.enablePlayerCollisions) {
            this.ag().collideRuleTeamName = StringUtils.left((String)("collideRule_" + ThreadLocalRandom.current().nextInt()), (int)16);
            ScoreboardTeam collideTeam = scoreboard.c(this.ag().collideRuleTeamName);
            collideTeam.b(false);
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.spark.registerCommandBeforePlugins(this.server);
        this.server.spark.enableAfterPlugins(this.server);
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.pluginsEnabled();
        }
        PaperCommands.INSTANCE.setValid();
        LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.INITIAL);
        ((SimpleHelpMap)this.server.getHelpMap()).initializeCommands();
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.G.acceptConnections();
    }

    public void initWorld(WorldServer worldserver, IWorldDataServer iworlddataserver, SaveData saveData, WorldOptions worldoptions) {
        boolean flag = saveData.A();
        if (worldserver.generator != null) {
            worldserver.getWorld().getPopulators().addAll(worldserver.generator.getDefaultPopulators((World)worldserver.getWorld()));
        }
        WorldBorder worldborder = worldserver.F_();
        worldborder.a(iworlddataserver.p());
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)worldserver.getWorld()));
        if (!iworlddataserver.n()) {
            try {
                MinecraftServer.a(worldserver, iworlddataserver, worldoptions.e(), flag);
                iworlddataserver.c(true);
                if (flag) {
                    this.a(this.j);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.a(throwable, "Exception initializing level");
                try {
                    worldserver.a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            iworlddataserver.c(true);
        }
    }

    private static void a(WorldServer world, IWorldDataServer worldProperties, boolean bonusChest, boolean debugWorld) {
        if (debugWorld) {
            worldProperties.a(BlockPosition.c.b(80), 0.0f);
        } else {
            ChunkProviderServer chunkproviderserver = world.m();
            if (world.generator != null) {
                Random rand = new Random(world.D());
                Location spawn = world.generator.getFixedSpawnLocation((World)world.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != world.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + worldProperties.e() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    worldProperties.a(new BlockPosition(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), spawn.getYaw());
                    return;
                }
            }
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(chunkproviderserver.i().b().a());
            int i2 = chunkproviderserver.g().a(world);
            if (i2 < world.L_()) {
                BlockPosition blockposition = chunkcoordintpair.l();
                i2 = world.a(HeightMap.Type.b, blockposition.u() + 8, blockposition.w() + 8);
            }
            worldProperties.a(chunkcoordintpair.l().b(8, i2, 8), 0.0f);
            int j2 = 0;
            int k2 = 0;
            int l2 = 0;
            int i1 = -1;
            for (int j1 = 0; j1 < MathHelper.h(11); ++j1) {
                BlockPosition blockposition1;
                if (j2 >= -5 && j2 <= 5 && k2 >= -5 && k2 <= 5 && (blockposition1 = WorldProviderNormal.a(world, new ChunkCoordIntPair(chunkcoordintpair.h + j2, chunkcoordintpair.i + k2))) != null) {
                    worldProperties.a(blockposition1, 0.0f);
                    break;
                }
                if (j2 == k2 || j2 < 0 && j2 == -k2 || j2 > 0 && j2 == 1 - k2) {
                    int k1 = l2;
                    l2 = -i1;
                    i1 = k1;
                }
                j2 += l2;
                k2 += i1;
            }
            if (bonusChest) {
                world.K_().a(Registries.aL).flatMap(iregistry -> iregistry.a(MiscOverworldFeatures.m)).ifPresent(holder_c -> ((WorldGenFeatureConfigured)holder_c.a()).a(world, chunkproviderserver.g(), world.A, worldProperties.a()));
            }
        }
    }

    private void a(SaveData properties) {
        properties.a(EnumDifficulty.a);
        properties.d(true);
        IWorldDataServer iworlddataserver = properties.I();
        iworlddataserver.b(false);
        iworlddataserver.a(false);
        iworlddataserver.a(1000000000);
        iworlddataserver.b(6000L);
        iworlddataserver.a(EnumGamemode.d);
    }

    public void prepareLevels(WorldLoadListener worldloadlistener, WorldServer worldserver) {
        int j2;
        this.forceTicks = true;
        l.info("Preparing start region for dimension {}", (Object)worldserver.ah().a());
        BlockPosition blockposition = worldserver.Y();
        worldloadlistener.a(new ChunkCoordIntPair(blockposition));
        ChunkProviderServer chunkproviderserver = worldserver.m();
        this.an = SystemUtils.d();
        worldserver.a(blockposition, worldserver.Z());
        int i2 = worldserver.N().c(GameRules.ab);
        int n2 = j2 = i2 > 0 ? MathHelper.h(WorldLoadListener.a(i2)) : 0;
        while (chunkproviderserver.b() < j2) {
            this.executeModerately();
        }
        this.executeModerately();
        WorldServer worldserver1 = worldserver;
        ForcedChunk forcedchunk = worldserver1.v().b(ForcedChunk.a(), "chunks");
        if (forcedchunk != null) {
            LongIterator longiterator = forcedchunk.b().iterator();
            while (longiterator.hasNext()) {
                long k2 = longiterator.nextLong();
                ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(k2);
                worldserver1.m().a(chunkcoordintpair, true);
            }
        }
        this.executeModerately();
        worldloadlistener.b();
        worldserver.a(worldserver.L.q() != EnumDifficulty.a && ((DedicatedServer)this).s.a().v);
        this.forceTicks = false;
    }

    public EnumGamemode u() {
        return this.j.k();
    }

    public boolean w_() {
        return this.j.l();
    }

    public abstract int k();

    public abstract int l();

    public abstract boolean m();

    public boolean a(boolean suppressLogs, boolean flush, boolean force) {
        return this.saveAllChunks(suppressLogs, flush, force, false);
    }

    public boolean saveAllChunks(boolean suppressLogs, boolean flush, boolean force, boolean close) {
        boolean flag3 = false;
        for (WorldServer worldserver : this.L()) {
            if (!suppressLogs) {
                l.info("Saving chunks for level '{}'/{}", (Object)worldserver, (Object)worldserver.ah().a());
            }
            worldserver.save(null, flush, worldserver.e && !force, close);
            flag3 = true;
        }
        if (flush) {
            for (WorldServer worldserver2 : this.L()) {
                l.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)worldserver2.m().a.n());
            }
            l.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean suppressLogs, boolean flush, boolean force) {
        boolean flag3;
        try {
            this.aG = true;
            this.ag().h();
            flag3 = this.a(suppressLogs, flush, force);
        }
        finally {
            this.aG = false;
        }
        return flag3;
    }

    @Override
    public void close() {
        this.v();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void v() {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        if (!this.hasLoggedStop && this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.shutdownThread = Thread.currentThread();
        WatchdogThread.doStop();
        if (this.A.e()) {
            this.aW();
        }
        l.info("Stopping server");
        CommandDispatcher.COMMAND_SENDING_POOL.shutdownNow();
        if (this.server != null) {
            this.server.spark.disable();
            this.server.disablePlugins();
            this.server.waitForAsyncTasksShutdown();
        }
        if (PluginInitializerManager.instance().pluginRemapper != null) {
            PluginInitializerManager.instance().pluginRemapper.shutdown();
        }
        this.ah().b();
        this.aG = true;
        if (this.Q != null) {
            l.info("Saving players");
            this.Q.h();
            this.Q.removeAll(this.isRestarting);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        l.info("Saving worlds");
        for (WorldServer worldserver : this.L()) {
            if (worldserver == null) continue;
            worldserver.e = false;
        }
        this.saveAllChunks(false, true, true, true);
        this.aG = false;
        this.aA.close();
        try {
            this.f.close();
        }
        catch (IOException ioexception1) {
            l.error("Failed to unlock level {}", (Object)this.f.f(), (Object)ioexception1);
        }
        MCUtil.ASYNC_EXECUTOR.shutdown();
        try {
            MCUtil.ASYNC_EXECUTOR.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            l.info("Saving usercache.json");
            this.at().save(false);
        }
        l.info("Waiting for I/O tasks to complete...");
        MoonriseRegionFileIO.flush(this);
        l.info("All I/O tasks to complete");
        if (this instanceof DedicatedServer) {
            MoonriseCommon.haltExecutors();
        }
        SystemUtils.j();
        try {
            TerminalConsoleAppender.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CustomLogManager.forceReset();
        this.i();
    }

    public String w() {
        return this.M;
    }

    @Override
    public void a_(String serverIp) {
        this.M = serverIp;
    }

    public boolean x() {
        return this.R;
    }

    public void a(boolean waitForShutdown) {
        this.safeShutdown(waitForShutdown, false);
    }

    public void safeShutdown(boolean waitForShutdown, boolean isRestarting) {
        this.isRestarting = isRestarting;
        this.hasLoggedStop = true;
        if (this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.R = false;
        if (waitForShutdown) {
            try {
                this.aj.join();
            }
            catch (InterruptedException interruptedexception) {
                l.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    private static double calcTps(double avg, double exp, double tps) {
        return avg * exp + tps * (1.0 - exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void y() {
        try {
            long serverStartTime = SystemUtils.d();
            if (!this.e()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.an = SystemUtils.d();
            this.J = this.bC().orElse(null);
            this.I = this.bF();
            l.info("Running delayed init tasks");
            this.server.getScheduler().mainThreadHeartbeat();
            long actualDoneTimeMs = System.currentTimeMillis() - org.bukkit.craftbukkit.Main.BOOT_TIME.toEpochMilli();
            l.info("Done ({})! For help, type \"help\"", (Object)String.format(Locale.ROOT, "%.3fs", (double)actualDoneTimeMs / 1000.0));
            this.server.spark.enableBeforePlugins();
            WatchdogThread.tick();
            WatchdogThread.hasStarted = true;
            Arrays.fill(this.recentTps, 20.0);
            long tickSection = SystemUtils.d();
            if (GlobalConfiguration.isFirstStart) {
                l.info("*************************************************************************************");
                l.info("This is the first time you're starting this server.");
                l.info("It's recommended you read our 'Getting Started' documentation for guidance.");
                l.info("View this and more helpful information here: https://docs.papermc.io/paper/next-steps");
                l.info("*************************************************************************************");
            }
            while (this.R) {
                boolean flag;
                long i2;
                if (!this.E() && this.aC.a() && this.aC.d()) {
                    i2 = 0L;
                    this.ah = this.an = SystemUtils.d();
                } else {
                    i2 = this.aC.h();
                    long j2 = SystemUtils.d() - this.an;
                    if (j2 > o + 20L * i2 && this.an - this.ah >= q + 100L * i2) {
                        long k2 = j2 / i2;
                        if (this.server.getWarnOnOverload()) {
                            l.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)(j2 / TimeRange.b), (Object)k2);
                        }
                        this.an += k2 * i2;
                        this.ah = this.an;
                    }
                }
                long currentTime = SystemUtils.d();
                if (++currentTick % 20 == 0) {
                    long diff = currentTime - tickSection;
                    BigDecimal currentTps = TPS_BASE.divide(new BigDecimal(diff), 30, RoundingMode.HALF_UP);
                    this.tps1.add(currentTps, diff);
                    this.tps5.add(currentTps, diff);
                    this.tps15.add(currentTps, diff);
                    this.recentTps[0] = this.tps1.getAverage();
                    this.recentTps[1] = this.tps5.getAverage();
                    this.recentTps[2] = this.tps15.getAverage();
                    tickSection = currentTime;
                }
                boolean bl = flag = i2 == 0L;
                if (this.F) {
                    this.F = false;
                    this.E = new TimeProfiler(SystemUtils.d(), this.T);
                }
                this.lastTick = currentTime;
                this.an += i2;
                try (Profiler.a profiler_a = Profiler.a(this.bI());){
                    GameProfilerFiller gameprofilerfiller = Profiler.a();
                    gameprofilerfiller.a("tick");
                    this.aJ.start();
                    this.a(flag ? () -> false : this::bu);
                    Throwable crash = this.chunkSystemCrash;
                    if (crash != null) {
                        this.chunkSystemCrash = null;
                        throw new RuntimeException("Chunk system crash propagated to tick()", crash);
                    }
                    this.aJ.end();
                    gameprofilerfiller.b("nextTickWait");
                    this.aq = true;
                    this.ap = Math.max(SystemUtils.d() + i2, this.an);
                    this.bs();
                    this.x_();
                    this.bt();
                    if (flag) {
                        this.aC.e();
                    }
                    gameprofilerfiller.c();
                    this.br();
                }
                finally {
                    this.aS();
                }
                this.ag = true;
                JvmProfiler.f.a(this.ax);
            }
            return;
        }
        catch (Throwable throwable2) {
            if (throwable2 instanceof ThreadDeath) {
                l.error("Main thread terminated by WatchDog due to hard crash", throwable2);
                return;
            }
            l.error("Encountered an unexpected exception", throwable2);
            CrashReport crashreport = MinecraftServer.b(throwable2);
            this.b(crashreport.f());
            Path path = this.D().resolve("crash-reports").resolve("crash-" + SystemUtils.f() + "-server.txt");
            if (crashreport.a(path, ReportType.a)) {
                l.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
            } else {
                l.error("We were unable to save this crash report to disk.");
            }
            this.a(crashreport);
            return;
        }
        finally {
            try {
                this.S = true;
                this.v();
            }
            catch (Throwable throwable3) {
                l.error("Exception stopping the server", throwable3);
            }
            finally {
                if (this.i.f() != null) {
                    this.i.f().a();
                }
            }
        }
    }

    private void br() {
        long i2 = SystemUtils.d();
        if (this.g()) {
            this.f().a(i2 - this.ak);
        }
        this.ak = i2;
    }

    private void bs() {
        if (this.g()) {
            this.al = SystemUtils.d();
            this.am = 0L;
        }
    }

    private void bt() {
        if (this.g()) {
            SampleLogger samplelogger = this.f();
            samplelogger.a(SystemUtils.d() - this.al - this.am, TpsDebugDimensions.c.ordinal());
            samplelogger.a(this.am, TpsDebugDimensions.d.ordinal());
        }
    }

    private static CrashReport b(Throwable throwable) {
        CrashReport crashreport;
        ReportedException reportedexception = null;
        for (Throwable throwable1 = throwable; throwable1 != null; throwable1 = throwable1.getCause()) {
            ReportedException reportedexception1;
            if (!(throwable1 instanceof ReportedException)) continue;
            reportedexception = reportedexception1 = (ReportedException)throwable1;
        }
        if (reportedexception != null) {
            crashreport = reportedexception.a();
            if (reportedexception != throwable) {
                crashreport.a("Wrapped in").a("Wrapping exception", throwable);
            }
        } else {
            crashreport = new CrashReport("Exception in server tick loop", throwable);
        }
        return crashreport;
    }

    private boolean bu() {
        return this.forceTicks || this.bB() || SystemUtils.d() < (this.aq ? this.ap : this.an);
    }

    private void executeModerately() {
        this.bA();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    public static boolean z() {
        RuntimeException runtimeexception = aH.get();
        if (runtimeexception != null) {
            throw runtimeexception;
        }
        return true;
    }

    public static void a(RuntimeException exception) {
        aH.compareAndSet(null, exception);
    }

    @Override
    public void b(BooleanSupplier stopCondition) {
        super.b(() -> MinecraftServer.z() && stopCondition.getAsBoolean());
    }

    protected void x_() {
        this.bA();
        this.ao = true;
        try {
            this.b(() -> !this.bu());
        }
        finally {
            this.ao = false;
        }
    }

    @Override
    public void A() {
        boolean flag = this.g();
        long i2 = flag ? SystemUtils.d() : 0L;
        long j2 = this.ao ? this.an - SystemUtils.d() : 100000L;
        LockSupport.parkNanos("waiting for tasks", j2);
        if (flag) {
            this.am += SystemUtils.d() - i2;
        }
    }

    public TickTask a(Runnable runnable) {
        if (this.hasStopped && Thread.currentThread().equals(this.shutdownThread)) {
            runnable.run();
            runnable = () -> {};
        }
        return new TickTask(this.T, runnable);
    }

    protected boolean a(TickTask ticktask) {
        return ticktask.a() + 3 < this.T || this.bu();
    }

    @Override
    public boolean B() {
        boolean flag;
        this.aq = flag = this.bv();
        return flag;
    }

    private boolean bv() {
        if (super.B()) {
            this.moonrise$executeMidTickTasks();
            return true;
        }
        boolean ret = false;
        if (this.aC.a() || this.bu()) {
            for (WorldServer worldserver : this.L()) {
                if (!worldserver.m().d()) continue;
                ret = true;
            }
        }
        return ret;
    }

    public void b(TickTask ticktask) {
        Profiler.a().f("runTask");
        super.d(ticktask);
    }

    private Optional<ServerPing.a> bC() {
        Optional<Path> optional = Optional.of(this.c("server-icon.png")).filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])).or(() -> this.f.j().filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                BufferedImage bufferedimage = ImageIO.read(path.toFile());
                Preconditions.checkState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedimage, "PNG", bytearrayoutputstream);
                return Optional.of(new ServerPing.a(bytearrayoutputstream.toByteArray()));
            }
            catch (Exception exception) {
                l.error("Couldn't load server icon", (Throwable)exception);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> C() {
        return this.f.j();
    }

    public Path D() {
        return Path.of("", new String[0]);
    }

    public void a(CrashReport report) {
    }

    public void i() {
    }

    public boolean E() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(BooleanSupplier shouldKeepTicking) {
        WatchdogThread.tick();
        long i2 = SystemUtils.d();
        int j2 = this.bq() * 20;
        this.removeDisabledPluginsBlockingSleep();
        if (j2 > 0) {
            this.aF = this.Q.m() == 0 && !this.aC.a() && this.pluginsBlockingSleep.isEmpty() ? ++this.aF : 0;
            if (this.aF >= j2) {
                Runnable task;
                this.server.spark.tickStart();
                if (this.aF == j2) {
                    l.info("Server empty for {} seconds, pausing", (Object)this.bq());
                    this.bD();
                }
                this.server.getScheduler().mainThreadHeartbeat();
                while ((task = this.processQueue.poll()) != null) {
                    task.run();
                }
                for (WorldServer level : this.P.values()) {
                    level.m().a(() -> true, false);
                }
                this.server.spark.executeMainThreadTasks();
                this.G();
                this.server.spark.tickEnd((double)(System.nanoTime() - this.lastTick) / 1000000.0);
                return;
            }
        }
        this.server.spark.tickStart();
        new ServerTickStartEvent(this.T + 1).callEvent();
        ++this.T;
        this.aC.m();
        this.c(shouldKeepTicking);
        if (i2 - this.ai >= s) {
            this.ai = i2;
            this.I = this.bF();
        }
        --this.U;
        GameProfilerFiller profiler = Profiler.a();
        int playerSaveInterval = GlobalConfiguration.get().playerAutoSave.rate;
        if (playerSaveInterval < 0) {
            playerSaveInterval = this.autosavePeriod;
        }
        profiler.a("save");
        boolean fullSave = this.autosavePeriod > 0 && this.T % this.autosavePeriod == 0;
        try {
            this.aG = true;
            if (playerSaveInterval > 0) {
                this.Q.saveAll(playerSaveInterval);
            }
            for (WorldServer level : this.L()) {
                if (level.paperConfig().chunks.autoSaveInterval.value() <= 0) continue;
                level.saveIncrementally(fullSave);
            }
        }
        finally {
            this.aG = false;
        }
        profiler.c();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        this.bA();
        this.server.spark.executeMainThreadTasks();
        long endTime = System.nanoTime();
        long remaining = 50000000L - (endTime - this.lastTick) - this.catchupTime;
        new ServerTickEndEvent(this.T, (double)(endTime - this.lastTick) / 1000000.0, remaining).callEvent();
        this.server.spark.tickEnd((double)(endTime - this.lastTick) / 1000000.0);
        gameprofilerfiller.a("tallying");
        long k2 = SystemUtils.d() - i2;
        int l2 = this.T % 100;
        this.ac -= this.ab[l2];
        this.ac += k2;
        this.ab[l2] = k2;
        this.ax = this.ax * 0.8f + (float)k2 / (float)TimeRange.b * 0.19999999f;
        this.tickTimes5s.add(this.T, k2);
        this.tickTimes10s.add(this.T, k2);
        this.tickTimes60s.add(this.T, k2);
        this.a(i2);
        gameprofilerfiller.c();
    }

    private void bD() {
        this.U = this.autosavePeriod;
        l.debug("Autosave started");
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("save");
        this.b(true, false, false);
        gameprofilerfiller.c();
        l.debug("Autosave finished");
    }

    private void a(long tickStartTime) {
        if (this.g()) {
            this.f().a(SystemUtils.d() - tickStartTime, TpsDebugDimensions.b.ordinal());
        }
    }

    private int bE() {
        float f2;
        if (this.aC.a()) {
            long i2 = this.aQ() + 1L;
            f2 = (float)TimeRange.a / (float)i2;
        } else {
            f2 = this.aC.f();
        }
        boolean flag = true;
        return Math.max(100, (int)(f2 * 300.0f));
    }

    public void F() {
        int i2 = this.bE();
        if (i2 < this.U) {
            this.U = i2;
        }
    }

    protected abstract SampleLogger f();

    public abstract boolean g();

    private ServerPing bF() {
        ServerPing.ServerPingPlayerSample serverping_serverpingplayersample = this.bG();
        return new ServerPing(PaperAdventure.asVanilla(this.motd), Optional.of(serverping_serverpingplayersample), Optional.of(ServerPing.ServerData.a()), Optional.ofNullable(this.J), this.aA());
    }

    private ServerPing.ServerPingPlayerSample bG() {
        List<EntityPlayer> list = this.Q.t();
        int i2 = this.O();
        if (this.an()) {
            return new ServerPing.ServerPingPlayerSample(i2, list.size(), List.of());
        }
        int j2 = Math.min(list.size(), SpigotConfig.playerSample);
        ObjectArrayList objectarraylist = new ObjectArrayList(j2);
        int k2 = MathHelper.a(this.K, 0, list.size() - j2);
        for (int l2 = 0; l2 < j2; ++l2) {
            EntityPlayer entityplayer = list.get(k2 + l2);
            objectarraylist.add((Object)(entityplayer.ab() ? entityplayer.gh() : e));
        }
        SystemUtils.c(objectarraylist, this.K);
        return new ServerPing.ServerPingPlayerSample(i2, list.size(), (List<GameProfile>)objectarraylist);
    }

    protected void c(BooleanSupplier shouldKeepTicking) {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        this.ag().t().forEach(entityplayer -> entityplayer.f.f());
        this.server.getScheduler().mainThreadHeartbeat();
        ((FoliaGlobalRegionScheduler)Bukkit.getGlobalRegionScheduler()).tick();
        this.L().forEach(level -> {
            for (Entity entity : level.G().a()) {
                CraftEntity bukkit;
                if (entity.dR() || (bukkit = entity.getBukkitEntityRaw()) == null) continue;
                bukkit.taskScheduler.executeTick();
            }
        });
        ClickCallbackProviderImpl.CALLBACK_MANAGER.handleQueue(this.T);
        gameprofilerfiller.a("commandFunctions");
        this.aE().b();
        gameprofilerfiller.b("levels");
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        for (WorldServer level2 : this.L()) {
            boolean doDaylight = level2.N().b(GameRules.l);
            long dayTime = level2.ad();
            long worldTime = level2.ac();
            PacketPlayOutUpdateTime worldPacket = new PacketPlayOutUpdateTime(worldTime, dayTime, doDaylight);
            for (EntityHuman entityHuman : level2.y()) {
                if (!(entityHuman instanceof EntityPlayer) || (this.T + entityHuman.ar()) % 20 != 0) continue;
                EntityPlayer entityplayer2 = (EntityPlayer)entityHuman;
                long playerTime = entityplayer2.getPlayerTime();
                PacketPlayOutUpdateTime packet = playerTime == dayTime ? worldPacket : new PacketPlayOutUpdateTime(worldTime, playerTime, doDaylight);
                entityplayer2.f.b(packet);
            }
        }
        this.isIteratingOverLevels = true;
        for (WorldServer worldserver : this.L()) {
            worldserver.hasPhysicsEvent = BlockPhysicsEvent.getHandlerList().getRegisteredListeners().length > 0;
            worldserver.hasEntityMoveEvent = EntityMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            TileEntityHopper.skipHopperEvents = worldserver.paperConfig().hopper.disableMoveEvent || InventoryMoveItemEvent.getHandlerList().getRegisteredListeners().length == 0;
            worldserver.updateLagCompensationTick();
            gameprofilerfiller.a(() -> {
                String s2 = String.valueOf(worldserver);
                return s2 + " " + String.valueOf(worldserver.ah().a());
            });
            gameprofilerfiller.a("tick");
            try {
                worldserver.a(shouldKeepTicking);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.a(throwable, "Exception ticking world");
                worldserver.a(crashreport);
                throw new ReportedException(crashreport);
            }
            gameprofilerfiller.c();
            gameprofilerfiller.c();
            worldserver.explosionDensityCache.clear();
        }
        this.isIteratingOverLevels = false;
        gameprofilerfiller.b("connection");
        this.G();
        gameprofilerfiller.b("players");
        this.Q.d();
        if (SharedConstants.aU && this.aC.i()) {
            GameTestHarnessTicker.a.b();
        }
        gameprofilerfiller.b("server gui refresh");
        for (int i2 = 0; i2 < this.z.size(); ++i2) {
            this.z.get(i2).run();
        }
        gameprofilerfiller.b("send chunks");
        for (EntityPlayer entityplayer3 : this.Q.t()) {
            entityplayer3.f.g.a(entityplayer3);
            entityplayer3.f.g();
        }
        gameprofilerfiller.c();
    }

    public void G() {
        this.ah().c();
    }

    private void b(WorldServer world) {
        this.Q.a(new PacketPlayOutUpdateTime(world.ac(), world.ad(), world.N().b(GameRules.l)), world.ah());
    }

    public void H() {
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("timeSync");
        for (WorldServer worldserver : this.L()) {
            this.b(worldserver);
        }
        gameprofilerfiller.c();
    }

    public boolean a(net.minecraft.world.level.World world) {
        return true;
    }

    public void b(Runnable tickable) {
        this.z.add(tickable);
    }

    protected void b(String serverId) {
        this.az = serverId;
    }

    public boolean I() {
        return !this.aj.isAlive();
    }

    public Path c(String path) {
        return this.D().resolve(path);
    }

    public final WorldServer J() {
        return this.P.get(net.minecraft.world.level.World.i);
    }

    @Nullable
    public WorldServer a(ResourceKey<net.minecraft.world.level.World> key) {
        return this.P.get(key);
    }

    public void addLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.ah(), level);
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.P;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.ah());
        this.P = Collections.unmodifiableMap(newLevels);
    }

    public Set<ResourceKey<net.minecraft.world.level.World>> K() {
        return this.P.keySet();
    }

    public Iterable<WorldServer> L() {
        return this.P.values();
    }

    @Override
    public String M() {
        return SharedConstants.b().c();
    }

    @Override
    public int N() {
        return this.Q.m();
    }

    @Override
    public int O() {
        return this.Q.n();
    }

    public String[] P() {
        return this.Q.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return ServerBuildInfo.buildInfo().brandName();
    }

    public SystemReport b(SystemReport details) {
        details.a("Server Running", () -> Boolean.toString(this.R));
        if (this.Q != null) {
            details.a("Player Count", () -> {
                int i2 = this.Q.m();
                return i2 + " / " + this.Q.n() + "; " + String.valueOf(this.Q.t());
            });
        }
        details.a("Active Data Packs", () -> ResourcePackRepository.a(this.ar.g()));
        details.a("Available Data Packs", () -> ResourcePackRepository.a(this.ar.d()));
        details.a("Enabled Feature Flags", () -> FeatureFlags.f.b(this.j.K()).stream().map(MinecraftKey::toString).collect(Collectors.joining(", ")));
        details.a("World Generation", () -> this.j.B().toString());
        details.a("World Seed", () -> String.valueOf(this.j.y().c()));
        SuppressedExceptionCollector suppressedexceptioncollector = this.aI;
        Objects.requireNonNull(this.aI);
        details.a("Suppressed Exceptions", suppressedexceptioncollector::a);
        if (this.az != null) {
            details.a("Server Id", () -> this.az);
        }
        return this.a(details);
    }

    public abstract SystemReport a(SystemReport var1);

    public ModCheck Q() {
        return ModCheck.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(IChatBaseComponent message) {
        l.info((String)PaperAdventure.ANSI_SERIALIZER.serialize(PaperAdventure.asAdventure(message)));
    }

    public KeyPair R() {
        return this.ad;
    }

    public int S() {
        return this.N;
    }

    public void a(int serverPort) {
        this.N = serverPort;
    }

    @Nullable
    public GameProfile T() {
        return this.ae;
    }

    public void b(@Nullable GameProfile hostProfile) {
        this.ae = hostProfile;
    }

    public boolean U() {
        return this.ae != null;
    }

    protected void V() {
        l.info("Generating keypair");
        try {
            this.ad = MinecraftEncryption.b();
        }
        catch (CryptographyException cryptographyexception) {
            throw new IllegalStateException("Failed to generate key pair", cryptographyexception);
        }
    }

    public void setDifficulty(WorldServer level, EnumDifficulty difficulty, boolean forceUpdate) {
        WorldDataServer worldData = level.L;
        if (forceUpdate || !worldData.r()) {
            worldData.a(worldData.l() ? EnumDifficulty.d : difficulty);
            level.a(worldData.q() != EnumDifficulty.a && ((DedicatedServer)this).s.a().v);
        }
    }

    public int b(int initialDistance) {
        return initialDistance;
    }

    private void bH() {
        for (WorldServer worldserver : this.L()) {
            worldserver.a(worldserver.L.q() != EnumDifficulty.a && ((DedicatedServer)this).s.a().v);
        }
    }

    public void b(boolean locked) {
        this.j.d(locked);
        this.ag().t().forEach(this::c);
    }

    private void c(EntityPlayer player) {
        WorldData worlddata = player.dW().D_();
        player.f.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
    }

    public boolean W() {
        return this.j.q() != EnumDifficulty.a;
    }

    public boolean X() {
        return this.af;
    }

    public void c(boolean demo) {
        this.af = demo;
    }

    public Optional<ServerResourcePackInfo> Y() {
        return Optional.empty();
    }

    public boolean Z() {
        return this.Y().filter(ServerResourcePackInfo::d).isPresent();
    }

    public abstract boolean n();

    public abstract int o();

    public boolean aa() {
        return this.V;
    }

    @Override
    public void d(boolean onlineMode) {
        this.V = onlineMode;
    }

    public boolean ab() {
        return this.W;
    }

    public void e(boolean preventProxyConnections) {
        this.W = preventProxyConnections;
    }

    public abstract boolean p();

    public boolean ac() {
        return this.X;
    }

    public void f(boolean pvpEnabled) {
        this.X = pvpEnabled;
    }

    public boolean ad() {
        return this.Y;
    }

    public void g(boolean flightEnabled) {
        this.Y = flightEnabled;
    }

    public abstract boolean q();

    @Override
    public String ae() {
        return LegacyComponentSerializer.legacySection().serialize(this.motd);
    }

    @Override
    public void d(String motd) {
        this.motd = LegacyComponentSerializer.legacySection().deserializeOr((Object)motd, (Component)Component.empty());
    }

    public Component motd() {
        return this.motd;
    }

    public void motd(Component motd) {
        this.motd = motd;
    }

    public boolean af() {
        return this.S;
    }

    public PlayerList ag() {
        return this.Q;
    }

    public void a(PlayerList playerManager) {
        this.Q = playerManager;
    }

    public abstract boolean r();

    public void a(EnumGamemode gameMode) {
        this.j.a(gameMode);
    }

    public ServerConnection ah() {
        return this.G == null ? (this.G = new ServerConnection(this)) : this.G;
    }

    public boolean ai() {
        return this.ag;
    }

    public boolean aj() {
        return false;
    }

    public boolean a(@Nullable EnumGamemode gameMode, boolean cheatsAllowed, int port) {
        return false;
    }

    public int ak() {
        return this.T;
    }

    public int al() {
        return 16;
    }

    public boolean a(WorldServer world, BlockPosition pos, EntityHuman player) {
        return false;
    }

    public boolean am() {
        return true;
    }

    public boolean an() {
        return false;
    }

    public Proxy ao() {
        return this.h;
    }

    public int ap() {
        return this.aa;
    }

    public void c(int playerIdleTimeout) {
        this.aa = playerIdleTimeout;
    }

    public MinecraftSessionService aq() {
        return this.i.c();
    }

    @Nullable
    public SignatureValidator ar() {
        return this.i.a();
    }

    public GameProfileRepository as() {
        return this.i.e();
    }

    @Nullable
    public UserCache at() {
        return this.i.f();
    }

    @Nullable
    public ServerPing au() {
        return this.I;
    }

    public void av() {
        this.ai = 0L;
    }

    public int aw() {
        return 29999984;
    }

    @Override
    public boolean ax() {
        return super.ax() && !this.af();
    }

    @Override
    public void c(Runnable runnable) {
        if (this.af()) {
            throw new ServerStopRejectedExecutionException("Server already shutting down");
        }
        super.c(runnable);
    }

    @Override
    public Thread ay() {
        return this.aj;
    }

    public int az() {
        return 256;
    }

    public boolean aA() {
        return false;
    }

    public long aB() {
        return this.an;
    }

    public DataFixer aC() {
        return this.L;
    }

    public int a(@Nullable WorldServer world) {
        return world != null ? world.N().c(GameRules.s) : 10;
    }

    public AdvancementDataWorld aD() {
        return this.aA.b.e();
    }

    public CustomFunctionData aE() {
        return this.av;
    }

    @Override
    @Deprecated
    @DoNotUse
    public CompletableFuture<Void> a(Collection<String> dataPacks) {
        return this.reloadResources(dataPacks, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public CompletableFuture<Void> reloadResources(Collection<String> dataPacks, ServerResourcesReloadedEvent.Cause cause) {
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Stream stream = dataPacks.stream();
            ResourcePackRepository resourcepackrepository = this.ar;
            Objects.requireNonNull(this.ar);
            return (ImmutableList)stream.map(resourcepackrepository::c).filter(Objects::nonNull).map(ResourcePackLoader::f).collect(ImmutableList.toImmutableList());
        }, this).thenCompose(immutablelist -> {
            ResourceManager resourcemanager = new ResourceManager(EnumResourcePackType.b, (List<IResourcePack>)immutablelist);
            List<IRegistry.a<?>> list = TagDataPack.loadTagsForExistingRegistries(resourcemanager, this.O.a(), ReloadableRegistrarEvent.Cause.RELOAD);
            return ((CompletableFuture)DataPackResources.a(resourcemanager, this.O, list, this.j.K(), this.n() ? CommandDispatcher.ServerType.b : CommandDispatcher.ServerType.c, this.l(), this.ay, this).whenComplete((datapackresources, throwable) -> {
                if (throwable != null) {
                    resourcemanager.close();
                }
            })).thenApply(datapackresources -> new ReloadableResources(resourcemanager, (DataPackResources)datapackresources));
        })).thenAcceptAsync(minecraftserver_reloadableresources -> {
            PaperBrigadier.moveBukkitCommands(this.aA.b().d(), minecraftserver_reloadableresources.b().d);
            this.aA.close();
            this.aA = minecraftserver_reloadableresources;
            this.ar.b(dataPacks);
            WorldDataConfiguration worlddataconfiguration = new WorldDataConfiguration(MinecraftServer.a(this.ar, true), this.j.K());
            this.j.a(worlddataconfiguration);
            this.aA.b.g();
            this.aA.b.c().a(this.j.K());
            this.aD = this.aD.reload(this.j.K());
            if (Thread.currentThread() != this.aj) {
                return;
            }
            for (EntityPlayer player : this.ag().t()) {
                player.S().b();
            }
            this.ag().u();
            this.av.a(this.aA.b.a());
            this.aB.a(this.aA.a);
            this.aE = FuelValues.a(this.O.a(), this.j.K());
            CraftBlockData.reloadCache();
            PaperCommands.INSTANCE.setValid();
            LifecycleEventRunner.INSTANCE.callReloadableRegistrarEvent(LifecycleEvents.COMMANDS, PaperCommands.INSTANCE, Plugin.class, ReloadableRegistrarEvent.Cause.RELOAD);
            SimpleHelpMap helpMap = (SimpleHelpMap)this.server.getHelpMap();
            helpMap.clear();
            helpMap.initializeGeneralTopics();
            helpMap.initializeCommands();
            this.server.syncCommands();
            new ServerResourcesReloadedEvent(cause).callEvent();
        }, (Executor)this);
        if (this.bx()) {
            Objects.requireNonNull(completablefuture);
            this.b(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static WorldDataConfiguration a(ResourcePackRepository resourcePackManager, WorldDataConfiguration dataConfiguration, boolean initMode, boolean safeMode) {
        DataPackConfiguration datapackconfiguration = dataConfiguration.a();
        FeatureFlagSet featureflagset = initMode ? FeatureFlagSet.a() : dataConfiguration.b();
        FeatureFlagSet featureflagset1 = initMode ? FeatureFlags.f.a() : dataConfiguration.b();
        resourcePackManager.a();
        if (safeMode) {
            return MinecraftServer.a(resourcePackManager, List.of(b), featureflagset, false);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s2 : datapackconfiguration.a()) {
            if (resourcePackManager.d(s2)) {
                set.add(s2);
                continue;
            }
            l.warn("Missing data pack {}", (Object)s2);
        }
        for (ResourcePackLoader resourcepackloader : resourcePackManager.d()) {
            String s1 = resourcepackloader.g();
            if (datapackconfiguration.b().contains(s1)) continue;
            FeatureFlagSet featureflagset2 = resourcepackloader.e();
            boolean flag2 = set.contains(s1);
            if (!flag2 && resourcepackloader.l().a()) {
                if (featureflagset2.a(featureflagset1)) {
                    l.info("Found new data pack {}, loading it automatically", (Object)s1);
                    set.add(s1);
                } else {
                    l.info("Found new data pack {}, but can't load it due to missing features {}", (Object)s1, (Object)FeatureFlags.a(featureflagset1, featureflagset2));
                }
            }
            if (!flag2 || featureflagset2.a(featureflagset1)) continue;
            l.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)s1, (Object)FeatureFlags.a(featureflagset1, featureflagset2));
            set.remove(s1);
        }
        if (set.isEmpty()) {
            l.info("No datapacks selected, forcing vanilla");
            set.add(b);
        }
        return MinecraftServer.a(resourcePackManager, set, featureflagset, true);
    }

    private static WorldDataConfiguration a(ResourcePackRepository resourcePackManager, Collection<String> enabledProfiles, FeatureFlagSet enabledFeatures, boolean allowEnabling) {
        resourcePackManager.b(enabledProfiles);
        MinecraftServer.a(resourcePackManager, enabledFeatures);
        DataPackConfiguration datapackconfiguration = MinecraftServer.a(resourcePackManager, allowEnabling);
        FeatureFlagSet featureflagset1 = resourcePackManager.f().c(enabledFeatures);
        return new WorldDataConfiguration(datapackconfiguration, featureflagset1);
    }

    private static void a(ResourcePackRepository resourcePackManager, FeatureFlagSet enabledFeatures) {
        FeatureFlagSet featureflagset1 = resourcePackManager.f();
        FeatureFlagSet featureflagset2 = enabledFeatures.d(featureflagset1);
        if (!featureflagset2.b()) {
            ObjectArraySet set = new ObjectArraySet(resourcePackManager.e());
            for (ResourcePackLoader resourcepackloader : resourcePackManager.d()) {
                if (featureflagset2.b()) break;
                if (resourcepackloader.l() != PackSource.d) continue;
                String s2 = resourcepackloader.g();
                FeatureFlagSet featureflagset3 = resourcepackloader.e();
                if (featureflagset3.b() || !featureflagset3.b(featureflagset2) || !featureflagset3.a(enabledFeatures)) continue;
                if (!set.add(s2)) {
                    throw new IllegalStateException("Tried to force '" + s2 + "', but it was already enabled");
                }
                l.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)s2);
                featureflagset2 = featureflagset2.d(featureflagset3);
            }
            resourcePackManager.b((Collection<String>)set);
        }
    }

    private static DataPackConfiguration a(ResourcePackRepository dataPackManager, boolean allowEnabling) {
        Collection<String> collection = dataPackManager.e();
        ImmutableList list = ImmutableList.copyOf(collection);
        List<String> list1 = allowEnabling ? dataPackManager.c().stream().filter(s2 -> !collection.contains(s2)).toList() : List.of();
        return new DataPackConfiguration((List<String>)list, list1);
    }

    public void a(CommandListenerWrapper source) {
        if (this.aN()) {
            PlayerList playerlist = source.l().ag();
            WhiteList whitelist = playerlist.i();
            if (!((DedicatedServer)MinecraftServer.getServer()).a().W.get().booleanValue()) {
                return;
            }
            ArrayList list = Lists.newArrayList(playerlist.t());
            for (EntityPlayer entityplayer : list) {
                if (whitelist.a(entityplayer.gh()) || this.ag().f(entityplayer.gh())) continue;
                entityplayer.f.disconnect((Component)Component.text((String)SpigotConfig.whitelistMessage), PlayerKickEvent.Cause.WHITELIST);
            }
        }
    }

    public ResourcePackRepository aF() {
        return this.ar;
    }

    public CommandDispatcher aG() {
        return this.aA.b.d();
    }

    public CommandListenerWrapper aH() {
        WorldServer worldserver = this.J();
        return new CommandListenerWrapper(this, worldserver == null ? Vec3D.c : Vec3D.a(worldserver.Y()), Vec2F.a, worldserver, 4, "Server", IChatBaseComponent.b("Server"), this, null);
    }

    @Override
    public boolean y_() {
        return true;
    }

    @Override
    public boolean z_() {
        return true;
    }

    @Override
    public abstract boolean c();

    public CraftingManager aI() {
        return this.aA.b.c();
    }

    public ScoreboardServer aJ() {
        return this.as;
    }

    public PersistentCommandStorage aK() {
        if (this.at == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.at;
    }

    public GameRules aL() {
        return this.J().N();
    }

    public BossBattleCustomData aM() {
        return this.au;
    }

    public boolean aN() {
        return this.aw;
    }

    public void h(boolean enforceWhitelist) {
        this.aw = enforceWhitelist;
    }

    public float aO() {
        return this.ax;
    }

    public ServerTickRateManager aP() {
        return this.aC;
    }

    public long aQ() {
        return this.ac / (long)Math.min(100, Math.max(this.T, 1));
    }

    public long[] aR() {
        return this.ab;
    }

    public int c(GameProfile profile) {
        if (this.ag().f(profile)) {
            OpListEntry oplistentry = (OpListEntry)this.ag().k().b(profile);
            return oplistentry != null ? oplistentry.a() : (this.a(profile) ? 4 : (this.U() ? (this.ag().v() ? 4 : 0) : this.k()));
        }
        return 0;
    }

    public abstract boolean a(GameProfile var1);

    public void a(Path file) throws IOException {
    }

    private void b(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<net.minecraft.world.level.World>, WorldServer> entry : this.P.entrySet()) {
                MinecraftKey minecraftkey = entry.getKey().a();
                Path path2 = path1.resolve(minecraftkey.b()).resolve(minecraftkey.a());
                java.nio.file.Files.createDirectories(path2, new FileAttribute[0]);
                entry.getValue().a(path2);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
            this.g(path.resolve("modules.txt"));
        }
        catch (IOException ioexception) {
            l.warn("Failed to save debug report", (Throwable)ioexception);
        }
    }

    private void c(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.by()));
            bufferedwriter.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aO())));
            bufferedwriter.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.ab)));
            bufferedwriter.write(String.format(Locale.ROOT, "queue: %s\n", SystemUtils.g()));
        }
    }

    @Override
    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gamerules = this.aL();
            gamerules.a(new GameRules.GameRuleVisitor(){

                @Override
                public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", key.a(), gamerules.a(key)));
                }
            });
            for (String s2 : list) {
                bufferedwriter.write(s2);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            String s2 = System.getProperty("java.class.path");
            String s1 = System.getProperty("path.separator");
            for (String s22 : Splitter.on((String)s1).split((CharSequence)s2)) {
                bufferedwriter.write(s22);
                bufferedwriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            ThreadInfo[] athreadinfo1 = athreadinfo;
            int i2 = athreadinfo.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                ThreadInfo threadinfo = athreadinfo1[j2];
                bufferedwriter.write(threadinfo.toString());
                bufferedwriter.write(10);
            }
        }
    }

    private void g(Path path) throws IOException {
        block11: {
            block10: {
                try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
                    ArrayList arraylist;
                    try {
                        arraylist = Lists.newArrayList(NativeModuleLister.a());
                    }
                    catch (Throwable throwable) {
                        l.warn("Failed to list native modules", throwable);
                        break block10;
                    }
                    arraylist.sort(Comparator.comparing(nativemodulelister_a -> nativemodulelister_a.a));
                    Iterator iterator = arraylist.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            break block11;
                        }
                        NativeModuleLister.a nativemodulelister_a2 = (NativeModuleLister.a)iterator.next();
                        bufferedwriter.write(nativemodulelister_a2.toString());
                        bufferedwriter.write(10);
                    }
                }
            }
            return;
        }
    }

    @Override
    public boolean bx() {
        return TickThread.isTickThread();
    }

    public boolean isDebugging() {
        return false;
    }

    public static MinecraftServer getServer() {
        return SERVER;
    }

    @Deprecated
    public static IRegistryCustom getDefaultRegistryAccess() {
        return CraftRegistry.getMinecraftRegistry();
    }

    private GameProfilerFiller bI() {
        if (this.D) {
            this.A = ActiveMetricsRecorder.a(new ServerMetricsSamplersProvider(SystemUtils.c, this.n()), SystemUtils.c, SystemUtils.h(), new MetricsPersister("server"), this.B, path -> {
                this.h(() -> this.b(path.resolve("server")));
                this.C.accept((Path)path);
            });
            this.D = false;
        }
        this.A.c();
        return GameProfilerTick.a(this.A.f(), GameProfilerTick.a("Server"));
    }

    public void aS() {
        this.A.d();
    }

    public boolean aT() {
        return this.A.e();
    }

    public void a(Consumer<MethodProfilerResults> resultConsumer, Consumer<Path> dumpConsumer) {
        this.B = methodprofilerresults -> {
            this.aU();
            resultConsumer.accept((MethodProfilerResults)methodprofilerresults);
        };
        this.C = dumpConsumer;
        this.D = true;
    }

    public void aU() {
        this.A = InactiveMetricsRecorder.a;
    }

    public void aV() {
        this.A.a();
    }

    public void aW() {
        this.A.b();
    }

    public Path a(SavedFile worldSavePath) {
        return this.f.a(worldSavePath);
    }

    public boolean aX() {
        return true;
    }

    public StructureTemplateManager aY() {
        return this.aB;
    }

    public SaveData aZ() {
        return this.j;
    }

    public IRegistryCustom.Dimension ba() {
        return this.O.a();
    }

    public LayeredRegistryAccess<RegistryLayer> bb() {
        return this.O;
    }

    public ReloadableServerRegistries.a bc() {
        return this.aA.b.b();
    }

    public ITextFilter a(EntityPlayer player) {
        return ITextFilter.e;
    }

    public PlayerInteractManager b(EntityPlayer player) {
        return this.X() ? new DemoPlayerInteractManager(player) : new PlayerInteractManager(player);
    }

    @Nullable
    public EnumGamemode bd() {
        return null;
    }

    public IResourceManager be() {
        return this.aA.a;
    }

    public boolean bf() {
        return this.aG;
    }

    public boolean bg() {
        return this.F || this.E != null;
    }

    public void bh() {
        this.F = true;
    }

    public MethodProfilerResults bi() {
        if (this.E == null) {
            return MethodProfilerResultsEmpty.a;
        }
        MethodProfilerResults methodprofilerresults = this.E.a(SystemUtils.d(), this.T);
        this.E = null;
        return methodprofilerresults;
    }

    public int bj() {
        return 1000000;
    }

    public void a(IChatBaseComponent message, ChatMessageType.a params, @Nullable String prefix) {
        Component s1 = PaperAdventure.asAdventure(params.a(message));
        if (prefix != null) {
            COMPONENT_LOGGER.info("[{}] {}", (Object)prefix, (Object)s1);
        } else {
            COMPONENT_LOGGER.info("{}", (Object)s1);
        }
    }

    public ChatDecorator bk() {
        return this.improvedChatDecorator;
    }

    public boolean bl() {
        return true;
    }

    public void a(EntityPlayer player, RemoteDebugSampleType type) {
    }

    public boolean bm() {
        return false;
    }

    private void a(CrashReport report, ChunkCoordIntPair pos, RegionStorageInfo key) {
        SystemUtils.h().execute(() -> {
            try {
                Path path = this.c("debug");
                FileUtils.c(path);
                String s2 = FileUtils.a(key.a());
                Path path1 = path.resolve("chunk-" + s2 + "-" + SystemUtils.f() + "-server.txt");
                FileStore filestore = java.nio.file.Files.getFileStore(path);
                long i2 = filestore.getUsableSpace();
                if (i2 < 8192L) {
                    l.warn("Not storing chunk IO report due to low space on drive {}", (Object)filestore.name());
                    return;
                }
                CrashReportSystemDetails crashreportsystemdetails = report.a("Chunk Info");
                Objects.requireNonNull(key);
                crashreportsystemdetails.a("Level", key::a);
                crashreportsystemdetails.a("Dimension", () -> key.b().a().toString());
                Objects.requireNonNull(key);
                crashreportsystemdetails.a("Storage", key::c);
                Objects.requireNonNull(pos);
                crashreportsystemdetails.a("Position", pos::toString);
                report.a(path1, ReportType.e);
                l.info("Saved details to {}", (Object)report.e());
            }
            catch (Exception exception) {
                l.warn("Failed to store chunk IO exception", (Throwable)exception);
            }
        });
    }

    @Override
    public void a(Throwable exception, RegionStorageInfo key, ChunkCoordIntPair chunkPos) {
        l.error("Failed to load chunk {},{}", new Object[]{chunkPos.h, chunkPos.i, exception});
        this.aI.a("chunk/load", exception);
        this.a(CrashReport.a(exception, "Chunk load failure"), chunkPos, key);
    }

    @Override
    public void b(Throwable exception, RegionStorageInfo key, ChunkCoordIntPair chunkPos) {
        l.error("Failed to save chunk {},{}", new Object[]{chunkPos.h, chunkPos.i, exception});
        this.aI.a("chunk/save", exception);
        this.a(CrashReport.a(exception, "Chunk save failure"), chunkPos, key);
    }

    public void a(Throwable exception, PacketType<?> type) {
        this.aI.a("packet/" + type.toString(), exception);
    }

    public PotionBrewer bn() {
        return this.aD;
    }

    public FuelValues bo() {
        return this.aE;
    }

    public ServerLinks bp() {
        return ServerLinks.a;
    }

    protected int bq() {
        return 0;
    }

    public boolean isTickPaused() {
        return this.aF > 0 && this.aF >= this.bq() * 20;
    }

    public void addPluginAllowingSleep(String pluginName, boolean value) {
        if (!value) {
            this.pluginsBlockingSleep.add(pluginName);
        } else {
            this.pluginsBlockingSleep.remove(pluginName);
        }
    }

    private void removeDisabledPluginsBlockingSleep() {
        if (this.pluginsBlockingSleep.isEmpty()) {
            return;
        }
        this.pluginsBlockingSleep.removeIf(plugin -> !PaperPluginManagerImpl.getInstance().isPluginEnabled((String)plugin));
    }

    private static /* synthetic */ boolean lambda$stopServer$9() {
        return true;
    }

    private static /* synthetic */ boolean lambda$stopServer$8(WorldServer worldserver1) {
        return worldserver1.m().a.e();
    }

    static {
        l = LogUtils.getLogger();
        COMPONENT_LOGGER = ComponentLogger.logger((String)l.getName());
        o = 30L * TimeRange.a / 20L;
        q = 10L * TimeRange.a;
        s = 5L * TimeRange.a;
        t = 10L * TimeRange.b;
        d = new WorldSettings("Demo World", EnumGamemode.a, false, EnumDifficulty.c, false, new GameRules(FeatureFlags.i), WorldDataConfiguration.c);
        e = new GameProfile(SystemUtils.e, "Anonymous Player");
        aH = new AtomicReference();
        SERVER_INIT = System.nanoTime();
        TPS_BASE = new BigDecimal(1.0E9).multiply(new BigDecimal(20));
    }

    public static class TickTimes {
        private final long[] times;

        public TickTimes(int length) {
            this.times = new long[length];
        }

        void add(int index, long time) {
            this.times[index % this.times.length] = time;
        }

        public long[] getTimes() {
            return (long[])this.times.clone();
        }

        public double getAverage() {
            long total = 0L;
            for (long value : this.times) {
                total += value;
            }
            return (double)total / (double)this.times.length * 1.0E-6;
        }
    }

    public static class RollingAverage {
        private final int size;
        private long time;
        private BigDecimal total;
        private int index = 0;
        private final BigDecimal[] samples;
        private final long[] times;

        RollingAverage(int size) {
            this.size = size;
            this.time = (long)size * 1000000000L;
            this.total = RollingAverage.dec(20L).multiply(RollingAverage.dec(1000000000L)).multiply(RollingAverage.dec(size));
            this.samples = new BigDecimal[size];
            this.times = new long[size];
            for (int i2 = 0; i2 < size; ++i2) {
                this.samples[i2] = RollingAverage.dec(20L);
                this.times[i2] = 1000000000L;
            }
        }

        private static BigDecimal dec(long t2) {
            return new BigDecimal(t2);
        }

        public void add(BigDecimal x2, long t2) {
            this.time -= this.times[this.index];
            this.total = this.total.subtract(this.samples[this.index].multiply(RollingAverage.dec(this.times[this.index])));
            this.samples[this.index] = x2;
            this.times[this.index] = t2;
            this.time += t2;
            this.total = this.total.add(x2.multiply(RollingAverage.dec(t2)));
            if (++this.index == this.size) {
                this.index = 0;
            }
        }

        public double getAverage() {
            return this.total.divide(RollingAverage.dec(this.time), 30, RoundingMode.HALF_UP).doubleValue();
        }
    }

    public record ReloadableResources(IReloadableResourceManager a, DataPackResources b) implements AutoCloseable
    {
        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this, o2);
        }
    }

    private static class TimeProfiler {
        final long a;
        final int b;

        TimeProfiler(long time, int tick) {
            this.a = time;
            this.b = tick;
        }

        MethodProfilerResults a(final long endTime, final int endTick) {
            return new MethodProfilerResults(){

                @Override
                public List<MethodProfilerResultsField> a(String parentPath) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return endTime;
                }

                @Override
                public int d() {
                    return endTick;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }

    public record ServerResourcePackInfo(UUID a, String b, String c, boolean d, @Nullable IChatBaseComponent e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this, o2);
        }
    }
}

