/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.registry.PaperRegistryAccess;
import io.papermc.paper.registry.PaperRegistryListenerManager;
import io.papermc.paper.registry.data.util.Conversions;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.tags.TagDataPack;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.slf4j.Logger;

public class ReloadableServerRegistries {
    private static final Logger a = LogUtils.getLogger();
    private static final RegistrationInfo b = new RegistrationInfo(Optional.empty(), Lifecycle.experimental());

    public static CompletableFuture<b> a(LayeredRegistryAccess<RegistryLayer> dynamicRegistries, List<IRegistry.a<?>> pendingTagLoads, IResourceManager resourceManager, Executor prepareExecutor) {
        List<HolderLookup.b<?>> list = TagDataPack.a(dynamicRegistries.b(RegistryLayer.d), pendingTagLoads);
        HolderLookup.a provider = HolderLookup.a.a(list.stream());
        RegistryOps registryOps = provider.a(JsonOps.INSTANCE);
        Conversions conversions = new Conversions(registryOps.b);
        List<CompletableFuture> list2 = LootDataType.a().map(type -> ReloadableServerRegistries.scheduleRegistryLoad(type, registryOps, resourceManager, prepareExecutor, conversions)).toList();
        CompletableFuture completableFuture = SystemUtils.d(list2);
        return completableFuture.thenApplyAsync(registries -> ReloadableServerRegistries.a(dynamicRegistries, provider, registries), prepareExecutor);
    }

    private static <T> CompletableFuture<IRegistryWritable<?>> scheduleRegistryLoad(LootDataType<T> type, RegistryOps<JsonElement> ops, IResourceManager resourceManager, Executor prepareExecutor, Conversions conversions) {
        return CompletableFuture.supplyAsync(() -> {
            RegistryMaterials writableRegistry = new RegistryMaterials(type.b(), Lifecycle.experimental());
            PaperRegistryAccess.instance().registerReloadableRegistry(type.b(), writableRegistry);
            HashMap<MinecraftKey, Object> map = new HashMap<MinecraftKey, Object>();
            String string = Registries.c(type.b());
            ResourceDataJson.a(resourceManager, string, ops, type.c(), map);
            map.forEach((id, value) -> PaperRegistryListenerManager.INSTANCE.registerWithListeners(writableRegistry, ResourceKey.a(type.b(), id), value, b, conversions));
            TagDataPack.loadTagsForRegistry(resourceManager, writableRegistry, ReloadableRegistrarEvent.Cause.RELOAD);
            return writableRegistry;
        }, prepareExecutor);
    }

    private static b a(LayeredRegistryAccess<RegistryLayer> dynamicRegistries, HolderLookup.a nonReloadables, List<IRegistryWritable<?>> registries) {
        LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = ReloadableServerRegistries.a(dynamicRegistries, registries);
        HolderLookup.a provider = ReloadableServerRegistries.a(nonReloadables, layeredRegistryAccess.a(RegistryLayer.d));
        ReloadableServerRegistries.a(provider);
        return new b(layeredRegistryAccess, provider);
    }

    private static HolderLookup.a a(HolderLookup.a first, HolderLookup.a second) {
        return HolderLookup.a.a(Stream.concat(first.c(), second.c()));
    }

    private static void a(HolderLookup.a registries) {
        ProblemReporter.a collector = new ProblemReporter.a();
        LootCollector validationContext = new LootCollector(collector, LootContextParameterSets.q, registries);
        LootDataType.a().forEach(type -> ReloadableServerRegistries.a(validationContext, type, registries));
        collector.a().forEach((id, error) -> a.warn("Found loot table element validation problem in {}: {}", id, error));
    }

    private static LayeredRegistryAccess<RegistryLayer> a(LayeredRegistryAccess<RegistryLayer> dynamicRegistries, List<IRegistryWritable<?>> registries) {
        return dynamicRegistries.a(RegistryLayer.d, new IRegistryCustom.c(registries).e());
    }

    private static <T> void a(LootCollector reporter, LootDataType<T> lootDataType, HolderLookup.a registries) {
        HolderLookup.b<T> holderLookup = registries.d(lootDataType.b());
        holderLookup.c().forEach(entry -> lootDataType.a(reporter, entry.h(), entry.a()));
    }

    public record b(LayeredRegistryAccess<RegistryLayer> a, HolderLookup.a b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "layers;lookupWithUpdatedTags", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "layers;lookupWithUpdatedTags", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "layers;lookupWithUpdatedTags", "a", "b"}, this, o2);
        }
    }

    public static class a {
        private final HolderLookup.a a;

        public a(HolderLookup.a registries) {
            this.a = registries;
        }

        public HolderGetter.a a() {
            return this.a;
        }

        public Collection<MinecraftKey> a(ResourceKey<? extends IRegistry<?>> registryRef) {
            return this.a.d(registryRef).c_().map(ResourceKey::a).toList();
        }

        public LootTable b(ResourceKey<LootTable> key) {
            return this.a.a(Registries.bg).flatMap(registryEntryLookup -> registryEntryLookup.a(key)).map(Holder::a).orElse(LootTable.a);
        }
    }
}

