/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagDataPack;
import net.minecraft.world.level.WorldDataConfiguration;
import org.slf4j.Logger;

public class WorldLoader {
    private static final Logger a = LogUtils.getLogger();

    public static <D, R> CompletableFuture<R> a(c serverConfig, f<D> loadContextSupplier, e<D, R> saveApplierFactory, Executor prepareExecutor, Executor applyExecutor) {
        try {
            Pair<WorldDataConfiguration, IReloadableResourceManager> pair = serverConfig.a.a();
            IReloadableResourceManager closeableResourceManager = (IReloadableResourceManager)pair.getSecond();
            LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = RegistryLayer.a();
            List<IRegistry.a<?>> list = TagDataPack.loadTagsForExistingRegistries(closeableResourceManager, layeredRegistryAccess.a(RegistryLayer.a), ReloadableRegistrarEvent.Cause.INITIAL);
            IRegistryCustom.Dimension frozen = layeredRegistryAccess.b(RegistryLayer.b);
            List<HolderLookup.b<?>> list2 = TagDataPack.a(frozen, list);
            IRegistryCustom.Dimension frozen2 = RegistryDataLoader.a(closeableResourceManager, list2, RegistryDataLoader.a);
            List<HolderLookup.b<?>> list3 = Stream.concat(list2.stream(), frozen2.c()).toList();
            IRegistryCustom.Dimension frozen3 = RegistryDataLoader.a(closeableResourceManager, list3, RegistryDataLoader.b);
            WorldDataConfiguration worldDataConfiguration = (WorldDataConfiguration)pair.getFirst();
            HolderLookup.a provider = HolderLookup.a.a(list3.stream());
            b<D> dataLoadOutput = loadContextSupplier.get(new a(closeableResourceManager, worldDataConfiguration, provider, frozen3));
            LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess2 = layeredRegistryAccess.a(RegistryLayer.b, frozen2, dataLoadOutput.b);
            return ((CompletableFuture)DataPackResources.a(closeableResourceManager, layeredRegistryAccess2, list, worldDataConfiguration.b(), serverConfig.b(), serverConfig.c(), prepareExecutor, applyExecutor).whenComplete((dataPackContents, throwable) -> {
                if (throwable != null) {
                    closeableResourceManager.close();
                }
            })).thenApplyAsync(dataPackContents -> {
                dataPackContents.g();
                return saveApplierFactory.create(closeableResourceManager, (DataPackResources)dataPackContents, layeredRegistryAccess2, dataLoadOutput.a);
            }, applyExecutor);
        }
        catch (Exception var18) {
            return CompletableFuture.failedFuture(var18);
        }
    }

    public record c(d a, CommandDispatcher.ServerType b, int c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "packConfig;commandSelection;functionCompilationLevel", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "packConfig;commandSelection;functionCompilationLevel", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "packConfig;commandSelection;functionCompilationLevel", "a", "b", "c"}, this, o2);
        }
    }

    public record d(ResourcePackRepository a, WorldDataConfiguration b, boolean c, boolean d) {
        private final ResourcePackRepository a;
        private final WorldDataConfiguration b;
        private final boolean c;
        private final boolean d;

        public Pair<WorldDataConfiguration, IReloadableResourceManager> a() {
            WorldDataConfiguration worldDataConfiguration = MinecraftServer.a(this.a, this.b, this.d, this.c);
            List<IResourcePack> list = this.a.h();
            ResourceManager closeableResourceManager = new ResourceManager(EnumResourcePackType.b, list);
            return Pair.of((Object)worldDataConfiguration, (Object)closeableResourceManager);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "packRepository;initialDataConfig;safeMode;initMode", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "packRepository;initialDataConfig;safeMode;initMode", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "packRepository;initialDataConfig;safeMode;initMode", "a", "b", "c", "d"}, this, o2);
        }

        public ResourcePackRepository b() {
            return this.a;
        }

        public WorldDataConfiguration c() {
            return this.b;
        }

        public boolean d() {
            return this.c;
        }

        public boolean e() {
            return this.d;
        }
    }

    public record a(IResourceManager a, WorldDataConfiguration b, HolderLookup.a c, IRegistryCustom.Dimension d) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "resources;dataConfiguration;datapackWorldgen;datapackDimensions", "a", "b", "c", "d"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "resources;dataConfiguration;datapackWorldgen;datapackDimensions", "a", "b", "c", "d"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "resources;dataConfiguration;datapackWorldgen;datapackDimensions", "a", "b", "c", "d"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface f<D> {
        public b<D> get(a var1);
    }

    public record b<D>(D a, IRegistryCustom.Dimension b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "cookie;finalDimensions", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "cookie;finalDimensions", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "cookie;finalDimensions", "a", "b"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface e<D, R> {
        public R create(IReloadableResourceManager var1, DataPackResources var2, LayeredRegistryAccess<RegistryLayer> var3, D var4);
    }
}

