/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class CommandAttribute {
    private static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(name -> IChatBaseComponent.b("commands.attribute.failed.entity", name));
    private static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((entityName, attributeName) -> IChatBaseComponent.b("commands.attribute.failed.no_attribute", entityName, attributeName));
    private static final Dynamic3CommandExceptionType c = new Dynamic3CommandExceptionType((entityName, attributeName, uuid) -> IChatBaseComponent.b("commands.attribute.failed.no_modifier", attributeName, entityName, uuid));
    private static final Dynamic3CommandExceptionType d = new Dynamic3CommandExceptionType((entityName, attributeName, uuid) -> IChatBaseComponent.b("commands.attribute.failed.modifier_already_present", uuid, attributeName, entityName));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("attribute").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("attribute", ResourceArgument.a(registryAccess, Registries.c)).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("get").executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), 1.0))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("base").then(net.minecraft.commands.CommandDispatcher.a("set").then(net.minecraft.commands.CommandDispatcher.a("value", DoubleArgumentType.doubleArg()).executes(context -> CommandAttribute.c((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("get").executes(context -> CommandAttribute.b((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), 1.0))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context -> CommandAttribute.b((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("modifier").then(net.minecraft.commands.CommandDispatcher.a("add").then(net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("value", DoubleArgumentType.doubleArg()).then(net.minecraft.commands.CommandDispatcher.a("add_value").executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "id"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), AttributeModifier.Operation.a)))).then(net.minecraft.commands.CommandDispatcher.a("add_multiplied_base").executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "id"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), AttributeModifier.Operation.b)))).then(net.minecraft.commands.CommandDispatcher.a("add_multiplied_total").executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "id"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), AttributeModifier.Operation.c))))))).then(net.minecraft.commands.CommandDispatcher.a("remove").then(net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "id")))))).then(net.minecraft.commands.CommandDispatcher.a("value").then(net.minecraft.commands.CommandDispatcher.a("get").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("id", ArgumentMinecraftKeyRegistered.a()).executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "id"), 1.0))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentMinecraftKeyRegistered.a((CommandContext<CommandListenerWrapper>)context, "id"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))))))))))));
    }

    private static AttributeModifiable a(Entity entity, Holder<AttributeBase> attribute) throws CommandSyntaxException {
        AttributeModifiable attributeInstance = CommandAttribute.a(entity).eY().a(attribute);
        if (attributeInstance == null) {
            throw b.create((Object)entity.al(), (Object)CommandAttribute.a(attribute));
        }
        return attributeInstance;
    }

    private static EntityLiving a(Entity entity) throws CommandSyntaxException {
        if (!(entity instanceof EntityLiving)) {
            throw a.create((Object)entity.al());
        }
        return (EntityLiving)entity;
    }

    private static EntityLiving b(Entity entity, Holder<AttributeBase> attribute) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.a(entity);
        if (!livingEntity.eY().b(attribute)) {
            throw b.create((Object)entity.al(), (Object)CommandAttribute.a(attribute));
        }
        return livingEntity;
    }

    private static int a(CommandListenerWrapper source, Entity target, Holder<AttributeBase> attribute, double multiplier) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.b(target, attribute);
        double d2 = livingEntity.h(attribute);
        source.a(() -> IChatBaseComponent.a("commands.attribute.value.get.success", CommandAttribute.a(attribute), target.al(), d2), false);
        return (int)(d2 * multiplier);
    }

    private static int b(CommandListenerWrapper source, Entity target, Holder<AttributeBase> attribute, double multiplier) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.b(target, attribute);
        double d2 = livingEntity.i(attribute);
        source.a(() -> IChatBaseComponent.a("commands.attribute.base_value.get.success", CommandAttribute.a(attribute), target.al(), d2), false);
        return (int)(d2 * multiplier);
    }

    private static int a(CommandListenerWrapper source, Entity target, Holder<AttributeBase> attribute, MinecraftKey id, double multiplier) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.b(target, attribute);
        AttributeMapBase attributeMap = livingEntity.eY();
        if (!attributeMap.a(attribute, id)) {
            throw c.create((Object)target.al(), (Object)CommandAttribute.a(attribute), (Object)id);
        }
        double d2 = attributeMap.b(attribute, id);
        source.a(() -> IChatBaseComponent.a("commands.attribute.modifier.value.get.success", IChatBaseComponent.a(id), CommandAttribute.a(attribute), target.al(), d2), false);
        return (int)(d2 * multiplier);
    }

    private static int c(CommandListenerWrapper source, Entity target, Holder<AttributeBase> attribute, double value) throws CommandSyntaxException {
        CommandAttribute.a(target, attribute).a(value);
        source.a(() -> IChatBaseComponent.a("commands.attribute.base_value.set.success", CommandAttribute.a(attribute), target.al(), value), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, Entity target, Holder<AttributeBase> attribute, MinecraftKey id, double value, AttributeModifier.Operation operation) throws CommandSyntaxException {
        AttributeModifiable attributeInstance = CommandAttribute.a(target, attribute);
        AttributeModifier attributeModifier = new AttributeModifier(id, value, operation);
        if (attributeInstance.b(id)) {
            throw d.create((Object)target.al(), (Object)CommandAttribute.a(attribute), (Object)id);
        }
        attributeInstance.d(attributeModifier);
        source.a(() -> IChatBaseComponent.a("commands.attribute.modifier.add.success", IChatBaseComponent.a(id), CommandAttribute.a(attribute), target.al()), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, Entity target, Holder<AttributeBase> attribute, MinecraftKey id) throws CommandSyntaxException {
        AttributeModifiable attributeInstance = CommandAttribute.a(target, attribute);
        if (attributeInstance.c(id)) {
            source.a(() -> IChatBaseComponent.a("commands.attribute.modifier.remove.success", IChatBaseComponent.a(id), CommandAttribute.a(attribute), target.al()), false);
            return 1;
        }
        throw c.create((Object)target.al(), (Object)CommandAttribute.a(attribute), (Object)id);
    }

    private static IChatBaseComponent a(Holder<AttributeBase> attribute) {
        return IChatBaseComponent.c(attribute.a().c());
    }
}

