/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.net.InetAddresses;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import org.bukkit.event.player.PlayerKickEvent;

public class CommandBanIp {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.banip.invalid"));
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.banip.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("ban-ip").requires(source -> source.c(3))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("target", StringArgumentType.word()).executes(context -> CommandBanIp.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"target"), null))).then(net.minecraft.commands.CommandDispatcher.a("reason", ArgumentChat.a()).executes(context -> CommandBanIp.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"target"), ArgumentChat.a((CommandContext<CommandListenerWrapper>)context, "reason")))))));
    }

    private static int a(CommandListenerWrapper source, String target, @Nullable IChatBaseComponent reason) throws CommandSyntaxException {
        if (InetAddresses.isInetAddress((String)target)) {
            return CommandBanIp.b(source, target, reason);
        }
        EntityPlayer serverPlayer = source.l().ag().a(target);
        if (serverPlayer != null) {
            return CommandBanIp.b(source, serverPlayer.B(), reason);
        }
        throw a.create();
    }

    private static int b(CommandListenerWrapper source, String targetIp, @Nullable IChatBaseComponent reason) throws CommandSyntaxException {
        IpBanList ipBanList = source.l().ag().g();
        if (ipBanList.a(targetIp)) {
            throw b.create();
        }
        List<EntityPlayer> list = source.l().ag().b(targetIp);
        IpBanEntry ipBanListEntry = new IpBanEntry(targetIp, null, source.c(), null, reason == null ? null : reason.getString());
        ipBanList.a(ipBanListEntry);
        source.a(() -> IChatBaseComponent.a("commands.banip.success", new Object[]{targetIp, ipBanListEntry.d()}), true);
        if (!list.isEmpty()) {
            source.a(() -> IChatBaseComponent.a("commands.banip.info", list.size(), EntitySelector.a(list)), true);
        }
        for (EntityPlayer serverPlayer : list) {
            serverPlayer.f.disconnect(IChatBaseComponent.c("multiplayer.disconnect.ip_banned"), PlayerKickEvent.Cause.IP_BANNED);
        }
        return list.size();
    }
}

