/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.CommandSetBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public class CommandFill {
    private static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((maxCount, count) -> IChatBaseComponent.b("commands.fill.toobig", maxCount, count));
    static final ArgumentTileLocation b = new ArgumentTileLocation(Blocks.a.m(), Collections.emptySet(), null);
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.fill.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("fill").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("from", ArgumentPosition.a()).then(net.minecraft.commands.CommandDispatcher.a("to", ArgumentPosition.a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("block", ArgumentTile.a(commandRegistryAccess)).executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context, "block"), Mode.a, null))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("replace").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context, "block"), Mode.a, null))).then(net.minecraft.commands.CommandDispatcher.a("filter", ArgumentBlockPredicate.a(commandRegistryAccess)).executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context, "block"), Mode.a, ArgumentBlockPredicate.a((CommandContext<CommandListenerWrapper>)context, "filter")))))).then(net.minecraft.commands.CommandDispatcher.a("keep").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context, "block"), Mode.a, pos -> pos.c().u(pos.d()))))).then(net.minecraft.commands.CommandDispatcher.a("outline").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context, "block"), Mode.b, null)))).then(net.minecraft.commands.CommandDispatcher.a("hollow").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context, "block"), Mode.c, null)))).then(net.minecraft.commands.CommandDispatcher.a("destroy").executes(context -> CommandFill.a((CommandListenerWrapper)context.getSource(), StructureBoundingBox.a(ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "from"), ArgumentPosition.a((CommandContext<CommandListenerWrapper>)context, "to")), ArgumentTile.a((CommandContext<CommandListenerWrapper>)context, "block"), Mode.d, null))))))));
    }

    private static int a(CommandListenerWrapper source, StructureBoundingBox range, ArgumentTileLocation block, Mode mode, @Nullable Predicate<ShapeDetectorBlock> filter) throws CommandSyntaxException {
        int j2;
        int i2 = range.d() * range.e() * range.f();
        if (i2 > (j2 = source.e().N().c(GameRules.A))) {
            throw a.create((Object)j2, (Object)i2);
        }
        ArrayList list = Lists.newArrayList();
        WorldServer serverLevel = source.e();
        int k2 = 0;
        for (BlockPosition blockPos : BlockPosition.b(range.h(), range.i(), range.j(), range.k(), range.l(), range.m())) {
            ArgumentTileLocation blockInput;
            if (filter != null && !filter.test(new ShapeDetectorBlock(serverLevel, blockPos, true)) || (blockInput = mode.e.filter(range, blockPos, block, serverLevel)) == null) continue;
            TileEntity blockEntity = serverLevel.c_(blockPos);
            Clearable.a(blockEntity);
            if (!blockInput.a(serverLevel, blockPos, 2)) continue;
            list.add(blockPos.j());
            ++k2;
        }
        for (BlockPosition blockPos2 : list) {
            Block block2 = serverLevel.a_(blockPos2).b();
            serverLevel.b(blockPos2, block2);
        }
        if (k2 == 0) {
            throw c.create();
        }
        int l2 = k2;
        source.a(() -> IChatBaseComponent.a("commands.fill.success", l2), true);
        return k2;
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode a = new Mode((range, pos, block, world) -> block);
        public static final /* enum */ Mode b = new Mode((range, pos, block, world) -> {
            if (pos.u() == range.h() || pos.u() == range.k() || pos.v() == range.i() || pos.v() == range.l() || pos.w() == range.j() || pos.w() == range.m()) {
                return block;
            }
            return null;
        });
        public static final /* enum */ Mode c = new Mode((range, pos, block, world) -> {
            if (pos.u() == range.h() || pos.u() == range.k() || pos.v() == range.i() || pos.v() == range.l() || pos.w() == range.j() || pos.w() == range.m()) {
                return block;
            }
            return b;
        });
        public static final /* enum */ Mode d = new Mode((range, pos, block, world) -> {
            world.b(pos, true);
            return block;
        });
        public final CommandSetBlock.Filter e;
        private static final /* synthetic */ Mode[] f;

        public static Mode[] values() {
            return (Mode[])f.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }

        private Mode(CommandSetBlock.Filter filter) {
            this.e = filter;
        }

        private static /* synthetic */ Mode[] a() {
            return new Mode[]{a, b, c, d};
        }

        static {
            f = Mode.a();
        }
    }
}

