/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomCommandExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;

public class CommandFunction {
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(argument -> IChatBaseComponent.b("commands.function.error.argument_not_compound", argument));
    static final DynamicCommandExceptionType d = new DynamicCommandExceptionType(argument -> IChatBaseComponent.b("commands.function.scheduled.no_functions", argument));
    @VisibleForTesting
    public static final Dynamic2CommandExceptionType a = new Dynamic2CommandExceptionType((argument, argument2) -> IChatBaseComponent.b("commands.function.instantiationFailure", argument, argument2));
    public static final SuggestionProvider<CommandListenerWrapper> b = (context, builder) -> {
        CustomFunctionData serverFunctionManager = ((CommandListenerWrapper)context.getSource()).l().aE();
        ICompletionProvider.a(serverFunctionManager.e(), builder, "#");
        return ICompletionProvider.a(serverFunctionManager.d(), builder);
    };
    static final b<CommandListenerWrapper> e = new b<CommandListenerWrapper>(){

        @Override
        @Override
        public void a(CommandListenerWrapper source, MinecraftKey id, int result) {
            source.a(() -> IChatBaseComponent.a("commands.function.result", IChatBaseComponent.a(id), result), true);
        }
    };

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        LiteralArgumentBuilder<CommandListenerWrapper> literalArgumentBuilder = net.minecraft.commands.CommandDispatcher.a("with");
        for (final CommandData.c dataProvider : CommandData.c) {
            dataProvider.a((ArgumentBuilder<CommandListenerWrapper, ?>)literalArgumentBuilder, builder -> ((ArgumentBuilder)builder.executes(new c(){

                @Override
                @Override
                protected NBTTagCompound a(CommandContext<CommandListenerWrapper> context) throws CommandSyntaxException {
                    return dataProvider.a(context).a();
                }
            })).then(net.minecraft.commands.CommandDispatcher.a("path", ArgumentNBTKey.a()).executes((Command)new c(){

                @Override
                @Override
                protected NBTTagCompound a(CommandContext<CommandListenerWrapper> context) throws CommandSyntaxException {
                    return CommandFunction.a(ArgumentNBTKey.a(context, "path"), dataProvider.a(context));
                }
            })));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("function").requires(source -> source.c(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("name", ArgumentTag.a()).suggests(b).executes((Command)new c(){

            @Override
            @Nullable
            @Override
            protected NBTTagCompound a(CommandContext<CommandListenerWrapper> context) {
                return null;
            }
        })).then(net.minecraft.commands.CommandDispatcher.a("arguments", ArgumentNBTTag.a()).executes((Command)new c(){

            @Override
            @Override
            protected NBTTagCompound a(CommandContext<CommandListenerWrapper> context) {
                return ArgumentNBTTag.a(context, "arguments");
            }
        }))).then(literalArgumentBuilder))));
    }

    static NBTTagCompound a(ArgumentNBTKey.g path, CommandDataAccessor object) throws CommandSyntaxException {
        NBTBase tag = CommandData.a(path, object);
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            return compoundTag;
        }
        throw c.create((Object)tag.c().a());
    }

    public static CommandListenerWrapper a(CommandListenerWrapper source) {
        return source.a().b(2);
    }

    public static <T extends ExecutionCommandSource<T>> void a(Collection<net.minecraft.commands.functions.CommandFunction<T>> commandFunctions, @Nullable NBTTagCompound args, T parentSource, T functionSource, ExecutionControl<T> control, b<T> resultConsumer, ChainModifiers flags) throws CommandSyntaxException {
        if (flags.c()) {
            CommandFunction.a(commandFunctions, args, parentSource, functionSource, control, resultConsumer);
        } else {
            CommandFunction.b(commandFunctions, args, parentSource, functionSource, control, resultConsumer);
        }
    }

    private static <T extends ExecutionCommandSource<T>> void a(@Nullable NBTTagCompound args, ExecutionControl<T> control, CommandDispatcher<T> dispatcher, T source, net.minecraft.commands.functions.CommandFunction<T> function, MinecraftKey id, CommandResultCallback returnValueConsumer, boolean propagateReturn) throws CommandSyntaxException {
        try {
            InstantiatedFunction<T> instantiatedFunction = function.a(args, dispatcher);
            control.a(new CallFunction<T>(instantiatedFunction, returnValueConsumer, propagateReturn).bind(source));
        }
        catch (FunctionInstantiationException functionInstantiationException) {
            throw a.create((Object)id, (Object)functionInstantiationException.a());
        }
    }

    private static <T extends ExecutionCommandSource<T>> CommandResultCallback a(T flags, b<T> resultConsumer, MinecraftKey id, CommandResultCallback wrapped) {
        if (flags.x()) {
            return wrapped;
        }
        return (successful, returnValue) -> {
            resultConsumer.a(flags, id, returnValue);
            wrapped.onResult(successful, returnValue);
        };
    }

    private static <T extends ExecutionCommandSource<T>> void a(Collection<net.minecraft.commands.functions.CommandFunction<T>> functions, @Nullable NBTTagCompound args, T parentSource, T functionSource, ExecutionControl<T> control, b<T> resultConsumer) throws CommandSyntaxException {
        CommandDispatcher<T> commandDispatcher = parentSource.w();
        T executionCommandSource = functionSource.a_();
        CommandResultCallback commandResultCallback = CommandResultCallback.chain(parentSource.p(), control.b().d());
        for (net.minecraft.commands.functions.CommandFunction<T> commandFunction : functions) {
            MinecraftKey resourceLocation = commandFunction.a();
            CommandResultCallback commandResultCallback2 = CommandFunction.a(parentSource, resultConsumer, resourceLocation, commandResultCallback);
            CommandFunction.a(args, control, commandDispatcher, executionCommandSource, commandFunction, resourceLocation, commandResultCallback2, true);
        }
        control.a(FallthroughTask.a());
    }

    private static <T extends ExecutionCommandSource<T>> void b(Collection<net.minecraft.commands.functions.CommandFunction<T>> functions, @Nullable NBTTagCompound args, T parentSource, T functionSource, ExecutionControl<T> control, b<T> resultConsumer) throws CommandSyntaxException {
        CommandDispatcher<T> commandDispatcher = parentSource.w();
        T executionCommandSource = functionSource.a_();
        CommandResultCallback commandResultCallback = parentSource.p();
        if (functions.isEmpty()) {
            return;
        }
        if (functions.size() == 1) {
            net.minecraft.commands.functions.CommandFunction<T> commandFunction = functions.iterator().next();
            MinecraftKey resourceLocation = commandFunction.a();
            CommandResultCallback commandResultCallback2 = CommandFunction.a(parentSource, resultConsumer, resourceLocation, commandResultCallback);
            CommandFunction.a(args, control, commandDispatcher, executionCommandSource, commandFunction, resourceLocation, commandResultCallback2, false);
        } else if (commandResultCallback == CommandResultCallback.a) {
            for (net.minecraft.commands.functions.CommandFunction<T> commandFunction2 : functions) {
                MinecraftKey resourceLocation2 = commandFunction2.a();
                CommandResultCallback commandResultCallback3 = CommandFunction.a(parentSource, resultConsumer, resourceLocation2, commandResultCallback);
                CommandFunction.a(args, control, commandDispatcher, executionCommandSource, commandFunction2, resourceLocation2, commandResultCallback3, false);
            }
        } else {
            class A {
                boolean a;
                int b;

                A() {
                }

                public void a(int returnValue) {
                    this.a = true;
                    this.b += returnValue;
                }
            }
            A lv = new A();
            CommandResultCallback commandResultCallback4 = (successful, returnValue) -> lv.a(returnValue);
            for (net.minecraft.commands.functions.CommandFunction<T> commandFunction3 : functions) {
                MinecraftKey resourceLocation3 = commandFunction3.a();
                CommandResultCallback commandResultCallback5 = CommandFunction.a(parentSource, resultConsumer, resourceLocation3, commandResultCallback4);
                CommandFunction.a(args, control, commandDispatcher, executionCommandSource, commandFunction3, resourceLocation3, commandResultCallback5, false);
            }
            control.a((context, frame) -> {
                if (arg.a) {
                    commandResultCallback.onSuccess(arg.b);
                }
            });
        }
    }

    public static interface b<T> {
        public void a(T var1, MinecraftKey var2, int var3);
    }

    static abstract class c
    extends CustomCommandExecutor.b<CommandListenerWrapper>
    implements CustomCommandExecutor.a<CommandListenerWrapper> {
        c() {
        }

        @Nullable
        protected abstract NBTTagCompound a(CommandContext<CommandListenerWrapper> var1) throws CommandSyntaxException;

        @Override
        @Override
        public void a(CommandListenerWrapper commandSourceStack, ContextChain<CommandListenerWrapper> contextChain, ChainModifiers chainModifiers, ExecutionControl<CommandListenerWrapper> executionControl) throws CommandSyntaxException {
            CommandContext commandContext = contextChain.getTopContext().copyFor((Object)commandSourceStack);
            Pair<MinecraftKey, Collection<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>>> pair = ArgumentTag.c((CommandContext<CommandListenerWrapper>)commandContext, "name");
            Collection collection = (Collection)pair.getSecond();
            if (collection.isEmpty()) {
                throw d.create((Object)IChatBaseComponent.a((MinecraftKey)pair.getFirst()));
            }
            NBTTagCompound compoundTag = this.a((CommandContext<CommandListenerWrapper>)commandContext);
            CommandListenerWrapper commandSourceStack2 = CommandFunction.a(commandSourceStack);
            if (collection.size() == 1) {
                commandSourceStack.a(() -> IChatBaseComponent.a("commands.function.scheduled.single", IChatBaseComponent.a(((net.minecraft.commands.functions.CommandFunction)collection.iterator().next()).a())), true);
            } else {
                commandSourceStack.a(() -> IChatBaseComponent.a("commands.function.scheduled.multiple", ChatComponentUtils.b(collection.stream().map(net.minecraft.commands.functions.CommandFunction::a).toList(), IChatBaseComponent::a)), true);
            }
            CommandFunction.a(collection, compoundTag, commandSourceStack, commandSourceStack2, executionControl, e, chainModifiers);
        }

        @Override
        public /* synthetic */ void b(ExecutionCommandSource source, ContextChain contextChain, ChainModifiers flags, ExecutionControl control) throws CommandSyntaxException {
            this.a((CommandListenerWrapper)source, (ContextChain<CommandListenerWrapper>)contextChain, flags, (ExecutionControl<CommandListenerWrapper>)control);
        }
    }
}

