/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.LookAt;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CommandTeleport {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.teleport.invalidPosition"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        LiteralCommandNode<CommandListenerWrapper> literalcommandnode = dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("teleport").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).then(net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).g()), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, null)))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), Collections.singleton(((CommandListenerWrapper)commandcontext.getSource()).g()), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "destination"))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("location", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, null))).then(net.minecraft.commands.CommandDispatcher.a("rotation", ArgumentRotation.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), ArgumentRotation.a((CommandContext<CommandListenerWrapper>)commandcontext, "rotation"), null)))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facing").then(net.minecraft.commands.CommandDispatcher.a("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("facingEntity", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new LookAt.a(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingEntity"), ArgumentAnchor.Anchor.a)))).then(net.minecraft.commands.CommandDispatcher.a("facingAnchor", ArgumentAnchor.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new LookAt.a(ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingEntity"), ArgumentAnchor.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingAnchor")))))))).then(net.minecraft.commands.CommandDispatcher.a("facingLocation", ArgumentVec3.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ((CommandListenerWrapper)commandcontext.getSource()).e(), ArgumentVec3.b((CommandContext<CommandListenerWrapper>)commandcontext, "location"), null, new LookAt.b(ArgumentVec3.a((CommandContext<CommandListenerWrapper>)commandcontext, "facingLocation")))))))).then(net.minecraft.commands.CommandDispatcher.a("destination", ArgumentEntity.a()).executes(commandcontext -> CommandTeleport.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)commandcontext, "destination")))))));
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("tp").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).redirect(literalcommandnode)));
    }

    private static int a(CommandListenerWrapper source, Collection<? extends net.minecraft.world.entity.Entity> targets, net.minecraft.world.entity.Entity destination) throws CommandSyntaxException {
        for (net.minecraft.world.entity.Entity entity : targets) {
            CommandTeleport.a(source, entity, (WorldServer)destination.dW(), destination.dB(), destination.dD(), destination.dH(), EnumSet.noneOf(Relative.class), destination.dM(), destination.dO(), null);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.entity.single", ((net.minecraft.world.entity.Entity)targets.iterator().next()).p_(), destination.p_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.entity.multiple", targets.size(), destination.p_()), true);
        }
        return targets.size();
    }

    private static int a(CommandListenerWrapper source, Collection<? extends net.minecraft.world.entity.Entity> targets, WorldServer world, IVectorPosition location, @Nullable IVectorPosition rotation, @Nullable LookAt facingLocation) throws CommandSyntaxException {
        Vec3D vec3d = location.a(source);
        Vec2F vec2f = rotation == null ? null : rotation.b(source);
        for (net.minecraft.world.entity.Entity entity : targets) {
            Set<Relative> set = CommandTeleport.a(location, rotation, entity.dW().ah() == world.ah());
            if (vec2f == null) {
                CommandTeleport.a(source, entity, world, vec3d.d, vec3d.e, vec3d.f, set, entity.dM(), entity.dO(), facingLocation);
                continue;
            }
            CommandTeleport.a(source, entity, world, vec3d.d, vec3d.e, vec3d.f, set, vec2f.j, vec2f.i, facingLocation);
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.location.single", ((net.minecraft.world.entity.Entity)targets.iterator().next()).p_(), CommandTeleport.a(vec3d.d), CommandTeleport.a(vec3d.e), CommandTeleport.a(vec3d.f)), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.teleport.success.location.multiple", targets.size(), CommandTeleport.a(vec3d.d), CommandTeleport.a(vec3d.e), CommandTeleport.a(vec3d.f)), true);
        }
        return targets.size();
    }

    private static Set<Relative> a(IVectorPosition pos, @Nullable IVectorPosition rotation, boolean sameDimension) {
        EnumSet<Relative> set = EnumSet.noneOf(Relative.class);
        if (pos.a()) {
            set.add(Relative.f);
            if (sameDimension) {
                set.add(Relative.a);
            }
        }
        if (pos.b()) {
            set.add(Relative.g);
            if (sameDimension) {
                set.add(Relative.b);
            }
        }
        if (pos.c()) {
            set.add(Relative.h);
            if (sameDimension) {
                set.add(Relative.c);
            }
        }
        if (rotation == null || rotation.a()) {
            set.add(Relative.e);
        }
        if (rotation == null || rotation.b()) {
            set.add(Relative.d);
        }
        return set;
    }

    private static String a(double d2) {
        return String.format(Locale.ROOT, "%f", d2);
    }

    private static void a(CommandListenerWrapper source, net.minecraft.world.entity.Entity target, WorldServer world, double x2, double y2, double z2, Set<Relative> movementFlags, float yaw, float pitch, @Nullable LookAt facingLocation) throws CommandSyntaxException {
        boolean result;
        BlockPosition blockposition = BlockPosition.a(x2, y2, z2);
        if (!World.l(blockposition)) {
            throw a.create();
        }
        double d3 = movementFlags.contains((Object)Relative.a) ? x2 - target.dB() : x2;
        double d4 = movementFlags.contains((Object)Relative.b) ? y2 - target.dD() : y2;
        double d5 = movementFlags.contains((Object)Relative.c) ? z2 - target.dH() : z2;
        float f2 = movementFlags.contains((Object)Relative.d) ? yaw - target.dM() : yaw;
        float f3 = movementFlags.contains((Object)Relative.e) ? pitch - target.dO() : pitch;
        float f4 = MathHelper.h(f2);
        float f5 = MathHelper.h(f3);
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            result = player.teleportTo(world, d3, d4, d5, movementFlags, f4, f5, true, PlayerTeleportEvent.TeleportCause.COMMAND);
        } else {
            Location to = new Location((org.bukkit.World)world.getWorld(), d3, d4, d5, f4, f5);
            EntityTeleportEvent event = new EntityTeleportEvent((Entity)target.getBukkitEntity(), target.getBukkitEntity().getLocation(), to);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getTo() == null) {
                return;
            }
            to = event.getTo();
            d3 = to.getX();
            d4 = to.getY();
            d5 = to.getZ();
            f4 = to.getYaw();
            f5 = to.getPitch();
            world = ((CraftWorld)to.getWorld()).getHandle();
            result = target.a(world, d3, d4, d5, movementFlags, f4, f5, true);
        }
        if (result) {
            EntityLiving entityliving;
            if (facingLocation != null) {
                facingLocation.perform(source, target);
            }
            if (!(target instanceof EntityLiving) || !(entityliving = (EntityLiving)target).fJ()) {
                target.h(target.dz().d(1.0, 0.0, 1.0));
                target.d(true);
            }
            if (target instanceof EntityCreature) {
                EntityCreature entitycreature = (EntityCreature)target;
                entitycreature.L().o();
            }
        }
    }
}

