/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.Vec3D;

public class RaidCommand {
    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("raid").requires(source -> source.c(3))).then(net.minecraft.commands.CommandDispatcher.a("start").then(net.minecraft.commands.CommandDispatcher.a("omenlvl", IntegerArgumentType.integer((int)0)).executes(context -> RaidCommand.b((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"omenlvl")))))).then(net.minecraft.commands.CommandDispatcher.a("stop").executes(context -> RaidCommand.c((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("check").executes(context -> RaidCommand.d((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("sound").then(net.minecraft.commands.CommandDispatcher.a("type", ArgumentChatComponent.a(registryAccess)).executes(context -> RaidCommand.a((CommandListenerWrapper)context.getSource(), ArgumentChatComponent.a((CommandContext<CommandListenerWrapper>)context, "type")))))).then(net.minecraft.commands.CommandDispatcher.a("spawnleader").executes(context -> RaidCommand.b((CommandListenerWrapper)context.getSource())))).then(net.minecraft.commands.CommandDispatcher.a("setomen").then(net.minecraft.commands.CommandDispatcher.a("level", IntegerArgumentType.integer((int)0)).executes(context -> RaidCommand.a((CommandListenerWrapper)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"level")))))).then(net.minecraft.commands.CommandDispatcher.a("glow").executes(context -> RaidCommand.a((CommandListenerWrapper)context.getSource())))));
    }

    private static int a(CommandListenerWrapper source) throws CommandSyntaxException {
        Raid raid = RaidCommand.a(source.h());
        if (raid != null) {
            Set<EntityRaider> set = raid.h();
            for (EntityRaider raider : set) {
                raider.a(new MobEffect(MobEffects.x, 1000, 1));
            }
        }
        return 1;
    }

    private static int a(CommandListenerWrapper source, int level) throws CommandSyntaxException {
        Raid raid = RaidCommand.a(source.h());
        if (raid != null) {
            int i2 = raid.l();
            if (level > i2) {
                source.b(IChatBaseComponent.b("Sorry, the max raid omen level you can set is " + i2));
            } else {
                int j2 = raid.m();
                raid.a(level);
                source.a(() -> IChatBaseComponent.b("Changed village's raid omen level from " + j2 + " to " + level), false);
            }
        } else {
            source.b(IChatBaseComponent.b("No raid found here"));
        }
        return 1;
    }

    private static int b(CommandListenerWrapper source) {
        source.a(() -> IChatBaseComponent.b("Spawned a raid captain"), false);
        EntityRaider raider = EntityTypes.aU.a(source.e(), EntitySpawnReason.n);
        if (raider == null) {
            source.b(IChatBaseComponent.b("Pillager failed to spawn"));
            return 0;
        }
        raider.x(true);
        raider.a(EnumItemSlot.f, Raid.a(source.u().e(Registries.d)));
        raider.a_(source.d().d, source.d().e, source.d().f);
        raider.a((WorldAccess)source.e(), source.e().d_(BlockPosition.a(source.d())), EntitySpawnReason.n, null);
        source.e().a_(raider);
        return 1;
    }

    private static int a(CommandListenerWrapper source, @Nullable IChatBaseComponent type) {
        if (type != null && type.getString().equals("local")) {
            WorldServer serverLevel = source.e();
            Vec3D vec3 = source.d().b(5.0, 0.0, 0.0);
            serverLevel.a(null, vec3.d, vec3.e, vec3.f, SoundEffects.vw, SoundCategory.g, 2.0f, 1.0f, serverLevel.A.g());
        }
        return 1;
    }

    private static int b(CommandListenerWrapper source, int level) throws CommandSyntaxException {
        EntityPlayer serverPlayer = source.h();
        BlockPosition blockPos = serverPlayer.dw();
        if (serverPlayer.y().e(blockPos)) {
            source.b(IChatBaseComponent.b("Raid already started close by"));
            return -1;
        }
        PersistentRaid raids = serverPlayer.y().A();
        Raid raid = raids.a(serverPlayer, serverPlayer.dw());
        if (raid != null) {
            raid.a(level);
            raids.c();
            source.a(() -> IChatBaseComponent.b("Created a raid in your local village"), false);
        } else {
            source.b(IChatBaseComponent.b("Failed to create a raid in your local village"));
        }
        return 1;
    }

    private static int c(CommandListenerWrapper source) throws CommandSyntaxException {
        EntityPlayer serverPlayer = source.h();
        BlockPosition blockPos = serverPlayer.dw();
        Raid raid = serverPlayer.y().d(blockPos);
        if (raid != null) {
            raid.n();
            source.a(() -> IChatBaseComponent.b("Stopped raid"), false);
            return 1;
        }
        source.b(IChatBaseComponent.b("No raid here"));
        return -1;
    }

    private static int d(CommandListenerWrapper source) throws CommandSyntaxException {
        Raid raid = RaidCommand.a(source.h());
        if (raid != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Found a started raid! ");
            source.a(() -> IChatBaseComponent.b(stringBuilder.toString()), false);
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append("Num groups spawned: ");
            stringBuilder2.append(raid.k());
            stringBuilder2.append(" Raid omen level: ");
            stringBuilder2.append(raid.m());
            stringBuilder2.append(" Num mobs: ");
            stringBuilder2.append(raid.r());
            stringBuilder2.append(" Raid health: ");
            stringBuilder2.append(raid.q());
            stringBuilder2.append(" / ");
            stringBuilder2.append(raid.g());
            source.a(() -> IChatBaseComponent.b(stringBuilder2.toString()), false);
            return 1;
        }
        source.b(IChatBaseComponent.b("Found no started raids"));
        return 0;
    }

    @Nullable
    private static Raid a(EntityPlayer player) {
        return player.y().d(player.dw());
    }
}

