/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.World;

public class SpawnArmorTrimsCommand {
    private static final List<ResourceKey<TrimPattern>> a = List.of(TrimPatterns.a, TrimPatterns.b, TrimPatterns.c, TrimPatterns.d, TrimPatterns.e, TrimPatterns.f, TrimPatterns.g, TrimPatterns.h, TrimPatterns.i, TrimPatterns.j, TrimPatterns.k, TrimPatterns.l, TrimPatterns.m, TrimPatterns.n, TrimPatterns.o, TrimPatterns.p, TrimPatterns.q, TrimPatterns.r);
    private static final List<ResourceKey<TrimMaterial>> b = List.of(TrimMaterials.a, TrimMaterials.b, TrimMaterials.c, TrimMaterials.d, TrimMaterials.e, TrimMaterials.f, TrimMaterials.g, TrimMaterials.h, TrimMaterials.i, TrimMaterials.j);
    private static final ToIntFunction<ResourceKey<TrimPattern>> c = SystemUtils.g(a);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> d = SystemUtils.g(b);

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("spawn_armor_trims").requires(source -> source.c(2))).executes(context -> SpawnArmorTrimsCommand.a((CommandListenerWrapper)context.getSource(), ((CommandListenerWrapper)context.getSource()).h()))));
    }

    private static int a(CommandListenerWrapper source, EntityHuman player) {
        World level = player.dW();
        NonNullList<ArmorTrim> nonNullList = NonNullList.a();
        IRegistry<TrimPattern> registry = level.K_().e(Registries.ba);
        IRegistry<TrimMaterial> registry2 = level.K_().e(Registries.aZ);
        HolderLookup<Item> holderLookup = level.a(Registries.K);
        Map<MinecraftKey, List<Item>> map = holderLookup.c().map(Holder.c::a).filter(item -> {
            Equippable equippable = item.g().a(DataComponents.D);
            return equippable != null && equippable.a().a() == EnumItemSlot.Function.b && equippable.c().isPresent();
        }).collect(Collectors.groupingBy(item -> item.g().a(DataComponents.D).c().get()));
        registry.s().sorted(Comparator.comparing(pattern -> c.applyAsInt(registry.d((TrimPattern)pattern).orElse(null)))).forEachOrdered(pattern -> registry2.s().sorted(Comparator.comparing(material -> d.applyAsInt(registry2.d((TrimMaterial)material).orElse(null)))).forEachOrdered(material -> nonNullList.add(new ArmorTrim(registry2.e((TrimMaterial)material), registry.e((TrimPattern)pattern)))));
        BlockPosition blockPos = player.dw().a(player.cO(), 5);
        int i2 = map.size() - 1;
        double d2 = 3.0;
        int j2 = 0;
        int k2 = 0;
        for (ArmorTrim armorTrim : nonNullList) {
            for (List<Item> list : map.values()) {
                double e2 = (double)blockPos.u() + 0.5 - (double)(j2 % registry2.d()) * 3.0;
                double f2 = (double)blockPos.v() + 0.5 + (double)(k2 % i2) * 3.0;
                double g2 = (double)blockPos.w() + 0.5 + (double)(j2 / registry2.d() * 10);
                EntityArmorStand armorStand = new EntityArmorStand(level, e2, f2, g2);
                armorStand.v(180.0f);
                armorStand.f(true);
                for (Item item2 : list) {
                    Equippable equippable = Objects.requireNonNull(item2.g().a(DataComponents.D));
                    ItemStack itemStack = new ItemStack(item2);
                    itemStack.b(DataComponents.U, armorTrim);
                    armorStand.a(equippable.a(), itemStack);
                    if (itemStack.a(Items.oK)) {
                        armorStand.b(armorTrim.b().a().a(armorTrim.a()).f().f(" ").b(armorTrim.a().a().e()));
                        armorStand.p(true);
                        continue;
                    }
                    armorStand.k(true);
                }
                level.b(armorStand);
                ++k2;
            }
            ++j2;
        }
        source.a(() -> IChatBaseComponent.b("Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }
}

