/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.Zone;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkDependencies;
import net.minecraft.world.level.chunk.status.ChunkPyramid;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public class ChunkGenerationTask {
    private final GeneratingChunkMap b;
    private final ChunkCoordIntPair c;
    @Nullable
    private ChunkStatus d = null;
    public final ChunkStatus a;
    private volatile boolean e;
    private final List<CompletableFuture<ChunkResult<IChunkAccess>>> f = new ArrayList<CompletableFuture<ChunkResult<IChunkAccess>>>();
    private final StaticCache2D<GenerationChunkHolder> g;
    private boolean h;

    private ChunkGenerationTask(GeneratingChunkMap chunkLoadingManager, ChunkStatus targetStatus, ChunkCoordIntPair pos, StaticCache2D<GenerationChunkHolder> chunks) {
        this.b = chunkLoadingManager;
        this.a = targetStatus;
        this.c = pos;
        this.g = chunks;
    }

    public static ChunkGenerationTask a(GeneratingChunkMap chunkLoadingManager, ChunkStatus targetStatus, ChunkCoordIntPair pos) {
        int i2 = ChunkPyramid.a.a(targetStatus).a(ChunkStatus.c);
        StaticCache2D<GenerationChunkHolder> staticCache2D = StaticCache2D.a(pos.h, pos.i, i2, (x2, z2) -> chunkLoadingManager.d(ChunkCoordIntPair.c(x2, z2)));
        return new ChunkGenerationTask(chunkLoadingManager, targetStatus, pos, staticCache2D);
    }

    @Nullable
    public CompletableFuture<?> a() {
        CompletableFuture<?> completableFuture;
        while ((completableFuture = this.g()) == null) {
            if (this.e || this.d == this.a) {
                this.e();
                return null;
            }
            this.d();
        }
        return completableFuture;
    }

    private void d() {
        ChunkStatus chunkStatus3;
        if (this.d == null) {
            ChunkStatus chunkStatus = ChunkStatus.c;
        } else if (!this.h && this.d == ChunkStatus.c && !this.f()) {
            this.h = true;
            ChunkStatus chunkStatus2 = ChunkStatus.c;
        } else {
            chunkStatus3 = ChunkStatus.a().get(this.d.b() + 1);
        }
        this.a(chunkStatus3, this.h);
        this.d = chunkStatus3;
    }

    public void b() {
        this.e = true;
    }

    private void e() {
        GenerationChunkHolder generationChunkHolder = this.g.a(this.c.h, this.c.i);
        generationChunkHolder.a(this);
        this.g.a(this.b::a);
    }

    private boolean f() {
        if (this.a == ChunkStatus.c) {
            return true;
        }
        ChunkStatus chunkStatus = this.g.a(this.c.h, this.c.i).q();
        if (chunkStatus == null || chunkStatus.d(this.a)) {
            return false;
        }
        ChunkDependencies chunkDependencies = ChunkPyramid.b.a(this.a).c();
        int i2 = chunkDependencies.c();
        for (int j2 = this.c.h - i2; j2 <= this.c.h + i2; ++j2) {
            for (int k2 = this.c.i - i2; k2 <= this.c.i + i2; ++k2) {
                int l2 = this.c.e(j2, k2);
                ChunkStatus chunkStatus2 = chunkDependencies.a(l2);
                ChunkStatus chunkStatus3 = this.g.a(j2, k2).q();
                if (chunkStatus3 != null && !chunkStatus3.d(chunkStatus2)) continue;
                return false;
            }
        }
        return true;
    }

    public GenerationChunkHolder c() {
        return this.g.a(this.c.h, this.c.i);
    }

    private void a(ChunkStatus targetStatus, boolean allowGeneration) {
        try (Zone zone = Profiler.a().d("scheduleLayer");){
            zone.a(targetStatus::f);
            int i2 = this.b(targetStatus, allowGeneration);
            for (int j2 = this.c.h - i2; j2 <= this.c.h + i2; ++j2) {
                for (int k2 = this.c.i - i2; k2 <= this.c.i + i2; ++k2) {
                    GenerationChunkHolder generationChunkHolder = this.g.a(j2, k2);
                    if (!this.e && this.a(targetStatus, allowGeneration, generationChunkHolder)) continue;
                    return;
                }
            }
        }
    }

    private int b(ChunkStatus status, boolean generate) {
        ChunkPyramid chunkPyramid = generate ? ChunkPyramid.a : ChunkPyramid.b;
        return chunkPyramid.a(this.a).a(status);
    }

    private boolean a(ChunkStatus targetStatus, boolean allowGeneration, GenerationChunkHolder chunkHolder) {
        ChunkPyramid chunkPyramid;
        ChunkStatus chunkStatus = chunkHolder.q();
        boolean bl = chunkStatus != null && targetStatus.b(chunkStatus);
        ChunkPyramid chunkPyramid2 = chunkPyramid = bl ? ChunkPyramid.a : ChunkPyramid.b;
        if (bl && !allowGeneration) {
            throw new IllegalStateException("Can't load chunk, but didn't expect to need to generate");
        }
        CompletableFuture<ChunkResult<IChunkAccess>> completableFuture = chunkHolder.a(chunkPyramid.a(targetStatus), this.b, this.g);
        ChunkResult chunkResult = completableFuture.getNow(null);
        if (chunkResult == null) {
            this.f.add(completableFuture);
            return true;
        }
        if (chunkResult.a()) {
            return true;
        }
        this.b();
        return false;
    }

    @Nullable
    private CompletableFuture<?> g() {
        while (!this.f.isEmpty()) {
            CompletableFuture<ChunkResult<IChunkAccess>> completableFuture = this.f.getLast();
            ChunkResult chunkResult = completableFuture.getNow(null);
            if (chunkResult == null) {
                return completableFuture;
            }
            this.f.removeLast();
            if (chunkResult.a()) continue;
            this.b();
        }
        return null;
    }
}

