/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.player.ChunkSystemServerPlayer;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.event.player.PlayerClientOptionsChangeEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerTeleportEndGatewayEvent;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import io.papermc.paper.util.MCUtil;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.translation.Translator;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerRotationPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetCursorItemPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ParticleStatus;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.Input;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockEndGateway;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityEndGateway;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.EndGateway;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R2.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftEndGateway;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftDimensionUtil;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedMainHandEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerLocaleChangeEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSpawnChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.MainHand;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EntityPlayer
extends EntityHuman
implements ChunkSystemServerPlayer {
    private static final Logger cz = LogUtils.getLogger();
    public long lastSave = MinecraftServer.currentTick;
    private static final int cC = 32;
    private static final int cD = 10;
    private static final int cE = 25;
    public static final double a = 1.0;
    public static final double b = 3.0;
    public static final int c = 2;
    public static final String d = "ender_pearls";
    public static final String e = "ender_pearl_dimension";
    private static final AttributeModifier cF = new AttributeModifier(MinecraftKey.b("creative_mode_block_range"), 0.5, AttributeModifier.Operation.a);
    private static final AttributeModifier cG = new AttributeModifier(MinecraftKey.b("creative_mode_entity_range"), 2.0, AttributeModifier.Operation.a);
    public PlayerConnection f;
    public final MinecraftServer g;
    public final PlayerInteractManager h;
    private final AdvancementDataPlayer cH;
    private final ServerStatisticManager cI;
    private float cJ = Float.MIN_VALUE;
    private int cK = Integer.MIN_VALUE;
    private int cL = Integer.MIN_VALUE;
    private int cM = Integer.MIN_VALUE;
    private int cN = Integer.MIN_VALUE;
    private int cO = Integer.MIN_VALUE;
    private float cP = -1.0E8f;
    private int cQ = -99999999;
    private boolean cR = true;
    public int cS = -99999999;
    public int cT = 60;
    private EnumChatVisibility cU;
    public ParticleStatus cV;
    private boolean cW = true;
    private long cX;
    @Nullable
    private net.minecraft.world.entity.Entity cY;
    public boolean cZ;
    public boolean i;
    private final RecipeBookServer da;
    @Nullable
    private Vec3D db;
    private int dc;
    private boolean dd;
    private int de = 2;
    public String df = null;
    public Locale adventure$locale = Locale.US;
    @Nullable
    private Vec3D dg;
    @Nullable
    private Vec3D dh;
    @Nullable
    private Vec3D di;
    private SectionPosition dj;
    private ChunkTrackingView dk;
    private ResourceKey<net.minecraft.world.level.World> dl;
    @Nullable
    private BlockPosition dm;
    private boolean dn;
    private float do;
    private final ITextFilter dp;
    private boolean dq;
    private boolean dr;
    private boolean ds;
    public WardenSpawnTracker dt;
    @Nullable
    private BlockPosition du;
    private Vec3D dv;
    private Input dw;
    private final Set<EntityEnderPearl> dx;
    public final ContainerSynchronizer dy;
    private final ICrafting dz;
    @Nullable
    private RemoteChatSession dA;
    @Nullable
    public final Object j;
    private final ICommandListener dB;
    private int dC;
    public boolean k;
    private int containerUpdateDelay;
    public long loginTime;
    public int patrolSpawnDelay;
    public boolean queueHealthUpdatePacket;
    public PacketPlayOutUpdateHealth queuedHealthUpdatePacket;
    public static final int MOBCATEGORY_TOTAL_ENUMS = EnumCreatureType.values().length;
    public final int[] mobCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public final int[] mobBackoffCounts = new int[MOBCATEGORY_TOTAL_ENUMS];
    public CraftPlayer.TransferCookieConnection transferCookieConnection;
    public String displayName;
    public Component adventure$displayName;
    public IChatBaseComponent listName;
    public int listOrder = 0;
    public Location compassTarget;
    public int newExp = 0;
    public int newLevel = 0;
    public int newTotalExp = 0;
    public boolean keepLevel = false;
    public double maxHealthCache;
    public boolean joining = true;
    public boolean sentListPacket = false;
    public boolean supressTrackerForLogin = false;
    public boolean isRealPlayer;
    public PlayerNaturallySpawnCreaturesEvent playerNaturallySpawnedEvent;
    @Nullable
    public String clientBrandName = null;
    public PlayerQuitEvent.QuitReason quitReason = null;
    private RegionizedPlayerChunkLoader.PlayerChunkLoaderData chunkLoader;
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    public long timeOffset = 0L;
    public boolean relativeTime = true;
    public WeatherType weather = null;
    private float pluginRainPosition;
    private float pluginRainPositionPrevious;

    @Override
    public final boolean moonrise$isRealPlayer() {
        return this.isRealPlayer;
    }

    @Override
    public final void moonrise$setRealPlayer(boolean real) {
        this.isRealPlayer = real;
    }

    @Override
    public final RegionizedPlayerChunkLoader.PlayerChunkLoaderData moonrise$getChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$setChunkLoader(RegionizedPlayerChunkLoader.PlayerChunkLoaderData loader) {
        this.chunkLoader = loader;
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    public EntityPlayer(MinecraftServer server, WorldServer world, GameProfile profile, ClientInformation clientOptions) {
        super(world, world.Y(), world.Z(), profile);
        this.cU = EnumChatVisibility.a;
        this.cV = ParticleStatus.a;
        this.cX = SystemUtils.c();
        this.dj = SectionPosition.a(0, 0, 0);
        this.dk = ChunkTrackingView.a;
        this.dl = net.minecraft.world.level.World.i;
        this.dt = new WardenSpawnTracker(0, 0, 0);
        this.dv = Vec3D.c;
        this.dw = Input.b;
        this.dx = new HashSet<EntityEnderPearl>();
        this.dy = new ContainerSynchronizer(){

            @Override
            public void a(Container handler, NonNullList<ItemStack> stacks, ItemStack cursorStack, int[] properties) {
                EntityPlayer.this.f.b(new PacketPlayOutWindowItems(handler.l, handler.k(), stacks, cursorStack));
                for (int i2 = 0; i2 < properties.length; ++i2) {
                    this.b(handler, i2, properties[i2]);
                }
            }

            @Override
            public void sendOffHandSlotChange() {
                EntityPlayer.this.f.b(new PacketPlayOutSetSlot(EntityPlayer.this.cc.l, EntityPlayer.this.cc.k(), 45, EntityPlayer.this.cc.b(45).g().v()));
            }

            @Override
            public void a(Container handler, int slot, ItemStack stack) {
                EntityPlayer.this.f.b(new PacketPlayOutSetSlot(handler.l, handler.k(), slot, stack));
            }

            @Override
            public void a(Container handler, ItemStack stack) {
                EntityPlayer.this.f.b(new ClientboundSetCursorItemPacket(stack.v()));
            }

            @Override
            public void a(Container handler, int property, int value) {
                this.b(handler, property, value);
            }

            private void b(Container handler, int property, int value) {
                EntityPlayer.this.f.b(new PacketPlayOutWindowData(handler.l, property, value));
            }
        };
        this.dz = new ICrafting(){

            @Override
            public void a(Container handler, int slotId, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gi()) {
                    CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gi(), stack);
                }
            }

            @Override
            public void slotChanged(Container handler, int slotId, ItemStack oldStack, ItemStack stack) {
                Slot slot = handler.b(slotId);
                if (!(slot instanceof SlotResult) && slot.c == EntityPlayer.this.gi()) {
                    if (PlayerInventorySlotChangeEvent.getHandlerList().getRegisteredListeners().length == 0) {
                        CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gi(), stack);
                        return;
                    }
                    PlayerInventorySlotChangeEvent event = new PlayerInventorySlotChangeEvent((Player)EntityPlayer.this.getBukkitEntity(), slotId, CraftItemStack.asBukkitCopy(oldStack), CraftItemStack.asBukkitCopy(stack));
                    event.callEvent();
                    if (event.shouldTriggerAdvancements()) {
                        CriterionTriggers.f.a(EntityPlayer.this, EntityPlayer.this.gi(), stack);
                    }
                }
            }

            @Override
            public void a(Container handler, int property, int value) {
            }
        };
        this.dB = new ICommandListener(){

            @Override
            public boolean y_() {
                return EntityPlayer.this.y().N().b(GameRules.p);
            }

            @Override
            public boolean z_() {
                return true;
            }

            @Override
            public boolean c() {
                return true;
            }

            @Override
            public void a(IChatBaseComponent message) {
                EntityPlayer.this.a(message);
            }

            @Override
            public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
                return EntityPlayer.this.getBukkitEntity();
            }
        };
        this.dp = server.a(this);
        this.h = server.b(this);
        this.da = new RecipeBookServer((resourcekey, consumer) -> server.aI().a(resourcekey, consumer));
        this.g = server;
        this.cI = server.ag().getPlayerStats(this);
        this.cH = server.ag().g(this);
        this.updateOptionsNoEvents(clientOptions);
        this.j = null;
        this.displayName = this.cI();
        this.adventure$displayName = Component.text((String)this.cI());
        this.bukkitPickUpLoot = true;
        this.maxHealthCache = this.eS();
    }

    @Deprecated
    public void resendItemInHands() {
        this.cd.b(this.gi(), this.gi().j).ifPresent(s2 -> this.dy.a(this.cd, s2, this.eZ()));
        this.dy.a((Container)this.cc, 45, this.fa());
    }

    public final BlockPosition getSpawnPoint(WorldServer worldserver) {
        BlockPosition blockposition = worldserver.Y();
        if (worldserver.G_().g() && worldserver.L.k() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.g.a(worldserver));
            int j2 = MathHelper.a(worldserver.F_().b(blockposition.u(), blockposition.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.t(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                BlockPosition blockposition1 = WorldProviderNormal.a(worldserver, blockposition.u() + j22 - i2, blockposition.w() + k22 - i2);
                if (blockposition1 == null) continue;
                return blockposition1;
            }
        }
        return blockposition;
    }

    @Override
    public BlockPosition a(WorldServer world, BlockPosition basePos) {
        AxisAlignedBB axisalignedbb = this.a(EntityPose.a).a(Vec3D.c);
        BlockPosition blockposition1 = basePos;
        if (world.G_().g() && world.L.k() != EnumGamemode.c) {
            long k2;
            long l2;
            int i2 = Math.max(0, this.g.a(world));
            int j2 = MathHelper.a(world.F_().b(basePos.u(), basePos.w()));
            if (j2 < i2) {
                i2 = j2;
            }
            if (j2 <= 1) {
                i2 = 1;
            }
            int i1 = (l2 = (k2 = (long)(i2 * 2 + 1)) * k2) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            int j1 = this.t(i1);
            int k1 = RandomSource.a().a(i1);
            for (int l1 = 0; l1 < i1; ++l1) {
                int i22 = (k1 + j1 * l1) % i1;
                int j22 = i22 % (i2 * 2 + 1);
                int k22 = i22 / (i2 * 2 + 1);
                int l22 = basePos.u() + j22 - i2;
                int i3 = basePos.w() + k22 - i2;
                try {
                    blockposition1 = WorldProviderNormal.a(world, l22, i3);
                    if (blockposition1 == null || !this.a(world, axisalignedbb.c(blockposition1.c()))) continue;
                    return blockposition1;
                }
                catch (Exception exception) {
                    CrashReport crashreport = CrashReport.a(exception, "Searching for spawn");
                    CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Spawn Lookup");
                    Objects.requireNonNull(basePos);
                    crashreportsystemdetails.a("Origin", basePos::toString);
                    int finalI = i2;
                    crashreportsystemdetails.a("Radius", () -> Integer.toString(finalI));
                    crashreportsystemdetails.a("Candidate", () -> "[" + l22 + "," + i3 + "]");
                    int finalL1 = l1;
                    crashreportsystemdetails.a("Progress", () -> finalL1 + " out of " + i1);
                    throw new ReportedException(crashreport);
                }
            }
            blockposition1 = basePos;
        }
        while (!this.a(world, axisalignedbb.c(blockposition1.c())) && blockposition1.v() < world.am()) {
            blockposition1 = blockposition1.d();
        }
        while (this.a(world, axisalignedbb.c(blockposition1.e().c())) && blockposition1.v() > world.L_() + 1) {
            blockposition1 = blockposition1.e();
        }
        return blockposition1;
    }

    private boolean a(WorldServer world, AxisAlignedBB box) {
        return world.a((net.minecraft.world.entity.Entity)this, box, true);
    }

    private int t(int horizontalSpawnArea) {
        return horizontalSpawnArea <= 16 ? horizontalSpawnArea - 1 : 17;
    }

    @Override
    public void a(NBTTagCompound nbt) {
        String spawnWorld;
        CraftWorld oldWorld;
        Logger logger;
        DataResult dataresult;
        super.a(nbt);
        if (nbt.b("warden_spawn_tracker", 10)) {
            dataresult = WardenSpawnTracker.a.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("warden_spawn_tracker")));
            logger = cz;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(wardenspawntracker -> {
                this.dt = wardenspawntracker;
            });
        }
        if (nbt.b("enteredNetherPosition", 10)) {
            NBTTagCompound nbttagcompound1 = nbt.p("enteredNetherPosition");
            this.dh = new Vec3D(nbttagcompound1.k("x"), nbttagcompound1.k("y"), nbttagcompound1.k("z"));
        }
        this.i = nbt.q("seenCredits");
        if (nbt.b("recipeBook", 10)) {
            this.da.a(nbt.p("recipeBook"), (ResourceKey<IRecipe<?>> resourcekey) -> this.g.aI().b((ResourceKey<IRecipe<?>>)resourcekey).isPresent());
        }
        this.getBukkitEntity().readExtraData(nbt);
        if (this.fR()) {
            this.fS();
        }
        if ((oldWorld = (CraftWorld)Bukkit.getWorld((String)(spawnWorld = nbt.l("SpawnWorld")))) != null) {
            this.dl = oldWorld.getHandle().ah();
        }
        if (nbt.b("SpawnX", 99) && nbt.b("SpawnY", 99) && nbt.b("SpawnZ", 99)) {
            this.dm = new BlockPosition(nbt.h("SpawnX"), nbt.h("SpawnY"), nbt.h("SpawnZ"));
            this.dn = nbt.q("SpawnForced");
            this.do = nbt.j("SpawnAngle");
            if (nbt.e("SpawnDimension")) {
                DataResult dataresult1 = net.minecraft.world.level.World.h.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c("SpawnDimension"));
                Logger logger1 = cz;
                Objects.requireNonNull(logger1);
                this.dl = dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).orElse(net.minecraft.world.level.World.i);
            }
        }
        this.ds = nbt.q("spawn_extra_particles_on_fall");
        NBTBase nbtbase = nbt.c("raid_omen_position");
        if (nbtbase != null) {
            dataresult = BlockPosition.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbtbase);
            logger = cz;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(blockposition -> {
                this.du = blockposition;
            });
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = WardenSpawnTracker.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.dt);
        Logger logger = cz;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("warden_spawn_tracker", (NBTBase)nbtbase));
        this.m(nbt);
        nbt.a("seenCredits", this.i);
        if (this.dh != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.a("x", this.dh.d);
            nbttagcompound1.a("y", this.dh.e);
            nbttagcompound1.a("z", this.dh.f);
            nbt.a("enteredNetherPosition", nbttagcompound1);
        }
        this.k(nbt);
        nbt.a("recipeBook", this.da.b());
        nbt.a("Dimension", this.dW().ah().a().toString());
        if (this.dm != null) {
            nbt.a("SpawnX", this.dm.u());
            nbt.a("SpawnY", this.dm.v());
            nbt.a("SpawnZ", this.dm.w());
            nbt.a("SpawnForced", this.dn);
            nbt.a("SpawnAngle", this.do);
            dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.dl.a());
            logger = cz;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("SpawnDimension", (NBTBase)nbtbase));
        }
        this.getBukkitEntity().setExtraData(nbt);
        nbt.a("spawn_extra_particles_on_fall", this.ds);
        if (this.du != null) {
            dataresult = BlockPosition.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.du);
            logger = cz;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("raid_omen_position", (NBTBase)nbtbase));
        }
        this.l(nbt);
    }

    private void k(NBTTagCompound nbt) {
        net.minecraft.world.entity.Entity entity = this.dg();
        net.minecraft.world.entity.Entity entity1 = this.dl();
        boolean persistVehicle = true;
        if (entity1 != null) {
            for (net.minecraft.world.entity.Entity vehicle = entity1; vehicle != null; vehicle = vehicle.dl()) {
                if (vehicle.persist) continue;
                persistVehicle = false;
                break;
            }
        }
        if (persistVehicle && entity1 != null && entity != this && entity.df() && !entity.dR()) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            entity.e(nbttagcompound2);
            nbttagcompound1.a("Attach", entity1.cG());
            nbttagcompound1.a("Entity", nbttagcompound2);
            nbt.a("RootVehicle", nbttagcompound1);
        }
    }

    public void a(Optional<NBTTagCompound> nbt) {
        net.minecraft.world.level.World world;
        if (nbt.isPresent() && nbt.get().b("RootVehicle", 10) && (world = this.dW()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            NBTTagCompound nbttagcompound = nbt.get().p("RootVehicle");
            net.minecraft.world.entity.Entity entity = EntityTypes.a(nbttagcompound.p("Entity"), (net.minecraft.world.level.World)worldserver, EntitySpawnReason.r, entity1 -> !worldserver.addWithUUID((net.minecraft.world.entity.Entity)entity1, CreatureSpawnEvent.SpawnReason.MOUNT) ? null : entity1);
            if (entity == null) {
                return;
            }
            UUID uuid = nbttagcompound.b("Attach") ? nbttagcompound.a("Attach") : null;
            if (entity.cG().equals(uuid)) {
                this.a(entity, true);
            } else {
                for (net.minecraft.world.entity.Entity entity12 : entity.dd()) {
                    if (!entity12.cG().equals(uuid)) continue;
                    this.a(entity12, true);
                    break;
                }
            }
            if (!this.bZ()) {
                cz.warn("Couldn't reattach entity to player");
                entity.discard(null);
                for (net.minecraft.world.entity.Entity entity12 : entity.dd()) {
                    entity12.discard(null);
                }
            }
        }
    }

    private void l(NBTTagCompound nbt) {
        if (!this.dx.isEmpty()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (EntityEnderPearl entityenderpearl : this.dx) {
                if (entityenderpearl.dW().paperConfig().misc.legacyEnderPearlBehavior) continue;
                if (entityenderpearl.dR()) {
                    cz.warn("Trying to save removed ender pearl, skipping");
                    continue;
                }
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                entityenderpearl.e(nbttagcompound1);
                DataResult dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)entityenderpearl.dW().ah().a());
                Logger logger = cz;
                Objects.requireNonNull(logger);
                dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound1.a(e, (NBTBase)nbtbase));
                nbttaglist.add(nbttagcompound1);
            }
            nbt.a(d, nbttaglist);
        }
    }

    public void b(Optional<NBTTagCompound> nbt) {
        NBTBase nbtbase;
        if (nbt.isPresent() && nbt.get().b(d, 9) && (nbtbase = nbt.get().c(d)) instanceof NBTTagList) {
            NBTTagList nbttaglist = (NBTTagList)nbtbase;
            nbttaglist.forEach(nbtbase1 -> {
                NBTTagCompound nbttagcompound;
                if (nbtbase1 instanceof NBTTagCompound && (nbttagcompound = (NBTTagCompound)nbtbase1).e(e)) {
                    DataResult dataresult = net.minecraft.world.level.World.h.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c(e));
                    Logger logger = cz;
                    Objects.requireNonNull(logger);
                    Optional optional1 = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
                    if (optional1.isEmpty()) {
                        cz.warn("No dimension defined for ender pearl, skipping");
                        return;
                    }
                    WorldServer worldserver = this.dW().p().a((ResourceKey)optional1.get());
                    if (worldserver != null) {
                        net.minecraft.world.entity.Entity entity = EntityTypes.a(nbttagcompound, (net.minecraft.world.level.World)worldserver, EntitySpawnReason.r, entity1 -> !worldserver.c((net.minecraft.world.entity.Entity)entity1) ? null : entity1);
                        if (entity != null) {
                            EntityPlayer.a(worldserver, entity.dy());
                        } else {
                            cz.warn("Failed to spawn player ender pearl in level ({}), skipping", optional1.get());
                        }
                    } else {
                        cz.warn("Trying to load ender pearl without level ({}) being loaded, skipping", optional1.get());
                    }
                }
            });
        }
    }

    public void spawnIn(net.minecraft.world.level.World world) {
        this.a(world);
        if (world == null) {
            this.dT();
            Vec3D position = null;
            if (this.dl != null && (world = this.g.a(this.dl)) != null && this.T() != null) {
                position = EntityPlayer.a((WorldServer)world, this.T(), this.U(), false, false).map(RespawnPosAngle::a).orElse(null);
            }
            if (world == null || position == null) {
                world = ((CraftWorld)Bukkit.getServer().getWorlds().get(0)).getHandle();
                position = Vec3D.b(world.Y());
            }
            this.a(world);
            this.o(position.a(), position.b(), position.c());
        }
        this.h.a((WorldServer)world);
    }

    public void a(int points) {
        float f2 = this.gs();
        float f1 = (f2 - 1.0f) / f2;
        this.cs = MathHelper.a((float)points / f2, 0.0f, f1);
        this.cS = -1;
    }

    public void b(int level) {
        this.cq = level;
        this.cS = -1;
    }

    @Override
    public void c(int levels) {
        super.c(levels);
        this.cS = -1;
    }

    @Override
    public void a(ItemStack enchantedItem, int experienceLevels) {
        super.a(enchantedItem, experienceLevels);
        this.cS = -1;
    }

    public void a(Container screenHandler) {
        screenHandler.a(this.dz);
        screenHandler.a(this.dy);
    }

    public void d() {
        this.a(this.cc);
    }

    @Override
    public void i_() {
        super.i_();
        this.f.b(ClientboundPlayerCombatEnterPacket.a);
    }

    @Override
    public void j_() {
        super.j_();
        this.f.b(new ClientboundPlayerCombatEndPacket(this.eQ()));
    }

    @Override
    public void a(IBlockData state) {
        CriterionTriggers.e.a(this, state);
    }

    @Override
    protected ItemCooldown g() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void h() {
        net.minecraft.world.entity.Entity entity;
        if (this.joining) {
            this.joining = false;
        }
        this.h.a();
        this.dt.a();
        --this.cT;
        if (this.aj > 0) {
            --this.aj;
        }
        if (--this.containerUpdateDelay <= 0) {
            this.cd.d();
            this.containerUpdateDelay = this.dW().paperConfig().tickRates.containerUpdate;
        }
        if (!(this.dW().C || this.cd == this.cc || !this.fi() && this.cd.b(this))) {
            this.closeContainer(InventoryCloseEvent.Reason.CANT_USE);
            this.cd = this.cc;
        }
        if ((entity = this.L()) != this) {
            if (entity.bL()) {
                this.a(entity.dB(), entity.dD(), entity.dH(), entity.dM(), entity.dO());
                this.y().m().a(this);
                if (this.fZ()) {
                    this.d((net.minecraft.world.entity.Entity)this);
                }
            } else {
                this.d((net.minecraft.world.entity.Entity)this);
            }
        }
        CriterionTriggers.x.a(this);
        if (this.db != null) {
            CriterionTriggers.v.a(this, this.db, this.af - this.dc);
        }
        this.l();
        this.m();
        this.gP();
        this.cH.b(this);
    }

    private void gP() {
        AttributeModifiable attributemodifiable1;
        AttributeModifiable attributemodifiable = this.g(GenericAttributes.g);
        if (attributemodifiable != null) {
            if (this.b()) {
                attributemodifiable.a(cF);
            } else {
                attributemodifiable.e(cF);
            }
        }
        if ((attributemodifiable1 = this.g(GenericAttributes.j)) != null) {
            if (this.b()) {
                attributemodifiable1.a(cG);
            } else {
                attributemodifiable1.e(cG);
            }
        }
    }

    public void i() {
        try {
            if (this.valid && !this.aa_() || !this.dp()) {
                super.h();
            }
            for (int i2 = 0; i2 < this.gi().b(); ++i2) {
                ItemStack itemstack = this.gi().a(i2);
                if (itemstack.f()) continue;
                this.j(itemstack);
            }
            if (this.eE() != this.cP || this.cQ != this.ce.a() || this.ce.c() == 0.0f != this.cR) {
                this.f.b(new PacketPlayOutUpdateHealth(this.getBukkitEntity().getScaledHealth(), this.ce.a(), this.ce.c()));
                this.cP = this.eE();
                this.cQ = this.ce.a();
                boolean bl = this.cR = this.ce.c() == 0.0f;
            }
            if (this.eE() + this.fw() != this.cJ) {
                this.cJ = this.eE() + this.fw();
                this.a(IScoreboardCriteria.g, MathHelper.f(this.cJ));
            }
            if (this.ce.a() != this.cK) {
                this.cK = this.ce.a();
                this.a(IScoreboardCriteria.h, MathHelper.f((float)this.cK));
            }
            if (this.ct() != this.cL) {
                this.cL = this.ct();
                this.a(IScoreboardCriteria.i, MathHelper.f((float)this.cL));
            }
            if (this.eP() != this.cM) {
                this.cM = this.eP();
                this.a(IScoreboardCriteria.j, MathHelper.f((float)this.cM));
            }
            if (this.cr != this.cO) {
                this.cO = this.cr;
                this.a(IScoreboardCriteria.k, MathHelper.f((float)this.cO));
            }
            if (this.maxHealthCache != (double)this.eS()) {
                this.getBukkitEntity().updateScaledHealth();
            }
            if (this.cq != this.cN) {
                this.cN = this.cq;
                this.a(IScoreboardCriteria.l, MathHelper.f((float)this.cN));
            }
            if (this.cr != this.cS) {
                this.cS = this.cr;
                this.f.b(new PacketPlayOutExperience(this.cs, this.cr, this.cq));
            }
            if (this.af % 20 == 0) {
                CriterionTriggers.q.a(this);
            }
            if (this.oldLevel == -1) {
                this.oldLevel = this.cq;
            }
            if (this.oldLevel != this.cq) {
                CraftEventFactory.callPlayerLevelChangeEvent(this.getBukkitEntity(), this.oldLevel, this.cq);
                this.oldLevel = this.cq;
            }
            if (this.getBukkitEntity().hasClientWorldBorder()) {
                ((CraftWorldBorder)this.getBukkitEntity().getWorldBorder()).getHandle().s();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Ticking player");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Player being ticked");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    private void j(ItemStack stack) {
        Packet<?> packet;
        MapId mapid = stack.a(DataComponents.L);
        WorldMap worldmap = ItemWorldMap.a(mapid, this.dW());
        if (worldmap != null && (packet = worldmap.a(mapid, this)) != null) {
            this.f.b(packet);
        }
    }

    @Override
    protected void j() {
        if (this.dW().al() == EnumDifficulty.a && this.y().N().b(GameRules.k)) {
            if (this.af % 20 == 0) {
                float f2;
                if (this.eE() < this.eS()) {
                    this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
                }
                if ((f2 = this.ce.c()) < 20.0f) {
                    this.ce.b(f2 + 1.0f);
                }
            }
            if (this.af % 10 == 0 && this.ce.b()) {
                this.ce.a(this.ce.a() + 1);
            }
        }
    }

    @Override
    public void k() {
        if (this.eE() > 0.0f && this.dg != null) {
            CriterionTriggers.X.a(this, this.dg);
        }
        this.dg = null;
        super.k();
    }

    public void l() {
        if (this.Z > 0.0f && this.dg == null) {
            this.dg = this.du();
            if (this.cx != null && this.cx.e <= this.dg.e) {
                CriterionTriggers.ae.a(this, this.cx, this.cy);
            }
        }
    }

    public void m() {
        if (this.dl() != null && this.dl().bx()) {
            if (this.di == null) {
                this.di = this.du();
            } else {
                CriterionTriggers.Y.a(this, this.di);
            }
        }
        if (!(this.di == null || this.dl() != null && this.dl().bx())) {
            this.di = null;
        }
    }

    private void a(IScoreboardCriteria criterion, int score) {
        this.dW().getCraftServer().getScoreboardManager().forAllObjectives(criterion, this, scoreaccess -> scoreaccess.a(score));
    }

    private static void processKeep(PlayerDeathEvent event, NonNullList<ItemStack> inv) {
        List itemsToKeep = event.getItemsToKeep();
        if (inv == null) {
            if (!itemsToKeep.isEmpty()) {
                for (org.bukkit.inventory.ItemStack itemStack : itemsToKeep) {
                    event.getEntity().getInventory().addItem(new org.bukkit.inventory.ItemStack[]{itemStack});
                }
            }
            return;
        }
        for (int i2 = 0; i2 < inv.size(); ++i2) {
            ItemStack item = inv.get(i2);
            if (EnchantmentManager.a(item, EnchantmentEffectComponents.D) || itemsToKeep.isEmpty() || item.f()) {
                inv.set(i2, ItemStack.j);
                continue;
            }
            org.bukkit.inventory.ItemStack bukkitStack = item.getBukkitStack();
            boolean keep = false;
            Iterator iterator = itemsToKeep.iterator();
            while (iterator.hasNext()) {
                org.bukkit.inventory.ItemStack itemStack = (org.bukkit.inventory.ItemStack)iterator.next();
                if (!bukkitStack.equals((Object)itemStack)) continue;
                iterator.remove();
                keep = true;
                break;
            }
            if (keep) continue;
            inv.set(i2, ItemStack.j);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        TextComponent deathMessage;
        boolean keepInventory;
        boolean flag = this.y().N().b(GameRules.n);
        if (this.dR()) {
            return;
        }
        ArrayList<Entity.DefaultDrop> loot = new ArrayList<Entity.DefaultDrop>(this.gi().b());
        boolean bl = keepInventory = this.y().N().b(GameRules.d) || this.aa_();
        if (!keepInventory) {
            for (ItemStack item : this.gi().getContents()) {
                if (item.f() || EnchantmentManager.a(item, EnchantmentEffectComponents.D)) continue;
                loot.add(new Entity.DefaultDrop(item, stack -> this.drop((ItemStack)stack, true, false, false)));
            }
        }
        if (this.eo() && this.y().N().b(GameRules.f)) {
            this.b(this.y(), damageSource, this.bd > 0);
            loot.addAll(this.drops);
            this.drops.clear();
        }
        IChatBaseComponent defaultMessage = this.eQ().a();
        String deathmessage = defaultMessage.getString();
        this.keepLevel = keepInventory;
        PlayerDeathEvent event = CraftEventFactory.callPlayerDeathEvent(this, damageSource, loot, PaperAdventure.asAdventure(defaultMessage), keepInventory);
        if (event.isCancelled()) {
            if (this.eE() <= 0.0f) {
                this.x((float)event.getReviveHealth());
            }
            return;
        }
        ((net.minecraft.world.entity.Entity)this).a(GameEvent.p);
        if (this.cd != this.cc) {
            this.closeContainer(InventoryCloseEvent.Reason.DEATH);
        }
        Object object = deathMessage = event.deathMessage() != null ? event.deathMessage() : Component.empty();
        if (deathMessage != null && deathMessage != Component.empty() && flag) {
            IChatBaseComponent ichatbasecomponent = PaperAdventure.asVanilla((Component)deathMessage);
            this.f.a(new ClientboundPlayerCombatKillPacket(this.ar(), ichatbasecomponent), PacketSendListener.a(() -> {
                boolean flag1 = true;
                String s2 = ichatbasecomponent.a(256);
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("death.attack.message_too_long", IChatBaseComponent.b(s2).a(EnumChatFormat.o));
                IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("death.attack.even_more_magic", this.p_()).a(chatmodifier -> chatmodifier.a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, ichatmutablecomponent)));
                return new ClientboundPlayerCombatKillPacket(this.ar(), ichatmutablecomponent1);
            }));
            ScoreboardTeam scoreboardTeam = this.cr();
            if (scoreboardTeam != null && scoreboardTeam.k() != ScoreboardTeamBase.EnumNameTagVisibility.a) {
                if (scoreboardTeam.k() == ScoreboardTeamBase.EnumNameTagVisibility.c) {
                    this.g.ag().a((EntityHuman)this, ichatbasecomponent);
                } else if (scoreboardTeam.k() == ScoreboardTeamBase.EnumNameTagVisibility.d) {
                    this.g.ag().b(this, ichatbasecomponent);
                }
            } else {
                this.g.ag().a(ichatbasecomponent, false);
            }
        } else {
            this.f.b(new ClientboundPlayerCombatKillPacket(this.ar(), CommonComponents.a));
        }
        this.gx();
        if (this.y().N().b(GameRules.O)) {
            this.gQ();
        }
        if (event.shouldDropExperience()) {
            this.b(this.y(), damageSource.d());
        }
        if (!event.getKeepInventory()) {
            for (NonNullList nonNullList : this.gi().l) {
                EntityPlayer.processKeep(event, nonNullList);
            }
            EntityPlayer.processKeep(event, null);
        }
        this.d((net.minecraft.world.entity.Entity)this);
        this.dW().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.d, this, ScoreAccess::b);
        EntityLiving entityliving = this.eR();
        if (entityliving != null) {
            this.b(StatisticList.h.b(entityliving.aq()));
            entityliving.a((net.minecraft.world.entity.Entity)this, this.bl, damageSource);
            this.f(entityliving);
        }
        this.dW().a((net.minecraft.world.entity.Entity)this, (byte)3);
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aH();
        this.k(0);
        this.c(false);
        this.eQ().c();
        this.c(Optional.of(GlobalPos.a(this.dW().ah(), this.dw())));
    }

    private void gQ() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.dw()).c(32.0, 10.0, 32.0);
        this.dW().a(EntityInsentient.class, axisalignedbb, IEntitySelector.f).stream().filter(entityinsentient -> entityinsentient instanceof IEntityAngerable).forEach(entityinsentient -> ((IEntityAngerable)((Object)entityinsentient)).a_(this.y(), this));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled != this) {
            super.a(entityKilled, score, damageSource);
            this.r(score);
            this.dW().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.f, this, ScoreAccess::b);
            if (entityKilled instanceof EntityHuman) {
                this.a(StatisticList.Q);
                this.dW().getCraftServer().getScoreboardManager().forAllObjectives(IScoreboardCriteria.e, this, ScoreAccess::b);
            } else {
                this.a(StatisticList.O);
            }
            this.a((ScoreHolder)this, (ScoreHolder)entityKilled, IScoreboardCriteria.m);
            this.a((ScoreHolder)entityKilled, (ScoreHolder)this, IScoreboardCriteria.n);
            CriterionTriggers.c.a(this, entityKilled, damageSource);
        }
    }

    private void a(ScoreHolder targetScoreHolder, ScoreHolder aboutScoreHolder, IScoreboardCriteria[] criterions) {
        int i2;
        ScoreboardTeam scoreboardteam = this.gy().e(aboutScoreHolder.cI());
        if (scoreboardteam != null && (i2 = scoreboardteam.n().b()) >= 0 && i2 < criterions.length) {
            this.dW().getCraftServer().getScoreboardManager().forAllObjectives(criterions[i2], targetScoreHolder, ScoreAccess::b);
        }
    }

    @Override
    public boolean a(WorldServer world, DamageSource source, float amount) {
        EntityHuman entityhuman1;
        EntityArrow entityarrow;
        net.minecraft.world.entity.Entity entity1;
        EntityHuman entityhuman;
        boolean flag;
        if (this.a(world, source)) {
            return false;
        }
        boolean bl = flag = this.g.n() && this.gR() && source.a(DamageTypeTags.m);
        if (!flag && this.cT > 0 && !source.a(DamageTypeTags.d)) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = source.d();
        if (entity instanceof EntityHuman && !this.a(entityhuman = (EntityHuman)entity)) {
            return false;
        }
        if (entity instanceof EntityArrow && (entity1 = (entityarrow = (EntityArrow)entity).p()) instanceof EntityHuman && !this.a(entityhuman1 = (EntityHuman)entity1)) {
            return false;
        }
        this.queueHealthUpdatePacket = true;
        boolean damaged = super.a(world, source, amount);
        this.queueHealthUpdatePacket = false;
        if (this.queuedHealthUpdatePacket != null) {
            this.f.b(this.queuedHealthUpdatePacket);
            this.queuedHealthUpdatePacket = null;
        }
        return damaged;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.gR() ? false : super.a(player);
    }

    private boolean gR() {
        return this.dW().pvpMode;
    }

    public TeleportTransition findRespawnPositionAndUseSpawnBlock(boolean flag, TeleportTransition.a teleporttransition_a, PlayerRespawnEvent.RespawnReason reason) {
        TeleportTransition teleportTransition;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        BlockPosition blockposition = this.T();
        float f2 = this.U();
        boolean flag1 = this.W();
        WorldServer worldserver = this.g.a(this.V());
        if (worldserver != null && blockposition != null) {
            Optional<RespawnPosAngle> optional = EntityPlayer.a(worldserver, blockposition, f2, flag1, flag);
            if (optional.isPresent()) {
                RespawnPosAngle entityplayer_respawnposangle = optional.get();
                isBedSpawn = entityplayer_respawnposangle.isBedSpawn();
                isAnchorSpawn = entityplayer_respawnposangle.isAnchorSpawn();
                teleportTransition = new TeleportTransition(worldserver, entityplayer_respawnposangle.a(), Vec3D.c, entityplayer_respawnposangle.b(), 0.0f, teleporttransition_a);
            } else {
                teleportTransition = TeleportTransition.a(this.g.J(), this, teleporttransition_a);
            }
        } else {
            teleportTransition = new TeleportTransition(this.g.J(), this, teleporttransition_a);
        }
        if (reason == null) {
            return teleportTransition;
        }
        CraftPlayer respawnPlayer = this.getBukkitEntity();
        Location location = CraftLocation.toBukkit(teleportTransition.c(), (World)teleportTransition.b().getWorld(), teleportTransition.e(), teleportTransition.f());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (reason == PlayerRespawnEvent.RespawnReason.END_PORTAL) {
            builder.add((Object)PlayerRespawnEvent.RespawnFlag.END_PORTAL);
        }
        PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((Player)respawnPlayer, location, isBedSpawn, isAnchorSpawn, reason, builder);
        this.dW().getCraftServer().getPluginManager().callEvent((Event)respawnEvent);
        if (this.f.isDisconnected()) {
            return null;
        }
        location = respawnEvent.getRespawnLocation();
        return new TeleportTransition(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toVec3D(location), teleportTransition.d(), location.getYaw(), location.getPitch(), teleportTransition.g(), teleportTransition.h(), teleportTransition.i(), teleportTransition.j(), teleportTransition.cause());
    }

    public static Optional<RespawnPosAngle> a(WorldServer world, BlockPosition pos, float spawnAngle, boolean spawnForced, boolean alive) {
        IBlockData iblockdata = world.a_(pos);
        Block block = iblockdata.b();
        if (block instanceof BlockRespawnAnchor && (spawnForced || iblockdata.c(BlockRespawnAnchor.d) > 0) && BlockRespawnAnchor.a(world)) {
            Optional<Vec3D> optional = BlockRespawnAnchor.a(EntityTypes.bS, world, pos);
            if (!spawnForced && alive && optional.isPresent()) {
                world.a(pos, (IBlockData)iblockdata.b(BlockRespawnAnchor.d, iblockdata.c(BlockRespawnAnchor.d) - 1), 3);
            }
            return optional.map(vec3d -> RespawnPosAngle.of(vec3d, pos, false, true));
        }
        if (block instanceof BlockBed && BlockBed.a(world)) {
            return BlockBed.a(EntityTypes.bS, (ICollisionAccess)world, pos, iblockdata.c(BlockFacingHorizontal.aF), spawnAngle).map(vec3d -> RespawnPosAngle.of(vec3d, pos, true, false));
        }
        if (!spawnForced) {
            return Optional.empty();
        }
        boolean flag2 = block.a(iblockdata);
        IBlockData iblockdata1 = world.a_(pos.d());
        boolean flag3 = iblockdata1.b().a(iblockdata1);
        return flag2 && flag3 ? Optional.of(new RespawnPosAngle(new Vec3D((double)pos.u() + 0.5, (double)pos.v() + 0.1, (double)pos.w() + 0.5), spawnAngle, false, false)) : Optional.empty();
    }

    public void n() {
        this.ao();
        this.y().a(this, Entity.RemovalReason.e);
        if (!this.k) {
            this.k = true;
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
            this.i = true;
        }
    }

    @Nullable
    public EntityPlayer a(TeleportTransition teleportTarget) {
        TileEntity tileEntity;
        if (this.fR()) {
            return null;
        }
        if (this.dR()) {
            return null;
        }
        if (teleportTarget.g()) {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.b, 0.0f));
        }
        WorldServer worldserver = teleportTarget.b();
        WorldServer worldserver1 = this.y();
        ResourceKey<WorldDimension> resourcekey = worldserver1.getTypeKey();
        Location enter = this.getBukkitEntity().getLocation();
        PositionMoveRotation absolutePosition = PositionMoveRotation.a(PositionMoveRotation.a(this), PositionMoveRotation.a(teleportTarget), teleportTarget.i());
        Location exit = CraftLocation.toBukkit(absolutePosition.a(), (World)worldserver.getWorld(), absolutePosition.c(), absolutePosition.d());
        PlayerTeleportEvent tpEvent = new PlayerTeleportEvent((Player)this.getBukkitEntity(), enter, exit, teleportTarget.cause());
        if (this.as != null && this.as.a((BlockEndGateway)Blocks.la) && (tileEntity = this.y().c_(this.as.c())) instanceof TileEntityEndGateway) {
            TileEntityEndGateway theEndGatewayBlockEntity = (TileEntityEndGateway)tileEntity;
            tpEvent = new PlayerTeleportEndGatewayEvent((Player)this.getBukkitEntity(), enter, exit, (EndGateway)new CraftEndGateway((World)this.y().getWorld(), theEndGatewayBlockEntity));
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)tpEvent);
        Location newExit = tpEvent.getTo();
        if (tpEvent.isCancelled() || newExit == null) {
            return null;
        }
        if (!newExit.equals((Object)exit)) {
            worldserver = ((CraftWorld)newExit.getWorld()).getHandle();
            teleportTarget = new TeleportTransition(worldserver, CraftLocation.toVec3D(newExit), Vec3D.c, newExit.getYaw(), newExit.getPitch(), teleportTarget.g(), teleportTarget.h(), Set.of(), teleportTarget.j(), teleportTarget.cause());
        }
        if (!teleportTarget.h()) {
            this.ae();
        }
        if (worldserver != null && worldserver.ah() == worldserver1.ah()) {
            this.f.internalTeleport(PositionMoveRotation.a(teleportTarget), teleportTarget.i());
            this.f.l();
            teleportTarget.j().onTransition(this);
            return this;
        }
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("moving");
        if (worldserver != null && resourcekey == WorldDimension.b && worldserver.getTypeKey() == WorldDimension.c) {
            this.dh = this.du();
        }
        gameprofilerfiller.c();
        gameprofilerfiller.a("placing");
        this.cZ = true;
        WorldData worlddata = worldserver.D_();
        this.f.b(new PacketPlayOutRespawn(this.b(worldserver), 3));
        this.f.b(new PacketPlayOutServerDifficulty(worlddata.q(), worlddata.r()));
        PlayerList playerlist = this.g.ag();
        playerlist.e(this);
        worldserver1.a(this, Entity.RemovalReason.e);
        this.dT();
        this.a(worldserver);
        this.f.internalTeleport(PositionMoveRotation.a(teleportTarget), teleportTarget.i());
        this.f.l();
        worldserver.d(this);
        gameprofilerfiller.c();
        this.g(worldserver1);
        this.fF();
        this.f.b(new PacketPlayOutAbilities(this.gj()));
        playerlist.a(this, worldserver);
        playerlist.f(this);
        playerlist.d(this);
        teleportTarget.j().onTransition(this);
        this.cS = -1;
        this.cP = -1.0f;
        this.cQ = -1;
        PlayerChangedWorldEvent changeEvent = new PlayerChangedWorldEvent((Player)this.getBukkitEntity(), (World)worldserver1.getWorld());
        this.dW().getCraftServer().getPluginManager().callEvent((Event)changeEvent);
        if (this.fG()) {
            this.fF();
        }
        return this;
    }

    @Override
    public CraftPortalEvent callPortalEvent(net.minecraft.world.entity.Entity entity, Location exit, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        Location enter = this.getBukkitEntity().getLocation();
        PlayerPortalEvent event = new PlayerPortalEvent((Player)this.getBukkitEntity(), enter, exit, cause, searchRadius, true, creationRadius);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    @Override
    public void a(float yaw, float pitch) {
        this.f.b(new ClientboundPlayerRotationPacket(yaw, pitch));
    }

    public void g(WorldServer origin) {
        ResourceKey<net.minecraft.world.level.World> resourcekey = origin.ah();
        ResourceKey<net.minecraft.world.level.World> resourcekey1 = this.dW().ah();
        ResourceKey<net.minecraft.world.level.World> maindimensionkey = CraftDimensionUtil.getMainDimensionKey(origin);
        ResourceKey<net.minecraft.world.level.World> maindimensionkey1 = CraftDimensionUtil.getMainDimensionKey(this.dW());
        if (GlobalConfiguration.get().misc.strictAdvancementDimensionCheck) {
            maindimensionkey = resourcekey;
            maindimensionkey1 = resourcekey1;
        }
        CriterionTriggers.w.a(this, maindimensionkey, maindimensionkey1);
        if (maindimensionkey != resourcekey || maindimensionkey1 != resourcekey1) {
            CriterionTriggers.w.a(this, resourcekey, resourcekey1);
        }
        if (maindimensionkey == net.minecraft.world.level.World.j && maindimensionkey1 == net.minecraft.world.level.World.i && this.dh != null) {
            CriterionTriggers.D.a(this, this.dh);
        }
        if (maindimensionkey1 != net.minecraft.world.level.World.j) {
            this.dh = null;
        }
    }

    @Override
    public boolean a(EntityPlayer spectator) {
        return spectator.aa_() ? this.L() == this : (this.aa_() ? false : super.a(spectator));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity item, int count) {
        super.a(item, count);
        this.cd.d();
    }

    private Either<EntityHuman.EnumBedResult, Unit> getBedResult(BlockPosition blockposition, EnumDirection enumdirection) {
        if (!this.fR() && this.bL()) {
            if (!this.dW().G_().j() || !this.dW().G_().l()) {
                return Either.left(EntityHuman.EnumBedResult.a);
            }
            if (!this.a(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.c);
            }
            if (this.b(blockposition, enumdirection)) {
                return Either.left(EntityHuman.EnumBedResult.d);
            }
            this.setRespawnPosition(this.dW().ah(), blockposition, this.dM(), false, true, PlayerSetSpawnEvent.Cause.BED);
            if (this.dW().U()) {
                return Either.left(EntityHuman.EnumBedResult.b);
            }
            if (!this.b()) {
                double d0 = 8.0;
                double d1 = 5.0;
                Vec3D vec3d = Vec3D.c(blockposition);
                List<EntityMonster> list = this.dW().a(EntityMonster.class, new AxisAlignedBB(vec3d.a() - 8.0, vec3d.b() - 5.0, vec3d.c() - 8.0, vec3d.a() + 8.0, vec3d.b() + 5.0, vec3d.c() + 8.0), (? super T entitymonster) -> entitymonster.a(this.y(), this));
                if (!list.isEmpty()) {
                    return Either.left(EntityHuman.EnumBedResult.f);
                }
            }
            return Either.right(Unit.a);
        }
        return Either.left(EntityHuman.EnumBedResult.e);
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        EnumDirection enumdirection = this.dW().a_(blockposition).c(BlockFacingHorizontal.aF);
        Either<EntityHuman.EnumBedResult, Unit> bedResult = this.getBedResult(blockposition, enumdirection);
        if (bedResult.left().orElse(null) == EntityHuman.EnumBedResult.e) {
            return bedResult;
        }
        if (force) {
            bedResult = Either.right(Unit.a);
        }
        if ((bedResult = CraftEventFactory.callPlayerBedEnterEvent(this, blockposition, bedResult)).left().isPresent()) {
            return bedResult;
        }
        Either<EntityHuman.EnumBedResult, Unit> either = super.startSleepInBed(blockposition, force).ifRight(unit -> {
            this.a(StatisticList.ap);
            CriterionTriggers.r.a(this);
        });
        if (!this.y().e()) {
            this.a(IChatBaseComponent.c("sleep.not_possible"), true);
        }
        ((WorldServer)this.dW()).f();
        return either;
    }

    @Override
    public void b(BlockPosition pos) {
        this.a(StatisticList.i.b(StatisticList.n));
        super.b(pos);
    }

    private boolean a(BlockPosition pos, EnumDirection direction) {
        return this.i(pos) || this.i(pos.a(direction.g()));
    }

    private boolean i(BlockPosition pos) {
        Vec3D vec3d = Vec3D.c(pos);
        return Math.abs(this.dB() - vec3d.a()) <= 3.0 && Math.abs(this.dD() - vec3d.b()) <= 2.0 && Math.abs(this.dH() - vec3d.c()) <= 3.0;
    }

    private boolean b(BlockPosition pos, EnumDirection direction) {
        BlockPosition blockposition1 = pos.d();
        return !this.h(blockposition1) || !this.h(blockposition1.a(direction.g()));
    }

    @Override
    public void a(boolean skipSleepTimer, boolean updateSleepingPlayers) {
        if (!this.fR()) {
            return;
        }
        CraftPlayer player = this.getBukkitEntity();
        BlockPosition bedPosition = this.fP().orElse(null);
        org.bukkit.block.Block bed = bedPosition != null ? this.dW().getWorld().getBlockAt(bedPosition.u(), bedPosition.v(), bedPosition.w()) : this.dW().getWorld().getBlockAt(player.getLocation());
        PlayerBedLeaveEvent event = new PlayerBedLeaveEvent((Player)player, bed, true);
        this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (this.fR()) {
            this.y().m().a(this, new PacketPlayOutAnimation(this, 2));
        }
        super.a(skipSleepTimer, updateSleepingPlayers);
        if (this.f != null) {
            this.f.teleport(this.dB(), this.dD(), this.dH(), this.dM(), this.dO(), PlayerTeleportEvent.TeleportCause.EXIT_BED);
        }
    }

    @Override
    public void a(double destX, double destY, double destZ) {
        this.bQ();
        this.a_(destX, destY, destZ);
    }

    @Override
    public boolean a(WorldServer world, DamageSource source) {
        return super.a(world, source) || this.Q() && !source.a(DamageTypes.m) || !this.dW().paperConfig().collisions.allowPlayerCrammingDamage && source.a(DamageTypes.h);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
    }

    @Override
    protected void b(WorldServer world, BlockPosition pos) {
        if (!this.aa_()) {
            super.b(world, pos);
        }
    }

    public void a(double xDifference, double yDifference, double zDifference, boolean onGround) {
        if (!this.dp()) {
            this.a(onGround, new Vec3D(xDifference, yDifference, zDifference));
            BlockPosition blockposition = this.aP();
            IBlockData iblockdata = this.dW().a_(blockposition);
            if (this.ds && onGround && this.Z > 0.0f) {
                Vec3D vec3d = blockposition.b().b(0.0, 0.5, 0.0);
                int i2 = (int)MathHelper.a(50.0f * this.Z, 0.0f, 200.0f);
                this.y().a(new ParticleParamBlock(Particles.b, iblockdata), vec3d.d, vec3d.e, vec3d.f, i2, (double)0.3f, (double)0.3f, (double)0.3f, 0.15f);
                this.ds = false;
            }
            super.a(yDifference, onGround, iblockdata, blockposition);
        }
    }

    @Override
    public void b_(@Nullable net.minecraft.world.entity.Entity entity) {
        super.b_(entity);
        this.cx = this.du();
        this.cy = entity;
        this.w(entity != null && entity.aq() == EntityTypes.bH);
    }

    @Override
    protected void o() {
        if (this.dW().t().i()) {
            super.o();
        }
    }

    @Override
    public void a(TileEntitySign sign, boolean front) {
        this.f.b(new PacketPlayOutBlockChange(this.dW(), sign.aB_()));
        this.f.b(new PacketPlayOutOpenSignEditor(sign.aB_(), front));
    }

    public int nextContainerCounter() {
        this.dC = this.dC % 100 + 1;
        return this.dC;
    }

    @Override
    public OptionalInt a(@Nullable ITileInventory factory) {
        if (factory == null) {
            return OptionalInt.empty();
        }
        this.nextContainerCounter();
        Container container = factory.createMenu(this.dC, this.gi(), this);
        IChatBaseComponent title = null;
        if (container != null) {
            container.setTitle(factory.p_());
            boolean cancelled = false;
            Pair<Component, Container> result = CraftEventFactory.callInventoryOpenEventWithTitle(this, container, cancelled);
            container = (Container)result.getSecond();
            title = PaperAdventure.asVanilla((Component)result.getFirst());
            if (container == null && !cancelled) {
                if (factory instanceof IInventory) {
                    ((IInventory)((Object)factory)).c(this);
                } else if (factory instanceof BlockChest.DoubleInventory) {
                    ((BlockChest.DoubleInventory)factory).inventorylargechest.c(this);
                } else if (!this.cb.b((TileEntityEnderChest)null)) {
                    this.cb.c(this);
                }
                return OptionalInt.empty();
            }
        }
        if (container == null) {
            if (this.aa_()) {
                this.a(IChatBaseComponent.c("container.spectatorCantOpen").a(EnumChatFormat.m), true);
            }
            return OptionalInt.empty();
        }
        this.cd = container;
        if (!this.fi()) {
            this.f.b(new PacketPlayOutOpenWindow(container.l, container.a(), Objects.requireNonNullElseGet(title, container::getTitle)));
        }
        this.a(container);
        return OptionalInt.of(this.dC);
    }

    @Override
    public void a(int syncId, MerchantRecipeList offers, int levelProgress, int experience, boolean leveled, boolean refreshable) {
        this.f.b(new PacketPlayOutOpenWindowMerchant(syncId, offers, levelProgress, experience, leveled, refreshable));
    }

    @Override
    public void a(EntityHorseAbstract horse, IInventory inventory) {
        this.nextContainerCounter();
        Container container = new ContainerHorse(this.dC, this.gi(), inventory, horse, horse.ag_());
        container.setTitle(horse.p_());
        container = CraftEventFactory.callInventoryOpenEvent(this, container);
        if (container == null) {
            inventory.c(this);
            return;
        }
        if (this.cd != this.cc) {
            this.closeContainer(InventoryCloseEvent.Reason.OPEN_NEW);
        }
        int i2 = horse.ag_();
        this.f.b(new PacketPlayOutOpenWindowHorse(this.dC, i2, horse.ar()));
        this.cd = container;
        this.a(this.cd);
    }

    @Override
    public void a(ItemStack book, EnumHand hand) {
        if (book.b(DataComponents.T)) {
            if (ItemWrittenBook.a(book, this.A(), this)) {
                this.cd.d();
            }
            this.f.b(new PacketPlayOutOpenBook(hand));
        }
    }

    @Override
    public void a(TileEntityCommand commandBlock) {
        this.f.b(PacketPlayOutTileEntityData.a(commandBlock, TileEntity::e));
    }

    @Override
    public void p() {
        this.closeContainer(InventoryCloseEvent.Reason.UNKNOWN);
    }

    @Override
    public void closeContainer(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.f.b(new PacketPlayOutCloseWindow(this.cd.l));
        this.q();
    }

    @Override
    public void closeUnloadedInventory(InventoryCloseEvent.Reason reason) {
        CraftEventFactory.handleInventoryCloseEvent(this, reason);
        this.f.b(new PacketPlayOutCloseWindow(this.cd.l));
        this.cd = this.cc;
    }

    @Override
    public void q() {
        this.cd.a(this);
        this.cc.a(this.cd);
        this.cd = this.cc;
    }

    @Override
    public void r() {
        double d0 = this.dB();
        double d1 = this.dD();
        double d2 = this.dH();
        super.r();
        this.q(this.dB() - d0, this.dD() - d1, this.dH() - d2);
    }

    public void b(double deltaX, double deltaY, double deltaZ) {
        if (!this.bZ() && !EntityPlayer.r(deltaX, deltaY, deltaZ)) {
            if (this.ck()) {
                int i2 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
                if (i2 > 0) {
                    this.a(StatisticList.C, i2);
                    this.causeFoodExhaustion(this.dW().spigotConfig.swimMultiplier * (float)i2 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SWIM);
                }
            } else if (((net.minecraft.world.entity.Entity)this).a(TagsFluid.a)) {
                int i3 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
                if (i3 > 0) {
                    this.a(StatisticList.w, i3);
                    this.causeFoodExhaustion(this.dW().spigotConfig.swimMultiplier * (float)i3 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_UNDERWATER);
                }
            } else if (this.bj()) {
                int i4 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
                if (i4 > 0) {
                    this.a(StatisticList.s, i4);
                    this.causeFoodExhaustion(this.dW().spigotConfig.swimMultiplier * (float)i4 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK_ON_WATER);
                }
            } else if (this.q_()) {
                if (deltaY > 0.0) {
                    this.a(StatisticList.u, (int)Math.round(deltaY * 100.0));
                }
            } else if (this.aJ()) {
                int i5 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
                if (i5 > 0) {
                    if (this.cj()) {
                        this.a(StatisticList.r, i5);
                        this.causeFoodExhaustion(this.dW().spigotConfig.sprintMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.SPRINT);
                    } else if (this.ci()) {
                        this.a(StatisticList.q, i5);
                        this.causeFoodExhaustion(this.dW().spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.CROUCH);
                    } else {
                        this.a(StatisticList.p, i5);
                        this.causeFoodExhaustion(this.dW().spigotConfig.otherMultiplier * (float)i5 * 0.01f, EntityExhaustionEvent.ExhaustionReason.WALK);
                    }
                }
            } else if (this.fJ()) {
                int i6 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
                this.a(StatisticList.B, i6);
            } else {
                int i7 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ) * 100.0f);
                if (i7 > 25) {
                    this.a(StatisticList.v, i7);
                }
            }
        }
    }

    private void q(double deltaX, double deltaY, double deltaZ) {
        if (this.bZ() && !EntityPlayer.r(deltaX, deltaY, deltaZ)) {
            int i2 = Math.round((float)Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 100.0f);
            net.minecraft.world.entity.Entity entity = this.dl();
            if (entity instanceof EntityMinecartAbstract) {
                this.a(StatisticList.x, i2);
            } else if (entity instanceof AbstractBoat) {
                this.a(StatisticList.y, i2);
            } else if (entity instanceof EntityPig) {
                this.a(StatisticList.z, i2);
            } else if (entity instanceof EntityHorseAbstract) {
                this.a(StatisticList.A, i2);
            } else if (entity instanceof EntityStrider) {
                this.a(StatisticList.D, i2);
            }
        }
    }

    private static boolean r(double deltaX, double deltaY, double deltaZ) {
        return deltaX == 0.0 && deltaY == 0.0 && deltaZ == 0.0;
    }

    @Override
    public void a(Statistic<?> stat, int amount) {
        this.cI.b(this, stat, amount);
        this.dW().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, scoreaccess -> scoreaccess.b(amount));
    }

    @Override
    public void a(Statistic<?> stat) {
        this.cI.a(this, stat, 0);
        this.dW().getCraftServer().getScoreboardManager().forAllObjectives(stat, this, ScoreAccess::c);
    }

    @Override
    public int a(Collection<RecipeHolder<?>> recipes) {
        return this.da.a(recipes, this);
    }

    @Override
    public void a(RecipeHolder<?> recipe, List<ItemStack> ingredients) {
        CriterionTriggers.ac.a(this, recipe.a(), ingredients);
    }

    @Override
    public void b(List<ResourceKey<IRecipe<?>>> recipes) {
        List<RecipeHolder<?>> list1 = recipes.stream().flatMap(resourcekey -> this.g.aI().b((ResourceKey<IRecipe<?>>)resourcekey).stream()).collect(Collectors.toList());
        this.a((Collection<RecipeHolder<?>>)list1);
    }

    @Override
    public int b(Collection<RecipeHolder<?>> recipes) {
        return this.da.b(recipes, this);
    }

    @Override
    public void s() {
        super.s();
        this.a(StatisticList.E);
        if (this.cj()) {
            this.causeFoodExhaustion(this.dW().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.dW().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void d(int experience) {
        super.d(experience);
        this.cS = -1;
    }

    public void t() {
        this.dd = true;
        this.bP();
        if (this.bZ() && this.dl() instanceof EntityPlayer) {
            this.ae();
        }
        if (this.fR()) {
            this.a(true, false);
        }
    }

    @Override
    public boolean u() {
        return this.dd;
    }

    public void v() {
        this.cP = -1.0E8f;
        this.cS = -1;
    }

    @Override
    public void a(IChatBaseComponent message, boolean overlay) {
        this.b(message, overlay);
    }

    @Override
    public void w() {
        if (!this.bz.f() && this.fz()) {
            this.f.b(new PacketPlayOutEntityStatus(this, 9));
            super.w();
        }
    }

    @Override
    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        super.a(anchorPoint, target);
        this.f.b(new PacketPlayOutLookAt(anchorPoint, target.d, target.e, target.f));
    }

    public void a(ArgumentAnchor.Anchor anchorPoint, net.minecraft.world.entity.Entity targetEntity, ArgumentAnchor.Anchor targetAnchor) {
        Vec3D vec3d = targetAnchor.a(targetEntity);
        super.a(anchorPoint, vec3d);
        this.f.b(new PacketPlayOutLookAt(anchorPoint, targetEntity, targetAnchor));
    }

    public void a(EntityPlayer oldPlayer, boolean alive) {
        this.dt = oldPlayer.dt;
        this.dA = oldPlayer.dA;
        this.h.a(oldPlayer.h.b(), oldPlayer.h.c());
        this.x();
        if (alive) {
            this.eY().b(oldPlayer.eY());
            this.x(oldPlayer.eE());
            this.ce = oldPlayer.ce;
            for (MobEffect mobEffect : oldPlayer.eB()) {
            }
            this.gi().a(oldPlayer.gi());
            this.cq = oldPlayer.cq;
            this.cr = oldPlayer.cr;
            this.cs = oldPlayer.cs;
            this.q(oldPlayer.gd());
            this.as = oldPlayer.as;
        } else {
            this.eY().b(oldPlayer.eY());
            if (this.y().N().b(GameRules.d) || oldPlayer.aa_()) {
                this.gi().a(oldPlayer.gi());
                this.cq = oldPlayer.cq;
                this.cr = oldPlayer.cr;
                this.cs = oldPlayer.cs;
                this.q(oldPlayer.gd());
            }
        }
        this.ct = oldPlayer.ct;
        this.cb = oldPlayer.cb;
        this.au().a(EntityHuman.bX, oldPlayer.au().a(EntityHuman.bX));
        this.cS = -1;
        this.cP = -1.0f;
        this.cQ = -1;
        this.i = oldPlayer.i;
        this.dh = oldPlayer.dh;
        this.dk = oldPlayer.dk;
        this.i(oldPlayer.gA());
        this.j(oldPlayer.gB());
        this.c(oldPlayer.gI());
    }

    @Override
    protected void a(MobEffect effect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, source);
        this.f.b(new PacketPlayOutEntityEffect(this.ar(), effect, true));
        if (effect.a(MobEffects.y)) {
            this.dc = this.af;
            this.db = this.du();
        }
        CriterionTriggers.B.a(this, source);
    }

    @Override
    protected void a(MobEffect effect, boolean reapplyEffect, @Nullable net.minecraft.world.entity.Entity source) {
        super.a(effect, reapplyEffect, source);
        this.f.b(new PacketPlayOutEntityEffect(this.ar(), effect, false));
        CriterionTriggers.B.a(this, source);
    }

    @Override
    protected void c(Collection<MobEffect> effects) {
        super.c(effects);
        for (MobEffect mobeffect : effects) {
            this.f.b(new PacketPlayOutRemoveEntityEffect(this.ar(), mobeffect.c()));
            if (!mobeffect.a(MobEffects.y)) continue;
            this.db = null;
        }
        CriterionTriggers.B.a(this, (net.minecraft.world.entity.Entity)null);
    }

    @Override
    public void c(double destX, double destY, double destZ) {
        this.f.a(new PositionMoveRotation(new Vec3D(destX, destY, destZ), Vec3D.c, 0.0f, 0.0f), Relative.a(Relative.l, Relative.k));
    }

    @Override
    public void d(double offsetX, double offsetY, double offsetZ) {
        this.f.a(new PositionMoveRotation(new Vec3D(offsetX, offsetY, offsetZ), Vec3D.c, 0.0f, 0.0f), Relative.j);
    }

    @Override
    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<Relative> set, float f2, float f1, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        boolean flag1;
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(d0, d1, d2));
        worldserver.m().a(TicketType.g, chunkcoordintpair, 1, this.ar());
        if (this.fR()) {
            this.a(true, true);
        }
        if (flag) {
            this.d((net.minecraft.world.entity.Entity)this);
        }
        if (flag1 = super.teleportTo(worldserver, d0, d1, d2, set, f2, f1, flag, cause)) {
            this.q(set.contains((Object)Relative.d) ? this.cA() + f2 : f2);
        }
        return flag1;
    }

    @Override
    public void e(double x2, double y2, double z2) {
        super.e(x2, y2, z2);
        this.f.l();
    }

    @Override
    public void b(net.minecraft.world.entity.Entity target) {
        this.y().m().a(this, new PacketPlayOutAnimation(target, 4));
    }

    @Override
    public void c(net.minecraft.world.entity.Entity target) {
        this.y().m().a(this, new PacketPlayOutAnimation(target, 5));
    }

    @Override
    public void x() {
        if (this.f != null) {
            this.f.b(new PacketPlayOutAbilities(this.gj()));
            this.K();
        }
    }

    public WorldServer y() {
        return (WorldServer)this.dW();
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.setGameMode(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event == null ? false : event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent setGameMode(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component message) {
        boolean flag = this.aa_();
        PlayerGameModeChangeEvent event = this.h.changeGameModeForPlayer(gameMode, cause, message);
        if (event == null || event.isCancelled()) {
            return null;
        }
        this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, gameMode.a()));
        if (gameMode == EnumGamemode.d) {
            this.gx();
            this.ae();
            EnchantmentManager.a(this);
        } else {
            this.d((net.minecraft.world.entity.Entity)this);
            if (flag) {
                EnchantmentManager.a(this.y(), (EntityLiving)this);
            }
        }
        this.x();
        this.fx();
        return event;
    }

    @Override
    public boolean aa_() {
        return this.h.b() == EnumGamemode.d;
    }

    @Override
    public boolean b() {
        return this.h.b() == EnumGamemode.b;
    }

    public ICommandListener z() {
        return this.dB;
    }

    public CommandListenerWrapper A() {
        return new CommandListenerWrapper(this.z(), this.du(), this.bU(), this.y(), this.G(), this.al().getString(), this.p_(), this.g, this);
    }

    public void a(IChatBaseComponent message) {
        this.b(message, false);
    }

    public void b(IChatBaseComponent message, boolean overlay) {
        if (this.x(overlay)) {
            this.f.a(new ClientboundSystemChatPacket(message, overlay), PacketSendListener.a(() -> {
                if (this.x(false)) {
                    boolean flag1 = true;
                    String s2 = message.a(256);
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.b(s2).a(EnumChatFormat.o);
                    return new ClientboundSystemChatPacket(IChatBaseComponent.a("multiplayer.message_not_delivered", ichatmutablecomponent).a(EnumChatFormat.m), false);
                }
                return null;
            }));
        }
    }

    public void a(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params) {
        this.sendChatMessage(message, filterMaskEnabled, params, null);
    }

    public void sendChatMessage(OutgoingChatMessage message, boolean filterMaskEnabled, ChatMessageType.a params, @Nullable IChatBaseComponent unsigned) {
        if (this.gT()) {
            message.sendToPlayer(this, filterMaskEnabled, params, unsigned);
        }
    }

    public String B() {
        SocketAddress socketaddress = this.f.m();
        if (socketaddress instanceof InetSocketAddress) {
            InetSocketAddress inetsocketaddress = (InetSocketAddress)socketaddress;
            return InetAddresses.toAddrString((InetAddress)inetsocketaddress.getAddress());
        }
        return "<unknown>";
    }

    public void a(ClientInformation clientOptions) {
        PlayerChangedMainHandEvent event;
        new PlayerClientOptionsChangeEvent((Player)this.getBukkitEntity(), (Map)SystemUtils.a(new IdentityHashMap(), (? super T map) -> {
            map.put(ClientOption.LOCALE, clientOptions.b());
            map.put(ClientOption.VIEW_DISTANCE, clientOptions.c());
            map.put(ClientOption.CHAT_VISIBILITY, ClientOption.ChatVisibility.valueOf((String)clientOptions.d().name()));
            map.put(ClientOption.CHAT_COLORS_ENABLED, clientOptions.e());
            map.put(ClientOption.SKIN_PARTS, new PaperSkinParts(clientOptions.f()));
            map.put(ClientOption.MAIN_HAND, clientOptions.g() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            map.put(ClientOption.TEXT_FILTERING_ENABLED, clientOptions.h());
            map.put(ClientOption.ALLOW_SERVER_LISTINGS, clientOptions.i());
            map.put(ClientOption.PARTICLE_VISIBILITY, ClientOption.ParticleVisibility.valueOf((String)clientOptions.j().name()));
        })).callEvent();
        if (this.fy() != clientOptions.g()) {
            event = new PlayerChangedMainHandEvent((Player)this.getBukkitEntity(), this.fy() == EnumMainHand.a ? MainHand.LEFT : MainHand.RIGHT);
            this.g.server.getPluginManager().callEvent((Event)event);
        }
        if (this.df == null || !this.df.equals(clientOptions.b())) {
            event = new PlayerLocaleChangeEvent((Player)this.getBukkitEntity(), clientOptions.b());
            this.g.server.getPluginManager().callEvent((Event)event);
        }
        this.updateOptionsNoEvents(clientOptions);
    }

    public void updateOptionsNoEvents(ClientInformation clientOptions) {
        this.df = clientOptions.b();
        this.adventure$locale = Objects.requireNonNullElse(Translator.parseLocale((String)this.df), Locale.US);
        this.de = clientOptions.c();
        this.cU = clientOptions.d();
        this.cW = clientOptions.e();
        this.dq = clientOptions.h();
        this.dr = clientOptions.i();
        this.cV = clientOptions.j();
        this.au().a(EntityHuman.bX, (byte)clientOptions.f());
        this.au().a(EntityHuman.bY, (byte)clientOptions.g().b());
    }

    public ClientInformation C() {
        byte b0 = this.au().a(EntityHuman.bX);
        EnumMainHand enummainhand = EnumMainHand.d.apply(this.au().a(EntityHuman.bY).byteValue());
        return new ClientInformation(this.df, this.de, this.cU, this.cW, b0, enummainhand, this.dq, this.dr, this.cV);
    }

    public boolean D() {
        return this.cW;
    }

    public EnumChatVisibility E() {
        return this.cU;
    }

    private boolean x(boolean overlay) {
        return this.cU == EnumChatVisibility.c ? overlay : true;
    }

    private boolean gT() {
        return this.cU == EnumChatVisibility.a;
    }

    public int F() {
        return this.de;
    }

    public void a(ServerPing metadata) {
        this.f.b(new ClientboundServerDataPacket(metadata.a(), metadata.d().map(ServerPing.a::a)));
    }

    @Override
    protected int G() {
        return this.g.c(this.gh());
    }

    public void H() {
        this.cX = SystemUtils.c();
    }

    public ServerStatisticManager I() {
        return this.cI;
    }

    public RecipeBookServer J() {
        return this.da;
    }

    @Override
    protected void K() {
        if (this.aa_()) {
            this.ez();
            this.k(true);
        } else {
            super.K();
        }
    }

    public net.minecraft.world.entity.Entity L() {
        return this.cY == null ? this : this.cY;
    }

    public void d(@Nullable net.minecraft.world.entity.Entity entity) {
        net.minecraft.world.entity.Entity entity1 = this.L();
        net.minecraft.world.entity.Entity entity2 = this.cY = entity == null ? this : entity;
        if (entity1 != this.cY) {
            net.minecraft.world.level.World world;
            if (this.cY == this) {
                PlayerStopSpectatingEntityEvent playerStopSpectatingEntityEvent = new PlayerStopSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity());
                if (!playerStopSpectatingEntityEvent.callEvent()) {
                    this.cY = entity1;
                    return;
                }
            } else {
                PlayerStartSpectatingEntityEvent playerStartSpectatingEntityEvent = new PlayerStartSpectatingEntityEvent((Player)this.getBukkitEntity(), (Entity)entity1.getBukkitEntity(), (Entity)entity.getBukkitEntity());
                if (!playerStartSpectatingEntityEvent.callEvent()) {
                    this.cY = entity1;
                    return;
                }
            }
            if ((world = this.cY.dW()) instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                this.teleportTo(worldserver, this.cY.dB(), this.cY.dD(), this.cY.dH(), Set.of(), this.dM(), this.dO(), false, PlayerTeleportEvent.TeleportCause.SPECTATE);
            }
            if (entity != null) {
                this.y().m().a(this);
            }
            this.f.b(new PacketPlayOutCamera(this.cY));
            this.f.l();
        }
    }

    @Override
    protected void M() {
        if (!this.cZ) {
            super.M();
        }
    }

    @Override
    public void e(net.minecraft.world.entity.Entity target) {
        if (this.h.b() == EnumGamemode.d) {
            this.d(target);
        } else {
            super.e(target);
        }
    }

    public long N() {
        return this.cX;
    }

    @Nullable
    public IChatBaseComponent O() {
        return this.listName;
    }

    public int P() {
        return this.listOrder;
    }

    @Override
    public void a(EnumHand hand) {
        super.a(hand);
        this.gD();
    }

    public boolean Q() {
        return this.cZ;
    }

    public void R() {
        this.cZ = false;
    }

    public AdvancementDataPlayer S() {
        return this.cH;
    }

    @Nullable
    public BlockPosition T() {
        return this.dm;
    }

    public float U() {
        return this.do;
    }

    public ResourceKey<net.minecraft.world.level.World> V() {
        return this.dl;
    }

    public boolean W() {
        return this.dn;
    }

    public void b(EntityPlayer player) {
        this.a(player.V(), player.T(), player.U(), player.W(), false);
    }

    @Deprecated
    public void a(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage) {
        this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, PlayerSetSpawnEvent.Cause.UNKNOWN);
    }

    @Deprecated
    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSpawnChangeEvent.Cause cause) {
        return this.setRespawnPosition(dimension, pos, angle, forced, sendMessage, cause == PlayerSpawnChangeEvent.Cause.RESET ? PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN : PlayerSetSpawnEvent.Cause.valueOf((String)cause.name()));
    }

    public boolean setRespawnPosition(ResourceKey<net.minecraft.world.level.World> dimension, @Nullable BlockPosition pos, float angle, boolean forced, boolean sendMessage, PlayerSetSpawnEvent.Cause cause) {
        Location spawnLoc = null;
        boolean willNotify = false;
        if (pos != null) {
            boolean flag2 = pos.equals(this.dm) && dimension.equals(this.dl);
            spawnLoc = MCUtil.toLocation(this.cV().a(dimension), pos);
            spawnLoc.setYaw(angle);
            willNotify = sendMessage && !flag2;
        }
        PlayerSpawnChangeEvent dumbEvent = new PlayerSpawnChangeEvent((Player)this.getBukkitEntity(), spawnLoc, forced, cause == PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN ? PlayerSpawnChangeEvent.Cause.RESET : PlayerSpawnChangeEvent.Cause.valueOf((String)cause.name()));
        dumbEvent.callEvent();
        PlayerSetSpawnEvent event = new PlayerSetSpawnEvent((Player)this.getBukkitEntity(), cause, dumbEvent.getNewSpawn(), dumbEvent.isForced(), willNotify, (Component)(willNotify ? Component.translatable((String)"block.minecraft.set_spawn") : null));
        event.setCancelled(dumbEvent.isCancelled());
        if (!event.callEvent()) {
            return false;
        }
        if (event.getLocation() != null) {
            dimension = event.getLocation().getWorld() != null ? ((CraftWorld)event.getLocation().getWorld()).getHandle().ah() : dimension;
            pos = MCUtil.toBlockPosition(event.getLocation());
            angle = event.getLocation().getYaw();
            forced = event.isForced();
            if (event.willNotifyPlayer() && event.getNotification() != null) {
                this.a(PaperAdventure.asVanilla(event.getNotification()));
            }
            this.dm = pos;
            this.dl = dimension;
            this.do = angle;
            this.dn = forced;
        } else {
            this.dm = null;
            this.dl = net.minecraft.world.level.World.i;
            this.do = 0.0f;
            this.dn = false;
        }
        return true;
    }

    public SectionPosition X() {
        return this.dj;
    }

    public void a(SectionPosition section) {
        this.dj = section;
    }

    public ChunkTrackingView Y() {
        return this.dk;
    }

    public void a(ChunkTrackingView chunkFilter) {
        this.dk = chunkFilter;
    }

    @Override
    public void a(SoundEffect sound, SoundCategory category, float volume, float pitch) {
        this.f.b(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.b.e(sound), category, this.dB(), this.dD(), this.dH(), volume, pitch, this.ae.g()));
    }

    @Override
    public EntityItem drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        WorldMap worldmap;
        EntityItem entityitem = this.b(itemstack, flag, flag1);
        if (entityitem == null) {
            return null;
        }
        if (callEvent) {
            CraftPlayer player = this.getBukkitEntity();
            Item drop = (Item)entityitem.getBukkitEntity();
            PlayerDropItemEvent event = new PlayerDropItemEvent((Player)player, drop);
            this.dW().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                org.bukkit.inventory.ItemStack cur = player.getInventory().getItemInHand();
                if (flag1 && (cur == null || cur.getAmount() == 0)) {
                    player.getInventory().setItemInHand(drop.getItemStack());
                } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                    cur.setAmount(cur.getAmount() + 1);
                    player.getInventory().setItemInHand(cur);
                } else {
                    player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                }
                return null;
            }
        }
        this.dW().b(entityitem);
        ItemStack itemstack1 = entityitem.l();
        if (flag1) {
            if (!itemstack1.f()) {
                this.a(StatisticList.f.b(itemstack1.h()), itemstack1.L());
            }
            this.a(StatisticList.F);
        }
        if (itemstack.h() == Items.sI && (worldmap = ItemWorldMap.b(itemstack, this.dW())) != null) {
            worldmap.a(this, itemstack);
        }
        return entityitem;
    }

    @Nullable
    private EntityItem b(ItemStack stack, boolean throwRandomly, boolean retainOwnership) {
        if (stack.f()) {
            return null;
        }
        double d0 = this.dF() - (double)0.3f;
        ItemStack tmp = stack.v();
        stack.e(0);
        stack = tmp;
        EntityItem entityitem = new EntityItem(this.dW(), this.dB(), d0, this.dH(), stack);
        entityitem.b(40);
        if (retainOwnership) {
            entityitem.b((net.minecraft.world.entity.Entity)this);
        }
        if (throwRandomly) {
            float f2 = this.ae.i() * 0.5f;
            float f1 = this.ae.i() * ((float)Math.PI * 2);
            entityitem.n(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.a(this.dO() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dO() * ((float)Math.PI / 180));
            float f32 = MathHelper.a(this.dM() * ((float)Math.PI / 180));
            float f4 = MathHelper.b(this.dM() * ((float)Math.PI / 180));
            float f5 = this.ae.i() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.ae.i();
            entityitem.n((double)(-f32 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f1 * 0.3f + 0.1f + (this.ae.i() - this.ae.i()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        return entityitem;
    }

    public ITextFilter Z() {
        return this.dp;
    }

    public void a(WorldServer world) {
        this.a((net.minecraft.world.level.World)world);
        this.h.a(world);
    }

    @Nullable
    private static EnumGamemode a(@Nullable NBTTagCompound nbt, String key) {
        return nbt != null && nbt.b(key, 99) ? EnumGamemode.a(nbt.h(key)) : null;
    }

    private EnumGamemode b(@Nullable EnumGamemode backupGameMode) {
        EnumGamemode enumgamemode1 = this.g.bd();
        return enumgamemode1 != null ? enumgamemode1 : (backupGameMode != null ? backupGameMode : this.g.u());
    }

    public void c(@Nullable NBTTagCompound nbt) {
        if (this.g.bd() != null && this.g.bd() != EntityPlayer.a(nbt, "playerGameType")) {
            if (new PlayerGameModeChangeEvent((Player)this.getBukkitEntity(), GameMode.getByValue((int)this.g.u().a()), PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, null).callEvent()) {
                this.h.a(this.g.bd(), EnumGamemode.e);
            } else {
                this.h.a(EntityPlayer.a(nbt, "playerGameType"), EntityPlayer.a(nbt, "previousPlayerGameType"));
            }
            return;
        }
        this.h.a(this.b(EntityPlayer.a(nbt, "playerGameType")), EntityPlayer.a(nbt, "previousPlayerGameType"));
    }

    private void m(NBTTagCompound nbt) {
        nbt.a("playerGameType", this.h.b().a());
        EnumGamemode enumgamemode = this.h.c();
        if (enumgamemode != null) {
            nbt.a("previousPlayerGameType", enumgamemode.a());
        }
    }

    @Override
    public boolean aa() {
        return this.dq;
    }

    public boolean c(EntityPlayer player) {
        return player == this ? false : this.dq || player.dq;
    }

    @Override
    public boolean c(WorldServer world, BlockPosition pos) {
        return super.c(world, pos) && world.a((EntityHuman)this, pos);
    }

    @Override
    protected void a(ItemStack stack) {
        CriterionTriggers.W.a(this, stack);
        super.a(stack);
    }

    public boolean a(boolean entireStack) {
        PlayerInventory playerinventory = this.gi();
        ItemStack itemstack = playerinventory.a(entireStack);
        this.cd.b(playerinventory, playerinventory.j).ifPresent(i2 -> this.cd.a(i2, playerinventory.f()));
        return this.a(itemstack, false, true) != null;
    }

    @Override
    public void b(ItemStack stack) {
        if (!this.gi().f(stack)) {
            this.a(stack, false);
        }
    }

    public boolean ab() {
        return this.dr;
    }

    @Override
    public Optional<WardenSpawnTracker> ac() {
        return Optional.of(this.dt);
    }

    public void b(boolean spawnExtraParticlesOnFall) {
        this.ds = spawnExtraParticlesOnFall;
    }

    @Override
    public void a(EntityItem item) {
        super.a(item);
        net.minecraft.world.entity.Entity entity = item.p();
        if (entity != null) {
            CriterionTriggers.S.a(this, item.l(), entity);
        }
    }

    public void a(RemoteChatSession session) {
        this.dA = session;
    }

    @Nullable
    public RemoteChatSession ad() {
        return this.dA != null && this.dA.b() ? null : this.dA;
    }

    @Override
    public void a(double deltaX, double deltaZ) {
        this.cw = (float)(MathHelper.d(deltaZ, deltaX) * 57.2957763671875 - (double)this.dM());
        this.f.b(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean a(net.minecraft.world.entity.Entity entity, boolean force) {
        if (super.a(entity, force)) {
            entity.j(this);
            this.f.a(new PositionMoveRotation(this.du(), Vec3D.c, 0.0f, 0.0f), Relative.k);
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                this.g.ag().a(entityliving, this.f);
            }
            return true;
        }
        return false;
    }

    @Override
    public void ae() {
        this.stopRiding(false);
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        net.minecraft.world.entity.Entity entity = this.dl();
        super.stopRiding(suppressCancellation);
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            for (MobEffect mobeffect : entityliving.eB()) {
                this.f.b(new PacketPlayOutRemoveEntityEffect(entity.ar(), mobeffect.c()));
            }
        }
    }

    public CommonPlayerSpawnInfo b(WorldServer world) {
        return new CommonPlayerSpawnInfo(world.ag(), world.ah(), BiomeManager.a(world.D()), this.h.b(), this.h.c(), world.ai(), world.C(), this.gI(), this.aC(), world.O());
    }

    public void c(BlockPosition startRaidPos) {
        this.du = startRaidPos;
    }

    public void af() {
        this.du = null;
    }

    @Nullable
    public BlockPosition ag() {
        return this.du;
    }

    @Override
    public Vec3D ah() {
        net.minecraft.world.entity.Entity entity = this.dl();
        return entity != null && entity.cX() != this ? entity.ah() : this.dv;
    }

    public void a(Vec3D movement) {
        this.dv = movement;
    }

    @Override
    protected float a(net.minecraft.world.entity.Entity target, float baseDamage, DamageSource damageSource) {
        return EnchantmentManager.a(this.y(), this.ea(), target, damageSource, baseDamage);
    }

    @Override
    public void a(net.minecraft.world.item.Item item, EnumItemSlot slot) {
        super.a(item, slot);
        this.b(StatisticList.d.b(item));
    }

    public Input ai() {
        return this.dw;
    }

    public void a(Input playerInput) {
        this.dw = playerInput;
    }

    public Vec3D aj() {
        float f2;
        float f3 = this.dw.c() == this.dw.d() ? 0.0f : (f2 = this.dw.c() ? 1.0f : -1.0f);
        float f1 = this.dw.a() == this.dw.b() ? 0.0f : (this.dw.a() ? 1.0f : -1.0f);
        return EntityPlayer.a(new Vec3D(f2, 0.0, f1), 1.0f, this.dM());
    }

    public void a(EntityEnderPearl enderPearl) {
        this.dx.add(enderPearl);
    }

    public void b(EntityEnderPearl enderPearl) {
        this.dx.remove(enderPearl);
    }

    public Set<EntityEnderPearl> ak() {
        return this.dx;
    }

    public long c(EntityEnderPearl enderPearl) {
        net.minecraft.world.level.World world = enderPearl.dW();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            ChunkCoordIntPair chunkcoordintpair = enderPearl.dy();
            this.a(enderPearl);
            worldserver.i();
            return EntityPlayer.a(worldserver, chunkcoordintpair) - 1L;
        }
        return 0L;
    }

    public static long a(WorldServer world, ChunkCoordIntPair chunkPos) {
        if (!world.paperConfig().misc.legacyEnderPearlBehavior) {
            world.m().a(TicketType.f, chunkPos, 2, chunkPos);
        }
        return TicketType.f.b();
    }

    public long getPlayerTime() {
        if (this.relativeTime) {
            return this.dW().ad() + this.timeOffset;
        }
        return this.dW().ad() - this.dW().ad() % 24000L + this.timeOffset;
    }

    public WeatherType getPlayerWeather() {
        return this.weather;
    }

    public void setPlayerWeather(WeatherType type, boolean plugin) {
        if (!plugin && this.weather != null) {
            return;
        }
        if (plugin) {
            this.weather = type;
        }
        if (type == WeatherType.DOWNFALL) {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.d, 0.0f));
        } else {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.c, 0.0f));
        }
    }

    public void updateWeather(float oldRain, float newRain, float oldThunder, float newThunder) {
        if (this.weather == null) {
            if (oldRain != newRain) {
                this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, newRain));
            }
        } else if (this.pluginRainPositionPrevious != this.pluginRainPosition) {
            this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.i, this.pluginRainPosition));
        }
        if (oldThunder != newThunder) {
            if (this.weather == WeatherType.DOWNFALL || this.weather == null) {
                this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, newThunder));
            } else {
                this.f.b(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.j, 0.0f));
            }
        }
    }

    public void tickWeather() {
        if (this.weather == null) {
            return;
        }
        this.pluginRainPositionPrevious = this.pluginRainPosition;
        this.pluginRainPosition = this.weather == WeatherType.DOWNFALL ? (float)((double)this.pluginRainPosition + 0.01) : (float)((double)this.pluginRainPosition - 0.01);
        this.pluginRainPosition = MathHelper.a(this.pluginRainPosition, 0.0f, 1.0f);
    }

    public void resetPlayerWeather() {
        this.weather = null;
        this.setPlayerWeather(this.dW().D_().i() ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.cI() + " at " + this.dB() + "," + this.dD() + "," + this.dH() + ")";
    }

    public void forceSetPositionRotation(double x2, double y2, double z2, float yaw, float pitch) {
        this.b(x2, y2, z2, yaw, pitch);
        this.f.l();
    }

    @Override
    public boolean fi() {
        return super.fi() || this.f != null && this.f.isDisconnected();
    }

    @Override
    public Scoreboard gy() {
        return this.getBukkitEntity().getScoreboard().getHandle();
    }

    public void reset() {
        float exp = 0.0f;
        if (this.keepLevel) {
            exp = this.cs;
            this.newTotalExp = this.cr;
            this.newLevel = this.cq;
        }
        this.x(this.eS());
        this.fF();
        this.j(this.cs());
        this.h(0);
        this.Z = 0.0f;
        this.ce = new FoodMetaData();
        this.cq = this.newLevel;
        this.cr = this.newTotalExp;
        this.cs = 0.0f;
        this.aP = 0;
        this.setArrowCount(0, true);
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        ((EntityLiving)this).bZ = true;
        this.cd = this.cc;
        this.bc = null;
        ((EntityLiving)this).ca = null;
        ((EntityLiving)this).bT = new CombatTracker(this);
        this.cS = -1;
        if (this.keepLevel) {
            this.cs = exp;
        } else {
            this.d(this.newExp);
        }
        this.keepLevel = false;
        this.n(0.0, 0.0, 0.0);
        ((EntityLiving)this).cn = false;
    }

    @Override
    public CraftPlayer getBukkitEntity() {
        return (CraftPlayer)super.getBukkitEntity();
    }

    public record RespawnPosAngle(Vec3D a, float b, boolean isBedSpawn, boolean isAnchorSpawn) {
        public static RespawnPosAngle of(Vec3D vec3d, BlockPosition blockposition, boolean isBedSpawn, boolean isAnchorSpawn) {
            return new RespawnPosAngle(vec3d, RespawnPosAngle.b(vec3d, blockposition), isBedSpawn, isAnchorSpawn);
        }

        private static float b(Vec3D respawnPos, BlockPosition currentPos) {
            Vec3D vec3d1 = Vec3D.c(currentPos).d(respawnPos).d();
            return (float)MathHelper.d(MathHelper.d(vec3d1.f, vec3d1.d) * 57.2957763671875 - 90.0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RespawnPosAngle.class, "position;yaw;isBedSpawn;isAnchorSpawn", "a", "b", "isBedSpawn", "isAnchorSpawn"}, this, o2);
        }
    }
}

