/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundEntityPositionSyncPacket;
import net.minecraft.network.protocol.game.ClientboundMoveMinecartPacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public class EntityTrackerEntry {
    private static final Logger b = LogUtils.getLogger();
    private static final int c = 1;
    private static final double d = 7.62939453125E-6;
    public static final int a = 60;
    private static final int e = 400;
    private final WorldServer f;
    private final Entity g;
    private final int h;
    private final boolean i;
    private final Consumer<Packet<?>> j;
    private final VecDeltaCodec k = new VecDeltaCodec();
    private byte l;
    private byte m;
    private byte n;
    private Vec3D o;
    private int p;
    private int q;
    private List<Entity> r = ImmutableList.of();
    private boolean s;
    private boolean t;
    @Nullable
    private List<DataWatcher.c<?>> u;
    private final Set<ServerPlayerConnection> trackedPlayers;
    private boolean forceStateResync;

    public EntityTrackerEntry(WorldServer worldserver, Entity entity, int i2, boolean flag, Consumer<Packet<?>> consumer, Set<ServerPlayerConnection> trackedPlayers) {
        this.trackedPlayers = trackedPlayers;
        this.f = worldserver;
        this.j = consumer;
        this.g = entity;
        this.h = i2;
        this.i = flag;
        this.k.e(entity.dv());
        this.o = entity.dz();
        this.l = MathHelper.g(entity.dM());
        this.m = MathHelper.g(entity.dO());
        this.n = MathHelper.g(entity.cA());
        this.t = entity.aJ();
        this.u = entity.au().c();
    }

    public void onPlayerAdd() {
        this.forceStateResync = true;
    }

    public void a() {
        List<Entity> list;
        if (this.g.moonrise$isHardColliding()) {
            this.q = 9999;
        }
        if (!(list = this.g.cZ()).equals(this.r)) {
            this.a(new PacketPlayOutMount(this.g));
            EntityTrackerEntry.a(list, this.r).forEach(entity -> {
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    entityplayer.f.a(entityplayer.dB(), entityplayer.dD(), entityplayer.dH(), entityplayer.dM(), entityplayer.dO());
                }
            });
            this.r = list;
        }
        Entity entity2 = this.g;
        if (!this.trackedPlayers.isEmpty() && entity2 instanceof EntityItemFrame) {
            MapId mapid;
            WorldMap worldmap;
            EntityItemFrame entityitemframe = (EntityItemFrame)entity2;
            ItemStack itemstack = entityitemframe.A();
            if (this.f.paperConfig().maps.itemFrameCursorUpdateInterval > 0 && this.p % this.f.paperConfig().maps.itemFrameCursorUpdateInterval == 0 && itemstack.h() instanceof ItemWorldMap && (worldmap = ItemWorldMap.a(mapid = entityitemframe.cachedMapId, this.f)) != null) {
                Iterator<ServerPlayerConnection> iterator = this.trackedPlayers.iterator();
                while (iterator.hasNext()) {
                    EntityPlayer entityplayer = iterator.next().o();
                    worldmap.a(entityplayer, itemstack);
                    Packet<?> packet = worldmap.a(mapid, entityplayer);
                    if (packet == null) continue;
                    entityplayer.f.b(packet);
                }
            }
            this.g();
        }
        if (this.forceStateResync || this.p % this.h == 0 || this.g.ar || this.g.au().a()) {
            boolean flag;
            byte b0 = MathHelper.g(this.g.dM());
            byte b1 = MathHelper.g(this.g.dO());
            boolean bl = flag = Math.abs(b0 - this.l) >= 1 || Math.abs(b1 - this.m) >= 1;
            if (this.g.bZ()) {
                if (flag) {
                    this.j.accept(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.g.ar(), b0, b1, this.g.aJ()));
                    this.l = b0;
                    this.m = b1;
                }
                this.k.e(this.g.dv());
                this.g();
                this.s = true;
            } else {
                EntityMinecartAbstract entityminecartabstract;
                MinecartBehavior minecartbehavior;
                Entity entity1 = this.g;
                if (entity1 instanceof EntityMinecartAbstract && (minecartbehavior = (entityminecartabstract = (EntityMinecartAbstract)entity1).l()) instanceof NewMinecartBehavior) {
                    NewMinecartBehavior newminecartbehavior = (NewMinecartBehavior)minecartbehavior;
                    this.a(newminecartbehavior, b0, b1, flag);
                } else {
                    Vec3D vec3d1;
                    double d0;
                    boolean flag5;
                    ++this.q;
                    Vec3D vec3d = this.g.dv();
                    Vec3D base = this.k.b;
                    double vec3d_dx = vec3d.d - base.d;
                    double vec3d_dy = vec3d.e - base.e;
                    double vec3d_dz = vec3d.f - base.f;
                    boolean flag1 = vec3d_dx * vec3d_dx + vec3d_dy * vec3d_dy + vec3d_dz * vec3d_dz >= 7.62939453125E-6;
                    Packet<PacketListenerPlayOut> packet1 = null;
                    boolean flag2 = flag1 || this.p % 60 == 0;
                    boolean flag3 = false;
                    boolean flag4 = false;
                    long i2 = this.k.a(vec3d);
                    long j2 = this.k.b(vec3d);
                    long k2 = this.k.c(vec3d);
                    boolean bl2 = flag5 = i2 < -32768L || i2 > 32767L || j2 < -32768L || j2 > 32767L || k2 < -32768L || k2 > 32767L;
                    if (!(this.forceStateResync || flag5 || this.q > 400 || this.s || this.t != this.g.aJ())) {
                        if (!(flag2 && flag || this.g instanceof EntityArrow)) {
                            if (flag2) {
                                packet1 = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(this.g.ar(), (short)i2, (short)j2, (short)k2, this.g.aJ());
                                flag3 = true;
                            } else if (flag) {
                                packet1 = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.g.ar(), b0, b1, this.g.aJ());
                                flag4 = true;
                            }
                        } else {
                            packet1 = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.g.ar(), (short)i2, (short)j2, (short)k2, b0, b1, this.g.aJ());
                            flag3 = true;
                            flag4 = true;
                        }
                    } else {
                        this.t = this.g.aJ();
                        this.q = 0;
                        packet1 = ClientboundEntityPositionSyncPacket.a(this.g);
                        flag3 = true;
                        flag4 = true;
                    }
                    if ((this.i || this.g.ar || this.g instanceof EntityLiving && ((EntityLiving)this.g).fJ()) && this.p > 0 && ((d0 = (vec3d1 = this.g.dz()).g(this.o)) > 1.0E-7 || d0 > 0.0 && vec3d1.h() == 0.0)) {
                        this.o = vec3d1;
                        Entity entity22 = this.g;
                        if (entity22 instanceof EntityFireball) {
                            EntityFireball entityfireball = (EntityFireball)entity22;
                            this.j.accept(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)List.of(new PacketPlayOutEntityVelocity(this.g.ar(), this.o), new ClientboundProjectilePowerPacket(entityfireball.ar(), entityfireball.c))));
                        } else {
                            this.j.accept(new PacketPlayOutEntityVelocity(this.g.ar(), this.o));
                        }
                    }
                    if (packet1 != null) {
                        this.j.accept(packet1);
                    }
                    this.g();
                    if (flag3) {
                        this.k.e(vec3d);
                    }
                    if (flag4) {
                        this.l = b0;
                        this.m = b1;
                    }
                    this.s = false;
                }
            }
            byte b2 = MathHelper.g(this.g.cA());
            if (Math.abs(b2 - this.n) >= 1) {
                this.j.accept(new PacketPlayOutEntityHeadRotation(this.g, b2));
                this.n = b2;
            }
            this.g.ar = false;
            this.forceStateResync = false;
        }
        ++this.p;
        if (this.g.T) {
            boolean cancelled = false;
            if (this.g instanceof EntityPlayer) {
                Player player = (Player)this.g.getBukkitEntity();
                Vector velocity = player.getVelocity();
                PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                this.g.dW().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    cancelled = true;
                } else if (!velocity.equals((Object)event.getVelocity())) {
                    player.setVelocity(event.getVelocity());
                }
            }
            if (cancelled) {
                return;
            }
            this.g.T = false;
            this.a(new PacketPlayOutEntityVelocity(this.g));
        }
    }

    private void a(NewMinecartBehavior controller, byte yaw, byte pitch, boolean changedAngles) {
        this.g();
        if (controller.e.isEmpty()) {
            boolean flag2;
            Vec3D vec3d = this.g.dz();
            double d0 = vec3d.g(this.o);
            Vec3D vec3d1 = this.g.dv();
            boolean flag1 = this.k.d(vec3d1).h() >= 7.62939453125E-6;
            boolean bl = flag2 = flag1 || this.p % 60 == 0;
            if (flag2 || changedAngles || d0 > 1.0E-7) {
                this.j.accept(new ClientboundMoveMinecartPacket(this.g.ar(), List.of(new NewMinecartBehavior.a(this.g.du(), this.g.dz(), this.g.dM(), this.g.dO(), 1.0f))));
            }
        } else {
            this.j.accept(new ClientboundMoveMinecartPacket(this.g.ar(), List.copyOf(controller.e)));
            controller.e.clear();
        }
        this.l = yaw;
        this.m = pitch;
        this.k.e(this.g.du());
    }

    private static Stream<Entity> a(List<Entity> passengers, List<Entity> lastPassengers) {
        return lastPassengers.stream().filter(entity -> !passengers.contains(entity));
    }

    public void a(EntityPlayer player) {
        this.g.e(player);
        player.f.b(new PacketPlayOutEntityDestroy(this.g.ar()));
    }

    public void b(EntityPlayer player) {
        ArrayList<Packet<? super PacketListenerPlayOut>> list = new ArrayList<Packet<? super PacketListenerPlayOut>>();
        Objects.requireNonNull(list);
        this.a(player, list::add);
        player.f.b(new ClientboundBundlePacket((Iterable<Packet<? super PacketListenerPlayOut>>)list));
        this.g.d(player);
    }

    public void a(EntityPlayer player, Consumer<Packet<PacketListenerPlayOut>> sender) {
        Leashable leashable;
        Entity entity;
        if (this.g.dR()) {
            return;
        }
        Packet<PacketListenerPlayOut> packet = this.g.a(this);
        sender.accept(packet);
        if (this.u != null) {
            sender.accept(new PacketPlayOutEntityMetadata(this.g.ar(), this.u));
        }
        boolean flag = this.i;
        if (this.g instanceof EntityLiving) {
            Collection<AttributeModifiable> collection = ((EntityLiving)this.g).eY().c();
            if (this.g.ar() == player.ar()) {
                ((EntityPlayer)this.g).getBukkitEntity().injectScaledMaxHealth(collection, false);
            }
            if (!collection.isEmpty()) {
                sender.accept(new PacketPlayOutUpdateAttributes(this.g.ar(), collection));
            }
            if (((EntityLiving)this.g).fJ()) {
                flag = true;
            }
        }
        if (flag && !(this.g instanceof EntityLiving)) {
            sender.accept(new PacketPlayOutEntityVelocity(this.g.ar(), this.o));
        }
        if ((entity = this.g) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            ArrayList list = Lists.newArrayList();
            for (EnumItemSlot enumitemslot : EnumItemSlot.i) {
                ItemStack itemstack = entityliving.a(enumitemslot);
                if (itemstack.f()) continue;
                list.add(Pair.of((Object)enumitemslot, (Object)itemstack.v()));
            }
            if (!list.isEmpty()) {
                sender.accept(new PacketPlayOutEntityEquipment(this.g.ar(), list, true));
            }
            ((EntityLiving)this.g).detectEquipmentUpdatesPublic();
        }
        if (!this.g.cZ().isEmpty()) {
            sender.accept(new PacketPlayOutMount(this.g));
        }
        if (this.g.bZ()) {
            sender.accept(new PacketPlayOutMount(this.g.dl()));
        }
        if ((entity = this.g) instanceof Leashable && (leashable = (Leashable)((Object)entity)).P_()) {
            sender.accept(new PacketPlayOutAttachEntity(this.g, leashable.A()));
        }
    }

    public Vec3D b() {
        return this.k.a();
    }

    public Vec3D c() {
        return this.o;
    }

    public float d() {
        return MathHelper.a(this.m);
    }

    public float e() {
        return MathHelper.a(this.l);
    }

    public float f() {
        return MathHelper.a(this.n);
    }

    private void g() {
        DataWatcher datawatcher = this.g.au();
        List<DataWatcher.c<?>> list = datawatcher.b();
        if (list != null) {
            this.u = datawatcher.c();
            this.a(new PacketPlayOutEntityMetadata(this.g.ar(), list));
        }
        if (this.g instanceof EntityLiving) {
            Set<AttributeModifiable> set = ((EntityLiving)this.g).eY().a();
            if (!set.isEmpty()) {
                if (this.g instanceof EntityPlayer) {
                    ((EntityPlayer)this.g).getBukkitEntity().injectScaledMaxHealth(set, false);
                }
                this.a(new PacketPlayOutUpdateAttributes(this.g.ar(), set));
            }
            set.clear();
        }
    }

    private void a(Packet<?> packet) {
        this.j.accept(packet);
        if (this.g instanceof EntityPlayer) {
            ((EntityPlayer)this.g).f.b(packet);
        }
    }
}

