/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightInterface;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightLightingProvider;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.server.level.ChunkTaskDispatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.slf4j.Logger;

public class LightEngineThreaded
extends LevelLightEngine
implements AutoCloseable,
StarLightLightingProvider {
    public static final int a = 1000;
    private static final Logger e = LogUtils.getLogger();
    private final PlayerChunkMap h;
    private final int j = 1000;
    private final AtomicLong chunkWorkCounter = new AtomicLong();

    private void queueTaskForSection(int chunkX, int chunkY, int chunkZ, Supplier<StarLightInterface.LightQueue.ChunkTasks> supplier) {
        WorldServer world = (WorldServer)this.starlight$getLightEngine().getWorld();
        IChunkAccess center = this.starlight$getLightEngine().getAnyChunkNow(chunkX, chunkZ);
        if (center == null || !center.n().a(ChunkStatus.l)) {
            return;
        }
        StarLightInterface.ServerLightQueue.ServerChunkTasks scheduledTask = (StarLightInterface.ServerLightQueue.ServerChunkTasks)supplier.get();
        if (scheduledTask == null) {
            return;
        }
        if (!scheduledTask.markTicketAdded()) {
            return;
        }
        Long ticketId = this.chunkWorkCounter.getAndIncrement();
        ChunkCoordIntPair pos = new ChunkCoordIntPair(chunkX, chunkZ);
        world.m().a(StarLightInterface.CHUNK_WORK_TICKET, pos, StarLightInterface.REGION_LIGHT_TICKET_LEVEL, ticketId);
        scheduledTask.queueOrRunTask(() -> world.m().b(StarLightInterface.CHUNK_WORK_TICKET, pos, StarLightInterface.REGION_LIGHT_TICKET_LEVEL, ticketId));
    }

    @Override
    public final int starlight$serverRelightChunks(Collection<ChunkCoordIntPair> chunks0, Consumer<ChunkCoordIntPair> chunkLightCallback, IntConsumer onComplete) {
        LinkedHashSet<ChunkCoordIntPair> chunks = new LinkedHashSet<ChunkCoordIntPair>(chunks0);
        HashMap<ChunkCoordIntPair, Long> ticketIds = new HashMap<ChunkCoordIntPair, Long>();
        WorldServer world = (WorldServer)this.starlight$getLightEngine().getWorld();
        Iterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            ChunkCoordIntPair pos = (ChunkCoordIntPair)iterator.next();
            Long id = ChunkTaskScheduler.getNextChunkRelightId();
            world.m().a(ChunkTaskScheduler.CHUNK_RELIGHT, pos, StarLightInterface.REGION_LIGHT_TICKET_LEVEL, id);
            ticketIds.put(pos, id);
            IChunkAccess chunk = (IChunkAccess)world.m().c(pos.h, pos.i);
            if (chunk != null && chunk.x() && chunk.n().a(ChunkStatus.l)) continue;
            iterator.remove();
            ticketIds.remove(pos);
            world.m().b(ChunkTaskScheduler.CHUNK_RELIGHT, pos, StarLightInterface.REGION_LIGHT_TICKET_LEVEL, id);
        }
        world.moonrise$getChunkTaskScheduler().radiusAwareScheduler.queueInfiniteRadiusTask(() -> this.starlight$getLightEngine().relightChunks(chunks, pos -> {
            if (chunkLightCallback != null) {
                chunkLightCallback.accept((ChunkCoordIntPair)pos);
            }
            world.moonrise$getChunkTaskScheduler().scheduleChunkTask(pos.h, pos.i, () -> {
                NewChunkHolder chunkHolder = world.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos.h, pos.i);
                if (chunkHolder == null) {
                    return;
                }
                List<EntityPlayer> players = chunkHolder.vanillaChunkHolder.moonrise$getPlayers(false);
                if (players.isEmpty()) {
                    return;
                }
                PacketPlayOutLightUpdate relightPacket = new PacketPlayOutLightUpdate((ChunkCoordIntPair)pos, this, null, null);
                for (EntityPlayer player : players) {
                    PlayerConnection conn = player.f;
                    if (conn == null) continue;
                    conn.b(relightPacket);
                }
            });
        }, relight -> {
            if (onComplete != null) {
                onComplete.accept(relight);
            }
            for (Map.Entry entry : ticketIds.entrySet()) {
                world.m().b(ChunkTaskScheduler.CHUNK_RELIGHT, (ChunkCoordIntPair)entry.getKey(), StarLightInterface.REGION_LIGHT_TICKET_LEVEL, (Long)entry.getValue());
            }
        }));
        return chunks.size();
    }

    public LightEngineThreaded(ILightAccess chunkProvider, PlayerChunkMap chunkLoadingManager, boolean hasBlockLight, ConsecutiveExecutor processor, ChunkTaskDispatcher executor) {
        super(chunkProvider, true, hasBlockLight);
        this.h = chunkLoadingManager;
    }

    @Override
    public void close() {
    }

    @Override
    public int a() {
        throw SystemUtils.b(new UnsupportedOperationException("Ran automatically on a different thread!"));
    }

    @Override
    public void a(BlockPosition pos) {
        BlockPosition posCopy = pos.j();
        this.queueTaskForSection(posCopy.u() >> 4, posCopy.v() >> 4, posCopy.w() >> 4, () -> this.starlight$getLightEngine().blockChange(posCopy));
    }

    protected void a(ChunkCoordIntPair pos) {
    }

    @Override
    public void a(SectionPosition pos, boolean notReady) {
        this.queueTaskForSection(pos.u(), pos.v(), pos.w(), () -> this.starlight$getLightEngine().sectionChange(pos, notReady));
    }

    @Override
    public void b(ChunkCoordIntPair chunkPos) {
    }

    @Override
    public void a(ChunkCoordIntPair pos, boolean retainData) {
    }

    @Override
    public void a(EnumSkyBlock lightType, SectionPosition pos, @Nullable NibbleArray nibbles) {
    }

    private void a(int x2, int z2, Update stage, Runnable task) {
        throw new UnsupportedOperationException();
    }

    private void a(int x2, int z2, IntSupplier completedLevelSupplier, Update stage, Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void b(ChunkCoordIntPair pos, boolean retainData) {
    }

    public CompletableFuture<IChunkAccess> a(IChunkAccess chunk, boolean bl) {
        return CompletableFuture.completedFuture(chunk);
    }

    public CompletableFuture<IChunkAccess> b(IChunkAccess chunk, boolean excludeBlocks) {
        throw new UnsupportedOperationException();
    }

    public void b() {
    }

    private void f() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<?> a(int x2, int z2) {
        throw new UnsupportedOperationException();
    }

    static final class Update
    extends Enum<Update> {
        public static final /* enum */ Update a = new Update();
        public static final /* enum */ Update b = new Update();
        private static final /* synthetic */ Update[] c;

        public static Update[] values() {
            return (Update[])c.clone();
        }

        public static Update valueOf(String name) {
            return Enum.valueOf(Update.class, name);
        }

        private static /* synthetic */ Update[] a() {
            return new Update[]{a, b};
        }

        static {
            c = Update.a();
        }
    }
}

