/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import io.papermc.paper.util.TraceUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkDependencies;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.TickListWorldGen;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class RegionLimitedWorldAccess
implements GeneratorAccessSeed {
    private static final Logger a = LogUtils.getLogger();
    private final StaticCache2D<GenerationChunkHolder> b;
    private final IChunkAccess c;
    private final WorldServer d;
    private final long e;
    private final WorldData f;
    private final RandomSource h;
    private final DimensionManager i;
    private final TickListWorldGen<Block> j = new TickListWorldGen(blockposition -> this.y((BlockPosition)blockposition).q());
    private final TickListWorldGen<FluidType> k = new TickListWorldGen(blockposition -> this.y((BlockPosition)blockposition).r());
    private final BiomeManager l;
    private final ChunkStep m;
    @Nullable
    private Supplier<String> n;
    private final AtomicLong o = new AtomicLong();
    private static final MinecraftKey p = MinecraftKey.b("worldgen_region_random");
    private boolean hasSetFarWarned = false;

    @Override
    public int a(EnumSkyBlock lightLayer, BlockPosition blockPos) {
        IChunkAccess chunk = this.a(blockPos.u() >> 4, blockPos.w() >> 4);
        if (!chunk.x()) {
            return 0;
        }
        return this.C_().a(lightLayer).b(blockPos);
    }

    @Override
    public int b(BlockPosition blockPos, int subtract) {
        IChunkAccess chunk = this.a(blockPos.u() >> 4, blockPos.w() >> 4);
        if (!chunk.x()) {
            return 0;
        }
        return this.C_().a(blockPos, subtract);
    }

    public RegionLimitedWorldAccess(WorldServer world, StaticCache2D<GenerationChunkHolder> chunks, ChunkStep generationStep, IChunkAccess centerPos) {
        this.m = generationStep;
        this.b = chunks;
        this.c = centerPos;
        this.d = world;
        this.e = world.D();
        this.f = world.D_();
        this.h = world.m().i().a(p).a(this.c.f().l());
        this.i = world.G_();
        this.l = new BiomeManager(this, BiomeManager.a(this.e));
    }

    public boolean a(ChunkCoordIntPair chunkPos, int checkRadius) {
        return this.d.m().a.b(chunkPos, checkRadius);
    }

    public ChunkCoordIntPair b() {
        return this.c.f();
    }

    @Override
    public void a(@Nullable Supplier<String> structureName) {
        this.n = structureName;
    }

    @Override
    public IChunkAccess a(int chunkX, int chunkZ) {
        return this.a(chunkX, chunkZ, ChunkStatus.c);
    }

    @Override
    @Nullable
    public IChunkAccess a(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        GenerationChunkHolder generationchunkholder;
        ChunkStatus chunkstatus1;
        int k2 = this.c.f().e(chunkX, chunkZ);
        ChunkStatus chunkStatus = chunkstatus1 = k2 >= this.m.b().b() ? null : this.m.b().a(k2);
        if (chunkstatus1 != null) {
            IChunkAccess ichunkaccess;
            generationchunkholder = this.b.a(chunkX, chunkZ);
            if (leastStatus.c(chunkstatus1) && (ichunkaccess = generationchunkholder.a(chunkstatus1)) != null) {
                return ichunkaccess;
            }
        } else {
            generationchunkholder = null;
        }
        CrashReport crashreport = CrashReport.a(new IllegalStateException("Requested chunk unavailable during world generation"), "Exception generating new chunk");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk request details");
        crashreportsystemdetails.a("Requested chunk", String.format(Locale.ROOT, "%d, %d", chunkX, chunkZ));
        crashreportsystemdetails.a("Generating status", () -> this.m.a().f());
        Objects.requireNonNull(leastStatus);
        crashreportsystemdetails.a("Requested status", leastStatus::f);
        crashreportsystemdetails.a("Actual status", () -> generationchunkholder == null ? "[out of cache bounds]" : generationchunkholder.q().f());
        crashreportsystemdetails.a("Maximum allowed status", () -> chunkstatus1 == null ? "null" : chunkstatus1.f());
        ChunkDependencies chunkdependencies = this.m.b();
        Objects.requireNonNull(chunkdependencies);
        crashreportsystemdetails.a("Dependencies", chunkdependencies::toString);
        crashreportsystemdetails.a("Requested distance", k2);
        ChunkCoordIntPair chunkcoordintpair = this.c.f();
        Objects.requireNonNull(chunkcoordintpair);
        crashreportsystemdetails.a("Generating chunk", chunkcoordintpair::toString);
        throw new ReportedException(crashreport);
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        int k2 = this.c.f().e(chunkX, chunkZ);
        return k2 < this.m.b().b();
    }

    @Override
    @Nullable
    public IChunkAccess getChunkIfLoadedImmediately(int x2, int z2) {
        return this.a(x2, z2, ChunkStatus.n, false);
    }

    @Override
    public final IBlockData getBlockStateIfLoaded(BlockPosition blockposition) {
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4);
        return chunk == null ? null : chunk.a_(blockposition);
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition blockposition) {
        IChunkAccess chunk = this.getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4);
        return chunk == null ? null : chunk.b_(blockposition);
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        return this.a(SectionPosition.a(pos.u()), SectionPosition.a(pos.w())).a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        return this.y(pos).b_(pos);
    }

    @Override
    @Nullable
    public EntityHuman a(double x2, double y2, double z2, double maxDistance, Predicate<Entity> targetPredicate) {
        return null;
    }

    @Override
    public int E_() {
        return 0;
    }

    @Override
    public BiomeManager I_() {
        return this.l;
    }

    @Override
    public Holder<BiomeBase> a(int biomeX, int biomeY, int biomeZ) {
        return this.d.a(biomeX, biomeY, biomeZ);
    }

    @Override
    public float a(EnumDirection direction, boolean shaded) {
        return 1.0f;
    }

    @Override
    public LevelLightEngine C_() {
        return this.d.C_();
    }

    @Override
    public boolean a(BlockPosition pos, boolean drop, @Nullable Entity breakingEntity, int maxUpdateDepth) {
        IBlockData iblockdata = this.a_(pos);
        if (iblockdata.l()) {
            return false;
        }
        if (drop) {
            a.warn("Potential async entity add during worldgen", new Throwable());
        }
        return this.a(pos, Blocks.a.m(), 3, maxUpdateDepth);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        IChunkAccess ichunkaccess = this.y(pos);
        TileEntity tileentity = ichunkaccess.c_(pos);
        if (tileentity != null) {
            return tileentity;
        }
        NBTTagCompound nbttagcompound = ichunkaccess.f(pos);
        IBlockData iblockdata = ichunkaccess.a_(pos);
        if (nbttagcompound != null) {
            if ("DUMMY".equals(nbttagcompound.l("id"))) {
                if (!iblockdata.x()) {
                    return null;
                }
                tileentity = ((ITileEntity)((Object)iblockdata.b())).a(pos, iblockdata);
            } else {
                tileentity = TileEntity.a(pos, iblockdata, nbttagcompound, this.d.K_());
            }
            if (tileentity != null) {
                ichunkaccess.a(tileentity);
                return tileentity;
            }
        }
        if (iblockdata.x()) {
            a.warn("Tried to access a block entity before it was created. {}", (Object)pos);
        }
        return null;
    }

    @Override
    public boolean f_(BlockPosition pos) {
        int i2 = SectionPosition.a(pos.u());
        int j2 = SectionPosition.a(pos.w());
        ChunkCoordIntPair chunkcoordintpair = this.b();
        int k2 = Math.abs(chunkcoordintpair.h - i2);
        int l2 = Math.abs(chunkcoordintpair.i - j2);
        if (k2 <= this.m.d() && l2 <= this.m.d()) {
            LevelHeightAccessor levelheightaccessor;
            return !this.c.A() || !(levelheightaccessor = this.c.B()).e(pos.v());
        }
        if (!this.hasSetFarWarned) {
            SystemUtils.b("Detected setBlock in a far chunk [" + i2 + ", " + j2 + "], pos: " + String.valueOf(pos) + ", status: " + String.valueOf(this.m.a()) + (String)(this.n == null ? "" : ", currently generating: " + this.n.get()));
            this.hasSetFarWarned = true;
            if (this.p() != null && this.p().isDebugging()) {
                TraceUtil.dumpTraceForThread("far setBlock call");
            }
        }
        return false;
    }

    @Override
    public boolean a(BlockPosition pos, IBlockData state, int flags, int maxUpdateDepth) {
        IBlockData iblockdata1;
        if (!this.f_(pos)) {
            return false;
        }
        IChunkAccess ichunkaccess = this.y(pos);
        IBlockData previousBlockState = iblockdata1 = ichunkaccess.a(pos, state, false);
        if (iblockdata1 != null) {
            this.d.a(pos, iblockdata1, state);
        }
        if (state.x()) {
            if (ichunkaccess.n().d() == ChunkType.b) {
                TileEntity tileentity = ((ITileEntity)((Object)state.b())).a(pos, state);
                if (tileentity != null) {
                    ichunkaccess.a(tileentity);
                } else {
                    ichunkaccess.d(pos);
                }
            } else {
                if (previousBlockState != null && !Objects.equals(previousBlockState.b(), state.b())) {
                    ichunkaccess.d(pos);
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.a("x", pos.u());
                nbttagcompound.a("y", pos.v());
                nbttagcompound.a("z", pos.w());
                nbttagcompound.a("id", "DUMMY");
                ichunkaccess.a(nbttagcompound);
            }
        } else if (iblockdata1 != null && iblockdata1.x()) {
            ichunkaccess.d(pos);
        }
        if (state.l(this, pos)) {
            this.f(pos);
        }
        return true;
    }

    private void f(BlockPosition pos) {
        this.y(pos).e(pos);
    }

    @Override
    public boolean b(Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        int i2 = SectionPosition.a(entity.dA());
        int j2 = SectionPosition.a(entity.dG());
        this.a(i2, j2).a(entity);
        return true;
    }

    @Override
    public boolean a(BlockPosition pos, boolean move) {
        return this.a(pos, Blocks.a.m(), 3);
    }

    @Override
    public WorldBorder F_() {
        return this.d.F_();
    }

    @Override
    public boolean B_() {
        return false;
    }

    @Override
    @Deprecated
    public WorldServer a() {
        return this.d;
    }

    @Override
    public IRegistryCustom K_() {
        return this.d.K_();
    }

    @Override
    public FeatureFlagSet J() {
        return this.d.J();
    }

    @Override
    public WorldData D_() {
        return this.f;
    }

    @Override
    public DifficultyDamageScaler d_(BlockPosition pos) {
        if (!this.b(SectionPosition.a(pos.u()), SectionPosition.a(pos.w()))) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyDamageScaler(this.d.al(), this.d.ad(), 0L, this.d.aq());
    }

    @Override
    @Nullable
    public MinecraftServer p() {
        return this.d.p();
    }

    @Override
    public IChunkProvider R() {
        return this.d.m();
    }

    @Override
    public long D() {
        return this.e;
    }

    @Override
    public LevelTickAccess<Block> T() {
        return this.j;
    }

    @Override
    public LevelTickAccess<FluidType> S() {
        return this.k;
    }

    @Override
    public int O() {
        return this.d.O();
    }

    @Override
    public RandomSource H_() {
        return this.h;
    }

    @Override
    public int a(HeightMap.Type heightmap, int x2, int z2) {
        return this.a(SectionPosition.a(x2), SectionPosition.a(z2)).a(heightmap, x2 & 0xF, z2 & 0xF) + 1;
    }

    @Override
    public void a(@Nullable EntityHuman source, BlockPosition pos, SoundEffect sound, SoundCategory category, float volume, float pitch) {
    }

    @Override
    public void a(ParticleParam parameters, double x2, double y2, double z2, double velocityX, double velocityY, double velocityZ) {
    }

    @Override
    public void a(@Nullable EntityHuman player, int eventId, BlockPosition pos, int data) {
    }

    @Override
    public void a(Holder<GameEvent> event, Vec3D emitterPos, GameEvent.a emitter) {
    }

    @Override
    public DimensionManager G_() {
        return this.i;
    }

    @Override
    public boolean a(BlockPosition pos, Predicate<IBlockData> state) {
        return state.test(this.a_(pos));
    }

    @Override
    public boolean b(BlockPosition pos, Predicate<Fluid> state) {
        return state.test(this.b_(pos));
    }

    @Override
    public <T extends Entity> List<T> a(EntityTypeTest<Entity, T> filter, AxisAlignedBB box, Predicate<? super T> predicate) {
        return Collections.emptyList();
    }

    @Override
    public List<Entity> a(@Nullable Entity except, AxisAlignedBB box, @Nullable Predicate<? super Entity> predicate) {
        return Collections.emptyList();
    }

    public List<EntityHuman> y() {
        return Collections.emptyList();
    }

    @Override
    public int L_() {
        return this.d.L_();
    }

    @Override
    public int M_() {
        return this.d.M_();
    }

    @Override
    public long J_() {
        return this.o.getAndIncrement();
    }
}

