/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.util.Priority;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.list.ReferenceList;
import ca.spottedleaf.moonrise.common.list.ShortList;
import ca.spottedleaf.moonrise.common.misc.NearbyPlayers;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.SimpleThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.ChunkDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.EntityDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.io.datacontroller.PoiDataController;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevelReader;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemServerLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.server.ServerEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_tick_iteration.ChunkTickServerLevel;
import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.destroystokyo.paper.event.entity.EntityRemoveFromWorldEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.block.BlockBreakProgressUpdateEvent;
import io.papermc.paper.threadedregions.TickRegions;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportType;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.ServerEntityGetter;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.raid.PersistentRaid;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.BlockActionData;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.portal.PortalTravelAgent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.PersistentIdCounts;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.ticks.TickListServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R2.generator.CustomChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R2.generator.CustomWorldChunkManager;
import org.bukkit.craftbukkit.v1_21_R2.util.WorldUUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LightningStrike;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.server.MapInitializeEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Merchant;
import org.bukkit.map.MapView;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotWorldConfig;

public class WorldServer
extends net.minecraft.world.level.World
implements ServerEntityGetter,
GeneratorAccessSeed,
ChunkSystemServerLevel,
ChunkSystemLevelReader,
ChunkTickServerLevel {
    public static final BlockPosition a = new BlockPosition(100, 50, 0);
    public static final IntProvider b = UniformInt.a(12000, 180000);
    public static final IntProvider c = UniformInt.a(12000, 24000);
    private static final IntProvider E = UniformInt.a(12000, 180000);
    public static final IntProvider d = UniformInt.a(3600, 15600);
    private static final Logger F = LogUtils.getLogger();
    private static final int G = 300;
    private static final int H = 65536;
    final List<EntityPlayer> I = Lists.newArrayList();
    public final ChunkProviderServer J;
    private final MinecraftServer K;
    public final WorldDataServer L;
    private int M;
    final EntityTickList N = new EntityTickList();
    private final GameEventDispatcher P;
    public boolean e;
    private final SleepStatus Q;
    private int R;
    private final PortalTravelAgent S;
    private final TickListServer<Block> T = new TickListServer(this::d);
    private final TickListServer<FluidType> U = new TickListServer(this::d);
    private final PathTypeCache V = new PathTypeCache();
    final Set<EntityInsentient> W = new ObjectOpenHashSet();
    volatile boolean X;
    protected final PersistentRaid f;
    private final ObjectLinkedOpenHashSet<BlockActionData> Y = new ObjectLinkedOpenHashSet();
    private final List<BlockActionData> Z = new ArrayList<BlockActionData>(64);
    private boolean aa;
    private final List<MobSpawner> ab;
    @Nullable
    private EnderDragonBattle ac;
    final Int2ObjectMap<EntityComplexPart> ad = new Int2ObjectOpenHashMap();
    private final StructureManager ae;
    private final StructureCheck af;
    private final boolean ag;
    private final RandomSequences ah;
    public final Convertable.ConversionSession convertable;
    public final UUID uuid;
    public boolean hasPhysicsEvent = true;
    public boolean hasEntityMoveEvent;
    private final WireHandler wireHandler = new WireHandler(this);
    private final RegionizedPlayerChunkLoader.ViewDistanceHolder viewDistanceHolder = new RegionizedPlayerChunkLoader.ViewDistanceHolder();
    private final RegionizedPlayerChunkLoader chunkLoader = new RegionizedPlayerChunkLoader(this);
    private final EntityDataController entityDataController;
    private final PoiDataController poiDataController;
    private final ChunkDataController chunkDataController;
    private final ChunkTaskScheduler chunkTaskScheduler;
    private long lastMidTickFailure;
    private long tickedBlocksOrFluids;
    private final NearbyPlayers nearbyPlayers = new NearbyPlayers(this);
    private static final ChunkProviderServer.a[] EMPTY_CHUNK_AND_HOLDERS = new ChunkProviderServer.a[0];
    private final ReferenceList<ChunkProviderServer.a> loadedChunks = new ReferenceList<ChunkProviderServer.a>(EMPTY_CHUNK_AND_HOLDERS);
    private final ReferenceList<ChunkProviderServer.a> tickingChunks = new ReferenceList<ChunkProviderServer.a>(EMPTY_CHUNK_AND_HOLDERS);
    private final ReferenceList<ChunkProviderServer.a> entityTickingChunks = new ReferenceList<ChunkProviderServer.a>(EMPTY_CHUNK_AND_HOLDERS);
    private static final ChunkProviderServer.a[] EMPTY_PLAYER_CHUNK_HOLDERS = new ChunkProviderServer.a[0];
    private final ReferenceList<ChunkProviderServer.a> playerTickingChunks = new ReferenceList<ChunkProviderServer.a>(EMPTY_PLAYER_CHUNK_HOLDERS);
    private final Long2IntOpenHashMap playerTickingRequests = new Long2IntOpenHashMap();
    private long lagCompensationTick = MinecraftServer.SERVER_INIT;
    private final SimpleThreadUnsafeRandom simpleRandom = new SimpleThreadUnsafeRandom(RandomSupport.a());
    static final AtomicReference<net.minecraft.world.entity.Entity> currentlyTickingEntity = new AtomicReference();

    @Override
    public Chunk getChunkIfLoaded(int x2, int z2) {
        return this.J.getChunkAtIfLoadedImmediately(x2, z2);
    }

    @Override
    public ResourceKey<WorldDimension> getTypeKey() {
        return this.convertable.dimensionType;
    }

    public final boolean areChunksLoadedForMove(AxisAlignedBB axisalignedbb) {
        int minBlockX = MathHelper.a(axisalignedbb.a - 1.0E-7) - 3;
        int maxBlockX = MathHelper.a(axisalignedbb.d + 1.0E-7) + 3;
        int minBlockZ = MathHelper.a(axisalignedbb.c - 1.0E-7) - 3;
        int maxBlockZ = MathHelper.a(axisalignedbb.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkProviderServer chunkProvider = this.m();
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                if (chunkProvider.getChunkAtIfLoadedImmediately(cx, cz) != null) continue;
                return false;
            }
        }
        return true;
    }

    public final void loadChunksForMoveAsync(AxisAlignedBB axisalignedbb, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        int minBlockX = MathHelper.a(axisalignedbb.a - 1.0E-7) - 3;
        int minBlockZ = MathHelper.a(axisalignedbb.c - 1.0E-7) - 3;
        int maxBlockX = MathHelper.a(axisalignedbb.d + 1.0E-7) + 3;
        int maxBlockZ = MathHelper.a(axisalignedbb.f + 1.0E-7) + 3;
        int minChunkX = minBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        this.loadChunks(minChunkX, minChunkZ, maxChunkX, maxChunkZ, priority, onLoad);
    }

    public final void loadChunks(int minChunkX, int minChunkZ, int maxChunkX, int maxChunkZ, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, priority, onLoad);
    }

    @Override
    @Nullable
    public EntityHuman b(UUID uuid) {
        EntityPlayer player = this.p().ag().a(uuid);
        return player != null && player.dW() == this ? player : null;
    }

    @Override
    public final Chunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.J.a(chunkX, chunkZ);
    }

    @Override
    public final IChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        if (newChunkHolder == null) {
            return null;
        }
        NewChunkHolder.ChunkCompletion lastCompletion = newChunkHolder.getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.chunk();
    }

    @Override
    public final IChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        NewChunkHolder newChunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(leastStatus);
    }

    @Override
    public final void moonrise$midTickTasks() {
        this.K.moonrise$executeMidTickTasks();
    }

    @Override
    public final IChunkAccess moonrise$syncLoadNonFull(int chunkX, int chunkZ, ChunkStatus status) {
        return this.moonrise$getChunkTaskScheduler().syncLoadNonFull(chunkX, chunkZ, status);
    }

    @Override
    public final ChunkTaskScheduler moonrise$getChunkTaskScheduler() {
        return this.chunkTaskScheduler;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getChunkDataController() {
        return this.chunkDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getPoiChunkDataController() {
        return this.poiDataController;
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController moonrise$getEntityChunkDataController() {
        return this.entityDataController;
    }

    @Override
    public final int moonrise$getRegionChunkShift() {
        return TickRegions.getRegionChunkShift();
    }

    @Override
    public final RegionizedPlayerChunkLoader moonrise$getPlayerChunkLoader() {
        return this.chunkLoader;
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPosition pos, int radiusBlocks, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(BlockPosition pos, int radiusBlocks, ChunkStatus chunkStatus, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(pos.u() - radiusBlocks >> 4, pos.u() + radiusBlocks >> 4, pos.w() - radiusBlocks >> 4, pos.w() + radiusBlocks >> 4, chunkStatus, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        this.moonrise$loadChunksAsync(minChunkX, maxChunkX, minChunkZ, maxChunkZ, ChunkStatus.n, priority, onLoad);
    }

    @Override
    public final void moonrise$loadChunksAsync(int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ, ChunkStatus chunkStatus, Priority priority, Consumer<List<IChunkAccess>> onLoad) {
        ChunkTaskScheduler chunkTaskScheduler = this.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        int requiredChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        AtomicInteger loadedChunks = new AtomicInteger();
        Long holderIdentifier = ChunkTaskScheduler.getNextChunkLoadId();
        int ticketLevel = ChunkTaskScheduler.getTicketLevel(chunkStatus);
        ArrayList ret = new ArrayList(requiredChunks);
        Consumer<IChunkAccess> consumer = chunk -> {
            if (chunk != null) {
                List list = ret;
                synchronized (list) {
                    ret.add(chunk);
                }
                chunkHolderManager.addTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunk.f(), ticketLevel, holderIdentifier);
            }
            if (loadedChunks.incrementAndGet() == requiredChunks) {
                try {
                    onLoad.accept(Collections.unmodifiableList(ret));
                }
                finally {
                    int len = ret.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        ChunkCoordIntPair chunkPos = ((IChunkAccess)ret.get(i2)).f();
                        chunkHolderManager.removeTicketAtLevel(ChunkTaskScheduler.CHUNK_LOAD, chunkPos, ticketLevel, holderIdentifier);
                    }
                }
            }
        };
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                chunkTaskScheduler.scheduleChunkLoad(cx, cz, chunkStatus, true, priority, consumer);
            }
        }
    }

    @Override
    public final RegionizedPlayerChunkLoader.ViewDistanceHolder moonrise$getViewDistanceHolder() {
        return this.viewDistanceHolder;
    }

    @Override
    public final long moonrise$getLastMidTickFailure() {
        return this.lastMidTickFailure;
    }

    @Override
    public final void moonrise$setLastMidTickFailure(long time) {
        this.lastMidTickFailure = time;
    }

    @Override
    public final NearbyPlayers moonrise$getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    @Override
    public final ReferenceList<ChunkProviderServer.a> moonrise$getLoadedChunks() {
        return this.loadedChunks;
    }

    @Override
    public final ReferenceList<ChunkProviderServer.a> moonrise$getTickingChunks() {
        return this.tickingChunks;
    }

    @Override
    public final ReferenceList<ChunkProviderServer.a> moonrise$getEntityTickingChunks() {
        return this.entityTickingChunks;
    }

    @Override
    public final boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        ChunkProviderServer chunkSource = this.J;
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.b(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final ReferenceList<ChunkProviderServer.a> moonrise$getPlayerTickingChunks() {
        return this.playerTickingChunks;
    }

    @Override
    public final void moonrise$markChunkForPlayerTicking(Chunk chunk) {
        ChunkCoordIntPair pos = chunk.f();
        if (!this.playerTickingRequests.containsKey(CoordinateUtils.getChunkKey(pos))) {
            return;
        }
        this.playerTickingChunks.add(chunk.moonrise$getChunkAndHolder());
    }

    @Override
    public final void moonrise$removeChunkForPlayerTicking(Chunk chunk) {
        this.playerTickingChunks.remove(chunk.moonrise$getChunkAndHolder());
    }

    @Override
    public final void moonrise$addPlayerTickingRequest(int chunkX, int chunkZ) {
        TickThread.ensureTickThread((net.minecraft.world.level.World)this, chunkX, chunkZ, "Cannot add ticking request async");
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (this.playerTickingRequests.addTo(chunkKey, 1) != 0) {
            return;
        }
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkKey);
        if (chunkHolder == null || !chunkHolder.isTickingReady()) {
            return;
        }
        this.playerTickingChunks.add(((Chunk)chunkHolder.getCurrentChunk()).moonrise$getChunkAndHolder());
    }

    @Override
    public final void moonrise$removePlayerTickingRequest(int chunkX, int chunkZ) {
        TickThread.ensureTickThread((net.minecraft.world.level.World)this, chunkX, chunkZ, "Cannot remove ticking request async");
        long chunkKey = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        int val = this.playerTickingRequests.addTo(chunkKey, -1);
        if (val <= 0) {
            throw new IllegalStateException("Negative counter");
        }
        if (val != 1) {
            return;
        }
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkKey);
        if (chunkHolder == null || !chunkHolder.isTickingReady()) {
            return;
        }
        this.playerTickingChunks.remove(((Chunk)chunkHolder.getCurrentChunk()).moonrise$getChunkAndHolder());
    }

    public long getLagCompensationTick() {
        return this.lagCompensationTick;
    }

    public void updateLagCompensationTick() {
        this.lagCompensationTick = (System.nanoTime() - MinecraftServer.SERVER_INIT) / TimeUnit.MILLISECONDS.toNanos(50L);
    }

    public WorldServer(MinecraftServer minecraftserver, Executor executor, Convertable.ConversionSession convertable_conversionsession, WorldDataServer iworlddataserver, ResourceKey<net.minecraft.world.level.World> resourcekey, WorldDimension worlddimension, WorldLoadListener worldloadlistener, boolean flag, long i2, List<MobSpawner> list, boolean flag1, @Nullable RandomSequences randomsequences, World.Environment env, org.bukkit.generator.ChunkGenerator gen, BiomeProvider biomeProvider) {
        super(iworlddataserver, resourcekey, minecraftserver.ba(), worlddimension.a(), false, flag, i2, minecraftserver.bj(), gen, biomeProvider, env, spigotConfig -> minecraftserver.paperConfigurations.createWorldConfig(PaperConfigurations.createWorldContextMap(convertable_conversionsession.c.f(), iworlddataserver.e(), resourcekey.a(), spigotConfig, minecraftserver.ba(), iworlddataserver.o())), executor);
        this.pvpMode = minecraftserver.ac();
        this.convertable = convertable_conversionsession;
        this.uuid = WorldUUID.getUUID(convertable_conversionsession.c.f().toFile());
        this.ag = flag1;
        this.K = minecraftserver;
        this.ab = list;
        this.L = iworlddataserver;
        ChunkGenerator chunkgenerator = worlddimension.b();
        this.L.setWorld(this);
        if (biomeProvider != null) {
            CustomWorldChunkManager worldChunkManager = new CustomWorldChunkManager((WorldInfo)this.getWorld(), biomeProvider, this.K.ba().e(Registries.aI), chunkgenerator.d());
            if (chunkgenerator instanceof ChunkGeneratorAbstract) {
                ChunkGeneratorAbstract cga = (ChunkGeneratorAbstract)chunkgenerator;
                chunkgenerator = new ChunkGeneratorAbstract((WorldChunkManager)worldChunkManager, cga.e);
            } else if (chunkgenerator instanceof ChunkProviderFlat) {
                ChunkProviderFlat cpf = (ChunkProviderFlat)chunkgenerator;
                chunkgenerator = new ChunkProviderFlat(cpf.h(), worldChunkManager);
            }
        }
        if (gen != null) {
            chunkgenerator = new CustomChunkGenerator(this, chunkgenerator, gen);
        }
        boolean flag2 = minecraftserver.aX();
        DataFixer datafixer = minecraftserver.aC();
        EntityStorage entitypersistentstorage = new EntityStorage(new SimpleRegionStorage(new RegionStorageInfo(convertable_conversionsession.f(), resourcekey, "entities"), convertable_conversionsession.a(resourcekey).resolve("entities"), datafixer, flag2, DataFixTypes.s), this, minecraftserver);
        StructureTemplateManager structuretemplatemanager = minecraftserver.aY();
        int j2 = this.spigotConfig.viewDistance;
        int k2 = this.spigotConfig.simulationDistance;
        this.J = new ChunkProviderServer(this, convertable_conversionsession, datafixer, structuretemplatemanager, executor, chunkgenerator, j2, k2, flag2, worldloadlistener, null, () -> minecraftserver.J().v());
        this.J.h().b();
        this.S = new PortalTravelAgent(this);
        this.X();
        this.aa();
        this.F_().a(minecraftserver.aw());
        this.f = this.v().a(PersistentRaid.a(this), PersistentRaid.a(this.ag()));
        if (!minecraftserver.U()) {
            iworlddataserver.a(minecraftserver.u());
        }
        long l2 = minecraftserver.aZ().y().c();
        this.af = new StructureCheck(this.J.m(), this.K_(), minecraftserver.aY(), this.getTypeKey(), chunkgenerator, this.J.i(), this, chunkgenerator.d(), l2, datafixer);
        this.ae = new StructureManager(this, this.L.y(), this.af);
        this.ac = this.ah() == net.minecraft.world.level.World.k && this.ag().a(BuiltinDimensionTypes.c) || env == World.Environment.THE_END ? new EnderDragonBattle(this, this.L.y().c(), this.L.C()) : null;
        this.Q = new SleepStatus();
        this.P = new GameEventDispatcher(this);
        this.ah = Objects.requireNonNullElseGet(randomsequences, () -> this.v().a(RandomSequences.a(l2), "random_sequences"));
        this.moonrise$setEntityLookup(new ServerEntityLookup(this, (LevelCallback<net.minecraft.world.entity.Entity>)new a()));
        this.chunkTaskScheduler = new ChunkTaskScheduler(this);
        this.entityDataController = new EntityDataController(new EntityDataController.EntityRegionFileStorage(new RegionStorageInfo(convertable_conversionsession.f(), resourcekey, "entities"), convertable_conversionsession.a(resourcekey).resolve("entities"), minecraftserver.aX()), this.chunkTaskScheduler);
        this.poiDataController = new PoiDataController(this, this.chunkTaskScheduler);
        this.chunkDataController = new ChunkDataController(this, this.chunkTaskScheduler);
        this.getCraftServer().addWorld(this.getWorld());
    }

    @Override
    public boolean b(int chunkX, int chunkZ) {
        return this.m().getChunkAtIfLoadedImmediately(chunkX, chunkZ) != null;
    }

    @Deprecated
    @VisibleForTesting
    public void a(@Nullable EnderDragonBattle enderDragonFight) {
        this.ac = enderDragonFight;
    }

    public void a(int clearDuration, int rainDuration, boolean raining, boolean thundering) {
        this.L.a(clearDuration);
        this.L.c(rainDuration);
        this.L.b(rainDuration);
        this.L.setRaining(raining, WeatherChangeEvent.Cause.COMMAND);
        this.L.setThundering(thundering, ThunderChangeEvent.Cause.COMMAND);
    }

    @Override
    public Holder<BiomeBase> a(int biomeX, int biomeY, int biomeZ) {
        return this.m().g().d().getNoiseBiome(biomeX, biomeY, biomeZ, this.m().i().b());
    }

    public StructureManager b() {
        return this.ae;
    }

    public void a(BooleanSupplier shouldKeepTicking) {
        boolean flag1;
        long j2;
        int i2;
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        this.aa = true;
        TickRateManager tickratemanager = this.t();
        boolean flag = tickratemanager.i();
        if (flag) {
            gameprofilerfiller.a("world border");
            this.F_().s();
            gameprofilerfiller.b("weather");
            this.au();
            gameprofilerfiller.c();
        }
        if (this.Q.a(i2 = this.N().c(GameRules.Q)) && this.Q.a(i2, this.I)) {
            j2 = this.B.d() + 24000L;
            TimeSkipEvent event = new TimeSkipEvent((World)this.getWorld(), TimeSkipEvent.SkipReason.NIGHT_SKIP, j2 - j2 % 24000L - this.ad());
            if (this.N().b(GameRules.l)) {
                this.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.b(this.ad() + event.getSkipAmount());
                }
            }
            if (!event.isCancelled()) {
                this.as();
            }
            if (this.N().b(GameRules.w) && this.af()) {
                this.h();
            }
        }
        this.X();
        if (flag) {
            this.c();
        }
        gameprofilerfiller.a("tickPending");
        if (!this.ai() && flag) {
            j2 = this.ac();
            gameprofilerfiller.a("blockTicks");
            this.T.a(j2, this.paperConfig().environment.maxBlockTicks, this::d);
            gameprofilerfiller.b("fluidTicks");
            this.U.a(j2, this.paperConfig().environment.maxFluidTicks, this::a);
            gameprofilerfiller.c();
        }
        gameprofilerfiller.b("raid");
        if (flag) {
            this.f.a();
        }
        gameprofilerfiller.b("chunkSource");
        this.m().a(shouldKeepTicking, true);
        gameprofilerfiller.b("blockEvents");
        if (flag) {
            this.av();
        }
        this.aa = false;
        gameprofilerfiller.c();
        boolean bl = flag1 = !this.paperConfig().unsupportedSettings.disableWorldTickingWhenEmpty || !this.I.isEmpty() || !this.x().isEmpty();
        if (flag1) {
            this.i();
        }
        if (flag1 || this.R++ < 300) {
            gameprofilerfiller.a("entities");
            if (this.ac != null && flag) {
                gameprofilerfiller.a("dragonFight");
                this.ac.c();
                gameprofilerfiller.c();
            }
            ActivationRange.activateEntities(this);
            this.N.a((net.minecraft.world.entity.Entity entity) -> {
                if (!entity.dR() && !tickratemanager.a((net.minecraft.world.entity.Entity)entity)) {
                    gameprofilerfiller.a("checkDespawn");
                    entity.dI();
                    gameprofilerfiller.c();
                    net.minecraft.world.entity.Entity entity1 = entity.dl();
                    if (entity1 != null) {
                        if (!entity1.dR() && entity1.y((net.minecraft.world.entity.Entity)entity)) {
                            return;
                        }
                        entity.ae();
                    }
                    gameprofilerfiller.a("tick");
                    this.a(this::a, entity);
                    gameprofilerfiller.c();
                }
            });
            gameprofilerfiller.c();
            this.W();
        }
        gameprofilerfiller.a("entityManagement");
        gameprofilerfiller.c();
    }

    @Override
    public boolean a(long chunkPos) {
        NewChunkHolder holder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return holder != null && holder.isTickingReady();
    }

    protected void c() {
        if (this.ag) {
            long i2 = this.B.c() + 1L;
            this.L.a(i2);
            Profiler.a().a("scheduledFunctions");
            this.L.s().a(this.K, i2);
            Profiler.a().c();
            if (this.L.o().b(GameRules.l)) {
                this.b(this.B.d() + 1L);
            }
        }
    }

    public void b(long timeOfDay) {
        this.L.b(timeOfDay);
    }

    public void a(boolean spawnMonsters, boolean spawnAnimals) {
        for (MobSpawner mobspawner : this.ab) {
            mobspawner.a(this, spawnMonsters, spawnAnimals);
        }
    }

    private void as() {
        this.Q.a();
        this.I.stream().filter(EntityLiving::fR).collect(Collectors.toList()).forEach(entityplayer -> entityplayer.a(false, false));
    }

    private void optimiseRandomTick(Chunk chunk, int tickSpeed) {
        ChunkSection[] sections = chunk.d();
        int minSection = WorldUtil.getMinSection(this);
        SimpleThreadUnsafeRandom simpleRandom = this.simpleRandom;
        boolean doubleTickFluids = !PlatformHooks.get().configFixMC224294();
        ChunkCoordIntPair cpos = chunk.f();
        int offsetX = cpos.h << 4;
        int offsetZ = cpos.i << 4;
        int sectionsLen = sections.length;
        for (int sectionIndex = 0; sectionIndex < sectionsLen; ++sectionIndex) {
            int offsetY = sectionIndex + minSection << 4;
            ChunkSection section = sections[sectionIndex];
            DataPaletteBlock<IBlockData> states = section.h;
            if (!section.e()) continue;
            ShortList tickList = section.moonrise$getTickingBlockList();
            for (int i2 = 0; i2 < tickSpeed; ++i2) {
                Fluid fluidState;
                int tickingBlocks = tickList.size();
                int index = simpleRandom.f() & 0xFFF;
                if (index >= tickingBlocks) continue;
                int location = tickList.getRaw(index) & 0xFFFF;
                IBlockData state = states.a(location);
                BlockPosition pos = new BlockPosition(location & 0xF | offsetX, location >>> 8 & 0xF | offsetY, location >>> 4 & 0xF | offsetZ);
                state.b(this, pos, simpleRandom);
                if (!doubleTickFluids || !(fluidState = state.y()).f()) continue;
                fluidState.a(this, pos, (RandomSource)simpleRandom);
            }
        }
    }

    public void a(Chunk chunk, int randomTickSpeed) {
        BlockPosition blockposition;
        SimpleThreadUnsafeRandom simpleRandom = this.simpleRandom;
        ChunkCoordIntPair chunkcoordintpair = chunk.f();
        boolean flag = this.af();
        int j2 = chunkcoordintpair.d();
        int k2 = chunkcoordintpair.e();
        GameProfilerFiller gameprofilerfiller = Profiler.a();
        gameprofilerfiller.a("thunder");
        if (!this.paperConfig().environment.disableThunder && flag && this.ae() && this.spigotConfig.thunderChance > 0 && simpleRandom.a(this.spigotConfig.thunderChance) == 0 && this.r(blockposition = this.b(this.a(j2, 0, k2, 15)))) {
            EntityLightning entitylightning;
            EntityHorseSkeleton entityhorseskeleton;
            boolean flag1;
            DifficultyDamageScaler difficultydamagescaler = this.d_(blockposition);
            boolean bl = flag1 = this.N().b(GameRules.e) && this.A.j() < (double)difficultydamagescaler.b() * this.paperConfig().entities.spawning.skeletonHorseThunderSpawnChance.or(0.01) && !this.a_(blockposition.e()).a(Blocks.sN);
            if (flag1 && (entityhorseskeleton = EntityTypes.bg.a(this, EntitySpawnReason.h)) != null) {
                entityhorseskeleton.x(true);
                entityhorseskeleton.c_(0);
                entityhorseskeleton.a_(blockposition.u(), blockposition.v(), blockposition.w());
                this.addFreshEntity(entityhorseskeleton, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            }
            if ((entitylightning = EntityTypes.ax.a(this, EntitySpawnReason.h)) != null) {
                entitylightning.e(Vec3D.c(blockposition));
                entitylightning.a(flag1);
                this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.WEATHER);
            }
        }
        gameprofilerfiller.b("iceandsnow");
        if (!this.paperConfig().environment.disableIceAndSnow) {
            for (int l2 = 0; l2 < randomTickSpeed; ++l2) {
                if (simpleRandom.a(48) != 0) continue;
                this.a(this.a(j2, 0, k2, 15));
            }
        }
        gameprofilerfiller.b("tickBlocks");
        if (randomTickSpeed > 0) {
            this.optimiseRandomTick(chunk, randomTickSpeed);
        }
        gameprofilerfiller.c();
    }

    @VisibleForTesting
    public void a(BlockPosition pos) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, pos);
        BlockPosition blockposition2 = blockposition1.e();
        BiomeBase biomebase = this.t(blockposition1).a();
        if (biomebase.a(this, blockposition2)) {
            CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition2, Blocks.eb.m(), null);
        }
        if (this.af()) {
            BiomeBase.Precipitation biomebase_precipitation;
            int i2 = this.N().c(GameRules.U);
            if (i2 > 0 && biomebase.b(this, blockposition1)) {
                IBlockData iblockdata = this.a_(blockposition1);
                if (iblockdata.a(Blocks.ea)) {
                    int j2 = iblockdata.c(BlockSnow.c);
                    if (j2 < Math.min(i2, 8)) {
                        IBlockData iblockdata1 = (IBlockData)iblockdata.b(BlockSnow.c, j2 + 1);
                        Block.a(iblockdata, iblockdata1, this, blockposition1);
                        CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, iblockdata1, null);
                    }
                } else {
                    CraftEventFactory.handleBlockFormEvent((net.minecraft.world.level.World)this, blockposition1, Blocks.ea.m(), null);
                }
            }
            if ((biomebase_precipitation = biomebase.a(blockposition2, this.O())) != BiomeBase.Precipitation.a) {
                IBlockData iblockdata2 = this.a_(blockposition2);
                iblockdata2.b().a(iblockdata2, (net.minecraft.world.level.World)this, blockposition2, biomebase_precipitation);
            }
        }
    }

    public Optional<BlockPosition> E(BlockPosition pos) {
        Optional<BlockPosition> optional = this.z().e(holder -> holder.a(PoiTypes.t), blockposition1 -> blockposition1.v() == this.a(HeightMap.Type.b, blockposition1.u(), blockposition1.w()) - 1, pos, 128, VillagePlace.Occupancy.c);
        return optional.map(blockposition1 -> blockposition1.b(1));
    }

    protected BlockPosition b(BlockPosition pos) {
        return this.findLightningTargetAround(pos, false);
    }

    public BlockPosition findLightningTargetAround(BlockPosition pos, boolean returnNullWhenNoTarget) {
        BlockPosition blockposition1 = this.a(HeightMap.Type.e, pos);
        Optional<BlockPosition> optional = this.E(blockposition1);
        if (optional.isPresent()) {
            return optional.get();
        }
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(blockposition1, blockposition1.h(this.am() + 1)).g(3.0);
        List<EntityLiving> list = this.a(EntityLiving.class, axisalignedbb, (? super T entityliving) -> entityliving != null && entityliving.bL() && this.h(entityliving.dw()) && !entityliving.aa_());
        if (!list.isEmpty()) {
            return list.get(this.A.a(list.size())).dw();
        }
        if (returnNullWhenNoTarget) {
            return null;
        }
        if (blockposition1.v() == this.L_() - 1) {
            blockposition1 = blockposition1.b(2);
        }
        return blockposition1;
    }

    public boolean d() {
        return this.aa;
    }

    public boolean e() {
        return this.N().c(GameRules.Q) <= 100;
    }

    private void at() {
        if (this.e() && (!this.p().U() || this.p().r())) {
            int i2 = this.N().c(GameRules.Q);
            IChatMutableComponent ichatmutablecomponent = this.Q.a(i2) ? IChatBaseComponent.c("sleep.skipping_night") : IChatBaseComponent.a("sleep.players_sleeping", this.Q.b(), this.Q.b(i2));
            for (EntityPlayer entityplayer : this.I) {
                entityplayer.a(ichatmutablecomponent, true);
            }
        }
    }

    public void f() {
        if (!this.I.isEmpty() && this.Q.a(this.I)) {
            this.at();
        }
    }

    public ScoreboardServer g() {
        return this.K.aJ();
    }

    private void au() {
        int idx;
        boolean flag = this.af();
        if (this.G_().g()) {
            if (this.N().b(GameRules.w)) {
                int i2 = this.L.f();
                int j2 = this.L.h();
                int k2 = this.L.j();
                boolean flag1 = this.B.g();
                boolean flag2 = this.B.i();
                if (i2 > 0) {
                    --i2;
                    j2 = flag1 ? 0 : 1;
                    k2 = flag2 ? 0 : 1;
                    flag1 = false;
                    flag2 = false;
                } else {
                    if (j2 > 0) {
                        if (--j2 == 0) {
                            flag1 = !flag1;
                        }
                    } else {
                        j2 = flag1 ? d.a(this.A) : E.a(this.A);
                    }
                    if (k2 > 0) {
                        if (--k2 == 0) {
                            flag2 = !flag2;
                        }
                    } else {
                        k2 = flag2 ? c.a(this.A) : b.a(this.A);
                    }
                }
                this.L.b(j2);
                this.L.c(k2);
                this.L.a(i2);
                this.L.setThundering(flag1, ThunderChangeEvent.Cause.NATURAL);
                this.L.setRaining(flag2, WeatherChangeEvent.Cause.NATURAL);
            }
            this.y = this.z;
            this.z = this.B.g() ? (this.z += 0.01f) : (this.z -= 0.01f);
            this.z = MathHelper.a(this.z, 0.0f, 1.0f);
            this.w = this.x;
            this.x = this.B.i() ? (this.x += 0.01f) : (this.x -= 0.01f);
            this.x = MathHelper.a(this.x, 0.0f, 1.0f);
        }
        for (idx = 0; idx < this.I.size(); ++idx) {
            if (this.I.get(idx).dW() != this) continue;
            this.I.get(idx).tickWeather();
        }
        if (flag != this.af()) {
            for (idx = 0; idx < this.I.size(); ++idx) {
                if (this.I.get(idx).dW() != this) continue;
                this.I.get(idx).setPlayerWeather(!flag ? WeatherType.DOWNFALL : WeatherType.CLEAR, false);
            }
        }
        for (idx = 0; idx < this.I.size(); ++idx) {
            if (this.I.get(idx).dW() != this) continue;
            this.I.get(idx).updateWeather(this.w, this.x, this.y, this.z);
        }
    }

    @VisibleForTesting
    public void h() {
        this.L.setRaining(false, WeatherChangeEvent.Cause.SLEEP);
        if (!this.L.i()) {
            this.L.c(0);
        }
        this.L.setThundering(false, ThunderChangeEvent.Cause.SLEEP);
        if (!this.L.g()) {
            this.L.b(0);
        }
    }

    public void i() {
        this.R = 0;
    }

    private void a(BlockPosition pos, FluidType fluid) {
        IBlockData iblockdata = this.a_(pos);
        Fluid fluid1 = iblockdata.y();
        if (fluid1.b(fluid)) {
            fluid1.a(this, pos, iblockdata);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.K.moonrise$executeMidTickTasks();
        }
    }

    private void d(BlockPosition pos, Block block) {
        IBlockData iblockdata = this.a_(pos);
        if (iblockdata.a(block)) {
            iblockdata.a(this, pos, this.A);
        }
        if ((++this.tickedBlocksOrFluids & 7L) != 0L) {
            this.K.moonrise$executeMidTickTasks();
        }
    }

    public static List<net.minecraft.world.entity.Entity> getCurrentlyTickingEntities() {
        net.minecraft.world.entity.Entity[] entityArray;
        net.minecraft.world.entity.Entity ticking = currentlyTickingEntity.get();
        if (ticking == null) {
            entityArray = new net.minecraft.world.entity.Entity[]{};
        } else {
            net.minecraft.world.entity.Entity[] entityArray2 = new net.minecraft.world.entity.Entity[1];
            entityArray = entityArray2;
            entityArray2[0] = ticking;
        }
        List<net.minecraft.world.entity.Entity> ret = Arrays.asList(entityArray);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(net.minecraft.world.entity.Entity entity) {
        TickThread.ensureTickThread("Cannot tick an entity off-main");
        try {
            if (currentlyTickingEntity.get() == null) {
                currentlyTickingEntity.lazySet(entity);
            }
            entity.bz();
            GameProfilerFiller gameprofilerfiller = Profiler.a();
            ++entity.af;
            gameprofilerfiller.a(() -> BuiltInRegistries.f.b(entity.aq()).toString());
            gameprofilerfiller.f("tickNonPassenger");
            boolean isActive = ActivationRange.checkIfActive(entity);
            if (isActive) {
                entity.h();
                entity.postTick();
            } else {
                entity.inactiveTick();
            }
            gameprofilerfiller.c();
            for (net.minecraft.world.entity.Entity entity1 : entity.cZ()) {
                this.tickPassenger(entity, entity1, isActive);
            }
        }
        finally {
            if (currentlyTickingEntity.get() == entity) {
                currentlyTickingEntity.lazySet(null);
            }
        }
    }

    private void tickPassenger(net.minecraft.world.entity.Entity vehicle, net.minecraft.world.entity.Entity passenger, boolean isActive) {
        if (!passenger.dR() && passenger.dl() == vehicle) {
            if (passenger instanceof EntityHuman || this.N.c(passenger)) {
                passenger.bz();
                ++passenger.af;
                GameProfilerFiller gameprofilerfiller = Profiler.a();
                gameprofilerfiller.a(() -> BuiltInRegistries.f.b(passenger.aq()).toString());
                gameprofilerfiller.f("tickPassenger");
                if (isActive) {
                    passenger.r();
                    passenger.postTick();
                } else {
                    passenger.h(Vec3D.c);
                    passenger.inactiveTick();
                    vehicle.j(passenger);
                }
                gameprofilerfiller.c();
                for (net.minecraft.world.entity.Entity entity2 : passenger.cZ()) {
                    this.tickPassenger(passenger, entity2, isActive);
                }
            }
        } else {
            passenger.ae();
        }
    }

    @Override
    public boolean a(EntityHuman player, BlockPosition pos) {
        return !this.K.a(this, pos, player) && this.F_().a(pos);
    }

    public void saveIncrementally(boolean doFull) {
        ChunkProviderServer chunkproviderserver = this.m();
        if (doFull) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
        }
        if (doFull) {
            this.b(true);
        }
        if (doFull) {
            WorldServer worldserver1 = this;
            this.L.a(worldserver1.F_().t());
            this.L.a(this.K.aM().a(this.K_()));
            this.convertable.a(this.K.ba(), this.L, this.K.ag().r());
        }
    }

    public void a(@Nullable IProgressUpdate progressListener, boolean flush, boolean savingDisabled) {
        this.save(progressListener, flush, savingDisabled, false);
    }

    public void save(@Nullable IProgressUpdate progressListener, boolean flush, boolean savingDisabled, boolean close) {
        ChunkProviderServer chunkproviderserver = this.m();
        if (!savingDisabled) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((World)this.getWorld()));
            if (progressListener != null) {
                progressListener.a(IChatBaseComponent.c("menu.savingLevel"));
            }
            this.b(flush);
            if (progressListener != null) {
                progressListener.c(IChatBaseComponent.c("menu.savingChunks"));
            }
            if (!close) {
                chunkproviderserver.a(flush);
            }
        }
        if (close) {
            try {
                chunkproviderserver.close(!savingDisabled);
            }
            catch (IOException never) {
                throw new RuntimeException(never);
            }
        }
        WorldServer worldserver1 = this;
        this.L.a(worldserver1.F_().t());
        this.L.a(this.K.aM().a(this.K_()));
        this.convertable.a(this.K.ba(), this.L, this.K.ag().r());
    }

    private void b(boolean flush) {
        if (this.ac != null) {
            this.L.a(this.ac.b());
        }
        WorldPersistentData worldpersistentdata = this.m().k();
        if (flush) {
            worldpersistentdata.b();
        } else {
            worldpersistentdata.a();
        }
    }

    public <T extends net.minecraft.world.entity.Entity> List<? extends T> a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.a(filter, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate, List<? super T> result) {
        this.a(filter, predicate, result, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void a(EntityTypeTest<net.minecraft.world.entity.Entity, T> filter, Predicate<? super T> predicate, List<? super T> result, int limit) {
        this.G().a(filter, (U entity) -> {
            if (predicate.test(entity)) {
                result.add((Object)entity);
                if (result.size() >= limit) {
                    return AbortableIterationConsumer.a.b;
                }
            }
            return AbortableIterationConsumer.a.a;
        });
    }

    public List<? extends EntityEnderDragon> j() {
        return this.a(EntityTypes.Q, EntityLiving::bL);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate) {
        return this.a(predicate, Integer.MAX_VALUE);
    }

    public List<EntityPlayer> a(Predicate<? super EntityPlayer> predicate, int limit) {
        ArrayList list = Lists.newArrayList();
        for (EntityPlayer entityplayer : this.I) {
            if (!predicate.test(entityplayer)) continue;
            list.add(entityplayer);
            if (list.size() < limit) continue;
            return list;
        }
        return list;
    }

    @Nullable
    public EntityPlayer k() {
        List<EntityPlayer> list = this.a(EntityLiving::bL);
        return list.isEmpty() ? null : list.get(this.A.a(list.size()));
    }

    @Override
    public boolean b(net.minecraft.world.entity.Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public boolean c(net.minecraft.world.entity.Entity entity) {
        return this.addWithUUID(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean addWithUUID(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return this.addEntity(entity, reason);
    }

    public void d(net.minecraft.world.entity.Entity entity) {
        this.addDuringTeleport(entity, null);
    }

    public void addDuringTeleport(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.c(entityplayer);
        } else {
            this.addEntity(entity, reason);
        }
    }

    public void a(EntityPlayer player) {
        this.c(player);
    }

    public void b(EntityPlayer player) {
        this.c(player);
    }

    private void c(EntityPlayer player) {
        net.minecraft.world.entity.Entity entity = this.G().a(player.cG());
        if (entity != null) {
            F.warn("Force-added player with duplicate UUID {}", (Object)player.cG());
            entity.ao();
            this.a((EntityPlayer)entity, Entity.RemovalReason.b);
        }
        this.moonrise$getEntityLookup().addNewEntity(player);
    }

    private boolean addEntity(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityItem itemEntity;
        AsyncCatcher.catchOp("entity add");
        entity.generation = false;
        if (entity.valid) {
            MinecraftServer.l.error("Attempted Double World add on {}", (Object)entity, (Object)new Throwable());
            return true;
        }
        if (entity.spawnReason == null) {
            entity.spawnReason = spawnReason;
        }
        if (entity.dR()) {
            return false;
        }
        if (entity instanceof EntityItem && (itemEntity = (EntityItem)entity).l().f()) {
            return false;
        }
        if (this.captureDrops != null && entity instanceof EntityItem) {
            this.captureDrops.add((EntityItem)entity);
            return true;
        }
        if (spawnReason != null && !CraftEventFactory.doEntityAddEventCalling(this, entity, spawnReason)) {
            return false;
        }
        return this.moonrise$getEntityLookup().addNewEntity(entity);
    }

    public boolean e(net.minecraft.world.entity.Entity entity) {
        return this.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public boolean tryAddFreshEntityWithPassengers(net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        if (entity.db().map(net.minecraft.world.entity.Entity::cG).anyMatch(this.moonrise$getEntityLookup()::hasEntity)) {
            return false;
        }
        this.addFreshEntityWithPassengers(entity, reason);
        return true;
    }

    public void a(Chunk chunk) {
        for (TileEntity tileentity : chunk.I().values()) {
            if (!(tileentity instanceof IInventory)) continue;
            for (HumanEntity h2 : Lists.newArrayList(((IInventory)((Object)tileentity)).getViewers())) {
                ((CraftHumanEntity)h2).getHandle().closeUnloadedInventory(InventoryCloseEvent.Reason.UNLOADED);
            }
        }
        chunk.J();
        chunk.c(this);
    }

    public void a(EntityPlayer player, Entity.RemovalReason reason) {
        player.remove(reason, null);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning) {
        return this.strikeLightning(entitylightning, LightningStrikeEvent.Cause.UNKNOWN);
    }

    public boolean strikeLightning(net.minecraft.world.entity.Entity entitylightning, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent lightning = CraftEventFactory.callLightningStrikeEvent((LightningStrike)entitylightning.getBukkitEntity(), cause);
        if (lightning.isCancelled()) {
            return false;
        }
        return this.b(entitylightning);
    }

    @Override
    public void a(int entityId, BlockPosition pos, int progress) {
        Iterator<EntityPlayer> iterator = this.K.ag().t().iterator();
        EntityHuman entityhuman = null;
        net.minecraft.world.entity.Entity entity = this.a(entityId);
        if (entity instanceof EntityHuman) {
            entityhuman = (EntityHuman)entity;
        }
        if (entity != null) {
            float progressFloat = (float)MathHelper.a(progress, 0, 10) / 10.0f;
            CraftBlock bukkitBlock = CraftBlock.at(this, pos);
            new BlockBreakProgressUpdateEvent((org.bukkit.block.Block)bukkitBlock, progressFloat, (Entity)entity.getBukkitEntity()).callEvent();
        }
        while (iterator.hasNext()) {
            EntityPlayer entityplayer = iterator.next();
            if (entityplayer == null || entityplayer.dW() != this || entityplayer.ar() == entityId) continue;
            double d0 = (double)pos.u() - entityplayer.dB();
            double d1 = (double)pos.v() - entityplayer.dD();
            double d2 = (double)pos.w() - entityplayer.dH();
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity()) || !(d0 * d0 + d1 * d1 + d2 * d2 < 1024.0)) continue;
            entityplayer.f.b(new PacketPlayOutBlockBreakAnimation(entityId, pos, progress));
        }
    }

    @Override
    public void a(@Nullable EntityHuman source, double x2, double y2, double z2, Holder<SoundEffect> sound, SoundCategory category, float volume, float pitch, long seed) {
        this.K.ag().a(source, x2, y2, z2, sound.a().a(volume), this.ah(), new PacketPlayOutNamedSoundEffect(sound, category, x2, y2, z2, volume, pitch, seed));
    }

    @Override
    public void a(@Nullable EntityHuman source, net.minecraft.world.entity.Entity entity, Holder<SoundEffect> sound, SoundCategory category, float volume, float pitch, long seed) {
        this.K.ag().a(source, entity.dB(), entity.dD(), entity.dH(), sound.a().a(volume), this.ah(), new PacketPlayOutEntitySound(sound, category, entity, volume, pitch, seed));
    }

    @Override
    public void b(int eventId, BlockPosition pos, int data) {
        if (this.N().b(GameRules.X)) {
            this.K.ag().t().forEach(entityplayer -> {
                Vec3D vec3d;
                if (entityplayer.dW() == this) {
                    Vec3D vec3d1 = Vec3D.b(pos);
                    if (entityplayer.f(vec3d1) < (double)MathHelper.h(32)) {
                        vec3d = vec3d1;
                    } else {
                        Vec3D vec3d2 = vec3d1.d(entityplayer.du()).d();
                        vec3d = entityplayer.du().e(vec3d2.c(32.0));
                    }
                } else {
                    vec3d = entityplayer.du();
                }
                entityplayer.f.b(new PacketPlayOutWorldEvent(eventId, BlockPosition.a(vec3d), data, true));
            });
        } else {
            this.a((EntityHuman)null, eventId, pos, data);
        }
    }

    @Override
    public void a(@Nullable EntityHuman player, int eventId, BlockPosition pos, int data) {
        this.K.ag().a(player, pos.u(), pos.v(), pos.w(), 64.0, this.ah(), new PacketPlayOutWorldEvent(eventId, pos, data, false));
    }

    public int l() {
        return this.G_().p();
    }

    @Override
    public void a(Holder<GameEvent> event, Vec3D emitterPos, GameEvent.a emitter) {
        if (this.getChunkIfLoadedImmediately(MathHelper.a(emitterPos.d) >> 4, MathHelper.a(emitterPos.f) >> 4) == null) {
            return;
        }
        this.P.a(event, emitterPos, emitter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BlockPosition pos, IBlockData oldState, IBlockData newState, int flags) {
        VoxelShape voxelshape1;
        VoxelShape voxelshape;
        if (this.X) {
            String s2 = "recursive call to sendBlockUpdated";
            SystemUtils.a("recursive call to sendBlockUpdated", (Throwable)new IllegalStateException("recursive call to sendBlockUpdated"));
        }
        this.m().a(pos);
        this.V.a(pos);
        if (this.paperConfig().misc.updatePathfindingOnBlockUpdate && VoxelShapes.c(voxelshape = oldState.g(this, pos), voxelshape1 = newState.g(this, pos), OperatorBoolean.g)) {
            ObjectArrayList list = new ObjectArrayList();
            Iterator<EntityInsentient> iterator = this.W.iterator();
            while (iterator.hasNext()) {
                EntityInsentient entityinsentient;
                try {
                    entityinsentient = iterator.next();
                }
                catch (ConcurrentModificationException ex) {
                    this.a(pos, oldState, newState, flags);
                    return;
                }
                NavigationAbstract navigationabstract = entityinsentient.L();
                if (!navigationabstract.b(pos)) continue;
                list.add(navigationabstract);
            }
            try {
                this.X = true;
                for (NavigationAbstract navigationabstract1 : list) {
                    navigationabstract1.j();
                }
            }
            finally {
                this.X = false;
            }
        }
    }

    @Override
    public void a(BlockPosition pos, Block block) {
        if (this.captureBlockStates) {
            return;
        }
        this.a(pos, block, ExperimentalRedstoneUtils.a(this, null, null));
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock, @Nullable Orientation orientation) {
        if (this.captureBlockStates) {
            return;
        }
        this.t.a(pos, sourceBlock, null, orientation);
    }

    @Override
    public void a(BlockPosition pos, Block sourceBlock, EnumDirection direction, @Nullable Orientation orientation) {
        this.t.a(pos, sourceBlock, direction, orientation);
    }

    @Override
    public void b(BlockPosition pos, Block sourceBlock, @Nullable Orientation orientation) {
        this.t.a(pos, sourceBlock, orientation);
    }

    @Override
    public void a(IBlockData state, BlockPosition pos, Block sourceBlock, @Nullable Orientation orientation, boolean notify) {
        this.t.a(state, pos, sourceBlock, orientation, notify);
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, byte status) {
        this.m().a(entity, new PacketPlayOutEntityStatus(entity, status));
    }

    @Override
    public void a(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
        this.m().a(entity, new ClientboundDamageEventPacket(entity, damageSource));
    }

    public ChunkProviderServer m() {
        return this.J;
    }

    @Override
    public void a(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator behavior, double x2, double y2, double z2, float power, boolean createFire, World.a explosionSourceType, ParticleParam smallParticle, ParticleParam largeParticle, Holder<SoundEffect> soundEvent) {
        this.explode0(entity, damageSource, behavior, x2, y2, z2, power, createFire, explosionSourceType, smallParticle, largeParticle, soundEvent);
    }

    public ServerExplosion explode0(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, World.a world_a, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        return this.explode0(entity, damagesource, explosiondamagecalculator, d0, d1, d2, f2, flag, world_a, particleparam, particleparam1, holder, null);
    }

    public ServerExplosion explode0(@Nullable net.minecraft.world.entity.Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, World.a world_a, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder, Consumer<ServerExplosion> configurator) {
        Explosion.Effect explosion_effect1 = switch (world_a) {
            case World.a.a -> Explosion.Effect.a;
            case World.a.b -> this.a(GameRules.R);
            case World.a.c -> this.N().b(GameRules.c) ? this.a(GameRules.S) : Explosion.Effect.a;
            case World.a.d -> this.a(GameRules.T);
            case World.a.e -> Explosion.Effect.d;
            case World.a.STANDARD -> Explosion.Effect.b;
            default -> throw new MatchException(null, null);
        };
        Vec3D vec3d = new Vec3D(d0, d1, d2);
        ServerExplosion serverexplosion = new ServerExplosion(this, entity, damagesource, explosiondamagecalculator, vec3d, f2, flag, explosion_effect1);
        if (configurator != null) {
            configurator.accept(serverexplosion);
        }
        serverexplosion.i();
        if (serverexplosion.wasCanceled) {
            return serverexplosion;
        }
        ParticleParam particleparam2 = serverexplosion.k() ? particleparam : particleparam1;
        for (EntityPlayer entityplayer : this.I) {
            if (!(entityplayer.f(vec3d) < 4096.0)) continue;
            Optional<Vec3D> optional = Optional.ofNullable(serverexplosion.j().get(entityplayer));
            entityplayer.f.b(new PacketPlayOutExplosion(vec3d, optional, particleparam2, holder));
        }
        return serverexplosion;
    }

    private Explosion.Effect a(GameRules.GameRuleKey<GameRules.GameRuleBoolean> decayRule) {
        return this.N().b(decayRule) ? Explosion.Effect.c : Explosion.Effect.b;
    }

    @Override
    public void a(BlockPosition pos, Block block, int type, int data) {
        this.Y.add((Object)new BlockActionData(pos, block, type, data));
    }

    private void av() {
        this.Z.clear();
        while (!this.Y.isEmpty()) {
            BlockActionData blockactiondata = (BlockActionData)this.Y.removeFirst();
            if (this.n(blockactiondata.a())) {
                if (!this.a(blockactiondata)) continue;
                this.K.ag().a(null, blockactiondata.a().u(), blockactiondata.a().v(), blockactiondata.a().w(), 64.0, this.ah(), new PacketPlayOutBlockAction(blockactiondata.a(), blockactiondata.b(), blockactiondata.c(), blockactiondata.d()));
                continue;
            }
            this.Z.add(blockactiondata);
        }
        this.Y.addAll(this.Z);
    }

    private boolean a(BlockActionData event) {
        IBlockData iblockdata = this.a_(event.a());
        return iblockdata.a(event.b()) ? iblockdata.a((net.minecraft.world.level.World)this, event.a(), event.c(), event.d()) : false;
    }

    public TickListServer<Block> n() {
        return this.T;
    }

    public TickListServer<FluidType> o() {
        return this.U;
    }

    @Override
    @Nonnull
    public MinecraftServer p() {
        return this.K;
    }

    public PortalTravelAgent q() {
        return this.S;
    }

    public StructureTemplateManager r() {
        return this.K.aY();
    }

    public <T extends ParticleParam> int a(T particle, double x2, double y2, double z2, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        return this.sendParticles(null, particle, x2, y2, z2, count, deltaX, deltaY, deltaZ, speed, false);
    }

    public <T extends ParticleParam> int sendParticles(EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        return this.sendParticles(this.I, sender, t0, d0, d1, d2, i2, d3, d4, d5, d6, force);
    }

    public <T extends ParticleParam> int sendParticles(List<EntityPlayer> receivers, @Nullable EntityPlayer sender, T t0, double d0, double d1, double d2, int i2, double d3, double d4, double d5, double d6, boolean force) {
        PacketPlayOutWorldParticles packetplayoutworldparticles = new PacketPlayOutWorldParticles(t0, force, d0, d1, d2, (float)d3, (float)d4, (float)d5, (float)d6, i2);
        int j2 = 0;
        for (EntityHuman entityHuman : receivers) {
            EntityPlayer entityplayer = (EntityPlayer)entityHuman;
            if (sender != null && !entityplayer.getBukkitEntity().canSee(sender.getBukkitEntity()) || !this.a(entityplayer, force, d0, d1, d2, packetplayoutworldparticles)) continue;
            ++j2;
        }
        return j2;
    }

    public <T extends ParticleParam> boolean a(EntityPlayer viewer, T particle, boolean force, double x2, double y2, double z2, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        PacketPlayOutWorldParticles packet = new PacketPlayOutWorldParticles(particle, force, x2, y2, z2, (float)deltaX, (float)deltaY, (float)deltaZ, (float)speed, count);
        return this.a(viewer, force, x2, y2, z2, packet);
    }

    private boolean a(EntityPlayer player, boolean force, double x2, double y2, double z2, Packet<?> packet) {
        if (player.dW() != this) {
            return false;
        }
        BlockPosition blockposition = player.dw();
        if (blockposition.a(new Vec3D(x2, y2, z2), force ? 512.0 : 32.0)) {
            player.f.b(packet);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public net.minecraft.world.entity.Entity a(int id) {
        return this.G().a(id);
    }

    @Deprecated
    @Nullable
    public net.minecraft.world.entity.Entity b(int id) {
        net.minecraft.world.entity.Entity entity = this.G().a(id);
        return entity != null ? entity : (net.minecraft.world.entity.Entity)this.ad.get(id);
    }

    @Nullable
    public net.minecraft.world.entity.Entity a(UUID uuid) {
        return this.G().a(uuid);
    }

    @Nullable
    public BlockPosition a(TagKey<Structure> structureTag, BlockPosition pos, int radius, boolean skipReferencedStructures) {
        if (!this.L.y().d()) {
            return null;
        }
        Optional optional = this.K_().e(Registries.aU).a(structureTag);
        if (optional.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<Structure>> pair = this.m().g().a(this, (HolderSet)optional.get(), pos, radius, skipReferencedStructures);
        return pair != null ? (BlockPosition)pair.getFirst() : null;
    }

    @Nullable
    public Pair<BlockPosition, Holder<BiomeBase>> a(Predicate<Holder<BiomeBase>> predicate, BlockPosition pos, int radius, int horizontalBlockCheckInterval, int verticalBlockCheckInterval) {
        return this.m().g().d().a(pos, radius, horizontalBlockCheckInterval, verticalBlockCheckInterval, predicate, this.m().i().b(), this);
    }

    public CraftingManager s() {
        return this.K.aI();
    }

    @Override
    public TickRateManager t() {
        return this.K.aP();
    }

    @Override
    public boolean u() {
        return this.e;
    }

    public WorldPersistentData v() {
        return this.m().k();
    }

    @Override
    @Nullable
    public WorldMap a(MapId id) {
        WorldPersistentData storage = this.p().J().v();
        Optional<PersistentBase> cacheEntry = storage.b.get(id.a());
        if (cacheEntry == null) {
            WorldMap worldmap = storage.b(WorldMap.a(), id.a());
            if (worldmap != null) {
                worldmap.id = id;
                new MapInitializeEvent((MapView)worldmap.mapView).callEvent();
                return worldmap;
            }
            return null;
        }
        Object var5_6 = cacheEntry.orElse(null);
        if (var5_6 instanceof WorldMap) {
            WorldMap mapItemSavedData = var5_6;
            mapItemSavedData.id = id;
            return mapItemSavedData;
        }
        return null;
    }

    @Override
    public void a(MapId id, WorldMap state) {
        state.id = id;
        MapInitializeEvent event = new MapInitializeEvent((MapView)state.mapView);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        this.p().J().v().a(id.a(), state);
    }

    @Override
    public MapId w() {
        return this.p().J().v().a(PersistentIdCounts.a(), "idcounts").b();
    }

    public void a(BlockPosition pos, float angle) {
        int i2;
        BlockPosition blockposition1 = this.B.a();
        float f1 = this.B.b();
        if (!blockposition1.equals(pos) || f1 != angle) {
            Location prevSpawnLoc = this.getWorld().getSpawnLocation();
            this.B.a(pos, angle);
            new SpawnChangeEvent((World)this.getWorld(), prevSpawnLoc).callEvent();
            this.p().ag().a(new PacketPlayOutSpawnPosition(pos, angle));
        }
        if (this.M > 1) {
            for (ChunkCoordIntPair chunkPos : MCUtil.getSpiralOutChunks(blockposition1, this.M - 2)) {
                this.m().removeTicketAtLevel(TicketType.a, chunkPos, 31, Unit.a);
            }
        }
        if ((i2 = this.N().c(GameRules.ab) + 1) > 1) {
            for (ChunkCoordIntPair chunkPos : MCUtil.getSpiralOutChunks(pos, i2 - 2)) {
                this.m().addTicketAtLevel(TicketType.a, chunkPos, 31, Unit.a);
            }
        }
        this.M = i2;
    }

    public LongSet x() {
        ForcedChunk forcedchunk = this.v().b(ForcedChunk.a(), "chunks");
        return forcedchunk != null ? LongSets.unmodifiable((LongSet)forcedchunk.b()) : LongSets.EMPTY_SET;
    }

    public boolean a(int x2, int z2, boolean forced) {
        boolean flag1;
        ForcedChunk forcedchunk = this.v().a(ForcedChunk.a(), "chunks");
        ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(x2, z2);
        long k2 = chunkcoordintpair.a();
        if (forced) {
            flag1 = forcedchunk.b().add(k2);
            if (flag1) {
                this.d(x2, z2);
            }
        } else {
            flag1 = forcedchunk.b().remove(k2);
        }
        forcedchunk.a(flag1);
        if (flag1) {
            this.m().a(chunkcoordintpair, forced);
        }
        return flag1;
    }

    public List<EntityPlayer> y() {
        return this.I;
    }

    @Override
    public void a(BlockPosition pos, IBlockData oldBlock, IBlockData newBlock) {
        Optional<Holder<VillagePlaceType>> optional1;
        Optional<Holder<VillagePlaceType>> optional = PoiTypes.a(oldBlock);
        if (!Objects.equals(optional, optional1 = PoiTypes.a(newBlock))) {
            BlockPosition blockposition1 = pos.j();
            optional.ifPresent(holder -> this.p().execute(() -> {
                this.z().a(blockposition1);
                PacketDebug.b(this, blockposition1);
            }));
            optional1.ifPresent(holder -> this.p().execute(() -> {
                if (optional.isEmpty() && this.z().a(blockposition1, (Holder<VillagePlaceType> poiType) -> true)) {
                    this.z().a(blockposition1);
                }
                this.z().a(blockposition1, (Holder<VillagePlaceType>)holder);
                PacketDebug.a(this, blockposition1);
            }));
        }
    }

    public VillagePlace z() {
        return this.m().l();
    }

    public boolean c(BlockPosition pos) {
        return this.a(pos, 1);
    }

    public boolean a(SectionPosition sectionPos) {
        return this.c(sectionPos.k());
    }

    public boolean a(BlockPosition pos, int maxDistance) {
        return maxDistance > 6 ? false : this.b(SectionPosition.a(pos)) <= maxDistance;
    }

    public int b(SectionPosition pos) {
        return this.z().a(pos);
    }

    public PersistentRaid A() {
        return this.f;
    }

    @Nullable
    public Raid d(BlockPosition pos) {
        return this.f.a(pos, 9216);
    }

    public boolean e(BlockPosition pos) {
        return this.d(pos) != null;
    }

    public void a(ReputationEvent interaction, net.minecraft.world.entity.Entity entity, ReputationHandler observer) {
        observer.a(interaction, entity);
    }

    public void a(Path path) throws IOException {
        Path path2;
        BufferedWriter bufferedwriter3;
        PlayerChunkMap playerchunkmap = this.m().a;
        try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "spawning_chunks: %d\n", playerchunkmap.j().b()));
            SpawnerCreature.d spawnercreature_d = this.m().n();
            if (spawnercreature_d != null) {
                for (Object2IntMap.Entry entry : spawnercreature_d.b().object2IntEntrySet()) {
                    bufferedwriter.write(String.format(Locale.ROOT, "spawn_count.%s: %d\n", ((EnumCreatureType)entry.getKey()).a(), entry.getIntValue()));
                }
            }
            bufferedwriter.write(String.format(Locale.ROOT, "entities: %s\n", this.moonrise$getEntityLookup().getDebugInfo()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_entity_tickers: %d\n", this.s.size()));
            bufferedwriter.write(String.format(Locale.ROOT, "block_ticks: %d\n", this.n().a()));
            bufferedwriter.write(String.format(Locale.ROOT, "fluid_ticks: %d\n", this.o().a()));
            bufferedwriter.write("distance_manager: " + playerchunkmap.j().d() + "\n");
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.m().f()));
        }
        CrashReport crashreport = new CrashReport("Level dump", new Exception("dummy"));
        this.a(crashreport);
        try (BufferedWriter bufferedwriter1 = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);){
            bufferedwriter1.write(crashreport.a(ReportType.c));
        }
        Path path1 = path.resolve("chunks.csv");
        BufferedWriter bufferedwriter2 = Files.newBufferedWriter(path1, new OpenOption[0]);
        if (bufferedwriter2 != null) {
            bufferedwriter2.close();
        }
        if ((bufferedwriter3 = Files.newBufferedWriter(path2 = path.resolve("entity_chunks.csv"), new OpenOption[0])) != null) {
            bufferedwriter3.close();
        }
        Path path3 = path.resolve("entities.csv");
        try (BufferedWriter bufferedwriter4 = Files.newBufferedWriter(path3, new OpenOption[0]);){
            WorldServer.a(bufferedwriter4, this.G().a());
        }
        Path path4 = path.resolve("block_entities.csv");
        try (BufferedWriter bufferedwriter5 = Files.newBufferedWriter(path4, new OpenOption[0]);){
            this.a(bufferedwriter5);
        }
    }

    private static void a(Writer writer, Iterable<net.minecraft.world.entity.Entity> entities) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("uuid").a("type").a("alive").a("display_name").a("custom_name").a(writer);
        for (net.minecraft.world.entity.Entity entity : entities) {
            IChatBaseComponent ichatbasecomponent = entity.an();
            IChatBaseComponent ichatbasecomponent1 = entity.p_();
            csvwriter.a(entity.dB(), entity.dD(), entity.dH(), entity.cG(), BuiltInRegistries.f.b(entity.aq()), entity.bL(), ichatbasecomponent1.getString(), ichatbasecomponent != null ? ichatbasecomponent.getString() : null);
        }
    }

    private void a(Writer writer) throws IOException {
        CSVWriter csvwriter = CSVWriter.a().a("x").a("y").a("z").a("type").a(writer);
        for (TickingBlockEntity tickingblockentity : this.s) {
            BlockPosition blockposition = tickingblockentity.c();
            csvwriter.a(blockposition.u(), blockposition.v(), blockposition.w(), tickingblockentity.d());
        }
    }

    @VisibleForTesting
    public void a(StructureBoundingBox box) {
        this.Y.removeIf(blockactiondata -> box.b(blockactiondata.a()));
    }

    @Override
    public void b(BlockPosition pos, Block block) {
        if (!this.ai()) {
            if (this.populating) {
                return;
            }
            this.a(pos, block);
        }
    }

    @Override
    public float a(EnumDirection direction, boolean shaded) {
        return 1.0f;
    }

    public Iterable<net.minecraft.world.entity.Entity> B() {
        return this.G().a();
    }

    public String toString() {
        return "ServerLevel[" + this.L.e() + "]";
    }

    public boolean C() {
        return this.L.z();
    }

    @Override
    public long D() {
        return this.L.y().c();
    }

    @Nullable
    public EnderDragonBattle E() {
        return this.ac;
    }

    @Override
    public WorldServer a() {
        return this;
    }

    @VisibleForTesting
    public String F() {
        return String.format(Locale.ROOT, "players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.I.size(), this.moonrise$getEntityLookup().getDebugInfo(), WorldServer.a(this.moonrise$getEntityLookup().a(), (T entity) -> BuiltInRegistries.f.b(entity.aq()).toString()), this.s.size(), WorldServer.a(this.s, TickingBlockEntity::d), this.n().a(), this.o().a(), this.I());
    }

    private static <T> String a(Iterable<T> items, Function<T, String> classifier) {
        try {
            Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
            for (T t0 : items) {
                String s2 = classifier.apply(t0);
                object2intopenhashmap.addTo((Object)s2, 1);
            }
            return object2intopenhashmap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(entry -> {
                String s1 = (String)entry.getKey();
                return s1 + ":" + entry.getIntValue();
            }).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public LevelEntityGetter<net.minecraft.world.entity.Entity> G() {
        AsyncCatcher.catchOp("Chunk getEntities call");
        return this.moonrise$getEntityLookup();
    }

    public void a(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addLegacyChunkEntities(entities, null);
    }

    public void addLegacyChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkCoordIntPair chunkPos) {
        this.moonrise$getEntityLookup().addLegacyChunkEntities(entities.toList(), chunkPos);
    }

    public void b(Stream<net.minecraft.world.entity.Entity> entities) {
        this.addWorldGenChunkEntities(entities, null);
    }

    public void addWorldGenChunkEntities(Stream<net.minecraft.world.entity.Entity> entities, ChunkCoordIntPair chunkPos) {
        this.moonrise$getEntityLookup().addWorldGenChunkEntities(entities.toList(), chunkPos);
    }

    public void b(Chunk chunk) {
        chunk.d(this.D_().c());
    }

    public void a(IChunkAccess chunk) {
        this.K.execute(() -> this.af.a(chunk.f(), chunk.g()));
    }

    public PathTypeCache H() {
        return this.V;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String I() {
        String s2 = this.J.e();
        return "Chunks[S] W: " + s2 + " E: " + this.moonrise$getEntityLookup().getDebugInfo();
    }

    public boolean c(long chunkPos) {
        return this.moonrise$getAnyChunkIfLoaded(CoordinateUtils.getChunkX(chunkPos), CoordinateUtils.getChunkZ(chunkPos)) != null;
    }

    private boolean d(long chunkPos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkPos);
        return chunkHolder != null && chunkHolder.isTickingReady();
    }

    public boolean f(BlockPosition pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean g(BlockPosition pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    public boolean a(ChunkCoordIntPair pos) {
        NewChunkHolder chunkHolder = this.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(pos));
        return chunkHolder != null && chunkHolder.isEntityTickingReady();
    }

    @Override
    public FeatureFlagSet J() {
        return this.K.aZ().K();
    }

    @Override
    public PotionBrewer K() {
        return this.K.bn();
    }

    @Override
    public FuelValues L() {
        return this.K.bo();
    }

    public RandomSource a(MinecraftKey id) {
        return this.ah.a(id);
    }

    public RandomSequences M() {
        return this.ah;
    }

    public GameRules N() {
        return this.L.o();
    }

    public List<EntityPlayer> getPlayersForGlobalSoundGamerule() {
        return this.N().b(GameRules.X) ? this.p().ag().l : this.y();
    }

    public double getGlobalSoundRangeSquared(Function<SpigotWorldConfig, Integer> rangeFunction) {
        double range = rangeFunction.apply(this.spigotConfig).intValue();
        return range <= 0.0 ? 4096.0 : range * range;
    }

    public void checkCapturedTreeStateForObserverNotify(BlockPosition pos, CraftBlockState craftBlockState) {
        if (craftBlockState.getPosition().v() == pos.v() && this.a_(craftBlockState.getPosition()) == craftBlockState.getHandle()) {
            this.notifyAndUpdatePhysics(craftBlockState.getPosition(), null, craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getHandle(), craftBlockState.getFlag(), 512);
        }
    }

    @Override
    public CrashReportSystemDetails a(CrashReport report) {
        CrashReportSystemDetails crashreportsystemdetails = super.a(report);
        crashreportsystemdetails.a("Loaded entity count", () -> String.valueOf(this.moonrise$getEntityLookup().getEntityCount()));
        return crashreportsystemdetails;
    }

    @Override
    public int O() {
        return this.J.g().f();
    }

    @Override
    public WireHandler getWireHandler() {
        return this.wireHandler;
    }

    @Override
    @Nullable
    public EntityHuman getGlobalPlayerByUUID(UUID uuid) {
        return this.K.ag().a(uuid);
    }

    private final class a
    implements LevelCallback<net.minecraft.world.entity.Entity> {
        a() {
        }

        @Override
        public void a(net.minecraft.world.entity.Entity entity) {
        }

        @Override
        public void b(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.g().a(entity);
        }

        @Override
        public void c(net.minecraft.world.entity.Entity entity) {
            if (entity instanceof Marker && !WorldServer.this.paperConfig().entities.markers.tick) {
                return;
            }
            WorldServer.this.N.a(entity);
        }

        @Override
        public void d(net.minecraft.world.entity.Entity entity) {
            WorldServer.this.N.b(entity);
            if (WorldServer.this.paperConfig().fixes.disableUnloadedChunkEnderpearlExploit && WorldServer.this.paperConfig().misc.legacyEnderPearlBehavior && entity instanceof EntityEnderPearl) {
                EntityEnderPearl pearl = (EntityEnderPearl)entity;
                pearl.b = null;
                ((IProjectile)pearl).a = null;
            }
        }

        @Override
        public void e(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity register");
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.I.add(entityplayer);
                WorldServer.this.f();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                WorldServer.this.W.add(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.x()) {
                    WorldServer.this.ad.put(entitycomplexpart.ar(), (Object)entitycomplexpart);
                }
            }
            entity.a(DynamicGameEventListener::a);
            entity.inWorld = true;
            entity.valid = true;
            WorldServer.this.m().b(entity);
            if (entity.getOriginVector() == null) {
                entity.setOrigin(entity.getBukkitEntity().getLocation());
            }
            if (entity.getOriginWorld() == null) {
                entity.setOrigin(entity.getOriginVector().toLocation((World)WorldServer.this.getWorld()));
            }
            new EntityAddToWorldEvent((Entity)entity.getBukkitEntity(), (World)WorldServer.this.getWorld()).callEvent();
        }

        @Override
        public void f(net.minecraft.world.entity.Entity entity) {
            AsyncCatcher.catchOp("entity unregister");
            if (entity instanceof EntityHuman) {
                Streams.stream(WorldServer.this.p().L()).map(WorldServer::v).forEach(worldData -> {
                    for (Optional<PersistentBase> o2 : worldData.b.values()) {
                        if (!(o2 instanceof WorldMap)) continue;
                        WorldMap map = (WorldMap)((Object)o2);
                        map.p.remove((EntityHuman)entity);
                        Iterator<WorldMap.WorldMapHumanTracker> iter = map.o.iterator();
                        while (iter.hasNext()) {
                            if (iter.next().a != entity) continue;
                            map.r.remove(entity.al().getString());
                            iter.remove();
                        }
                    }
                });
            }
            if (entity.getBukkitEntity() instanceof InventoryHolder && (!(entity instanceof EntityPlayer) || entity.dS() != Entity.RemovalReason.a)) {
                Object merchant;
                CraftEntity craftEntity = entity.getBukkitEntity();
                if (craftEntity instanceof Merchant && (merchant = (Merchant)craftEntity).getTrader() != null) {
                    merchant.getTrader().closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
                for (HumanEntity h2 : Lists.newArrayList((Iterable)((InventoryHolder)entity.getBukkitEntity()).getInventory().getViewers())) {
                    h2.closeInventory(InventoryCloseEvent.Reason.UNLOADED);
                }
            }
            WorldServer.this.m().a(entity);
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                WorldServer.this.I.remove(entityplayer);
                WorldServer.this.f();
            }
            if (entity instanceof EntityInsentient) {
                EntityInsentient entityinsentient = (EntityInsentient)entity;
                WorldServer.this.W.remove(entityinsentient);
            }
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon entityenderdragon = (EntityEnderDragon)entity;
                for (EntityComplexPart entitycomplexpart : entityenderdragon.x()) {
                    WorldServer.this.ad.remove(entitycomplexpart.ar());
                }
            }
            entity.a(DynamicGameEventListener::b);
            entity.valid = false;
            if (!(entity instanceof EntityPlayer)) {
                for (EntityPlayer player : WorldServer.this.K.ag().l) {
                    player.getBukkitEntity().onEntityRemove(entity);
                }
            }
            new EntityRemoveFromWorldEvent((Entity)entity.getBukkitEntity(), (World)WorldServer.this.getWorld()).callEvent();
        }

        @Override
        public void g(net.minecraft.world.entity.Entity entity) {
            entity.a(DynamicGameEventListener::c);
        }
    }
}

