/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.util.ChatDeserializer;

public class LegacyTextFilter
extends ServerTextFilter {
    private static final String b = "v1/chat";
    final URL c;
    final a d;
    final URL e;
    final a f;
    private final String g;

    private LegacyTextFilter(URL chatEndpoint, ServerTextFilter.b messageEncoder, URL joinEndpoint, a joinEncoder, URL leaveEndpoint, a leaveEncoder, String apiKey, ServerTextFilter.a ignorer, ExecutorService threadPool) {
        super(chatEndpoint, messageEncoder, ignorer, threadPool);
        this.c = joinEndpoint;
        this.d = joinEncoder;
        this.e = leaveEndpoint;
        this.f = leaveEncoder;
        this.g = apiKey;
    }

    @Nullable
    public static ServerTextFilter a(String config) {
        try {
            ServerTextFilter.b messageEncoder2;
            JsonObject jsonObject = ChatDeserializer.a(config);
            URI uRI = new URI(ChatDeserializer.i(jsonObject, "apiServer"));
            String string = ChatDeserializer.i(jsonObject, "apiKey");
            if (string.isEmpty()) {
                throw new IllegalArgumentException("Missing API key");
            }
            int i2 = ChatDeserializer.a(jsonObject, "ruleId", 1);
            String string2 = ChatDeserializer.a(jsonObject, "serverId", "");
            String string3 = ChatDeserializer.a(jsonObject, "roomId", "Java:Chat");
            int j2 = ChatDeserializer.a(jsonObject, "hashesToDrop", -1);
            int k2 = ChatDeserializer.a(jsonObject, "maxConcurrentRequests", 7);
            JsonObject jsonObject2 = ChatDeserializer.a(jsonObject, "endpoints", null);
            String string4 = LegacyTextFilter.a(jsonObject2, "chat", b);
            boolean bl = string4.equals(b);
            URL uRL = uRI.resolve("/" + string4).toURL();
            URL uRL2 = LegacyTextFilter.a(uRI, jsonObject2, "join", "v1/join");
            URL uRL3 = LegacyTextFilter.a(uRI, jsonObject2, "leave", "v1/leave");
            a joinOrLeaveEncoder = profile -> {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("server", string2);
                jsonObject.addProperty("room", string3);
                jsonObject.addProperty("user_id", profile.getId().toString());
                jsonObject.addProperty("user_display_name", profile.getName());
                return jsonObject;
            };
            if (bl) {
                ServerTextFilter.b messageEncoder = (profile, message) -> {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("rule", (Number)i2);
                    jsonObject.addProperty("server", string2);
                    jsonObject.addProperty("room", string3);
                    jsonObject.addProperty("player", profile.getId().toString());
                    jsonObject.addProperty("player_display_name", profile.getName());
                    jsonObject.addProperty("text", message);
                    jsonObject.addProperty("language", "*");
                    return jsonObject;
                };
            } else {
                String string5 = String.valueOf(i2);
                messageEncoder2 = (profile, message) -> {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("rule_id", string5);
                    jsonObject.addProperty("category", string2);
                    jsonObject.addProperty("subcategory", string3);
                    jsonObject.addProperty("user_id", profile.getId().toString());
                    jsonObject.addProperty("user_display_name", profile.getName());
                    jsonObject.addProperty("text", message);
                    jsonObject.addProperty("language", "*");
                    return jsonObject;
                };
            }
            ServerTextFilter.a ignoreStrategy = ServerTextFilter.a.select(j2);
            ExecutorService executorService = LegacyTextFilter.a(k2);
            String string6 = Base64.getEncoder().encodeToString(string.getBytes(StandardCharsets.US_ASCII));
            return new LegacyTextFilter(uRL, messageEncoder2, uRL2, joinOrLeaveEncoder, uRL3, joinOrLeaveEncoder, string6, ignoreStrategy, executorService);
        }
        catch (Exception exception) {
            ServerTextFilter.a.warn("Failed to parse chat filter config {}", (Object)config, (Object)exception);
            return null;
        }
    }

    @Override
    @Override
    public ITextFilter a(GameProfile profile) {
        return new ServerTextFilter.c(profile){

            @Override
            @Override
            public void a() {
                LegacyTextFilter.this.a(this.b, LegacyTextFilter.this.c, LegacyTextFilter.this.d, this.c);
            }

            @Override
            @Override
            public void b() {
                LegacyTextFilter.this.a(this.b, LegacyTextFilter.this.e, LegacyTextFilter.this.f, this.c);
            }
        };
    }

    void a(GameProfile gameProfile, URL endpoint, a profileEncoder, Executor executor) {
        executor.execute(() -> {
            JsonObject jsonObject = profileEncoder.encode(gameProfile);
            try {
                this.b(jsonObject, endpoint);
            }
            catch (Exception exception) {
                ServerTextFilter.a.warn("Failed to send join/leave packet to {} for player {}", new Object[]{endpoint, gameProfile, exception});
            }
        });
    }

    private void b(JsonObject payload, URL endpoint) throws IOException {
        HttpURLConnection httpURLConnection = this.a(payload, endpoint);
        try (InputStream inputStream = httpURLConnection.getInputStream();){
            this.a(inputStream);
        }
    }

    @Override
    @Override
    protected void a(HttpURLConnection connection) {
        connection.setRequestProperty("Authorization", "Basic " + this.g);
    }

    @Override
    @Override
    protected FilteredText a(String raw, ServerTextFilter.a hashIgnorer, JsonObject response) {
        boolean bl = ChatDeserializer.a(response, "response", false);
        if (bl) {
            return FilteredText.a(raw);
        }
        String string = ChatDeserializer.a(response, "hashed", null);
        if (string == null) {
            return FilteredText.b(raw);
        }
        JsonArray jsonArray = ChatDeserializer.v(response, "hashes");
        FilterMask filterMask = this.a(raw, jsonArray, hashIgnorer);
        return new FilteredText(raw, filterMask);
    }

    @FunctionalInterface
    static interface a {
        public JsonObject encode(GameProfile var1);
    }
}

