/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCertificate;
import com.microsoft.aad.msal4j.IClientCredential;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ServerTextFilter;
import net.minecraft.util.ChatDeserializer;

public class PlayerSafetyServiceTextFilter
extends ServerTextFilter {
    private final ConfidentialClientApplication b;
    private final ClientCredentialParameters c;
    private final Set<String> d;
    private final int e;

    private PlayerSafetyServiceTextFilter(URL url, ServerTextFilter.b messageEncoder, ServerTextFilter.a hashIgnorer, ExecutorService threadPool, ConfidentialClientApplication application, ClientCredentialParameters credentialParameters, Set<String> fullyFilteredEvents, int readTimeout) {
        super(url, messageEncoder, hashIgnorer, threadPool);
        this.b = application;
        this.c = credentialParameters;
        this.d = fullyFilteredEvents;
        this.e = readTimeout;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ServerTextFilter a(String response) {
        void confidentialClientApplication2;
        void uRL2;
        JsonObject jsonObject = ChatDeserializer.a(response);
        URI uRI = URI.create(ChatDeserializer.i(jsonObject, "apiServer"));
        String string = ChatDeserializer.i(jsonObject, "apiPath");
        String string2 = ChatDeserializer.i(jsonObject, "scope");
        String string3 = ChatDeserializer.a(jsonObject, "serverId", "");
        String string4 = ChatDeserializer.i(jsonObject, "applicationId");
        String string5 = ChatDeserializer.i(jsonObject, "tenantId");
        String string6 = ChatDeserializer.a(jsonObject, "roomId", "Java:Chat");
        String string7 = ChatDeserializer.i(jsonObject, "certificatePath");
        String string8 = ChatDeserializer.a(jsonObject, "certificatePassword", "");
        int i2 = ChatDeserializer.a(jsonObject, "hashesToDrop", -1);
        int j2 = ChatDeserializer.a(jsonObject, "maxConcurrentRequests", 7);
        JsonArray jsonArray = ChatDeserializer.v(jsonObject, "fullyFilteredEvents");
        HashSet<String> set = new HashSet<String>();
        jsonArray.forEach(json -> set.add(ChatDeserializer.a(json, "filteredEvent")));
        int k2 = ChatDeserializer.a(jsonObject, "connectionReadTimeoutMs", 2000);
        try {
            URL uRL = uRI.resolve(string).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        ServerTextFilter.b messageEncoder = (profile, message) -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("userId", profile.getId().toString());
            jsonObject.addProperty("userDisplayName", profile.getName());
            jsonObject.addProperty("server", string3);
            jsonObject.addProperty("room", string6);
            jsonObject.addProperty("area", "JavaChatRealms");
            jsonObject.addProperty("data", message);
            jsonObject.addProperty("language", "*");
            return jsonObject;
        };
        ServerTextFilter.a ignoreStrategy = ServerTextFilter.a.select(i2);
        ExecutorService executorService = PlayerSafetyServiceTextFilter.a(j2);
        try (InputStream inputStream = Files.newInputStream(Path.of(string7, new String[0]), new OpenOption[0]);){
            IClientCertificate iClientCertificate = ClientCredentialFactory.createFromCertificate((InputStream)inputStream, (String)string8);
        }
        catch (Exception exception) {
            ServerTextFilter.a.warn("Failed to open certificate file");
            return null;
        }
        try {
            void iClientCertificate3;
            ConfidentialClientApplication confidentialClientApplication = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)string4, (IClientCredential)iClientCertificate3).sendX5c(true).executorService(executorService)).authority(String.format(Locale.ROOT, "https://login.microsoftonline.com/%s/", string5))).build();
        }
        catch (Exception exception2) {
            ServerTextFilter.a.warn("Failed to create confidential client application");
            return null;
        }
        ClientCredentialParameters clientCredentialParameters = ClientCredentialParameters.builder(Set.of(string2)).build();
        return new PlayerSafetyServiceTextFilter((URL)uRL2, messageEncoder, ignoreStrategy, executorService, (ConfidentialClientApplication)confidentialClientApplication2, clientCredentialParameters, set, k2);
    }

    private IAuthenticationResult b() {
        return (IAuthenticationResult)this.b.acquireToken(this.c).join();
    }

    @Override
    @Override
    protected void a(HttpURLConnection connection) {
        IAuthenticationResult iAuthenticationResult = this.b();
        connection.setRequestProperty("Authorization", "Bearer " + iAuthenticationResult.accessToken());
    }

    @Override
    @Override
    protected FilteredText a(String raw, ServerTextFilter.a hashIgnorer, JsonObject response) {
        JsonObject jsonObject = ChatDeserializer.a(response, "result", null);
        if (jsonObject == null) {
            return FilteredText.b(raw);
        }
        boolean bl = ChatDeserializer.a(jsonObject, "filtered", true);
        if (!bl) {
            return FilteredText.a(raw);
        }
        JsonArray jsonArray = ChatDeserializer.a(jsonObject, "events", new JsonArray());
        for (JsonElement jsonElement : jsonArray) {
            JsonObject jsonObject2 = jsonElement.getAsJsonObject();
            String string = ChatDeserializer.a(jsonObject2, "id", "");
            if (!this.d.contains(string)) continue;
            return FilteredText.b(raw);
        }
        JsonArray jsonArray2 = ChatDeserializer.a(jsonObject, "redactedTextIndex", new JsonArray());
        return new FilteredText(raw, this.a(raw, jsonArray2, hashIgnorer));
    }

    @Override
    @Override
    protected int a() {
        return this.e;
    }
}

