/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.Profiler;
import org.bukkit.craftbukkit.v1_21_R2.CraftServer;
import org.bukkit.craftbukkit.v1_21_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R2.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R2.util.Waitable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.slf4j.Logger;

public abstract class ServerCommonPacketListenerImpl
implements ServerCommonPacketListener,
CraftPlayer.TransferCookieConnection {
    private static final Logger f = LogUtils.getLogger();
    public static final int b = 15000;
    private static final int g = 15000;
    private static final IChatBaseComponent h = IChatBaseComponent.c("disconnect.timeout");
    static final IChatBaseComponent c = IChatBaseComponent.c("multiplayer.disconnect.unexpected_query_response");
    protected final MinecraftServer d;
    public final NetworkManager e;
    private final boolean i;
    private long j = SystemUtils.c();
    private boolean k;
    private long l;
    private long m;
    private boolean n = false;
    private int o;
    private volatile boolean p = false;
    public final Map<UUID, ResourcePackCallback> packCallbacks = new ConcurrentHashMap<UUID, ResourcePackCallback>();
    private static final long KEEPALIVE_LIMIT = Long.getLong("paper.playerconnection.keepalive", 30L) * 1000L;
    protected static final MinecraftKey MINECRAFT_BRAND = MinecraftKey.b("brand");
    protected final EntityPlayer player;
    protected final CraftServer cserver;
    public boolean processedDisconnect;
    private static final MinecraftKey CUSTOM_REGISTER = MinecraftKey.b("register");
    private static final MinecraftKey CUSTOM_UNREGISTER = MinecraftKey.b("unregister");

    @Override
    public boolean isTransferred() {
        return this.i;
    }

    @Override
    public EnumProtocol getProtocol() {
        return this.b();
    }

    @Override
    public void sendPacket(Packet<?> packet) {
        this.b(packet);
    }

    @Override
    public void kickPlayer(IChatBaseComponent reason, PlayerKickEvent.Cause cause) {
        this.disconnect(reason, cause);
    }

    public ServerCommonPacketListenerImpl(MinecraftServer minecraftserver, NetworkManager networkmanager, CommonListenerCookie commonlistenercookie, EntityPlayer player) {
        this.d = minecraftserver;
        this.e = networkmanager;
        this.j = SystemUtils.c();
        this.o = commonlistenercookie.b();
        this.i = commonlistenercookie.d();
        this.player = player;
        this.player.transferCookieConnection = this;
        this.cserver = minecraftserver.server;
    }

    public CraftPlayer getCraftPlayer() {
        return this.player == null ? null : this.player.getBukkitEntity();
    }

    private void l() {
        if (!this.n) {
            this.m = SystemUtils.c();
            this.n = true;
        }
    }

    @Override
    public void a(DisconnectionDetails info) {
        this.onDisconnect(info, null);
    }

    public void onDisconnect(DisconnectionDetails info, @Nullable Component quitMessage) {
        if (this.h()) {
            f.info("Stopping singleplayer server as player logged out");
            this.d.a(false);
        }
    }

    @Override
    public void a(Packet packet, Exception exception) throws ReportedException {
        ServerCommonPacketListener.super.a(packet, exception);
        this.d.a(exception, packet.a());
    }

    @Override
    public void a(ServerboundKeepAlivePacket packet) {
        if (this.k && packet.b() == this.l) {
            int i2 = (int)(SystemUtils.c() - this.j);
            this.o = (this.o * 3 + i2) / 4;
            this.k = false;
        } else if (!this.h()) {
            this.disconnectAsync(h, PlayerKickEvent.Cause.TIMEOUT);
        }
    }

    @Override
    public void a(ServerboundPongPacket packet) {
    }

    @Override
    public void a(ServerboundCustomPayloadPacket packet) {
        CustomPacketPayload customPacketPayload = packet.b();
        if (customPacketPayload instanceof BrandPayload) {
            BrandPayload brandPayload = (BrandPayload)customPacketPayload;
            this.player.clientBrandName = brandPayload.b();
        }
        if (!(packet.b() instanceof DiscardedPayload)) {
            return;
        }
        PlayerConnectionUtils.a(packet, this, this.player.y());
        MinecraftKey identifier = packet.b().a().a();
        ByteBuf payload = ((DiscardedPayload)packet.b()).data();
        if (identifier.equals(CUSTOM_REGISTER)) {
            try {
                String channels = payload.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().addChannel(channel);
                }
            }
            catch (Exception ex) {
                PlayerConnection.h.error("Couldn't register custom payload", (Throwable)ex);
                this.disconnect(IChatBaseComponent.b("Invalid payload REGISTER!"), PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        } else if (identifier.equals(CUSTOM_UNREGISTER)) {
            try {
                String channels = payload.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().removeChannel(channel);
                }
            }
            catch (Exception ex) {
                PlayerConnection.h.error("Couldn't unregister custom payload", (Throwable)ex);
                this.disconnect(IChatBaseComponent.b("Invalid payload UNREGISTER!"), PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        } else {
            try {
                byte[] data = new byte[payload.readableBytes()];
                payload.readBytes(data);
                if (identifier.equals(MINECRAFT_BRAND)) {
                    try {
                        this.player.clientBrandName = new PacketDataSerializer(Unpooled.copiedBuffer((byte[])data)).d(256);
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        this.player.clientBrandName = "illegal";
                    }
                }
                this.cserver.getMessenger().dispatchIncomingMessage((Player)this.player.getBukkitEntity(), identifier.toString(), data);
            }
            catch (Exception ex) {
                PlayerConnection.h.error("Couldn't dispatch custom payload", (Throwable)ex);
                this.disconnect(IChatBaseComponent.b("Invalid custom payload!"), PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        }
    }

    public final boolean isDisconnected() {
        return !this.player.joining && !this.e.i() || this.processedDisconnect;
    }

    @Override
    public void a(ServerboundResourcePackPacket packet) {
        PlayerResourcePackStatusEvent.Status packStatus;
        ResourcePackCallback callback;
        PlayerConnectionUtils.a(packet, this, this.d);
        if (packet.e() == ServerboundResourcePackPacket.a.b && this.d.Z()) {
            f.info("Disconnecting {} due to resource pack {} rejection", (Object)this.i().getName(), (Object)packet.b());
            this.disconnect(IChatBaseComponent.c("multiplayer.requiredTexturePrompt.disconnect"), PlayerKickEvent.Cause.RESOURCE_PACK_REJECTION);
        }
        if ((callback = packet.e().a() ? this.packCallbacks.remove(packet.b()) : this.packCallbacks.get(packet.b())) != null) {
            callback.packEventReceived(packet.b(), ResourcePackStatus.valueOf((String)packet.e().name()), (Audience)this.getCraftPlayer());
        }
        this.player.getBukkitEntity().resourcePackStatus = packStatus = PlayerResourcePackStatusEvent.Status.values()[packet.e().ordinal()];
        this.cserver.getPluginManager().callEvent((Event)new PlayerResourcePackStatusEvent((Player)this.getCraftPlayer(), packet.b(), packStatus));
    }

    @Override
    public void a(ServerboundCookieResponsePacket packet) {
        PlayerConnectionUtils.a(packet, this, this.d);
        if (this.player.getBukkitEntity().handleCookieResponse(packet)) {
            return;
        }
        this.disconnect(c, PlayerKickEvent.Cause.INVALID_COOKIE);
    }

    protected void e() {
        Profiler.a().a("keepAlive");
        long currentTime = SystemUtils.c();
        long elapsedTime = currentTime - this.j;
        if (!this.h() && elapsedTime >= 15000L) {
            if (this.k && !this.processedDisconnect && elapsedTime >= KEEPALIVE_LIMIT) {
                this.disconnect(h, PlayerKickEvent.Cause.TIMEOUT);
            } else if (this.a(currentTime)) {
                this.k = true;
                this.j = currentTime;
                this.l = currentTime;
                this.b(new ClientboundKeepAlivePacket(this.l));
            }
        }
        Profiler.a().c();
    }

    private boolean a(long time) {
        if (this.n) {
            if (time - this.m >= 15000L) {
                this.disconnect(h, PlayerKickEvent.Cause.TIMEOUT);
            }
            return false;
        }
        return true;
    }

    public void f() {
        this.p = true;
    }

    public void g() {
        this.p = false;
        this.e.a();
    }

    public void b(Packet<?> packet) {
        this.a(packet, (PacketSendListener)null);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener callbacks) {
        if (packet == null || this.processedDisconnect) {
            return;
        }
        if (packet instanceof PacketPlayOutSpawnPosition) {
            PacketPlayOutSpawnPosition packet6 = (PacketPlayOutSpawnPosition)packet;
            this.player.compassTarget = CraftLocation.toBukkit(packet6.b, this.getCraftPlayer().getWorld());
        }
        if (packet.d()) {
            this.l();
        }
        boolean flag = !this.p || !this.d.bx();
        try {
            this.e.a(packet, callbacks, flag);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Sending packet");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Packet being sent");
            crashreportsystemdetails.a("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException(crashreport);
        }
    }

    public void disconnect(Component reason) {
        this.disconnect(reason, PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(Component reason, PlayerKickEvent.Cause cause) {
        this.disconnect(PaperAdventure.asVanilla(reason), cause);
    }

    @Deprecated
    @DoNotUse
    public void a(IChatBaseComponent reason) {
        this.disconnect(reason, PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(IChatBaseComponent reason, PlayerKickEvent.Cause cause) {
        this.disconnect(new DisconnectionDetails(reason), cause);
    }

    public void disconnect(final DisconnectionDetails disconnectionInfo, final PlayerKickEvent.Cause cause) {
        if (this.processedDisconnect) {
            return;
        }
        if (!this.cserver.isPrimaryThread()) {
            Waitable waitable = new Waitable(){

                protected Object evaluate() {
                    ServerCommonPacketListenerImpl.this.disconnect(disconnectionInfo, cause);
                    return null;
                }
            };
            this.d.processQueue.add(waitable);
            try {
                waitable.get();
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e3) {
                throw new RuntimeException(e3);
            }
            return;
        }
        TranslatableComponent leaveMessage = Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? this.player.getBukkitEntity().displayName() : Component.text((String)this.player.cI())});
        PlayerKickEvent event = new PlayerKickEvent((Player)this.player.getBukkitEntity(), PaperAdventure.asAdventure(disconnectionInfo.a()), (Component)leaveMessage, cause);
        if (this.cserver.getServer().x()) {
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return;
        }
        this.disconnect0(new DisconnectionDetails(PaperAdventure.asVanilla(event.reason()), disconnectionInfo.b(), disconnectionInfo.c()), event.leaveMessage());
    }

    private void disconnect0(DisconnectionDetails disconnectiondetails, @Nullable Component leaveMessage) {
        this.player.quitReason = PlayerQuitEvent.QuitReason.KICKED;
        this.e.a(new ClientboundDisconnectPacket(disconnectiondetails.a()), PacketSendListener.a(() -> this.e.a(disconnectiondetails)));
        this.onDisconnect(disconnectiondetails, leaveMessage);
        this.e.m();
        MinecraftServer minecraftserver = this.d;
        NetworkManager networkmanager = this.e;
        Objects.requireNonNull(this.e);
        minecraftserver.scheduleOnMain(networkmanager::n);
    }

    public void disconnectAsync(Component reason, PlayerKickEvent.Cause cause) {
        this.disconnectAsync(PaperAdventure.asVanilla(reason), cause);
    }

    public void disconnectAsync(IChatBaseComponent reason, PlayerKickEvent.Cause cause) {
        this.disconnectAsync(new DisconnectionDetails(reason), cause);
    }

    public void disconnectAsync(DisconnectionDetails disconnectionInfo, PlayerKickEvent.Cause cause) {
        if (this.cserver.isPrimaryThread()) {
            this.disconnect(disconnectionInfo, cause);
            return;
        }
        this.e.m();
        this.d.scheduleOnMain(() -> {
            this.disconnect(disconnectionInfo, cause);
            if (this.player.quitReason == null) {
                this.e.enableAutoRead();
            }
        });
    }

    protected boolean h() {
        return this.d.a(this.i());
    }

    protected abstract GameProfile i();

    @VisibleForDebug
    public GameProfile j() {
        return this.i();
    }

    public int k() {
        return this.o;
    }

    protected CommonListenerCookie a(ClientInformation syncedOptions) {
        return new CommonListenerCookie(this.i(), this.o, syncedOptions, this.i);
    }
}

