/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.logging.LogUtils;
import com.velocitypowered.natives.util.Natives;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.network.ChannelInitializeListenerHolder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.NetworkManagerServer;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.server.network.LegacyPingHandler;
import net.minecraft.server.network.MemoryServerHandshakePacketListenerImpl;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerConnection {
    private static final Logger d = LogUtils.getLogger();
    public static final Supplier<NioEventLoopGroup> a = Suppliers.memoize(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Server IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(d)).build()));
    public static final Supplier<EpollEventLoopGroup> b = Suppliers.memoize(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Server IO #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(d)).build()));
    final MinecraftServer e;
    public volatile boolean c;
    private final List<ChannelFuture> f = Collections.synchronizedList(Lists.newArrayList());
    final List<NetworkManager> g = Collections.synchronizedList(Lists.newArrayList());
    private final Queue<NetworkManager> pending = new ConcurrentLinkedQueue<NetworkManager>();
    private static final boolean disableFlushConsolidation = Boolean.getBoolean("Paper.disableFlushConsolidate");

    private final void addPending() {
        NetworkManager connection;
        while ((connection = this.pending.poll()) != null) {
            this.g.add(connection);
            connection.isPending = false;
        }
    }

    public ServerConnection(MinecraftServer server) {
        this.e = server;
        this.c = true;
    }

    public void a(@Nullable InetAddress address, int port) throws IOException {
        this.bind(new InetSocketAddress(address, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress address) throws IOException {
        List<ChannelFuture> list = this.f;
        List<ChannelFuture> list2 = this.f;
        synchronized (list2) {
            EventLoopGroup eventloopgroup;
            Class oclass;
            if (Epoll.isAvailable() && this.e.p()) {
                oclass = address instanceof DomainSocketAddress ? EpollServerDomainSocketChannel.class : EpollServerSocketChannel.class;
                eventloopgroup = (EventLoopGroup)b.get();
                d.info("Using epoll channel type");
            } else {
                oclass = NioServerSocketChannel.class;
                eventloopgroup = (EventLoopGroup)a.get();
                d.info("Using default channel type");
            }
            if (GlobalConfiguration.get().proxies.proxyProtocol) {
                d.warn("Using HAProxy, please ensure the server port is adequately firewalled.");
            }
            d.info("Paper: Using " + Natives.compress.getLoadedVariant() + " compression from Velocity.");
            d.info("Paper: Using " + Natives.cipher.getLoadedVariant() + " cipher from Velocity.");
            this.f.add(((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(oclass)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(final Channel channel) {
                    NetworkManager object;
                    try {
                        channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                    }
                    catch (ChannelException channelException) {
                        // empty catch block
                    }
                    if (!disableFlushConsolidation) {
                        channel.pipeline().addFirst(new ChannelHandler[]{new FlushConsolidationHandler()});
                    }
                    ChannelPipeline channelpipeline = channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                    if (ServerConnection.this.e.am()) {
                        channelpipeline.addLast("legacy_query", (ChannelHandler)new LegacyPingHandler(ServerConnection.this.d()));
                    }
                    NetworkManager.a(channelpipeline, EnumProtocolDirection.a, false, null);
                    int j2 = ServerConnection.this.e.o();
                    NetworkManager networkManager = object = j2 > 0 ? new NetworkManagerServer(j2) : new NetworkManager(EnumProtocolDirection.a);
                    if (GlobalConfiguration.get().proxies.proxyProtocol) {
                        channel.pipeline().addAfter("timeout", "haproxy-decoder", (ChannelHandler)new HAProxyMessageDecoder());
                        channel.pipeline().addAfter("haproxy-decoder", "haproxy-handler", (ChannelHandler)new ChannelInboundHandlerAdapter(this){

                            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                                if (msg instanceof HAProxyMessage) {
                                    HAProxyMessage message = (HAProxyMessage)msg;
                                    if (message.command() == HAProxyCommand.PROXY) {
                                        String realaddress = message.sourceAddress();
                                        int realport = message.sourcePort();
                                        InetSocketAddress socketaddr = new InetSocketAddress(realaddress, realport);
                                        NetworkManager connection = (NetworkManager)channel.pipeline().get("packet_handler");
                                        connection.o = socketaddr;
                                        String proxyAddress = message.destinationAddress();
                                        int proxyPort = message.destinationPort();
                                        connection.haProxyAddress = new InetSocketAddress(proxyAddress, proxyPort);
                                    }
                                } else {
                                    super.channelRead(ctx, msg);
                                }
                            }
                        });
                    }
                    ServerConnection.this.pending.add(object);
                    object.a(channelpipeline);
                    object.a(new HandshakeListener(ServerConnection.this.e, object));
                    ChannelInitializeListenerHolder.callListeners(channel);
                }
            }).group(eventloopgroup).localAddress(address)).option(ChannelOption.AUTO_READ, (Object)false)).bind().syncUninterruptibly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptConnections() {
        List<ChannelFuture> list = this.f;
        synchronized (list) {
            for (ChannelFuture future : this.f) {
                future.channel().config().setAutoRead(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress a() {
        ChannelFuture channelfuture;
        List<ChannelFuture> list = this.f;
        List<ChannelFuture> list2 = this.f;
        synchronized (list2) {
            channelfuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.a);
                    networkmanager.a(new MemoryServerHandshakePacketListenerImpl(ServerConnection.this.e, networkmanager));
                    ServerConnection.this.g.add(networkmanager);
                    ChannelPipeline channelpipeline = channel.pipeline();
                    NetworkManager.a(channelpipeline, EnumProtocolDirection.a);
                    networkmanager.a(channelpipeline);
                }
            }).group((EventLoopGroup)a.get()).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
            this.f.add(channelfuture);
        }
        return channelfuture.channel().localAddress();
    }

    public void b() {
        this.c = false;
        for (ChannelFuture channelfuture : this.f) {
            try {
                channelfuture.channel().close().sync();
            }
            catch (InterruptedException interruptedexception) {
                d.error("Interrupted whilst closing channel");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void c() {
        List<NetworkManager> list = this.g;
        List<NetworkManager> list2 = this.g;
        synchronized (list2) {
            this.addPending();
            if (SpigotConfig.playerShuffle > 0 && MinecraftServer.currentTick % SpigotConfig.playerShuffle == 0) {
                Collections.shuffle(this.g);
            }
            Iterator<NetworkManager> iterator = this.g.iterator();
            while (iterator.hasNext()) {
                NetworkManager networkmanager = iterator.next();
                if (networkmanager.j()) continue;
                if (networkmanager.i()) {
                    try {
                        networkmanager.b();
                    }
                    catch (Exception exception) {
                        if (networkmanager.e()) {
                            throw new ReportedException(CrashReport.a(exception, "Ticking memory connection"));
                        }
                        d.warn("Failed to handle packet for {}", (Object)networkmanager.a(this.e.bl()), (Object)exception);
                        IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.b("Internal server error");
                        networkmanager.a(new ClientboundDisconnectPacket(ichatmutablecomponent), PacketSendListener.a(() -> networkmanager.a(ichatmutablecomponent)));
                        networkmanager.m();
                    }
                    continue;
                }
                if (networkmanager.preparing) continue;
                iterator.remove();
                networkmanager.n();
            }
        }
    }

    public MinecraftServer d() {
        return this.e;
    }

    public List<NetworkManager> e() {
        return this.g;
    }

    private static class LatencySimulator
    extends ChannelInboundHandlerAdapter {
        private static final Timer a = new HashedWheelTimer();
        private final int b;
        private final int c;
        private final List<DelayedMessage> d = Lists.newArrayList();

        public LatencySimulator(int baseDelay, int extraDelay) {
            this.b = baseDelay;
            this.c = extraDelay;
        }

        public void channelRead(ChannelHandlerContext channelhandlercontext, Object object) {
            this.a(channelhandlercontext, object);
        }

        private void a(ChannelHandlerContext ctx, Object msg) {
            int i2 = this.b + (int)(Math.random() * (double)this.c);
            this.d.add(new DelayedMessage(ctx, msg));
            a.newTimeout(this::a, (long)i2, TimeUnit.MILLISECONDS);
        }

        private void a(Timeout timeout) {
            DelayedMessage serverconnection_latencysimulator_delayedmessage = this.d.remove(0);
            serverconnection_latencysimulator_delayedmessage.a.fireChannelRead(serverconnection_latencysimulator_delayedmessage.b);
        }

        private static class DelayedMessage {
            public final ChannelHandlerContext a;
            public final Object b;

            public DelayedMessage(ChannelHandlerContext context, Object message) {
                this.a = context;
                this.b = message;
            }
        }
    }
}

