/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.LegacyTextFilter;
import net.minecraft.server.network.PlayerSafetyServiceTextFilter;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.UtilColor;
import net.minecraft.util.thread.ConsecutiveExecutor;
import org.slf4j.Logger;

public abstract class ServerTextFilter
implements AutoCloseable {
    protected static final Logger a = LogUtils.getLogger();
    private static final AtomicInteger b = new AtomicInteger(1);
    private static final ThreadFactory c = runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("Chat-Filter-Worker-" + b.getAndIncrement());
        return thread;
    };
    private final URL d;
    private final b e;
    final a f;
    final ExecutorService g;

    protected static ExecutorService a(int threadCount) {
        return Executors.newFixedThreadPool(threadCount, c);
    }

    protected ServerTextFilter(URL url, b messageEncoder, a hashIgnorer, ExecutorService threadPool) {
        this.f = hashIgnorer;
        this.g = threadPool;
        this.d = url;
        this.e = messageEncoder;
    }

    protected static URL a(URI uri, @Nullable JsonObject endpoints, String key, String defaultPath) throws MalformedURLException {
        String string = ServerTextFilter.a(endpoints, key, defaultPath);
        return uri.resolve("/" + string).toURL();
    }

    protected static String a(@Nullable JsonObject endpoints, String key, String defaultPath) {
        return endpoints != null ? ChatDeserializer.a(endpoints, key, defaultPath) : defaultPath;
    }

    @Nullable
    public static ServerTextFilter a(DedicatedServerProperties properties) {
        String string = properties.R;
        if (UtilColor.h(string)) {
            return null;
        }
        return switch (properties.S) {
            case 0 -> LegacyTextFilter.a(string);
            case 1 -> PlayerSafetyServiceTextFilter.a(string);
            default -> {
                a.warn("Could not create text filter - unsupported text filtering version used");
                yield null;
            }
        };
    }

    protected CompletableFuture<FilteredText> a(GameProfile profile, String raw, a hashIgnorer, Executor executor) {
        if (raw.isEmpty()) {
            return CompletableFuture.completedFuture(FilteredText.a);
        }
        return CompletableFuture.supplyAsync(() -> {
            JsonObject jsonObject = this.e.encode(profile, raw);
            try {
                JsonObject jsonObject2 = this.b(jsonObject, this.d);
                return this.a(raw, hashIgnorer, jsonObject2);
            }
            catch (Exception exception) {
                a.warn("Failed to validate message '{}'", (Object)raw, (Object)exception);
                return FilteredText.b(raw);
            }
        }, executor);
    }

    protected abstract FilteredText a(String var1, a var2, JsonObject var3);

    protected FilterMask a(String raw, JsonArray redactedTextIndex, a hashIgnorer) {
        if (redactedTextIndex.isEmpty()) {
            return FilterMask.c;
        }
        if (hashIgnorer.shouldIgnore(raw, redactedTextIndex.size())) {
            return FilterMask.b;
        }
        FilterMask filterMask = new FilterMask(raw.length());
        for (int i2 = 0; i2 < redactedTextIndex.size(); ++i2) {
            filterMask.a(redactedTextIndex.get(i2).getAsInt());
        }
        return filterMask;
    }

    @Override
    @Override
    public void close() {
        this.g.shutdownNow();
    }

    protected void a(InputStream stream) throws IOException {
        byte[] bs = new byte[1024];
        while (stream.read(bs) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject b(JsonObject request, URL url) throws IOException {
        HttpURLConnection httpURLConnection = this.a(request, url);
        try (InputStream inputStream = httpURLConnection.getInputStream();){
            JsonObject jsonObject;
            if (httpURLConnection.getResponseCode() == 204) {
                JsonObject jsonObject2 = new JsonObject();
                return jsonObject2;
            }
            try {
                jsonObject = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8))).getAsJsonObject();
            }
            catch (Throwable throwable) {
                this.a(inputStream);
                throw throwable;
            }
            this.a(inputStream);
            return jsonObject;
        }
    }

    protected HttpURLConnection a(JsonObject request, URL url) throws IOException {
        HttpURLConnection httpURLConnection = this.a(url);
        this.a(httpURLConnection);
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter jsonWriter = new JsonWriter((Writer)outputStreamWriter);){
            Streams.write((JsonElement)request, (JsonWriter)jsonWriter);
        }
        int i2 = httpURLConnection.getResponseCode();
        if (i2 < 200 || i2 >= 300) {
            throw new d(i2 + " " + httpURLConnection.getResponseMessage());
        }
        return httpURLConnection;
    }

    protected abstract void a(HttpURLConnection var1);

    protected int a() {
        return 2000;
    }

    protected HttpURLConnection a(URL url) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(this.a());
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        httpURLConnection.setRequestProperty("Accept", "application/json");
        httpURLConnection.setRequestProperty("User-Agent", "Minecraft server" + SharedConstants.b().c());
        return httpURLConnection;
    }

    public ITextFilter a(GameProfile profile) {
        return new c(profile);
    }

    @FunctionalInterface
    public static interface a {
        public static final a a = (hashes, hashesSize) -> false;
        public static final a b = (hashes, hashesSize) -> hashes.length() == hashesSize;

        public static a ignoreOverThreshold(int hashesToDrop) {
            return (hashes, hashesSize) -> hashesSize >= hashesToDrop;
        }

        public static a select(int hashesToDrop) {
            return switch (hashesToDrop) {
                case -1 -> a;
                case 0 -> b;
                default -> net.minecraft.server.network.ServerTextFilter$a.ignoreOverThreshold(hashesToDrop);
            };
        }

        public boolean shouldIgnore(String var1, int var2);
    }

    @FunctionalInterface
    protected static interface b {
        public JsonObject encode(GameProfile var1, String var2);
    }

    protected static class d
    extends RuntimeException {
        protected d(String message) {
            super(message);
        }
    }

    protected class c
    implements ITextFilter {
        protected final GameProfile b;
        protected final Executor c;

        protected c(GameProfile gameProfile) {
            this.b = gameProfile;
            ConsecutiveExecutor consecutiveExecutor = new ConsecutiveExecutor(ServerTextFilter.this.g, "chat stream for " + gameProfile.getName());
            this.c = consecutiveExecutor::a_;
        }

        @Override
        @Override
        public CompletableFuture<List<FilteredText>> a(List<String> texts) {
            List list = (List)texts.stream().map(text -> ServerTextFilter.this.a(this.b, (String)text, ServerTextFilter.this.f, this.c)).collect(ImmutableList.toImmutableList());
            return SystemUtils.e(list).exceptionally(throwable -> ImmutableList.of());
        }

        @Override
        @Override
        public CompletableFuture<FilteredText> a(String text) {
            return ServerTextFilter.this.a(this.b, text, ServerTextFilter.this.f, this.c);
        }
    }
}

