/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.OverlayMetadataSection;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.EnumResourcePackVersion;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.flag.FeatureFlagSet;
import org.slf4j.Logger;

public class ResourcePackLoader {
    private static final Logger a = LogUtils.getLogger();
    private final PackLocationInfo b;
    public final c c;
    private final a d;
    private final PackSelectionConfig e;

    @Nullable
    public static ResourcePackLoader a(PackLocationInfo info, c packFactory, EnumResourcePackType type, PackSelectionConfig position) {
        int i2 = SharedConstants.b().a(type);
        a metadata = ResourcePackLoader.a(info, packFactory, i2);
        return metadata != null ? new ResourcePackLoader(info, packFactory, metadata, position) : null;
    }

    public ResourcePackLoader(PackLocationInfo info, c packFactory, a metaData, PackSelectionConfig position) {
        this.b = info;
        this.c = packFactory;
        this.d = metaData;
        this.e = position;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static a a(PackLocationInfo info, c packFactory, int currentPackFormat) {
        try (IResourcePack packResources = packFactory.a(info);){
            ResourcePackInfo packMetadataSection = packResources.a(ResourcePackInfo.b);
            if (packMetadataSection == null) {
                a.warn("Missing metadata in pack {}", (Object)info.a());
                a a2 = null;
                return a2;
            }
            FeatureFlagsMetadataSection featureFlagsMetadataSection = packResources.a(FeatureFlagsMetadataSection.a);
            FeatureFlagSet featureFlagSet = featureFlagsMetadataSection != null ? featureFlagsMetadataSection.a() : FeatureFlagSet.a();
            InclusiveRange<Integer> inclusiveRange = ResourcePackLoader.a(info.a(), packMetadataSection);
            EnumResourcePackVersion packCompatibility = EnumResourcePackVersion.a(inclusiveRange, currentPackFormat);
            OverlayMetadataSection overlayMetadataSection = packResources.a(OverlayMetadataSection.a);
            List<String> list = overlayMetadataSection != null ? overlayMetadataSection.a(currentPackFormat) : List.of();
            a a3 = new a(packMetadataSection.a(), packCompatibility, featureFlagSet, list);
            return a3;
        }
        catch (Exception exception) {
            a.warn("Failed to read pack {} metadata", (Object)info.a(), (Object)exception);
            return null;
        }
    }

    private static InclusiveRange<Integer> a(String packId, ResourcePackInfo metadata) {
        int i2 = metadata.b();
        if (metadata.c().isEmpty()) {
            return new InclusiveRange<Integer>(i2);
        }
        InclusiveRange<Integer> inclusiveRange = metadata.c().get();
        if (!inclusiveRange.a(i2)) {
            a.warn("Pack {} declared support for versions {} but declared main format is {}, defaulting to {}", new Object[]{packId, inclusiveRange, i2, i2});
            return new InclusiveRange<Integer>(i2);
        }
        return inclusiveRange;
    }

    public PackLocationInfo a() {
        return this.b;
    }

    public IChatBaseComponent b() {
        return this.b.b();
    }

    public IChatBaseComponent c() {
        return this.d.a();
    }

    public IChatBaseComponent a(boolean enabled) {
        return this.b.a(enabled, this.d.a);
    }

    public EnumResourcePackVersion d() {
        return this.d.b();
    }

    public FeatureFlagSet e() {
        return this.d.c();
    }

    public IResourcePack f() {
        return this.c.a(this.b, this.d);
    }

    public String g() {
        return this.b.a();
    }

    public PackSelectionConfig h() {
        return this.e;
    }

    public boolean i() {
        return this.e.a();
    }

    public boolean j() {
        return this.e.c();
    }

    public Position k() {
        return this.e.b();
    }

    public PackSource l() {
        return this.b.c();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ResourcePackLoader)) {
            return false;
        }
        ResourcePackLoader pack = (ResourcePackLoader)object;
        return this.b.equals(pack.b);
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }

    public static interface c {
        public IResourcePack a(PackLocationInfo var1);

        public IResourcePack a(PackLocationInfo var1, a var2);
    }

    public record a(IChatBaseComponent a, EnumResourcePackVersion b, FeatureFlagSet c, List<String> d) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "a", "b", "c", "d"}, this, object);
        }
    }

    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position a = new Position();
        public static final /* enum */ Position b = new Position();
        private static final /* synthetic */ Position[] c;

        public static Position[] values() {
            return (Position[])c.clone();
        }

        public static Position valueOf(String string) {
            return Enum.valueOf(Position.class, string);
        }

        public <T> int a(List<T> items, T item, Function<T, PackSelectionConfig> profileGetter, boolean listInverted) {
            PackSelectionConfig packSelectionConfig2;
            int j2;
            Position position;
            Position position2 = position = listInverted ? this.a() : this;
            if (position == b) {
                PackSelectionConfig packSelectionConfig;
                int i2;
                for (i2 = 0; i2 < items.size() && (packSelectionConfig = profileGetter.apply(items.get(i2))).c() && packSelectionConfig.b() == this; ++i2) {
                }
                items.add(i2, item);
                return i2;
            }
            for (j2 = items.size() - 1; j2 >= 0 && (packSelectionConfig2 = profileGetter.apply(items.get(j2))).c() && packSelectionConfig2.b() == this; --j2) {
            }
            items.add(j2 + 1, item);
            return j2 + 1;
        }

        public Position a() {
            return this == a ? b : a;
        }

        private static /* synthetic */ Position[] b() {
            return new Position[]{a, b};
        }

        static {
            c = Position.b();
        }
    }
}

