/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.SystemUtils;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import org.slf4j.Logger;

public class ReloadableProfiled
extends Reloadable<a> {
    private static final Logger c = LogUtils.getLogger();
    private final Stopwatch d = Stopwatch.createUnstarted();

    public ReloadableProfiled(IResourceManager manager, List<IReloadListener> reloaders, Executor prepareExecutor, Executor applyExecutor, CompletableFuture<Unit> initialStage) {
        super(prepareExecutor, applyExecutor, manager, reloaders, (preparationBarrier, resourceManager, preparableReloadListener, executor2, executor3) -> {
            AtomicLong atomicLong = new AtomicLong();
            AtomicLong atomicLong2 = new AtomicLong();
            CompletableFuture<Void> completableFuture = preparableReloadListener.a(preparationBarrier, resourceManager, ReloadableProfiled.a(executor2, atomicLong, preparableReloadListener.c()), ReloadableProfiled.a(executor3, atomicLong2, preparableReloadListener.c()));
            return completableFuture.thenApplyAsync(void_ -> {
                c.debug("Finished reloading {}", (Object)preparableReloadListener.c());
                return new a(preparableReloadListener.c(), atomicLong, atomicLong2);
            }, applyExecutor);
        }, initialStage);
        this.d.start();
        this.b = this.b.thenApplyAsync(this::a, applyExecutor);
    }

    private static Executor a(Executor executor, AtomicLong atomicLong, String string) {
        return runnable -> executor.execute(() -> {
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a(string);
            long l2 = SystemUtils.d();
            runnable.run();
            atomicLong.addAndGet(SystemUtils.d() - l2);
            profilerFiller.c();
        });
    }

    private List<a> a(List<a> summaries) {
        this.d.stop();
        long l2 = 0L;
        c.info("Resource reload finished after {} ms", (Object)this.d.elapsed(TimeUnit.MILLISECONDS));
        for (a state : summaries) {
            long m2 = TimeUnit.NANOSECONDS.toMillis(state.b.get());
            long n2 = TimeUnit.NANOSECONDS.toMillis(state.c.get());
            long o2 = m2 + n2;
            String string = state.a;
            c.info("{} took approximately {} ms ({} ms preparing, {} ms applying)", new Object[]{string, o2, m2, n2});
            l2 += n2;
        }
        c.info("Total blocking time: {} ms", (Object)l2);
        return summaries;
    }

    public record a(String a, AtomicLong b, AtomicLong c) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "name;preparationNanos;reloadNanos", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "name;preparationNanos;reloadNanos", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "name;preparationNanos;reloadNanos", "a", "b", "c"}, this, object);
        }
    }
}

