/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public abstract class ResourceDataJson<T>
extends ResourceDataAbstract<Map<MinecraftKey, T>> {
    private static final Logger a = LogUtils.getLogger();
    private final DynamicOps<JsonElement> b;
    private final Codec<T> c;
    private final String d;

    protected ResourceDataJson(HolderLookup.a registries, Codec<T> codec, String dataType) {
        this(registries.a(JsonOps.INSTANCE), codec, dataType);
    }

    protected ResourceDataJson(Codec<T> codec, String dataType) {
        this((DynamicOps<JsonElement>)JsonOps.INSTANCE, codec, dataType);
    }

    private ResourceDataJson(DynamicOps<JsonElement> ops, Codec<T> codec, String dataType) {
        this.b = ops;
        this.c = codec;
        this.d = dataType;
    }

    @Override
    protected Map<MinecraftKey, T> a(IResourceManager resourceManager, GameProfilerFiller profilerFiller) {
        HashMap map = new HashMap();
        ResourceDataJson.a(resourceManager, this.d, this.b, this.c, map);
        return map;
    }

    public static <T> void a(IResourceManager manager, String dataType, DynamicOps<JsonElement> ops, Codec<T> codec, Map<MinecraftKey, T> result) {
        FileToIdConverter fileToIdConverter = FileToIdConverter.a(dataType);
        for (Map.Entry<MinecraftKey, IResource> entry : fileToIdConverter.a(manager).entrySet()) {
            MinecraftKey resourceLocation = entry.getKey();
            MinecraftKey resourceLocation2 = fileToIdConverter.b(resourceLocation);
            try {
                BufferedReader reader = entry.getValue().e();
                try {
                    codec.parse(ops, (Object)JsonParser.parseReader((Reader)reader)).ifSuccess(value -> {
                        if (result.putIfAbsent(resourceLocation2, value) != null) {
                            throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(resourceLocation2));
                        }
                    }).ifError(error -> a.error("Couldn't parse data file '{}' from '{}': {}", new Object[]{resourceLocation2, resourceLocation, error}));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                a.error("Couldn't parse data file '{}' from '{}'", new Object[]{resourceLocation2, resourceLocation, exception});
            }
        }
    }

    @Override
    protected /* synthetic */ Object b(IResourceManager manager, GameProfilerFiller profiler) {
        return this.a(manager, profiler);
    }
}

