/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.IMinecraftServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.rcon.thread.RemoteConnectionThread;
import net.minecraft.server.rcon.thread.RemoteControlSession;
import org.slf4j.Logger;

public class RemoteControlListener
extends RemoteConnectionThread {
    private static final Logger d = LogUtils.getLogger();
    private final ServerSocket e;
    private final String f;
    private final List<RemoteControlSession> g = Lists.newArrayList();
    private final IMinecraftServer h;

    private RemoteControlListener(IMinecraftServer server, ServerSocket listener, String password) {
        super("RCON Listener");
        this.h = server;
        this.e = listener;
        this.f = password;
    }

    private void d() {
        this.g.removeIf(client -> !client.c());
    }

    @Override
    public void run() {
        try {
            while (this.a) {
                try {
                    Socket socket = this.e.accept();
                    RemoteControlSession rconClient = new RemoteControlSession(this.h, this.f, socket);
                    rconClient.a();
                    this.g.add(rconClient);
                    this.d();
                }
                catch (SocketTimeoutException var7) {
                    this.d();
                }
                catch (IOException var8) {
                    if (!this.a) continue;
                    d.info("IO exception: ", (Throwable)var8);
                }
            }
        }
        finally {
            this.a(this.e);
        }
    }

    @Nullable
    public static RemoteControlListener a(IMinecraftServer server) {
        int i2;
        DedicatedServerProperties dedicatedServerProperties = server.a();
        String string = dedicatedServerProperties.rconIp;
        if (string.isEmpty()) {
            string = "0.0.0.0";
        }
        if (0 < (i2 = dedicatedServerProperties.r) && 65535 >= i2) {
            String string2 = dedicatedServerProperties.s;
            if (string2.isEmpty()) {
                d.warn("No rcon password set in server.properties, rcon disabled!");
                return null;
            }
            try {
                ServerSocket serverSocket = new ServerSocket(i2, 0, InetAddress.getByName(string));
                serverSocket.setSoTimeout(500);
                RemoteControlListener rconThread = new RemoteControlListener(server, serverSocket, string2);
                if (!rconThread.a()) {
                    return null;
                }
                d.info("RCON running on {}:{}", (Object)string, (Object)i2);
                return rconThread;
            }
            catch (IOException var7) {
                d.warn("Unable to initialise RCON on {}:{}", new Object[]{string, i2, var7});
                return null;
            }
        }
        d.warn("Invalid rcon port {} found in server.properties, rcon disabled!", (Object)i2);
        return null;
    }

    @Override
    public void b() {
        this.a = false;
        this.a(this.e);
        super.b();
        for (RemoteControlSession rconClient : this.g) {
            if (!rconClient.c()) continue;
            rconClient.b();
        }
        this.g.clear();
    }

    public void stopNonBlocking() {
        this.a = false;
        for (RemoteControlSession client : this.g) {
            client.a = false;
        }
    }

    private void a(ServerSocket socket) {
        d.debug("closeSocket: {}", (Object)socket);
        try {
            socket.close();
        }
        catch (IOException var3) {
            d.warn("Failed to close socket", (Throwable)var3);
        }
    }
}

