/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookRemovePacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.bukkit.craftbukkit.v1_21_R2.event.CraftEventFactory;
import org.slf4j.Logger;

public class RecipeBookServer
extends RecipeBook {
    public static final String b = "recipeBook";
    private static final Logger e = LogUtils.getLogger();
    private final a f;
    @VisibleForTesting
    public final Set<ResourceKey<IRecipe<?>>> c = Sets.newIdentityHashSet();
    @VisibleForTesting
    protected final Set<ResourceKey<IRecipe<?>>> d = Sets.newIdentityHashSet();

    public RecipeBookServer(a collector) {
        this.f = collector;
    }

    public void a(ResourceKey<IRecipe<?>> recipeKey) {
        this.c.add(recipeKey);
    }

    public boolean b(ResourceKey<IRecipe<?>> recipeKey) {
        return this.c.contains(recipeKey);
    }

    public void c(ResourceKey<IRecipe<?>> recipeKey) {
        this.c.remove(recipeKey);
        this.d.remove(recipeKey);
    }

    public void d(ResourceKey<IRecipe<?>> recipeKey) {
        this.d.remove(recipeKey);
    }

    private void e(ResourceKey<IRecipe<?>> recipeKey) {
        this.d.add(recipeKey);
    }

    public int a(Collection<RecipeHolder<?>> recipes, EntityPlayer player) {
        ArrayList<ClientboundRecipeBookAddPacket.a> list = new ArrayList<ClientboundRecipeBookAddPacket.a>();
        for (RecipeHolder<?> recipeholder : recipes) {
            ResourceKey<IRecipe<?>> resourcekey = recipeholder.a();
            if (this.c.contains(resourcekey) || recipeholder.b().aq_() || !CraftEventFactory.handlePlayerRecipeListUpdateEvent(player, resourcekey.a())) continue;
            this.a(resourcekey);
            this.e(resourcekey);
            this.f.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)recipedisplayentry, recipeholder.b().i(), true)));
            CriterionTriggers.g.a(player, recipeholder);
        }
        if (!list.isEmpty() && player.f != null) {
            player.f.b(new ClientboundRecipeBookAddPacket(list, false));
        }
        return list.size();
    }

    public int b(Collection<RecipeHolder<?>> recipes, EntityPlayer player) {
        ArrayList list = Lists.newArrayList();
        for (RecipeHolder<?> recipeholder : recipes) {
            ResourceKey<IRecipe<?>> resourcekey = recipeholder.a();
            if (!this.c.contains(resourcekey)) continue;
            this.c(resourcekey);
            this.f.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(recipedisplayentry.a()));
        }
        if (!list.isEmpty() && player.f != null) {
            player.f.b(new ClientboundRecipeBookRemovePacket(list));
        }
        return list.size();
    }

    public NBTTagCompound b() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.a().b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (ResourceKey<IRecipe<?>> resourcekey : this.c) {
            nbttaglist.add(NBTTagString.a(resourcekey.a().toString()));
        }
        nbttagcompound.a("recipes", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (ResourceKey<IRecipe<?>> resourcekey1 : this.d) {
            nbttaglist1.add(NBTTagString.a(resourcekey1.a().toString()));
        }
        nbttagcompound.a("toBeDisplayed", nbttaglist1);
        return nbttagcompound;
    }

    public void a(NBTTagCompound nbt, Predicate<ResourceKey<IRecipe<?>>> validPredicate) {
        this.a(RecipeBookSettings.a(nbt));
        NBTTagList nbttaglist = nbt.c("recipes", 8);
        this.a(nbttaglist, this::a, validPredicate);
        NBTTagList nbttaglist1 = nbt.c("toBeDisplayed", 8);
        this.a(nbttaglist1, this::e, validPredicate);
    }

    private void a(NBTTagList list, Consumer<ResourceKey<IRecipe<?>>> handler, Predicate<ResourceKey<IRecipe<?>>> validPredicate) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String s2 = list.j(i2);
            try {
                ResourceKey<IRecipe<?>> resourcekey = ResourceKey.a(Registries.bk, MinecraftKey.a(s2));
                if (!validPredicate.test(resourcekey)) {
                    e.error("Tried to load unrecognized recipe: {} removed now.", resourcekey);
                    continue;
                }
                handler.accept(resourcekey);
                continue;
            }
            catch (ResourceKeyInvalidException resourcekeyinvalidexception) {
                e.error("Tried to load improperly formatted recipe: {} removed now.", (Object)s2);
            }
        }
    }

    public void a(EntityPlayer player) {
        player.f.b(new ClientboundRecipeBookSettingsPacket(this.a()));
        ArrayList<ClientboundRecipeBookAddPacket.a> list = new ArrayList<ClientboundRecipeBookAddPacket.a>(this.c.size());
        for (ResourceKey<IRecipe<?>> resourcekey : this.c) {
            this.f.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(new ClientboundRecipeBookAddPacket.a((RecipeDisplayEntry)recipedisplayentry, false, this.d.contains(resourcekey))));
        }
        player.f.b(new ClientboundRecipeBookAddPacket(list, true));
    }

    public void a(RecipeBookServer recipeBook) {
        this.c.clear();
        this.d.clear();
        this.a.a(recipeBook.a);
        this.c.addAll(recipeBook.c);
        this.d.addAll(recipeBook.d);
    }

    @FunctionalInterface
    public static interface a {
        public void displaysForRecipe(ResourceKey<IRecipe<?>> var1, Consumer<RecipeDisplayEntry> var2);
    }
}

