/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    public static final StreamCodec<PacketDataSerializer, RecipeBookSettings> a = StreamCodec.a(RecipeBookSettings::b, RecipeBookSettings::a);
    private static final Map<RecipeBookType, Pair<String, String>> b = ImmutableMap.of((Object)((Object)RecipeBookType.a), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.b), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.c), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.d), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable"));
    private final Map<RecipeBookType, a> c;

    private RecipeBookSettings(Map<RecipeBookType, a> categoryOptions) {
        this.c = categoryOptions;
    }

    public RecipeBookSettings() {
        this(new EnumMap<RecipeBookType, a>(RecipeBookType.class));
    }

    private a c(RecipeBookType category) {
        return this.c.getOrDefault((Object)category, net.minecraft.stats.RecipeBookSettings$a.a);
    }

    private void a(RecipeBookType category, UnaryOperator<a> modifier) {
        this.c.compute(category, (key, value) -> {
            if (value == null) {
                value = net.minecraft.stats.RecipeBookSettings$a.a;
            }
            if ((value = (a)modifier.apply((a)value)).equals(net.minecraft.stats.RecipeBookSettings$a.a)) {
                value = null;
            }
            return value;
        });
    }

    public boolean a(RecipeBookType category) {
        return this.c((RecipeBookType)category).b;
    }

    public void a(RecipeBookType category, boolean open) {
        this.a(category, option -> option.a(open));
    }

    public boolean b(RecipeBookType category) {
        return this.c((RecipeBookType)category).c;
    }

    public void b(RecipeBookType category, boolean filtering) {
        this.a(category, option -> option.b(filtering));
    }

    private static RecipeBookSettings a(PacketDataSerializer buf) {
        EnumMap<RecipeBookType, a> map = new EnumMap<RecipeBookType, a>(RecipeBookType.class);
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            boolean bl = buf.readBoolean();
            boolean bl2 = buf.readBoolean();
            if (!bl && !bl2) continue;
            map.put(recipeBookType, new a(bl, bl2));
        }
        return new RecipeBookSettings(map);
    }

    private void b(PacketDataSerializer buf) {
        for (RecipeBookType recipeBookType : RecipeBookType.values()) {
            a typeSettings = this.c.getOrDefault((Object)recipeBookType, net.minecraft.stats.RecipeBookSettings$a.a);
            buf.a(typeSettings.b);
            buf.a(typeSettings.c);
        }
    }

    public static RecipeBookSettings a(NBTTagCompound nbt) {
        EnumMap<RecipeBookType, a> map = new EnumMap<RecipeBookType, a>(RecipeBookType.class);
        b.forEach((category, pair) -> {
            boolean bl = nbt.q((String)pair.getFirst());
            boolean bl2 = nbt.q((String)pair.getSecond());
            if (bl || bl2) {
                map.put((RecipeBookType)((Object)category), new a(bl, bl2));
            }
        });
        return new RecipeBookSettings(map);
    }

    public void b(NBTTagCompound nbt) {
        b.forEach((category, pair) -> {
            a typeSettings = this.c.getOrDefault(category, net.minecraft.stats.RecipeBookSettings$a.a);
            nbt.a((String)pair.getFirst(), typeSettings.b);
            nbt.a((String)pair.getSecond(), typeSettings.c);
        });
    }

    public RecipeBookSettings a() {
        return new RecipeBookSettings(new EnumMap<RecipeBookType, a>(this.c));
    }

    public void a(RecipeBookSettings other) {
        this.c.clear();
        this.c.putAll(other.c);
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object instanceof RecipeBookSettings && this.c.equals(((RecipeBookSettings)object).c);
    }

    @Override
    public int hashCode() {
        return this.c.hashCode();
    }

    static final class a
    extends Record {
        private final boolean b;
        private final boolean c;
        public static final a a = new a(false, false);

        a(boolean guiOpen, boolean filteringCraftable) {
            this.b = guiOpen;
            this.c = filteringCraftable;
        }

        @Override
        @Override
        public String toString() {
            return "[open=" + this.b + ", filtering=" + this.c + "]";
        }

        public a a(boolean guiOpen) {
            return new a(guiOpen, this.c);
        }

        public a b(boolean filteringCraftable) {
            return new a(this.b, filteringCraftable);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "open;filtering", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "open;filtering", "b", "c"}, this, object);
        }

        public boolean a() {
            return this.b;
        }

        public boolean b() {
            return this.c;
        }
    }
}

