/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.tag.PaperTagListenerManager;
import io.papermc.paper.tag.TagEventConfig;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.DependencySorter;
import org.slf4j.Logger;

public class TagDataPack<T> {
    private static final Logger a = LogUtils.getLogger();
    final a<T> b;
    private final String c;

    public TagDataPack(a<T> entrySupplier, String dataType) {
        this.b = entrySupplier;
        this.c = dataType;
    }

    public Map<MinecraftKey, List<b>> a(IResourceManager resourceManager) {
        HashMap<MinecraftKey, List<b>> map = new HashMap<MinecraftKey, List<b>>();
        FileToIdConverter fileToIdConverter = FileToIdConverter.a(this.c);
        for (Map.Entry<MinecraftKey, List<IResource>> entry : fileToIdConverter.b(resourceManager).entrySet()) {
            MinecraftKey resourceLocation = entry.getKey();
            MinecraftKey resourceLocation2 = fileToIdConverter.b(resourceLocation);
            for (IResource resource : entry.getValue()) {
                try {
                    BufferedReader reader = resource.e();
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        List list = map.computeIfAbsent(resourceLocation2, id -> new ArrayList());
                        TagFile tagFile = (TagFile)TagFile.a.parse(new Dynamic<JsonElement>((DynamicOps<JsonElement>)JsonOps.INSTANCE, jsonElement)).getOrThrow();
                        if (tagFile.b()) {
                            list.clear();
                        }
                        String string = resource.b();
                        tagFile.a().forEach(entryx -> list.add(new b((TagEntry)entryx, string)));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception var17) {
                    a.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{resourceLocation2, resourceLocation, resource.b(), var17});
                }
            }
        }
        return map;
    }

    private Either<List<b>, List<T>> a(TagEntry.a<T> valueGetter, List<b> entries) {
        LinkedHashSet sequencedSet = new LinkedHashSet();
        ArrayList<b> list = new ArrayList<b>();
        for (b entryWithSource : entries) {
            if (entryWithSource.a().a(valueGetter, sequencedSet::add)) continue;
            list.add(entryWithSource);
        }
        return list.isEmpty() ? Either.right(List.copyOf(sequencedSet)) : Either.left(list);
    }

    public Map<MinecraftKey, List<T>> build(Map<MinecraftKey, List<b>> tags, @Nullable TagEventConfig<T, ?> eventConfig) {
        tags = PaperTagListenerManager.INSTANCE.firePreFlattenEvent(tags, eventConfig);
        final HashMap map = new HashMap();
        TagEntry.a lookup = new TagEntry.a<T>(){

            @Override
            @Nullable
            public T a(MinecraftKey id, boolean required) {
                return TagDataPack.this.b.get(id, required).orElse(null);
            }

            @Override
            @Nullable
            public Collection<T> a(MinecraftKey id) {
                return (Collection)map.get(id);
            }
        };
        DependencySorter<MinecraftKey, d> dependencySorter = new DependencySorter<MinecraftKey, d>();
        tags.forEach((id, entries) -> dependencySorter.a((MinecraftKey)id, new d((List<b>)entries)));
        dependencySorter.a((K id, V dependencies) -> this.a(lookup, dependencies.a).ifLeft(missingReferences -> a.error("Couldn't load tag {} as it is missing following references: {}", id, (Object)missingReferences.stream().map(Objects::toString).collect(Collectors.joining(", ")))).ifRight(values -> map.put((MinecraftKey)id, values)));
        return PaperTagListenerManager.INSTANCE.firePostFlattenEvent(map, eventConfig);
    }

    public static <T> void a(TagNetworkSerialization.a tags, IRegistryWritable<T> registry) {
        tags.a(registry).b.forEach(registry::a);
    }

    public static List<IRegistry.a<?>> a(IResourceManager resourceManager, IRegistryCustom registryManager) {
        return TagDataPack.loadTagsForExistingRegistries(resourceManager, registryManager, ReloadableRegistrarEvent.Cause.INITIAL);
    }

    public static List<IRegistry.a<?>> loadTagsForExistingRegistries(IResourceManager resourceManager, IRegistryCustom registryManager, ReloadableRegistrarEvent.Cause cause) {
        return registryManager.a().map(registry -> TagDataPack.loadPendingTags(resourceManager, registry.b(), cause)).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    public static <T> void a(IResourceManager resourceManager, IRegistryWritable<T> registry) {
        TagDataPack.loadTagsForRegistry(resourceManager, registry, ReloadableRegistrarEvent.Cause.INITIAL);
    }

    public static <T> void loadTagsForRegistry(IResourceManager resourceManager, IRegistryWritable<T> registry, ReloadableRegistrarEvent.Cause cause) {
        ResourceKey resourceKey = registry.g();
        TagDataPack<Holder<Holder<T>>> tagLoader = new TagDataPack<Holder<Holder<T>>>(net.minecraft.tags.TagDataPack$a.a(registry), Registries.d(resourceKey));
        tagLoader.build(tagLoader.a(resourceManager), PaperTagListenerManager.INSTANCE.createEventConfig(registry, cause)).forEach((id, entries) -> registry.a(TagKey.a(resourceKey, id), (List)entries));
    }

    private static <T> Map<TagKey<T>, List<Holder<T>>> a(ResourceKey<? extends IRegistry<T>> registryRef, Map<MinecraftKey, List<Holder<T>>> tags) {
        return tags.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> TagKey.a(registryRef, (MinecraftKey)entry.getKey()), Map.Entry::getValue));
    }

    private static <T> Optional<IRegistry.a<T>> loadPendingTags(IResourceManager resourceManager, IRegistry<T> registry, ReloadableRegistrarEvent.Cause cause) {
        ResourceKey<IRegistry<T>> resourceKey = registry.g();
        TagDataPack<Holder<Holder<T>>> tagLoader = new TagDataPack<Holder<Holder<T>>>(net.minecraft.tags.TagDataPack$a.a(registry), Registries.d(resourceKey));
        c<T> loadResult = new c<T>(resourceKey, TagDataPack.a(registry.g(), tagLoader.build(tagLoader.a(resourceManager), PaperTagListenerManager.INSTANCE.createEventConfig(registry, cause))));
        return loadResult.b().isEmpty() ? Optional.empty() : Optional.of(registry.a(loadResult));
    }

    public static List<HolderLookup.b<?>> a(IRegistryCustom.Dimension registryManager, List<IRegistry.a<?>> tagLoads) {
        ArrayList list = new ArrayList();
        registryManager.a().forEach(registry -> {
            IRegistry.a pendingTags = TagDataPack.a(tagLoads, registry.a());
            list.add(pendingTags != null ? pendingTags.c() : registry.b());
        });
        return list;
    }

    @Nullable
    private static IRegistry.a<?> a(List<IRegistry.a<?>> pendingTags, ResourceKey<? extends IRegistry<?>> registryRef) {
        for (IRegistry.a<?> pendingTags2 : pendingTags) {
            if (pendingTags2.a() != registryRef) continue;
            return pendingTags2;
        }
        return null;
    }

    public static interface a<T> {
        public Optional<? extends T> get(MinecraftKey var1, boolean var2);

        public static <T> a<? extends Holder<T>> a(IRegistry<T> registry) {
            return (id, required) -> registry.c(id);
        }

        public static <T> a<Holder<T>> a(IRegistryWritable<T> registry) {
            HolderGetter holderGetter = registry.p();
            return (id, required) -> (required ? holderGetter : registry).a(ResourceKey.a(registry.g(), id));
        }
    }

    public record b(TagEntry a, String b) {
        @Override
        public String toString() {
            return String.valueOf(this.a) + " (from " + this.b + ")";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "entry;source", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "entry;source", "a", "b"}, this, o2);
        }
    }

    public record c<T>(ResourceKey<? extends IRegistry<T>> a, Map<TagKey<T>, List<Holder<T>>> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "key;tags", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "key;tags", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "key;tags", "a", "b"}, this, o2);
        }
    }

    record d(List<b> a) implements DependencySorter.a<MinecraftKey>
    {
        @Override
        public void a(Consumer<MinecraftKey> callback) {
            this.a.forEach(entry -> entry.a.a(callback));
        }

        @Override
        public void b(Consumer<MinecraftKey> callback) {
            this.a.forEach(entry -> entry.a.b(callback));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "entries", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "entries", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "entries", "a"}, this, o2);
        }
    }
}

